# coding: utf-8

"""
    Infisical API

    List of all available APIs that can be consumed

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, Field, StrictBool, StrictStr, conlist

class ApiV3SecretsMovePostRequest(BaseModel):
    """
    ApiV3SecretsMovePostRequest
    """
    project_slug: StrictStr = Field(default=..., alias="projectSlug")
    source_environment: StrictStr = Field(default=..., alias="sourceEnvironment")
    source_secret_path: Optional[StrictStr] = Field(default='/', alias="sourceSecretPath")
    destination_environment: StrictStr = Field(default=..., alias="destinationEnvironment")
    destination_secret_path: Optional[StrictStr] = Field(default='/', alias="destinationSecretPath")
    secret_ids: conlist(StrictStr) = Field(default=..., alias="secretIds")
    should_overwrite: Optional[StrictBool] = Field(default=False, alias="shouldOverwrite")
    __properties = ["projectSlug", "sourceEnvironment", "sourceSecretPath", "destinationEnvironment", "destinationSecretPath", "secretIds", "shouldOverwrite"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ApiV3SecretsMovePostRequest:
        """Create an instance of ApiV3SecretsMovePostRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ApiV3SecretsMovePostRequest:
        """Create an instance of ApiV3SecretsMovePostRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ApiV3SecretsMovePostRequest.parse_obj(obj)

        _obj = ApiV3SecretsMovePostRequest.parse_obj({
            "project_slug": obj.get("projectSlug"),
            "source_environment": obj.get("sourceEnvironment"),
            "source_secret_path": obj.get("sourceSecretPath") if obj.get("sourceSecretPath") is not None else '/',
            "destination_environment": obj.get("destinationEnvironment"),
            "destination_secret_path": obj.get("destinationSecretPath") if obj.get("destinationSecretPath") is not None else '/',
            "secret_ids": obj.get("secretIds"),
            "should_overwrite": obj.get("shouldOverwrite") if obj.get("shouldOverwrite") is not None else False
        })
        return _obj


