# coding: utf-8

"""
    Infisical API

    List of all available APIs that can be consumed

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Optional, Union
from pydantic import BaseModel, Field, StrictBool, StrictFloat, StrictInt, StrictStr, conlist, validator

class ApiV3SecretsRawSecretNamePostRequest(BaseModel):
    """
    ApiV3SecretsRawSecretNamePostRequest
    """
    workspace_id: StrictStr = Field(default=..., alias="workspaceId", description="The ID of the project to create the secret in.")
    environment: StrictStr = Field(default=..., description="The slug of the environment to create the secret in.")
    secret_path: Optional[StrictStr] = Field(default='/', alias="secretPath", description="The path to create the secret in.")
    secret_value: StrictStr = Field(default=..., alias="secretValue", description="The value of the secret to create.")
    secret_comment: Optional[StrictStr] = Field(default='', alias="secretComment", description="Attach a comment to the secret.")
    tag_ids: Optional[conlist(StrictStr)] = Field(default=None, alias="tagIds", description="The ID of the tags to be attached to the created secret.")
    skip_multiline_encoding: Optional[StrictBool] = Field(default=None, alias="skipMultilineEncoding", description="Skip multiline encoding for the secret value.")
    type: Optional[StrictStr] = Field(default='shared', description="The type of the secret to create.")
    secret_reminder_repeat_days: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="secretReminderRepeatDays", description="Interval for secret rotation notifications, measured in days")
    secret_reminder_note: Optional[StrictStr] = Field(default=None, alias="secretReminderNote", description="Note to be attached in notification email")
    __properties = ["workspaceId", "environment", "secretPath", "secretValue", "secretComment", "tagIds", "skipMultilineEncoding", "type", "secretReminderRepeatDays", "secretReminderNote"]

    @validator('type')
    def type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('shared', 'personal'):
            raise ValueError("must be one of enum values ('shared', 'personal')")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ApiV3SecretsRawSecretNamePostRequest:
        """Create an instance of ApiV3SecretsRawSecretNamePostRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if secret_reminder_repeat_days (nullable) is None
        # and __fields_set__ contains the field
        if self.secret_reminder_repeat_days is None and "secret_reminder_repeat_days" in self.__fields_set__:
            _dict['secretReminderRepeatDays'] = None

        # set to None if secret_reminder_note (nullable) is None
        # and __fields_set__ contains the field
        if self.secret_reminder_note is None and "secret_reminder_note" in self.__fields_set__:
            _dict['secretReminderNote'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ApiV3SecretsRawSecretNamePostRequest:
        """Create an instance of ApiV3SecretsRawSecretNamePostRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ApiV3SecretsRawSecretNamePostRequest.parse_obj(obj)

        _obj = ApiV3SecretsRawSecretNamePostRequest.parse_obj({
            "workspace_id": obj.get("workspaceId"),
            "environment": obj.get("environment"),
            "secret_path": obj.get("secretPath") if obj.get("secretPath") is not None else '/',
            "secret_value": obj.get("secretValue"),
            "secret_comment": obj.get("secretComment") if obj.get("secretComment") is not None else '',
            "tag_ids": obj.get("tagIds"),
            "skip_multiline_encoding": obj.get("skipMultilineEncoding"),
            "type": obj.get("type") if obj.get("type") is not None else 'shared',
            "secret_reminder_repeat_days": obj.get("secretReminderRepeatDays"),
            "secret_reminder_note": obj.get("secretReminderNote")
        })
        return _obj


