# coding: utf-8

"""
    Infisical API

    List of all available APIs that can be consumed

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictStr, validator

class ApiV3SecretsSecretNameDeleteRequest(BaseModel):
    """
    ApiV3SecretsSecretNameDeleteRequest
    """
    type: Optional[StrictStr] = 'shared'
    secret_path: Optional[StrictStr] = Field(default='/', alias="secretPath")
    secret_id: Optional[StrictStr] = Field(default=None, alias="secretId")
    workspace_id: StrictStr = Field(default=..., alias="workspaceId")
    environment: StrictStr = Field(...)
    __properties = ["type", "secretPath", "secretId", "workspaceId", "environment"]

    @validator('type')
    def type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('shared', 'personal'):
            raise ValueError("must be one of enum values ('shared', 'personal')")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ApiV3SecretsSecretNameDeleteRequest:
        """Create an instance of ApiV3SecretsSecretNameDeleteRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ApiV3SecretsSecretNameDeleteRequest:
        """Create an instance of ApiV3SecretsSecretNameDeleteRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ApiV3SecretsSecretNameDeleteRequest.parse_obj(obj)

        _obj = ApiV3SecretsSecretNameDeleteRequest.parse_obj({
            "type": obj.get("type") if obj.get("type") is not None else 'shared',
            "secret_path": obj.get("secretPath") if obj.get("secretPath") is not None else '/',
            "secret_id": obj.get("secretId"),
            "workspace_id": obj.get("workspaceId"),
            "environment": obj.get("environment")
        })
        return _obj


