# coding: utf-8

"""
    Infisical API

    List of all available APIs that can be consumed

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Dict, List, Optional, Union
from pydantic import BaseModel, Field, StrictBool, StrictStr, confloat, conint, conlist, validator

class ApiV3SecretsSecretNamePatchRequest(BaseModel):
    """
    ApiV3SecretsSecretNamePatchRequest
    """
    workspace_id: StrictStr = Field(default=..., alias="workspaceId")
    environment: StrictStr = Field(...)
    secret_id: Optional[StrictStr] = Field(default=None, alias="secretId")
    type: Optional[StrictStr] = 'shared'
    secret_path: Optional[StrictStr] = Field(default='/', alias="secretPath")
    secret_value_ciphertext: StrictStr = Field(default=..., alias="secretValueCiphertext")
    secret_value_iv: StrictStr = Field(default=..., alias="secretValueIV")
    secret_value_tag: StrictStr = Field(default=..., alias="secretValueTag")
    secret_comment_ciphertext: Optional[StrictStr] = Field(default=None, alias="secretCommentCiphertext")
    secret_comment_iv: Optional[StrictStr] = Field(default=None, alias="secretCommentIV")
    secret_comment_tag: Optional[StrictStr] = Field(default=None, alias="secretCommentTag")
    secret_reminder_repeat_days: Optional[Union[confloat(le=365, ge=1, strict=True), conint(le=365, ge=1, strict=True)]] = Field(default=None, alias="secretReminderRepeatDays")
    secret_reminder_note: Optional[StrictStr] = Field(default=None, alias="secretReminderNote")
    tags: Optional[conlist(StrictStr)] = None
    skip_multiline_encoding: Optional[StrictBool] = Field(default=None, alias="skipMultilineEncoding")
    secret_name: Optional[StrictStr] = Field(default=None, alias="secretName")
    secret_key_iv: Optional[StrictStr] = Field(default=None, alias="secretKeyIV")
    secret_key_tag: Optional[StrictStr] = Field(default=None, alias="secretKeyTag")
    secret_key_ciphertext: Optional[StrictStr] = Field(default=None, alias="secretKeyCiphertext")
    metadata: Optional[Dict[str, StrictStr]] = None
    __properties = ["workspaceId", "environment", "secretId", "type", "secretPath", "secretValueCiphertext", "secretValueIV", "secretValueTag", "secretCommentCiphertext", "secretCommentIV", "secretCommentTag", "secretReminderRepeatDays", "secretReminderNote", "tags", "skipMultilineEncoding", "secretName", "secretKeyIV", "secretKeyTag", "secretKeyCiphertext", "metadata"]

    @validator('type')
    def type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in ('shared', 'personal'):
            raise ValueError("must be one of enum values ('shared', 'personal')")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ApiV3SecretsSecretNamePatchRequest:
        """Create an instance of ApiV3SecretsSecretNamePatchRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if secret_reminder_repeat_days (nullable) is None
        # and __fields_set__ contains the field
        if self.secret_reminder_repeat_days is None and "secret_reminder_repeat_days" in self.__fields_set__:
            _dict['secretReminderRepeatDays'] = None

        # set to None if secret_reminder_note (nullable) is None
        # and __fields_set__ contains the field
        if self.secret_reminder_note is None and "secret_reminder_note" in self.__fields_set__:
            _dict['secretReminderNote'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ApiV3SecretsSecretNamePatchRequest:
        """Create an instance of ApiV3SecretsSecretNamePatchRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ApiV3SecretsSecretNamePatchRequest.parse_obj(obj)

        _obj = ApiV3SecretsSecretNamePatchRequest.parse_obj({
            "workspace_id": obj.get("workspaceId"),
            "environment": obj.get("environment"),
            "secret_id": obj.get("secretId"),
            "type": obj.get("type") if obj.get("type") is not None else 'shared',
            "secret_path": obj.get("secretPath") if obj.get("secretPath") is not None else '/',
            "secret_value_ciphertext": obj.get("secretValueCiphertext"),
            "secret_value_iv": obj.get("secretValueIV"),
            "secret_value_tag": obj.get("secretValueTag"),
            "secret_comment_ciphertext": obj.get("secretCommentCiphertext"),
            "secret_comment_iv": obj.get("secretCommentIV"),
            "secret_comment_tag": obj.get("secretCommentTag"),
            "secret_reminder_repeat_days": obj.get("secretReminderRepeatDays"),
            "secret_reminder_note": obj.get("secretReminderNote"),
            "tags": obj.get("tags"),
            "skip_multiline_encoding": obj.get("skipMultilineEncoding"),
            "secret_name": obj.get("secretName"),
            "secret_key_iv": obj.get("secretKeyIV"),
            "secret_key_tag": obj.get("secretKeyTag"),
            "secret_key_ciphertext": obj.get("secretKeyCiphertext"),
            "metadata": obj.get("metadata")
        })
        return _obj


