# coding: utf-8

"""
    Infisical API

    List of all available APIs that can be consumed

    The version of the OpenAPI document: 0.0.1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictStr, constr

class ApiV3SignupCompleteAccountSignupPostRequest(BaseModel):
    """
    ApiV3SignupCompleteAccountSignupPostRequest
    """
    email: StrictStr = Field(...)
    first_name: StrictStr = Field(default=..., alias="firstName")
    last_name: Optional[StrictStr] = Field(default=None, alias="lastName")
    protected_key: StrictStr = Field(default=..., alias="protectedKey")
    protected_key_iv: StrictStr = Field(default=..., alias="protectedKeyIV")
    protected_key_tag: StrictStr = Field(default=..., alias="protectedKeyTag")
    public_key: StrictStr = Field(default=..., alias="publicKey")
    encrypted_private_key: StrictStr = Field(default=..., alias="encryptedPrivateKey")
    encrypted_private_key_iv: StrictStr = Field(default=..., alias="encryptedPrivateKeyIV")
    encrypted_private_key_tag: StrictStr = Field(default=..., alias="encryptedPrivateKeyTag")
    salt: StrictStr = Field(...)
    verifier: StrictStr = Field(...)
    organization_name: constr(strict=True, min_length=1) = Field(default=..., alias="organizationName")
    provider_auth_token: Optional[StrictStr] = Field(default=None, alias="providerAuthToken")
    attribution_source: Optional[StrictStr] = Field(default=None, alias="attributionSource")
    password: StrictStr = Field(...)
    __properties = ["email", "firstName", "lastName", "protectedKey", "protectedKeyIV", "protectedKeyTag", "publicKey", "encryptedPrivateKey", "encryptedPrivateKeyIV", "encryptedPrivateKeyTag", "salt", "verifier", "organizationName", "providerAuthToken", "attributionSource", "password"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ApiV3SignupCompleteAccountSignupPostRequest:
        """Create an instance of ApiV3SignupCompleteAccountSignupPostRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if provider_auth_token (nullable) is None
        # and __fields_set__ contains the field
        if self.provider_auth_token is None and "provider_auth_token" in self.__fields_set__:
            _dict['providerAuthToken'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ApiV3SignupCompleteAccountSignupPostRequest:
        """Create an instance of ApiV3SignupCompleteAccountSignupPostRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ApiV3SignupCompleteAccountSignupPostRequest.parse_obj(obj)

        _obj = ApiV3SignupCompleteAccountSignupPostRequest.parse_obj({
            "email": obj.get("email"),
            "first_name": obj.get("firstName"),
            "last_name": obj.get("lastName"),
            "protected_key": obj.get("protectedKey"),
            "protected_key_iv": obj.get("protectedKeyIV"),
            "protected_key_tag": obj.get("protectedKeyTag"),
            "public_key": obj.get("publicKey"),
            "encrypted_private_key": obj.get("encryptedPrivateKey"),
            "encrypted_private_key_iv": obj.get("encryptedPrivateKeyIV"),
            "encrypted_private_key_tag": obj.get("encryptedPrivateKeyTag"),
            "salt": obj.get("salt"),
            "verifier": obj.get("verifier"),
            "organization_name": obj.get("organizationName"),
            "provider_auth_token": obj.get("providerAuthToken"),
            "attribution_source": obj.get("attributionSource"),
            "password": obj.get("password")
        })
        return _obj


