"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.State = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Defines a state of a detector.
 */
class State {
    constructor(props) {
        this.props = props;
        this.transitionEvents = [];
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_iotevents_alpha_StateProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, State);
            }
            throw error;
        }
        this.stateName = props.stateName;
    }
    /**
     * Add a transition event to the state.
     * The transition event will be triggered if condition is evaluated to `true`.
     *
     * @param targetState the state that will be transit to when the event triggered
     * @param options transition options including the condition that causes the state transition
     */
    transitionTo(targetState, options) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_iotevents_alpha_State(targetState);
            jsiiDeprecationWarnings._aws_cdk_aws_iotevents_alpha_TransitionOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.transitionTo);
            }
            throw error;
        }
        const alreadyAdded = this.transitionEvents.some(transitionEvent => transitionEvent.nextState === targetState);
        if (alreadyAdded) {
            throw new Error(`State '${this.stateName}' already has a transition defined to '${targetState.stateName}'`);
        }
        this.transitionEvents.push({
            eventName: options.eventName ?? `${this.stateName}_to_${targetState.stateName}`,
            nextState: targetState,
            condition: options.when,
            actions: options.executing,
        });
    }
    /**
     * Collect states in dependency gragh that constructed by state transitions,
     * and return the JSONs of the states.
     * This function is called recursively and collect the states.
     *
     * @internal
     */
    _collectStateJsons(scope, actionBindOptions, collectedStates) {
        if (collectedStates.has(this)) {
            return [];
        }
        collectedStates.add(this);
        return [
            this.toStateJson(scope, actionBindOptions),
            ...this.transitionEvents.flatMap(transitionEvent => {
                return transitionEvent.nextState._collectStateJsons(scope, actionBindOptions, collectedStates);
            }),
        ];
    }
    /**
     * Returns true if this state has at least one condition via events.
     *
     * @internal
     */
    _onEnterEventsHaveAtLeastOneCondition() {
        return this.props.onEnter?.some(event => event.condition) ?? false;
    }
    toStateJson(scope, actionBindOptions) {
        const { onEnter, onInput, onExit } = this.props;
        return {
            stateName: this.stateName,
            onEnter: onEnter && {
                events: toEventsJson(scope, actionBindOptions, onEnter),
            },
            onInput: (onInput || this.transitionEvents.length !== 0) ? {
                events: toEventsJson(scope, actionBindOptions, onInput),
                transitionEvents: toTransitionEventsJson(scope, actionBindOptions, this.transitionEvents),
            } : undefined,
            onExit: onExit && {
                events: toEventsJson(scope, actionBindOptions, onExit),
            },
        };
    }
}
_a = JSII_RTTI_SYMBOL_1;
State[_a] = { fqn: "@aws-cdk/aws-iotevents-alpha.State", version: "2.77.0-alpha.0" };
exports.State = State;
function toEventsJson(scope, actionBindOptions, events) {
    return events?.map(event => ({
        eventName: event.eventName,
        condition: event.condition?.evaluate(),
        actions: event.actions?.map(action => action._bind(scope, actionBindOptions).configuration),
    }));
}
function toTransitionEventsJson(scope, actionBindOptions, transitionEvents) {
    if (transitionEvents.length === 0) {
        return undefined;
    }
    return transitionEvents.map(transitionEvent => ({
        eventName: transitionEvent.eventName,
        condition: transitionEvent.condition.evaluate(),
        actions: transitionEvent.actions?.map(action => action._bind(scope, actionBindOptions).configuration),
        nextState: transitionEvent.nextState.stateName,
    }));
}
//# sourceMappingURL=data:application/json;base64,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