# Copyright 2023 Qilimanjaro Quantum Tech
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

"""Port class."""
from dataclasses import dataclass

from qililab.chip.node import Node
from qililab.typings import NodeName
from qililab.typings.enums import Line
from qililab.utils import Factory


@Factory.register
@dataclass
class Port(Node):
    """This class is used to represent a port connected to the chip.

    Each port has a line associated to communicate with the chip. The different types of lines supported
    are flux, drive, feedline input and feedline output lines.

    Args:
        name (str): Name for the port
        line (Line): The type of line associated with the port
    """

    name = NodeName.PORT  #: Name for the port
    line: Line  #: The type of line associated with the port
