from typing import overload, Any, Callable, TypeVar, Union
from typing import Tuple, List, Sequence, MutableSequence

Callback = Union[Callable[..., None], None]
Buffer = TypeVar('Buffer')
Pointer = TypeVar('Pointer')
Template = TypeVar('Template')

import vtkmodules.vtkCommonCore
import vtkmodules.vtkCommonExecutionModel

class vtkConvertSelectionDomain(vtkmodules.vtkCommonExecutionModel.vtkPassInputTypeAlgorithm):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkConvertSelectionDomain': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkConvertSelectionDomain': ...

class vtkDataRepresentation(vtkmodules.vtkCommonExecutionModel.vtkPassInputTypeAlgorithm):
    annotation_link:'getset_descriptor'
    internal_annotation_output_port:'getset_descriptor'
    internal_output_port:'getset_descriptor'
    internal_selection_output_port:'getset_descriptor'
    selectable:'getset_descriptor'
    selection_array_name:'getset_descriptor'
    selection_array_names:'getset_descriptor'
    selection_type:'getset_descriptor'
    @overload
    def Annotate(self, view:'vtkView', annotations:'vtkAnnotationLayers') -> None: ...
    @overload
    def Annotate(self, view:'vtkView', annotations:'vtkAnnotationLayers', extend:bool) -> None: ...
    def ApplyViewTheme(self, theme:'vtkViewTheme') -> None: ...
    def ConvertSelection(self, view:'vtkView', selection:'vtkSelection') -> 'vtkSelection': ...
    def GetAnnotationLink(self) -> 'vtkAnnotationLink': ...
    def GetInputConnection(self, port:int=0, index:int=0) -> 'vtkAlgorithmOutput': ...
    @overload
    def GetInternalAnnotationOutputPort(self) -> 'vtkAlgorithmOutput': ...
    @overload
    def GetInternalAnnotationOutputPort(self, port:int) -> 'vtkAlgorithmOutput': ...
    @overload
    def GetInternalAnnotationOutputPort(self, port:int, conn:int) -> 'vtkAlgorithmOutput': ...
    @overload
    def GetInternalOutputPort(self) -> 'vtkAlgorithmOutput': ...
    @overload
    def GetInternalOutputPort(self, port:int) -> 'vtkAlgorithmOutput': ...
    @overload
    def GetInternalOutputPort(self, port:int, conn:int) -> 'vtkAlgorithmOutput': ...
    @overload
    def GetInternalSelectionOutputPort(self) -> 'vtkAlgorithmOutput': ...
    @overload
    def GetInternalSelectionOutputPort(self, port:int) -> 'vtkAlgorithmOutput': ...
    @overload
    def GetInternalSelectionOutputPort(self, port:int, conn:int) -> 'vtkAlgorithmOutput': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetSelectable(self) -> bool: ...
    def GetSelectionArrayName(self) -> str: ...
    def GetSelectionArrayNames(self) -> 'vtkStringArray': ...
    def GetSelectionType(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkDataRepresentation': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkDataRepresentation': ...
    @overload
    def Select(self, view:'vtkView', selection:'vtkSelection') -> None: ...
    @overload
    def Select(self, view:'vtkView', selection:'vtkSelection', extend:bool) -> None: ...
    def SelectableOff(self) -> None: ...
    def SelectableOn(self) -> None: ...
    def SetAnnotationLink(self, link:'vtkAnnotationLink') -> None: ...
    def SetSelectable(self, _arg:bool) -> None: ...
    def SetSelectionArrayName(self, name:str) -> None: ...
    def SetSelectionArrayNames(self, names:'vtkStringArray') -> None: ...
    def SetSelectionType(self, _arg:int) -> None: ...
    @overload
    def UpdateAnnotations(self, annotations:'vtkAnnotationLayers') -> None: ...
    @overload
    def UpdateAnnotations(self, annotations:'vtkAnnotationLayers', extend:bool) -> None: ...
    @overload
    def UpdateSelection(self, selection:'vtkSelection') -> None: ...
    @overload
    def UpdateSelection(self, selection:'vtkSelection', extend:bool) -> None: ...

class vtkEmptyRepresentation(vtkDataRepresentation):
    internal_annotation_output_port:'getset_descriptor'
    @overload
    def GetInternalAnnotationOutputPort(self) -> 'vtkAlgorithmOutput': ...
    @overload
    def GetInternalAnnotationOutputPort(self, port:int) -> 'vtkAlgorithmOutput': ...
    @overload
    def GetInternalAnnotationOutputPort(self, port:int, conn:int) -> 'vtkAlgorithmOutput': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkEmptyRepresentation': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkEmptyRepresentation': ...

class vtkView(vtkmodules.vtkCommonCore.vtkObject):
    observer:'getset_descriptor'
    representation:'getset_descriptor'
    def AddRepresentation(self, rep:'vtkDataRepresentation') -> None: ...
    def AddRepresentationFromInput(self, input:'vtkDataObject') -> 'vtkDataRepresentation': ...
    def AddRepresentationFromInputConnection(self, conn:'vtkAlgorithmOutput') -> 'vtkDataRepresentation': ...
    def ApplyViewTheme(self, theme:'vtkViewTheme') -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfRepresentations(self) -> int: ...
    def GetObserver(self) -> 'vtkCommand': ...
    def GetRepresentation(self, index:int=0) -> 'vtkDataRepresentation': ...
    def IsA(self, type:str) -> int: ...
    def IsRepresentationPresent(self, rep:'vtkDataRepresentation') -> bool: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkView': ...
    def RegisterProgress(self, algorithm:'vtkObject', message:str=...) -> None: ...
    def RemoveAllRepresentations(self) -> None: ...
    @overload
    def RemoveRepresentation(self, rep:'vtkDataRepresentation') -> None: ...
    @overload
    def RemoveRepresentation(self, rep:'vtkAlgorithmOutput') -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkView': ...
    def SetRepresentation(self, rep:'vtkDataRepresentation') -> None: ...
    def SetRepresentationFromInput(self, input:'vtkDataObject') -> 'vtkDataRepresentation': ...
    def SetRepresentationFromInputConnection(self, conn:'vtkAlgorithmOutput') -> 'vtkDataRepresentation': ...
    def UnRegisterProgress(self, algorithm:'vtkObject') -> None: ...
    def Update(self) -> None: ...

class vtkRenderViewBase(vtkView):
    interactor:'getset_descriptor'
    render_window:'getset_descriptor'
    renderer:'getset_descriptor'
    def GetInteractor(self) -> 'vtkRenderWindowInteractor': ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetRenderWindow(self) -> 'vtkRenderWindow': ...
    def GetRenderer(self) -> 'vtkRenderer': ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> 'vtkRenderViewBase': ...
    def Render(self) -> None: ...
    def ResetCamera(self) -> None: ...
    def ResetCameraClippingRange(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkRenderViewBase': ...
    def SetInteractor(self, __a:'vtkRenderWindowInteractor') -> None: ...
    def SetRenderWindow(self, win:'vtkRenderWindow') -> None: ...
    def SetRenderer(self, ren:'vtkRenderer') -> None: ...

class vtkViewTheme(vtkmodules.vtkCommonCore.vtkObject):
    background_color:'getset_descriptor'
    background_color2:'getset_descriptor'
    cell_alpha_range:'getset_descriptor'
    cell_color:'getset_descriptor'
    cell_hue_range:'getset_descriptor'
    cell_lookup_table:'getset_descriptor'
    cell_opacity:'getset_descriptor'
    cell_saturation_range:'getset_descriptor'
    cell_text_property:'getset_descriptor'
    cell_value_range:'getset_descriptor'
    edge_label_color:'getset_descriptor'
    line_width:'getset_descriptor'
    outline_color:'getset_descriptor'
    point_alpha_range:'getset_descriptor'
    point_color:'getset_descriptor'
    point_hue_range:'getset_descriptor'
    point_lookup_table:'getset_descriptor'
    point_opacity:'getset_descriptor'
    point_saturation_range:'getset_descriptor'
    point_size:'getset_descriptor'
    point_text_property:'getset_descriptor'
    point_value_range:'getset_descriptor'
    scale_cell_lookup_table:'getset_descriptor'
    scale_point_lookup_table:'getset_descriptor'
    selected_cell_color:'getset_descriptor'
    selected_cell_opacity:'getset_descriptor'
    selected_point_color:'getset_descriptor'
    selected_point_opacity:'getset_descriptor'
    vertex_label_color:'getset_descriptor'
    @staticmethod
    def CreateMellowTheme() -> 'vtkViewTheme': ...
    @staticmethod
    def CreateNeonTheme() -> 'vtkViewTheme': ...
    @staticmethod
    def CreateOceanTheme() -> 'vtkViewTheme': ...
    def GetBackgroundColor(self) -> Tuple[float, float, float]: ...
    def GetBackgroundColor2(self) -> Tuple[float, float, float]: ...
    @overload
    def GetCellAlphaRange(self) -> Pointer: ...
    @overload
    def GetCellAlphaRange(self, mn:float, mx:float) -> None: ...
    @overload
    def GetCellAlphaRange(self, rng:MutableSequence[float]) -> None: ...
    def GetCellColor(self) -> Tuple[float, float, float]: ...
    @overload
    def GetCellHueRange(self) -> Pointer: ...
    @overload
    def GetCellHueRange(self, mn:float, mx:float) -> None: ...
    @overload
    def GetCellHueRange(self, rng:MutableSequence[float]) -> None: ...
    def GetCellLookupTable(self) -> 'vtkScalarsToColors': ...
    def GetCellOpacity(self) -> float: ...
    @overload
    def GetCellSaturationRange(self) -> Pointer: ...
    @overload
    def GetCellSaturationRange(self, mn:float, mx:float) -> None: ...
    @overload
    def GetCellSaturationRange(self, rng:MutableSequence[float]) -> None: ...
    def GetCellTextProperty(self) -> 'vtkTextProperty': ...
    @overload
    def GetCellValueRange(self) -> Pointer: ...
    @overload
    def GetCellValueRange(self, mn:float, mx:float) -> None: ...
    @overload
    def GetCellValueRange(self, rng:MutableSequence[float]) -> None: ...
    @overload
    def GetEdgeLabelColor(self) -> Pointer: ...
    @overload
    def GetEdgeLabelColor(self, r:float, g:float, b:float) -> None: ...
    @overload
    def GetEdgeLabelColor(self, c:MutableSequence[float]) -> None: ...
    def GetLineWidth(self) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetOutlineColor(self) -> Tuple[float, float, float]: ...
    @overload
    def GetPointAlphaRange(self) -> Pointer: ...
    @overload
    def GetPointAlphaRange(self, mn:float, mx:float) -> None: ...
    @overload
    def GetPointAlphaRange(self, rng:MutableSequence[float]) -> None: ...
    def GetPointColor(self) -> Tuple[float, float, float]: ...
    @overload
    def GetPointHueRange(self) -> Pointer: ...
    @overload
    def GetPointHueRange(self, mn:float, mx:float) -> None: ...
    @overload
    def GetPointHueRange(self, rng:MutableSequence[float]) -> None: ...
    def GetPointLookupTable(self) -> 'vtkScalarsToColors': ...
    def GetPointOpacity(self) -> float: ...
    @overload
    def GetPointSaturationRange(self) -> Pointer: ...
    @overload
    def GetPointSaturationRange(self, mn:float, mx:float) -> None: ...
    @overload
    def GetPointSaturationRange(self, rng:MutableSequence[float]) -> None: ...
    def GetPointSize(self) -> float: ...
    def GetPointTextProperty(self) -> 'vtkTextProperty': ...
    @overload
    def GetPointValueRange(self) -> Pointer: ...
    @overload
    def GetPointValueRange(self, mn:float, mx:float) -> None: ...
    @overload
    def GetPointValueRange(self, rng:MutableSequence[float]) -> None: ...
    def GetScaleCellLookupTable(self) -> bool: ...
    def GetScalePointLookupTable(self) -> bool: ...
    def GetSelectedCellColor(self) -> Tuple[float, float, float]: ...
    def GetSelectedCellOpacity(self) -> float: ...
    def GetSelectedPointColor(self) -> Tuple[float, float, float]: ...
    def GetSelectedPointOpacity(self) -> float: ...
    @overload
    def GetVertexLabelColor(self) -> Pointer: ...
    @overload
    def GetVertexLabelColor(self, r:float, g:float, b:float) -> None: ...
    @overload
    def GetVertexLabelColor(self, c:MutableSequence[float]) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def LookupMatchesCellTheme(self, s2c:'vtkScalarsToColors') -> bool: ...
    def LookupMatchesPointTheme(self, s2c:'vtkScalarsToColors') -> bool: ...
    def NewInstance(self) -> 'vtkViewTheme': ...
    @staticmethod
    def SafeDownCast(o:'vtkObjectBase') -> 'vtkViewTheme': ...
    def ScaleCellLookupTableOff(self) -> None: ...
    def ScaleCellLookupTableOn(self) -> None: ...
    def ScalePointLookupTableOff(self) -> None: ...
    def ScalePointLookupTableOn(self) -> None: ...
    @overload
    def SetBackgroundColor(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetBackgroundColor(self, _arg:Sequence[float]) -> None: ...
    @overload
    def SetBackgroundColor2(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetBackgroundColor2(self, _arg:Sequence[float]) -> None: ...
    @overload
    def SetCellAlphaRange(self, mn:float, mx:float) -> None: ...
    @overload
    def SetCellAlphaRange(self, rng:MutableSequence[float]) -> None: ...
    @overload
    def SetCellColor(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetCellColor(self, _arg:Sequence[float]) -> None: ...
    @overload
    def SetCellHueRange(self, mn:float, mx:float) -> None: ...
    @overload
    def SetCellHueRange(self, rng:MutableSequence[float]) -> None: ...
    def SetCellLookupTable(self, lut:'vtkScalarsToColors') -> None: ...
    def SetCellOpacity(self, _arg:float) -> None: ...
    @overload
    def SetCellSaturationRange(self, mn:float, mx:float) -> None: ...
    @overload
    def SetCellSaturationRange(self, rng:MutableSequence[float]) -> None: ...
    def SetCellTextProperty(self, tprop:'vtkTextProperty') -> None: ...
    @overload
    def SetCellValueRange(self, mn:float, mx:float) -> None: ...
    @overload
    def SetCellValueRange(self, rng:MutableSequence[float]) -> None: ...
    @overload
    def SetEdgeLabelColor(self, r:float, g:float, b:float) -> None: ...
    @overload
    def SetEdgeLabelColor(self, c:MutableSequence[float]) -> None: ...
    def SetLineWidth(self, _arg:float) -> None: ...
    @overload
    def SetOutlineColor(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetOutlineColor(self, _arg:Sequence[float]) -> None: ...
    @overload
    def SetPointAlphaRange(self, mn:float, mx:float) -> None: ...
    @overload
    def SetPointAlphaRange(self, rng:MutableSequence[float]) -> None: ...
    @overload
    def SetPointColor(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetPointColor(self, _arg:Sequence[float]) -> None: ...
    @overload
    def SetPointHueRange(self, mn:float, mx:float) -> None: ...
    @overload
    def SetPointHueRange(self, rng:MutableSequence[float]) -> None: ...
    def SetPointLookupTable(self, lut:'vtkScalarsToColors') -> None: ...
    def SetPointOpacity(self, _arg:float) -> None: ...
    @overload
    def SetPointSaturationRange(self, mn:float, mx:float) -> None: ...
    @overload
    def SetPointSaturationRange(self, rng:MutableSequence[float]) -> None: ...
    def SetPointSize(self, _arg:float) -> None: ...
    def SetPointTextProperty(self, tprop:'vtkTextProperty') -> None: ...
    @overload
    def SetPointValueRange(self, mn:float, mx:float) -> None: ...
    @overload
    def SetPointValueRange(self, rng:MutableSequence[float]) -> None: ...
    def SetScaleCellLookupTable(self, _arg:bool) -> None: ...
    def SetScalePointLookupTable(self, _arg:bool) -> None: ...
    @overload
    def SetSelectedCellColor(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetSelectedCellColor(self, _arg:Sequence[float]) -> None: ...
    def SetSelectedCellOpacity(self, _arg:float) -> None: ...
    @overload
    def SetSelectedPointColor(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetSelectedPointColor(self, _arg:Sequence[float]) -> None: ...
    def SetSelectedPointOpacity(self, _arg:float) -> None: ...
    @overload
    def SetVertexLabelColor(self, r:float, g:float, b:float) -> None: ...
    @overload
    def SetVertexLabelColor(self, c:MutableSequence[float]) -> None: ...

