"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file

Copyright 2021 The Dapr Authors
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
"""

import builtins
import collections.abc
import google.protobuf.any_pb2
import google.protobuf.descriptor
import google.protobuf.duration_pb2
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class HTTPExtension(google.protobuf.message.Message):
    """HTTPExtension includes HTTP verb and querystring
    when Dapr runtime delivers HTTP content.

    For example, when callers calls http invoke api
    `POST http://localhost:3500/v1.0/invoke/<app_id>/method/<method>?query1=value1&query2=value2`

    Dapr runtime will parse POST as a verb and extract querystring to quersytring map.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Verb:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _VerbEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[HTTPExtension._Verb.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        NONE: HTTPExtension._Verb.ValueType  # 0
        GET: HTTPExtension._Verb.ValueType  # 1
        HEAD: HTTPExtension._Verb.ValueType  # 2
        POST: HTTPExtension._Verb.ValueType  # 3
        PUT: HTTPExtension._Verb.ValueType  # 4
        DELETE: HTTPExtension._Verb.ValueType  # 5
        CONNECT: HTTPExtension._Verb.ValueType  # 6
        OPTIONS: HTTPExtension._Verb.ValueType  # 7
        TRACE: HTTPExtension._Verb.ValueType  # 8
        PATCH: HTTPExtension._Verb.ValueType  # 9

    class Verb(_Verb, metaclass=_VerbEnumTypeWrapper):
        """Type of HTTP 1.1 Methods
        RFC 7231: https://tools.ietf.org/html/rfc7231#page-24
        RFC 5789: https://datatracker.ietf.org/doc/html/rfc5789
        """

    NONE: HTTPExtension.Verb.ValueType  # 0
    GET: HTTPExtension.Verb.ValueType  # 1
    HEAD: HTTPExtension.Verb.ValueType  # 2
    POST: HTTPExtension.Verb.ValueType  # 3
    PUT: HTTPExtension.Verb.ValueType  # 4
    DELETE: HTTPExtension.Verb.ValueType  # 5
    CONNECT: HTTPExtension.Verb.ValueType  # 6
    OPTIONS: HTTPExtension.Verb.ValueType  # 7
    TRACE: HTTPExtension.Verb.ValueType  # 8
    PATCH: HTTPExtension.Verb.ValueType  # 9

    VERB_FIELD_NUMBER: builtins.int
    QUERYSTRING_FIELD_NUMBER: builtins.int
    verb: Global___HTTPExtension.Verb.ValueType
    """Required. HTTP verb."""
    querystring: builtins.str
    """Optional. querystring represents an encoded HTTP url query string in the following format: name=value&name2=value2"""
    def __init__(
        self,
        *,
        verb: Global___HTTPExtension.Verb.ValueType = ...,
        querystring: builtins.str = ...,
    ) -> None: ...
    _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["querystring", b"querystring", "verb", b"verb"]
    def ClearField(self, field_name: _ClearFieldArgType) -> None: ...

Global___HTTPExtension: typing_extensions.TypeAlias = HTTPExtension

@typing.final
class InvokeRequest(google.protobuf.message.Message):
    """InvokeRequest is the message to invoke a method with the data.
    This message is used in InvokeService of Dapr gRPC Service and OnInvoke
    of AppCallback gRPC service.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    METHOD_FIELD_NUMBER: builtins.int
    DATA_FIELD_NUMBER: builtins.int
    CONTENT_TYPE_FIELD_NUMBER: builtins.int
    HTTP_EXTENSION_FIELD_NUMBER: builtins.int
    method: builtins.str
    """Required. method is a method name which will be invoked by caller."""
    content_type: builtins.str
    """The type of data content.

    This field is required if data delivers http request body
    Otherwise, this is optional.
    """
    @property
    def data(self) -> google.protobuf.any_pb2.Any:
        """Required in unary RPCs. Bytes value or Protobuf message which caller sent.
        Dapr treats Any.value as bytes type if Any.type_url is unset.
        """

    @property
    def http_extension(self) -> Global___HTTPExtension:
        """HTTP specific fields if request conveys http-compatible request.

        This field is required for http-compatible request. Otherwise,
        this field is optional.
        """

    def __init__(
        self,
        *,
        method: builtins.str = ...,
        data: google.protobuf.any_pb2.Any | None = ...,
        content_type: builtins.str = ...,
        http_extension: Global___HTTPExtension | None = ...,
    ) -> None: ...
    _HasFieldArgType: typing_extensions.TypeAlias = typing.Literal["data", b"data", "http_extension", b"http_extension"]
    def HasField(self, field_name: _HasFieldArgType) -> builtins.bool: ...
    _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["content_type", b"content_type", "data", b"data", "http_extension", b"http_extension", "method", b"method"]
    def ClearField(self, field_name: _ClearFieldArgType) -> None: ...

Global___InvokeRequest: typing_extensions.TypeAlias = InvokeRequest

@typing.final
class InvokeResponse(google.protobuf.message.Message):
    """InvokeResponse is the response message including data and its content type
    from app callback.
    This message is used in InvokeService of Dapr gRPC Service and OnInvoke
    of AppCallback gRPC service.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DATA_FIELD_NUMBER: builtins.int
    CONTENT_TYPE_FIELD_NUMBER: builtins.int
    content_type: builtins.str
    """Required. The type of data content."""
    @property
    def data(self) -> google.protobuf.any_pb2.Any:
        """Required in unary RPCs. The content body of InvokeService response."""

    def __init__(
        self,
        *,
        data: google.protobuf.any_pb2.Any | None = ...,
        content_type: builtins.str = ...,
    ) -> None: ...
    _HasFieldArgType: typing_extensions.TypeAlias = typing.Literal["data", b"data"]
    def HasField(self, field_name: _HasFieldArgType) -> builtins.bool: ...
    _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["content_type", b"content_type", "data", b"data"]
    def ClearField(self, field_name: _ClearFieldArgType) -> None: ...

Global___InvokeResponse: typing_extensions.TypeAlias = InvokeResponse

@typing.final
class StreamPayload(google.protobuf.message.Message):
    """Chunk of data sent in a streaming request or response.
    This is used in requests including InternalInvokeRequestStream.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DATA_FIELD_NUMBER: builtins.int
    SEQ_FIELD_NUMBER: builtins.int
    data: builtins.bytes
    """Data sent in the chunk.
    The amount of data included in each chunk is up to the discretion of the sender, and can be empty.
    Additionally, the amount of data doesn't need to be fixed and subsequent messages can send more, or less, data.
    Receivers must not make assumptions about the number of bytes they'll receive in each chunk.
    """
    seq: builtins.int
    """Sequence number. This is a counter that starts from 0 and increments by 1 on each chunk sent."""
    def __init__(
        self,
        *,
        data: builtins.bytes = ...,
        seq: builtins.int = ...,
    ) -> None: ...
    _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["data", b"data", "seq", b"seq"]
    def ClearField(self, field_name: _ClearFieldArgType) -> None: ...

Global___StreamPayload: typing_extensions.TypeAlias = StreamPayload

@typing.final
class StateItem(google.protobuf.message.Message):
    """StateItem represents state key, value, and additional options to save state."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class MetadataEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["key", b"key", "value", b"value"]
        def ClearField(self, field_name: _ClearFieldArgType) -> None: ...

    KEY_FIELD_NUMBER: builtins.int
    VALUE_FIELD_NUMBER: builtins.int
    ETAG_FIELD_NUMBER: builtins.int
    METADATA_FIELD_NUMBER: builtins.int
    OPTIONS_FIELD_NUMBER: builtins.int
    key: builtins.str
    """Required. The state key"""
    value: builtins.bytes
    """Required. The state data for key"""
    @property
    def etag(self) -> Global___Etag:
        """The entity tag which represents the specific version of data.
        The exact ETag format is defined by the corresponding data store.
        """

    @property
    def metadata(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """The metadata which will be passed to state store component."""

    @property
    def options(self) -> Global___StateOptions:
        """Options for concurrency and consistency to save the state."""

    def __init__(
        self,
        *,
        key: builtins.str = ...,
        value: builtins.bytes = ...,
        etag: Global___Etag | None = ...,
        metadata: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        options: Global___StateOptions | None = ...,
    ) -> None: ...
    _HasFieldArgType: typing_extensions.TypeAlias = typing.Literal["etag", b"etag", "options", b"options"]
    def HasField(self, field_name: _HasFieldArgType) -> builtins.bool: ...
    _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["etag", b"etag", "key", b"key", "metadata", b"metadata", "options", b"options", "value", b"value"]
    def ClearField(self, field_name: _ClearFieldArgType) -> None: ...

Global___StateItem: typing_extensions.TypeAlias = StateItem

@typing.final
class Etag(google.protobuf.message.Message):
    """Etag represents a state item version"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    VALUE_FIELD_NUMBER: builtins.int
    value: builtins.str
    """value sets the etag value"""
    def __init__(
        self,
        *,
        value: builtins.str = ...,
    ) -> None: ...
    _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["value", b"value"]
    def ClearField(self, field_name: _ClearFieldArgType) -> None: ...

Global___Etag: typing_extensions.TypeAlias = Etag

@typing.final
class StateOptions(google.protobuf.message.Message):
    """StateOptions configures concurrency and consistency for state operations"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _StateConcurrency:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _StateConcurrencyEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[StateOptions._StateConcurrency.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        CONCURRENCY_UNSPECIFIED: StateOptions._StateConcurrency.ValueType  # 0
        CONCURRENCY_FIRST_WRITE: StateOptions._StateConcurrency.ValueType  # 1
        CONCURRENCY_LAST_WRITE: StateOptions._StateConcurrency.ValueType  # 2

    class StateConcurrency(_StateConcurrency, metaclass=_StateConcurrencyEnumTypeWrapper):
        """Enum describing the supported concurrency for state."""

    CONCURRENCY_UNSPECIFIED: StateOptions.StateConcurrency.ValueType  # 0
    CONCURRENCY_FIRST_WRITE: StateOptions.StateConcurrency.ValueType  # 1
    CONCURRENCY_LAST_WRITE: StateOptions.StateConcurrency.ValueType  # 2

    class _StateConsistency:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _StateConsistencyEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[StateOptions._StateConsistency.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        CONSISTENCY_UNSPECIFIED: StateOptions._StateConsistency.ValueType  # 0
        CONSISTENCY_EVENTUAL: StateOptions._StateConsistency.ValueType  # 1
        CONSISTENCY_STRONG: StateOptions._StateConsistency.ValueType  # 2

    class StateConsistency(_StateConsistency, metaclass=_StateConsistencyEnumTypeWrapper):
        """Enum describing the supported consistency for state."""

    CONSISTENCY_UNSPECIFIED: StateOptions.StateConsistency.ValueType  # 0
    CONSISTENCY_EVENTUAL: StateOptions.StateConsistency.ValueType  # 1
    CONSISTENCY_STRONG: StateOptions.StateConsistency.ValueType  # 2

    CONCURRENCY_FIELD_NUMBER: builtins.int
    CONSISTENCY_FIELD_NUMBER: builtins.int
    concurrency: Global___StateOptions.StateConcurrency.ValueType
    consistency: Global___StateOptions.StateConsistency.ValueType
    def __init__(
        self,
        *,
        concurrency: Global___StateOptions.StateConcurrency.ValueType = ...,
        consistency: Global___StateOptions.StateConsistency.ValueType = ...,
    ) -> None: ...
    _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["concurrency", b"concurrency", "consistency", b"consistency"]
    def ClearField(self, field_name: _ClearFieldArgType) -> None: ...

Global___StateOptions: typing_extensions.TypeAlias = StateOptions

@typing.final
class ConfigurationItem(google.protobuf.message.Message):
    """ConfigurationItem represents all the configuration with its name(key)."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class MetadataEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["key", b"key", "value", b"value"]
        def ClearField(self, field_name: _ClearFieldArgType) -> None: ...

    VALUE_FIELD_NUMBER: builtins.int
    VERSION_FIELD_NUMBER: builtins.int
    METADATA_FIELD_NUMBER: builtins.int
    value: builtins.str
    """Required. The value of configuration item."""
    version: builtins.str
    """Version is response only and cannot be fetched. Store is not expected to keep all versions available"""
    @property
    def metadata(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """the metadata which will be passed to/from configuration store component."""

    def __init__(
        self,
        *,
        value: builtins.str = ...,
        version: builtins.str = ...,
        metadata: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
    ) -> None: ...
    _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["metadata", b"metadata", "value", b"value", "version", b"version"]
    def ClearField(self, field_name: _ClearFieldArgType) -> None: ...

Global___ConfigurationItem: typing_extensions.TypeAlias = ConfigurationItem

@typing.final
class JobFailurePolicy(google.protobuf.message.Message):
    """JobFailurePolicy defines the policy to apply when a job fails to trigger."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DROP_FIELD_NUMBER: builtins.int
    CONSTANT_FIELD_NUMBER: builtins.int
    @property
    def drop(self) -> Global___JobFailurePolicyDrop: ...
    @property
    def constant(self) -> Global___JobFailurePolicyConstant: ...
    def __init__(
        self,
        *,
        drop: Global___JobFailurePolicyDrop | None = ...,
        constant: Global___JobFailurePolicyConstant | None = ...,
    ) -> None: ...
    _HasFieldArgType: typing_extensions.TypeAlias = typing.Literal["constant", b"constant", "drop", b"drop", "policy", b"policy"]
    def HasField(self, field_name: _HasFieldArgType) -> builtins.bool: ...
    _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["constant", b"constant", "drop", b"drop", "policy", b"policy"]
    def ClearField(self, field_name: _ClearFieldArgType) -> None: ...
    _WhichOneofReturnType_policy: typing_extensions.TypeAlias = typing.Literal["drop", "constant"]
    _WhichOneofArgType_policy: typing_extensions.TypeAlias = typing.Literal["policy", b"policy"]
    def WhichOneof(self, oneof_group: _WhichOneofArgType_policy) -> _WhichOneofReturnType_policy | None: ...

Global___JobFailurePolicy: typing_extensions.TypeAlias = JobFailurePolicy

@typing.final
class JobFailurePolicyDrop(google.protobuf.message.Message):
    """JobFailurePolicyDrop is a policy which drops the job tick when the job fails to trigger."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

Global___JobFailurePolicyDrop: typing_extensions.TypeAlias = JobFailurePolicyDrop

@typing.final
class JobFailurePolicyConstant(google.protobuf.message.Message):
    """JobFailurePolicyConstant is a policy which retries the job at a consistent interval when the job fails to trigger."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INTERVAL_FIELD_NUMBER: builtins.int
    MAX_RETRIES_FIELD_NUMBER: builtins.int
    max_retries: builtins.int
    """max_retries is the optional maximum number of retries to attempt before giving up.
    If unset, the Job will be retried indefinitely.
    """
    @property
    def interval(self) -> google.protobuf.duration_pb2.Duration:
        """interval is the constant delay to wait before retrying the job."""

    def __init__(
        self,
        *,
        interval: google.protobuf.duration_pb2.Duration | None = ...,
        max_retries: builtins.int | None = ...,
    ) -> None: ...
    _HasFieldArgType: typing_extensions.TypeAlias = typing.Literal["_max_retries", b"_max_retries", "interval", b"interval", "max_retries", b"max_retries"]
    def HasField(self, field_name: _HasFieldArgType) -> builtins.bool: ...
    _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["_max_retries", b"_max_retries", "interval", b"interval", "max_retries", b"max_retries"]
    def ClearField(self, field_name: _ClearFieldArgType) -> None: ...
    _WhichOneofReturnType__max_retries: typing_extensions.TypeAlias = typing.Literal["max_retries"]
    _WhichOneofArgType__max_retries: typing_extensions.TypeAlias = typing.Literal["_max_retries", b"_max_retries"]
    def WhichOneof(self, oneof_group: _WhichOneofArgType__max_retries) -> _WhichOneofReturnType__max_retries | None: ...

Global___JobFailurePolicyConstant: typing_extensions.TypeAlias = JobFailurePolicyConstant
