"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file

Copyright 2025 The Dapr Authors
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
"""

import builtins
import collections.abc
import dapr.proto.common.v1.common_pb2
import google.protobuf.any_pb2
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.message
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class RegisterActorTimerRequest(google.protobuf.message.Message):
    """RegisterActorTimerRequest is the message to register a timer for an actor of a given type and id."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ACTOR_TYPE_FIELD_NUMBER: builtins.int
    ACTOR_ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DUE_TIME_FIELD_NUMBER: builtins.int
    PERIOD_FIELD_NUMBER: builtins.int
    CALLBACK_FIELD_NUMBER: builtins.int
    DATA_FIELD_NUMBER: builtins.int
    TTL_FIELD_NUMBER: builtins.int
    actor_type: builtins.str
    actor_id: builtins.str
    name: builtins.str
    due_time: builtins.str
    period: builtins.str
    callback: builtins.str
    data: builtins.bytes
    ttl: builtins.str
    def __init__(
        self,
        *,
        actor_type: builtins.str = ...,
        actor_id: builtins.str = ...,
        name: builtins.str = ...,
        due_time: builtins.str = ...,
        period: builtins.str = ...,
        callback: builtins.str = ...,
        data: builtins.bytes = ...,
        ttl: builtins.str = ...,
    ) -> None: ...
    _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["actor_id", b"actor_id", "actor_type", b"actor_type", "callback", b"callback", "data", b"data", "due_time", b"due_time", "name", b"name", "period", b"period", "ttl", b"ttl"]
    def ClearField(self, field_name: _ClearFieldArgType) -> None: ...

Global___RegisterActorTimerRequest: typing_extensions.TypeAlias = RegisterActorTimerRequest

@typing.final
class UnregisterActorTimerRequest(google.protobuf.message.Message):
    """UnregisterActorTimerRequest is the message to unregister an actor timer"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ACTOR_TYPE_FIELD_NUMBER: builtins.int
    ACTOR_ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    actor_type: builtins.str
    actor_id: builtins.str
    name: builtins.str
    def __init__(
        self,
        *,
        actor_type: builtins.str = ...,
        actor_id: builtins.str = ...,
        name: builtins.str = ...,
    ) -> None: ...
    _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["actor_id", b"actor_id", "actor_type", b"actor_type", "name", b"name"]
    def ClearField(self, field_name: _ClearFieldArgType) -> None: ...

Global___UnregisterActorTimerRequest: typing_extensions.TypeAlias = UnregisterActorTimerRequest

@typing.final
class RegisterActorReminderRequest(google.protobuf.message.Message):
    """RegisterActorReminderRequest is the message to register a reminder for an actor of a given type and id."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ACTOR_TYPE_FIELD_NUMBER: builtins.int
    ACTOR_ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DUE_TIME_FIELD_NUMBER: builtins.int
    PERIOD_FIELD_NUMBER: builtins.int
    DATA_FIELD_NUMBER: builtins.int
    TTL_FIELD_NUMBER: builtins.int
    OVERWRITE_FIELD_NUMBER: builtins.int
    FAILURE_POLICY_FIELD_NUMBER: builtins.int
    actor_type: builtins.str
    actor_id: builtins.str
    name: builtins.str
    due_time: builtins.str
    period: builtins.str
    data: builtins.bytes
    ttl: builtins.str
    overwrite: builtins.bool
    """If true, allows this reminder to overwrite an existing reminder with the
    same name. If not set, defaults to true.
    """
    @property
    def failure_policy(self) -> dapr.proto.common.v1.common_pb2.JobFailurePolicy:
        """failure_policy is the optional policy for handling job failures. If not
        set, the reminder will have the failure policy of trying 3 times on a
        single tick before giving up.
        """

    def __init__(
        self,
        *,
        actor_type: builtins.str = ...,
        actor_id: builtins.str = ...,
        name: builtins.str = ...,
        due_time: builtins.str = ...,
        period: builtins.str = ...,
        data: builtins.bytes = ...,
        ttl: builtins.str = ...,
        overwrite: builtins.bool | None = ...,
        failure_policy: dapr.proto.common.v1.common_pb2.JobFailurePolicy | None = ...,
    ) -> None: ...
    _HasFieldArgType: typing_extensions.TypeAlias = typing.Literal["_failure_policy", b"_failure_policy", "_overwrite", b"_overwrite", "failure_policy", b"failure_policy", "overwrite", b"overwrite"]
    def HasField(self, field_name: _HasFieldArgType) -> builtins.bool: ...
    _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["_failure_policy", b"_failure_policy", "_overwrite", b"_overwrite", "actor_id", b"actor_id", "actor_type", b"actor_type", "data", b"data", "due_time", b"due_time", "failure_policy", b"failure_policy", "name", b"name", "overwrite", b"overwrite", "period", b"period", "ttl", b"ttl"]
    def ClearField(self, field_name: _ClearFieldArgType) -> None: ...
    _WhichOneofReturnType__failure_policy: typing_extensions.TypeAlias = typing.Literal["failure_policy"]
    _WhichOneofArgType__failure_policy: typing_extensions.TypeAlias = typing.Literal["_failure_policy", b"_failure_policy"]
    _WhichOneofReturnType__overwrite: typing_extensions.TypeAlias = typing.Literal["overwrite"]
    _WhichOneofArgType__overwrite: typing_extensions.TypeAlias = typing.Literal["_overwrite", b"_overwrite"]
    @typing.overload
    def WhichOneof(self, oneof_group: _WhichOneofArgType__failure_policy) -> _WhichOneofReturnType__failure_policy | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: _WhichOneofArgType__overwrite) -> _WhichOneofReturnType__overwrite | None: ...

Global___RegisterActorReminderRequest: typing_extensions.TypeAlias = RegisterActorReminderRequest

@typing.final
class UnregisterActorReminderRequest(google.protobuf.message.Message):
    """UnregisterActorReminderRequest is the message to unregister an actor reminder."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ACTOR_TYPE_FIELD_NUMBER: builtins.int
    ACTOR_ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    actor_type: builtins.str
    actor_id: builtins.str
    name: builtins.str
    def __init__(
        self,
        *,
        actor_type: builtins.str = ...,
        actor_id: builtins.str = ...,
        name: builtins.str = ...,
    ) -> None: ...
    _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["actor_id", b"actor_id", "actor_type", b"actor_type", "name", b"name"]
    def ClearField(self, field_name: _ClearFieldArgType) -> None: ...

Global___UnregisterActorReminderRequest: typing_extensions.TypeAlias = UnregisterActorReminderRequest

@typing.final
class GetActorStateRequest(google.protobuf.message.Message):
    """GetActorStateRequest is the message to get key-value states from specific actor."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ACTOR_TYPE_FIELD_NUMBER: builtins.int
    ACTOR_ID_FIELD_NUMBER: builtins.int
    KEY_FIELD_NUMBER: builtins.int
    actor_type: builtins.str
    actor_id: builtins.str
    key: builtins.str
    def __init__(
        self,
        *,
        actor_type: builtins.str = ...,
        actor_id: builtins.str = ...,
        key: builtins.str = ...,
    ) -> None: ...
    _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["actor_id", b"actor_id", "actor_type", b"actor_type", "key", b"key"]
    def ClearField(self, field_name: _ClearFieldArgType) -> None: ...

Global___GetActorStateRequest: typing_extensions.TypeAlias = GetActorStateRequest

@typing.final
class GetActorStateResponse(google.protobuf.message.Message):
    """GetActorStateResponse is the response conveying the actor's state value."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class MetadataEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["key", b"key", "value", b"value"]
        def ClearField(self, field_name: _ClearFieldArgType) -> None: ...

    DATA_FIELD_NUMBER: builtins.int
    METADATA_FIELD_NUMBER: builtins.int
    data: builtins.bytes
    @property
    def metadata(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """The metadata which will be sent to app."""

    def __init__(
        self,
        *,
        data: builtins.bytes = ...,
        metadata: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
    ) -> None: ...
    _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["data", b"data", "metadata", b"metadata"]
    def ClearField(self, field_name: _ClearFieldArgType) -> None: ...

Global___GetActorStateResponse: typing_extensions.TypeAlias = GetActorStateResponse

@typing.final
class ExecuteActorStateTransactionRequest(google.protobuf.message.Message):
    """ExecuteActorStateTransactionRequest is the message to execute multiple operations on a specified actor."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ACTOR_TYPE_FIELD_NUMBER: builtins.int
    ACTOR_ID_FIELD_NUMBER: builtins.int
    OPERATIONS_FIELD_NUMBER: builtins.int
    actor_type: builtins.str
    actor_id: builtins.str
    @property
    def operations(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[Global___TransactionalActorStateOperation]: ...
    def __init__(
        self,
        *,
        actor_type: builtins.str = ...,
        actor_id: builtins.str = ...,
        operations: collections.abc.Iterable[Global___TransactionalActorStateOperation] | None = ...,
    ) -> None: ...
    _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["actor_id", b"actor_id", "actor_type", b"actor_type", "operations", b"operations"]
    def ClearField(self, field_name: _ClearFieldArgType) -> None: ...

Global___ExecuteActorStateTransactionRequest: typing_extensions.TypeAlias = ExecuteActorStateTransactionRequest

@typing.final
class TransactionalActorStateOperation(google.protobuf.message.Message):
    """TransactionalActorStateOperation is the message to execute a specified operation with a key-value pair."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class MetadataEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["key", b"key", "value", b"value"]
        def ClearField(self, field_name: _ClearFieldArgType) -> None: ...

    OPERATIONTYPE_FIELD_NUMBER: builtins.int
    KEY_FIELD_NUMBER: builtins.int
    VALUE_FIELD_NUMBER: builtins.int
    METADATA_FIELD_NUMBER: builtins.int
    operationType: builtins.str
    key: builtins.str
    @property
    def value(self) -> google.protobuf.any_pb2.Any: ...
    @property
    def metadata(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """The metadata used for transactional operations.

        Common metadata property:
        - ttlInSeconds : the time to live in seconds for the stored value.
        """

    def __init__(
        self,
        *,
        operationType: builtins.str = ...,
        key: builtins.str = ...,
        value: google.protobuf.any_pb2.Any | None = ...,
        metadata: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
    ) -> None: ...
    _HasFieldArgType: typing_extensions.TypeAlias = typing.Literal["value", b"value"]
    def HasField(self, field_name: _HasFieldArgType) -> builtins.bool: ...
    _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["key", b"key", "metadata", b"metadata", "operationType", b"operationType", "value", b"value"]
    def ClearField(self, field_name: _ClearFieldArgType) -> None: ...

Global___TransactionalActorStateOperation: typing_extensions.TypeAlias = TransactionalActorStateOperation

@typing.final
class InvokeActorRequest(google.protobuf.message.Message):
    """InvokeActorRequest is the message to call an actor."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class MetadataEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["key", b"key", "value", b"value"]
        def ClearField(self, field_name: _ClearFieldArgType) -> None: ...

    ACTOR_TYPE_FIELD_NUMBER: builtins.int
    ACTOR_ID_FIELD_NUMBER: builtins.int
    METHOD_FIELD_NUMBER: builtins.int
    DATA_FIELD_NUMBER: builtins.int
    METADATA_FIELD_NUMBER: builtins.int
    actor_type: builtins.str
    actor_id: builtins.str
    method: builtins.str
    data: builtins.bytes
    @property
    def metadata(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]: ...
    def __init__(
        self,
        *,
        actor_type: builtins.str = ...,
        actor_id: builtins.str = ...,
        method: builtins.str = ...,
        data: builtins.bytes = ...,
        metadata: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
    ) -> None: ...
    _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["actor_id", b"actor_id", "actor_type", b"actor_type", "data", b"data", "metadata", b"metadata", "method", b"method"]
    def ClearField(self, field_name: _ClearFieldArgType) -> None: ...

Global___InvokeActorRequest: typing_extensions.TypeAlias = InvokeActorRequest

@typing.final
class InvokeActorResponse(google.protobuf.message.Message):
    """InvokeActorResponse is the method that returns an actor invocation response."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    DATA_FIELD_NUMBER: builtins.int
    data: builtins.bytes
    def __init__(
        self,
        *,
        data: builtins.bytes = ...,
    ) -> None: ...
    _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["data", b"data"]
    def ClearField(self, field_name: _ClearFieldArgType) -> None: ...

Global___InvokeActorResponse: typing_extensions.TypeAlias = InvokeActorResponse

@typing.final
class GetActorReminderRequest(google.protobuf.message.Message):
    """GetActorReminderRequest is the message to get an already-registered actor reminder"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ACTOR_TYPE_FIELD_NUMBER: builtins.int
    ACTOR_ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    actor_type: builtins.str
    actor_id: builtins.str
    name: builtins.str
    def __init__(
        self,
        *,
        actor_type: builtins.str = ...,
        actor_id: builtins.str = ...,
        name: builtins.str = ...,
    ) -> None: ...
    _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["actor_id", b"actor_id", "actor_type", b"actor_type", "name", b"name"]
    def ClearField(self, field_name: _ClearFieldArgType) -> None: ...

Global___GetActorReminderRequest: typing_extensions.TypeAlias = GetActorReminderRequest

@typing.final
class GetActorReminderResponse(google.protobuf.message.Message):
    """GetActorReminderResponse is the response conveying an actor's reminder."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ACTOR_TYPE_FIELD_NUMBER: builtins.int
    ACTOR_ID_FIELD_NUMBER: builtins.int
    DUE_TIME_FIELD_NUMBER: builtins.int
    PERIOD_FIELD_NUMBER: builtins.int
    DATA_FIELD_NUMBER: builtins.int
    TTL_FIELD_NUMBER: builtins.int
    actor_type: builtins.str
    actor_id: builtins.str
    due_time: builtins.str
    period: builtins.str
    ttl: builtins.str
    @property
    def data(self) -> google.protobuf.any_pb2.Any: ...
    def __init__(
        self,
        *,
        actor_type: builtins.str = ...,
        actor_id: builtins.str = ...,
        due_time: builtins.str | None = ...,
        period: builtins.str | None = ...,
        data: google.protobuf.any_pb2.Any | None = ...,
        ttl: builtins.str | None = ...,
    ) -> None: ...
    _HasFieldArgType: typing_extensions.TypeAlias = typing.Literal["_due_time", b"_due_time", "_period", b"_period", "_ttl", b"_ttl", "data", b"data", "due_time", b"due_time", "period", b"period", "ttl", b"ttl"]
    def HasField(self, field_name: _HasFieldArgType) -> builtins.bool: ...
    _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["_due_time", b"_due_time", "_period", b"_period", "_ttl", b"_ttl", "actor_id", b"actor_id", "actor_type", b"actor_type", "data", b"data", "due_time", b"due_time", "period", b"period", "ttl", b"ttl"]
    def ClearField(self, field_name: _ClearFieldArgType) -> None: ...
    _WhichOneofReturnType__due_time: typing_extensions.TypeAlias = typing.Literal["due_time"]
    _WhichOneofArgType__due_time: typing_extensions.TypeAlias = typing.Literal["_due_time", b"_due_time"]
    _WhichOneofReturnType__period: typing_extensions.TypeAlias = typing.Literal["period"]
    _WhichOneofArgType__period: typing_extensions.TypeAlias = typing.Literal["_period", b"_period"]
    _WhichOneofReturnType__ttl: typing_extensions.TypeAlias = typing.Literal["ttl"]
    _WhichOneofArgType__ttl: typing_extensions.TypeAlias = typing.Literal["_ttl", b"_ttl"]
    @typing.overload
    def WhichOneof(self, oneof_group: _WhichOneofArgType__due_time) -> _WhichOneofReturnType__due_time | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: _WhichOneofArgType__period) -> _WhichOneofReturnType__period | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: _WhichOneofArgType__ttl) -> _WhichOneofReturnType__ttl | None: ...

Global___GetActorReminderResponse: typing_extensions.TypeAlias = GetActorReminderResponse

@typing.final
class ListActorRemindersRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ACTOR_TYPE_FIELD_NUMBER: builtins.int
    ACTOR_ID_FIELD_NUMBER: builtins.int
    actor_type: builtins.str
    actor_id: builtins.str
    def __init__(
        self,
        *,
        actor_type: builtins.str = ...,
        actor_id: builtins.str | None = ...,
    ) -> None: ...
    _HasFieldArgType: typing_extensions.TypeAlias = typing.Literal["_actor_id", b"_actor_id", "actor_id", b"actor_id"]
    def HasField(self, field_name: _HasFieldArgType) -> builtins.bool: ...
    _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["_actor_id", b"_actor_id", "actor_id", b"actor_id", "actor_type", b"actor_type"]
    def ClearField(self, field_name: _ClearFieldArgType) -> None: ...
    _WhichOneofReturnType__actor_id: typing_extensions.TypeAlias = typing.Literal["actor_id"]
    _WhichOneofArgType__actor_id: typing_extensions.TypeAlias = typing.Literal["_actor_id", b"_actor_id"]
    def WhichOneof(self, oneof_group: _WhichOneofArgType__actor_id) -> _WhichOneofReturnType__actor_id | None: ...

Global___ListActorRemindersRequest: typing_extensions.TypeAlias = ListActorRemindersRequest

@typing.final
class ListActorRemindersResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    REMINDERS_FIELD_NUMBER: builtins.int
    @property
    def reminders(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[Global___NamedActorReminder]: ...
    def __init__(
        self,
        *,
        reminders: collections.abc.Iterable[Global___NamedActorReminder] | None = ...,
    ) -> None: ...
    _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["reminders", b"reminders"]
    def ClearField(self, field_name: _ClearFieldArgType) -> None: ...

Global___ListActorRemindersResponse: typing_extensions.TypeAlias = ListActorRemindersResponse

@typing.final
class NamedActorReminder(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    REMINDER_FIELD_NUMBER: builtins.int
    name: builtins.str
    @property
    def reminder(self) -> Global___ActorReminder: ...
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        reminder: Global___ActorReminder | None = ...,
    ) -> None: ...
    _HasFieldArgType: typing_extensions.TypeAlias = typing.Literal["reminder", b"reminder"]
    def HasField(self, field_name: _HasFieldArgType) -> builtins.bool: ...
    _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["name", b"name", "reminder", b"reminder"]
    def ClearField(self, field_name: _ClearFieldArgType) -> None: ...

Global___NamedActorReminder: typing_extensions.TypeAlias = NamedActorReminder

@typing.final
class ActorReminder(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ACTOR_TYPE_FIELD_NUMBER: builtins.int
    ACTOR_ID_FIELD_NUMBER: builtins.int
    DUE_TIME_FIELD_NUMBER: builtins.int
    PERIOD_FIELD_NUMBER: builtins.int
    DATA_FIELD_NUMBER: builtins.int
    TTL_FIELD_NUMBER: builtins.int
    actor_type: builtins.str
    actor_id: builtins.str
    due_time: builtins.str
    period: builtins.str
    ttl: builtins.str
    @property
    def data(self) -> google.protobuf.any_pb2.Any: ...
    def __init__(
        self,
        *,
        actor_type: builtins.str = ...,
        actor_id: builtins.str = ...,
        due_time: builtins.str | None = ...,
        period: builtins.str | None = ...,
        data: google.protobuf.any_pb2.Any | None = ...,
        ttl: builtins.str | None = ...,
    ) -> None: ...
    _HasFieldArgType: typing_extensions.TypeAlias = typing.Literal["_due_time", b"_due_time", "_period", b"_period", "_ttl", b"_ttl", "data", b"data", "due_time", b"due_time", "period", b"period", "ttl", b"ttl"]
    def HasField(self, field_name: _HasFieldArgType) -> builtins.bool: ...
    _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["_due_time", b"_due_time", "_period", b"_period", "_ttl", b"_ttl", "actor_id", b"actor_id", "actor_type", b"actor_type", "data", b"data", "due_time", b"due_time", "period", b"period", "ttl", b"ttl"]
    def ClearField(self, field_name: _ClearFieldArgType) -> None: ...
    _WhichOneofReturnType__due_time: typing_extensions.TypeAlias = typing.Literal["due_time"]
    _WhichOneofArgType__due_time: typing_extensions.TypeAlias = typing.Literal["_due_time", b"_due_time"]
    _WhichOneofReturnType__period: typing_extensions.TypeAlias = typing.Literal["period"]
    _WhichOneofArgType__period: typing_extensions.TypeAlias = typing.Literal["_period", b"_period"]
    _WhichOneofReturnType__ttl: typing_extensions.TypeAlias = typing.Literal["ttl"]
    _WhichOneofArgType__ttl: typing_extensions.TypeAlias = typing.Literal["_ttl", b"_ttl"]
    @typing.overload
    def WhichOneof(self, oneof_group: _WhichOneofArgType__due_time) -> _WhichOneofReturnType__due_time | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: _WhichOneofArgType__period) -> _WhichOneofReturnType__period | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: _WhichOneofArgType__ttl) -> _WhichOneofReturnType__ttl | None: ...

Global___ActorReminder: typing_extensions.TypeAlias = ActorReminder

@typing.final
class UnregisterActorRemindersByTypeRequest(google.protobuf.message.Message):
    """UnregisterActorRemindersByTypeRequest is the message to unregister an actor
    reminders by the given type. Optional actor_id can be provided to limit the
    scope of the operation to a specific actor instance.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ACTOR_TYPE_FIELD_NUMBER: builtins.int
    ACTOR_ID_FIELD_NUMBER: builtins.int
    actor_type: builtins.str
    actor_id: builtins.str
    def __init__(
        self,
        *,
        actor_type: builtins.str = ...,
        actor_id: builtins.str | None = ...,
    ) -> None: ...
    _HasFieldArgType: typing_extensions.TypeAlias = typing.Literal["_actor_id", b"_actor_id", "actor_id", b"actor_id"]
    def HasField(self, field_name: _HasFieldArgType) -> builtins.bool: ...
    _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["_actor_id", b"_actor_id", "actor_id", b"actor_id", "actor_type", b"actor_type"]
    def ClearField(self, field_name: _ClearFieldArgType) -> None: ...
    _WhichOneofReturnType__actor_id: typing_extensions.TypeAlias = typing.Literal["actor_id"]
    _WhichOneofArgType__actor_id: typing_extensions.TypeAlias = typing.Literal["_actor_id", b"_actor_id"]
    def WhichOneof(self, oneof_group: _WhichOneofArgType__actor_id) -> _WhichOneofReturnType__actor_id | None: ...

Global___UnregisterActorRemindersByTypeRequest: typing_extensions.TypeAlias = UnregisterActorRemindersByTypeRequest

@typing.final
class UnregisterActorRemindersByTypeResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

Global___UnregisterActorRemindersByTypeResponse: typing_extensions.TypeAlias = UnregisterActorRemindersByTypeResponse
