"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file

Copyright 2025 The Dapr Authors
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
"""

import builtins
import collections.abc
import google.protobuf.any_pb2
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.message
import google.protobuf.struct_pb2
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

if sys.version_info >= (3, 13):
    from warnings import deprecated
else:
    from typing_extensions import deprecated

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@deprecated("""This message has been marked as deprecated using proto message options.""")
@typing.final
class ConversationRequest(google.protobuf.message.Message):
    """ConversationRequest is the request object for Conversation."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class ParametersEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        @property
        def value(self) -> google.protobuf.any_pb2.Any: ...
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: google.protobuf.any_pb2.Any | None = ...,
        ) -> None: ...
        _HasFieldArgType: typing_extensions.TypeAlias = typing.Literal["value", b"value"]
        def HasField(self, field_name: _HasFieldArgType) -> builtins.bool: ...
        _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["key", b"key", "value", b"value"]
        def ClearField(self, field_name: _ClearFieldArgType) -> None: ...

    @typing.final
    class MetadataEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["key", b"key", "value", b"value"]
        def ClearField(self, field_name: _ClearFieldArgType) -> None: ...

    NAME_FIELD_NUMBER: builtins.int
    CONTEXTID_FIELD_NUMBER: builtins.int
    INPUTS_FIELD_NUMBER: builtins.int
    PARAMETERS_FIELD_NUMBER: builtins.int
    METADATA_FIELD_NUMBER: builtins.int
    SCRUBPII_FIELD_NUMBER: builtins.int
    TEMPERATURE_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The name of Conversation component"""
    contextID: builtins.str
    """The ID of an existing chat (like in ChatGPT)"""
    scrubPII: builtins.bool
    """Scrub PII data that comes back from the LLM"""
    temperature: builtins.float
    """Temperature for the LLM to optimize for creativity or predictability"""
    @property
    def inputs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[Global___ConversationInput]:
        """Inputs for the conversation, support multiple input in one time."""

    @property
    def parameters(self) -> google.protobuf.internal.containers.MessageMap[builtins.str, google.protobuf.any_pb2.Any]:
        """Parameters for all custom fields."""

    @property
    def metadata(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """The metadata passing to conversation components."""

    def __init__(
        self,
        *,
        name: builtins.str = ...,
        contextID: builtins.str | None = ...,
        inputs: collections.abc.Iterable[Global___ConversationInput] | None = ...,
        parameters: collections.abc.Mapping[builtins.str, google.protobuf.any_pb2.Any] | None = ...,
        metadata: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        scrubPII: builtins.bool | None = ...,
        temperature: builtins.float | None = ...,
    ) -> None: ...
    _HasFieldArgType: typing_extensions.TypeAlias = typing.Literal["_contextID", b"_contextID", "_scrubPII", b"_scrubPII", "_temperature", b"_temperature", "contextID", b"contextID", "scrubPII", b"scrubPII", "temperature", b"temperature"]
    def HasField(self, field_name: _HasFieldArgType) -> builtins.bool: ...
    _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["_contextID", b"_contextID", "_scrubPII", b"_scrubPII", "_temperature", b"_temperature", "contextID", b"contextID", "inputs", b"inputs", "metadata", b"metadata", "name", b"name", "parameters", b"parameters", "scrubPII", b"scrubPII", "temperature", b"temperature"]
    def ClearField(self, field_name: _ClearFieldArgType) -> None: ...
    _WhichOneofReturnType__contextID: typing_extensions.TypeAlias = typing.Literal["contextID"]
    _WhichOneofArgType__contextID: typing_extensions.TypeAlias = typing.Literal["_contextID", b"_contextID"]
    _WhichOneofReturnType__scrubPII: typing_extensions.TypeAlias = typing.Literal["scrubPII"]
    _WhichOneofArgType__scrubPII: typing_extensions.TypeAlias = typing.Literal["_scrubPII", b"_scrubPII"]
    _WhichOneofReturnType__temperature: typing_extensions.TypeAlias = typing.Literal["temperature"]
    _WhichOneofArgType__temperature: typing_extensions.TypeAlias = typing.Literal["_temperature", b"_temperature"]
    @typing.overload
    def WhichOneof(self, oneof_group: _WhichOneofArgType__contextID) -> _WhichOneofReturnType__contextID | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: _WhichOneofArgType__scrubPII) -> _WhichOneofReturnType__scrubPII | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: _WhichOneofArgType__temperature) -> _WhichOneofReturnType__temperature | None: ...

Global___ConversationRequest: typing_extensions.TypeAlias = ConversationRequest

@typing.final
class ConversationRequestAlpha2(google.protobuf.message.Message):
    """ConversationRequestAlpha2 is the new request object for Conversation.
    Many of these fields are inspired by openai.ChatCompletionNewParams
    https://github.com/openai/openai-go/blob/main/chatcompletion.go#L2106
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class ParametersEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        @property
        def value(self) -> google.protobuf.any_pb2.Any: ...
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: google.protobuf.any_pb2.Any | None = ...,
        ) -> None: ...
        _HasFieldArgType: typing_extensions.TypeAlias = typing.Literal["value", b"value"]
        def HasField(self, field_name: _HasFieldArgType) -> builtins.bool: ...
        _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["key", b"key", "value", b"value"]
        def ClearField(self, field_name: _ClearFieldArgType) -> None: ...

    @typing.final
    class MetadataEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["key", b"key", "value", b"value"]
        def ClearField(self, field_name: _ClearFieldArgType) -> None: ...

    NAME_FIELD_NUMBER: builtins.int
    CONTEXT_ID_FIELD_NUMBER: builtins.int
    INPUTS_FIELD_NUMBER: builtins.int
    PARAMETERS_FIELD_NUMBER: builtins.int
    METADATA_FIELD_NUMBER: builtins.int
    SCRUB_PII_FIELD_NUMBER: builtins.int
    TEMPERATURE_FIELD_NUMBER: builtins.int
    TOOLS_FIELD_NUMBER: builtins.int
    TOOL_CHOICE_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The name of Conversation component"""
    context_id: builtins.str
    """The ID of an existing chat (like in ChatGPT)"""
    scrub_pii: builtins.bool
    """Scrub PII data that comes back from the LLM"""
    temperature: builtins.float
    """Temperature for the LLM to optimize for creativity or predictability"""
    tool_choice: builtins.str
    """Controls which (if any) tool is called by the model. 
    `none` means the model will not call any tool and instead generates a message. 
    `auto` means the model can pick between generating a message or calling one or more tools.
    Alternatively, a specific tool name may be used here, and casing/syntax must match on tool name.
    `none` is the default when no tools are present.
    `auto` is the default if tools are present.
    `required` requires one or more functions to be called.
    ref: https://github.com/openai/openai-go/blob/main/chatcompletion.go#L1976
    ref: https://python.langchain.com/docs/how_to/tool_choice/
    """
    @property
    def inputs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[Global___ConversationInputAlpha2]:
        """Inputs for the conversation, support multiple input in one time.
        This is the revamped conversation inputs better matching openai.
        """

    @property
    def parameters(self) -> google.protobuf.internal.containers.MessageMap[builtins.str, google.protobuf.any_pb2.Any]:
        """Parameters for all custom fields."""

    @property
    def metadata(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """The metadata passing to conversation components."""

    @property
    def tools(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[Global___ConversationTools]:
        """Tools register the tools available to be used by the LLM during the conversation.
        These are sent on a per request basis.
        The tools available during the first round of the conversation
        may be different than tools specified later on.
        """

    def __init__(
        self,
        *,
        name: builtins.str = ...,
        context_id: builtins.str | None = ...,
        inputs: collections.abc.Iterable[Global___ConversationInputAlpha2] | None = ...,
        parameters: collections.abc.Mapping[builtins.str, google.protobuf.any_pb2.Any] | None = ...,
        metadata: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        scrub_pii: builtins.bool | None = ...,
        temperature: builtins.float | None = ...,
        tools: collections.abc.Iterable[Global___ConversationTools] | None = ...,
        tool_choice: builtins.str | None = ...,
    ) -> None: ...
    _HasFieldArgType: typing_extensions.TypeAlias = typing.Literal["_context_id", b"_context_id", "_scrub_pii", b"_scrub_pii", "_temperature", b"_temperature", "_tool_choice", b"_tool_choice", "context_id", b"context_id", "scrub_pii", b"scrub_pii", "temperature", b"temperature", "tool_choice", b"tool_choice"]
    def HasField(self, field_name: _HasFieldArgType) -> builtins.bool: ...
    _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["_context_id", b"_context_id", "_scrub_pii", b"_scrub_pii", "_temperature", b"_temperature", "_tool_choice", b"_tool_choice", "context_id", b"context_id", "inputs", b"inputs", "metadata", b"metadata", "name", b"name", "parameters", b"parameters", "scrub_pii", b"scrub_pii", "temperature", b"temperature", "tool_choice", b"tool_choice", "tools", b"tools"]
    def ClearField(self, field_name: _ClearFieldArgType) -> None: ...
    _WhichOneofReturnType__context_id: typing_extensions.TypeAlias = typing.Literal["context_id"]
    _WhichOneofArgType__context_id: typing_extensions.TypeAlias = typing.Literal["_context_id", b"_context_id"]
    _WhichOneofReturnType__scrub_pii: typing_extensions.TypeAlias = typing.Literal["scrub_pii"]
    _WhichOneofArgType__scrub_pii: typing_extensions.TypeAlias = typing.Literal["_scrub_pii", b"_scrub_pii"]
    _WhichOneofReturnType__temperature: typing_extensions.TypeAlias = typing.Literal["temperature"]
    _WhichOneofArgType__temperature: typing_extensions.TypeAlias = typing.Literal["_temperature", b"_temperature"]
    _WhichOneofReturnType__tool_choice: typing_extensions.TypeAlias = typing.Literal["tool_choice"]
    _WhichOneofArgType__tool_choice: typing_extensions.TypeAlias = typing.Literal["_tool_choice", b"_tool_choice"]
    @typing.overload
    def WhichOneof(self, oneof_group: _WhichOneofArgType__context_id) -> _WhichOneofReturnType__context_id | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: _WhichOneofArgType__scrub_pii) -> _WhichOneofReturnType__scrub_pii | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: _WhichOneofArgType__temperature) -> _WhichOneofReturnType__temperature | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: _WhichOneofArgType__tool_choice) -> _WhichOneofReturnType__tool_choice | None: ...

Global___ConversationRequestAlpha2: typing_extensions.TypeAlias = ConversationRequestAlpha2

@deprecated("""This message has been marked as deprecated using proto message options.""")
@typing.final
class ConversationInput(google.protobuf.message.Message):
    """maintained for backwards compatibility"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONTENT_FIELD_NUMBER: builtins.int
    ROLE_FIELD_NUMBER: builtins.int
    SCRUBPII_FIELD_NUMBER: builtins.int
    content: builtins.str
    """The content to send to the llm"""
    role: builtins.str
    """The role to set for the message"""
    scrubPII: builtins.bool
    """Scrub PII data that goes into the LLM"""
    def __init__(
        self,
        *,
        content: builtins.str = ...,
        role: builtins.str | None = ...,
        scrubPII: builtins.bool | None = ...,
    ) -> None: ...
    _HasFieldArgType: typing_extensions.TypeAlias = typing.Literal["_role", b"_role", "_scrubPII", b"_scrubPII", "role", b"role", "scrubPII", b"scrubPII"]
    def HasField(self, field_name: _HasFieldArgType) -> builtins.bool: ...
    _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["_role", b"_role", "_scrubPII", b"_scrubPII", "content", b"content", "role", b"role", "scrubPII", b"scrubPII"]
    def ClearField(self, field_name: _ClearFieldArgType) -> None: ...
    _WhichOneofReturnType__role: typing_extensions.TypeAlias = typing.Literal["role"]
    _WhichOneofArgType__role: typing_extensions.TypeAlias = typing.Literal["_role", b"_role"]
    _WhichOneofReturnType__scrubPII: typing_extensions.TypeAlias = typing.Literal["scrubPII"]
    _WhichOneofArgType__scrubPII: typing_extensions.TypeAlias = typing.Literal["_scrubPII", b"_scrubPII"]
    @typing.overload
    def WhichOneof(self, oneof_group: _WhichOneofArgType__role) -> _WhichOneofReturnType__role | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: _WhichOneofArgType__scrubPII) -> _WhichOneofReturnType__scrubPII | None: ...

Global___ConversationInput: typing_extensions.TypeAlias = ConversationInput

@typing.final
class ConversationInputAlpha2(google.protobuf.message.Message):
    """directly inspired by openai.ChatCompletionNewParams
    https://github.com/openai/openai-go/blob/main/chatcompletion.go#L2106
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MESSAGES_FIELD_NUMBER: builtins.int
    SCRUB_PII_FIELD_NUMBER: builtins.int
    scrub_pii: builtins.bool
    """Scrub PII data that goes into the LLM"""
    @property
    def messages(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[Global___ConversationMessage]:
        """The content to send to the llm"""

    def __init__(
        self,
        *,
        messages: collections.abc.Iterable[Global___ConversationMessage] | None = ...,
        scrub_pii: builtins.bool | None = ...,
    ) -> None: ...
    _HasFieldArgType: typing_extensions.TypeAlias = typing.Literal["_scrub_pii", b"_scrub_pii", "scrub_pii", b"scrub_pii"]
    def HasField(self, field_name: _HasFieldArgType) -> builtins.bool: ...
    _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["_scrub_pii", b"_scrub_pii", "messages", b"messages", "scrub_pii", b"scrub_pii"]
    def ClearField(self, field_name: _ClearFieldArgType) -> None: ...
    _WhichOneofReturnType__scrub_pii: typing_extensions.TypeAlias = typing.Literal["scrub_pii"]
    _WhichOneofArgType__scrub_pii: typing_extensions.TypeAlias = typing.Literal["_scrub_pii", b"_scrub_pii"]
    def WhichOneof(self, oneof_group: _WhichOneofArgType__scrub_pii) -> _WhichOneofReturnType__scrub_pii | None: ...

Global___ConversationInputAlpha2: typing_extensions.TypeAlias = ConversationInputAlpha2

@typing.final
class ConversationMessage(google.protobuf.message.Message):
    """inspired by openai.ChatCompletionMessageParamUnion
    https://github.com/openai/openai-go/blob/main/chatcompletion.go#L1449
    The role field is inherent to the type of ConversationMessage,
    and is propagated in the backend according to the underlying LLM provider type.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    OF_DEVELOPER_FIELD_NUMBER: builtins.int
    OF_SYSTEM_FIELD_NUMBER: builtins.int
    OF_USER_FIELD_NUMBER: builtins.int
    OF_ASSISTANT_FIELD_NUMBER: builtins.int
    OF_TOOL_FIELD_NUMBER: builtins.int
    @property
    def of_developer(self) -> Global___ConversationMessageOfDeveloper: ...
    @property
    def of_system(self) -> Global___ConversationMessageOfSystem: ...
    @property
    def of_user(self) -> Global___ConversationMessageOfUser: ...
    @property
    def of_assistant(self) -> Global___ConversationMessageOfAssistant: ...
    @property
    def of_tool(self) -> Global___ConversationMessageOfTool:
        """Note: there could be a ConversationMessageOfFunction type here too, 
        but that is deprecated in openai, so we will not support this.
        """

    def __init__(
        self,
        *,
        of_developer: Global___ConversationMessageOfDeveloper | None = ...,
        of_system: Global___ConversationMessageOfSystem | None = ...,
        of_user: Global___ConversationMessageOfUser | None = ...,
        of_assistant: Global___ConversationMessageOfAssistant | None = ...,
        of_tool: Global___ConversationMessageOfTool | None = ...,
    ) -> None: ...
    _HasFieldArgType: typing_extensions.TypeAlias = typing.Literal["message_types", b"message_types", "of_assistant", b"of_assistant", "of_developer", b"of_developer", "of_system", b"of_system", "of_tool", b"of_tool", "of_user", b"of_user"]
    def HasField(self, field_name: _HasFieldArgType) -> builtins.bool: ...
    _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["message_types", b"message_types", "of_assistant", b"of_assistant", "of_developer", b"of_developer", "of_system", b"of_system", "of_tool", b"of_tool", "of_user", b"of_user"]
    def ClearField(self, field_name: _ClearFieldArgType) -> None: ...
    _WhichOneofReturnType_message_types: typing_extensions.TypeAlias = typing.Literal["of_developer", "of_system", "of_user", "of_assistant", "of_tool"]
    _WhichOneofArgType_message_types: typing_extensions.TypeAlias = typing.Literal["message_types", b"message_types"]
    def WhichOneof(self, oneof_group: _WhichOneofArgType_message_types) -> _WhichOneofReturnType_message_types | None: ...

Global___ConversationMessage: typing_extensions.TypeAlias = ConversationMessage

@typing.final
class ConversationMessageOfDeveloper(google.protobuf.message.Message):
    """inspired by openai.ChatCompletionDeveloperMessageParam
    https://github.com/openai/openai-go/blob/main/chatcompletion.go#L1130
    ConversationMessageOfDeveloper is intended to be the contents of a conversation message,
    as the role of a developer.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    CONTENT_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The name of the participant in the message."""
    @property
    def content(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[Global___ConversationMessageContent]: ...
    def __init__(
        self,
        *,
        name: builtins.str | None = ...,
        content: collections.abc.Iterable[Global___ConversationMessageContent] | None = ...,
    ) -> None: ...
    _HasFieldArgType: typing_extensions.TypeAlias = typing.Literal["_name", b"_name", "name", b"name"]
    def HasField(self, field_name: _HasFieldArgType) -> builtins.bool: ...
    _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["_name", b"_name", "content", b"content", "name", b"name"]
    def ClearField(self, field_name: _ClearFieldArgType) -> None: ...
    _WhichOneofReturnType__name: typing_extensions.TypeAlias = typing.Literal["name"]
    _WhichOneofArgType__name: typing_extensions.TypeAlias = typing.Literal["_name", b"_name"]
    def WhichOneof(self, oneof_group: _WhichOneofArgType__name) -> _WhichOneofReturnType__name | None: ...

Global___ConversationMessageOfDeveloper: typing_extensions.TypeAlias = ConversationMessageOfDeveloper

@typing.final
class ConversationMessageOfSystem(google.protobuf.message.Message):
    """inspired by openai.ChatCompletionSystemMessageParam
    https://github.com/openai/openai-go/blob/main/chatcompletion.go#L1842
    ConversationMessageOfSystem is intended to be the contents of a conversation message,
    as the role of a system.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    CONTENT_FIELD_NUMBER: builtins.int
    name: builtins.str
    @property
    def content(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[Global___ConversationMessageContent]: ...
    def __init__(
        self,
        *,
        name: builtins.str | None = ...,
        content: collections.abc.Iterable[Global___ConversationMessageContent] | None = ...,
    ) -> None: ...
    _HasFieldArgType: typing_extensions.TypeAlias = typing.Literal["_name", b"_name", "name", b"name"]
    def HasField(self, field_name: _HasFieldArgType) -> builtins.bool: ...
    _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["_name", b"_name", "content", b"content", "name", b"name"]
    def ClearField(self, field_name: _ClearFieldArgType) -> None: ...
    _WhichOneofReturnType__name: typing_extensions.TypeAlias = typing.Literal["name"]
    _WhichOneofArgType__name: typing_extensions.TypeAlias = typing.Literal["_name", b"_name"]
    def WhichOneof(self, oneof_group: _WhichOneofArgType__name) -> _WhichOneofReturnType__name | None: ...

Global___ConversationMessageOfSystem: typing_extensions.TypeAlias = ConversationMessageOfSystem

@typing.final
class ConversationMessageOfUser(google.protobuf.message.Message):
    """inspired by openai.ChatCompletionUserMessageParam
    https://github.com/openai/openai-go/blob/main/chatcompletion.go#L2060C6-L2060C36
    ConversationMessageOfUser is intended to be the contents of a conversation message,
    as the role of an end user.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    CONTENT_FIELD_NUMBER: builtins.int
    name: builtins.str
    @property
    def content(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[Global___ConversationMessageContent]: ...
    def __init__(
        self,
        *,
        name: builtins.str | None = ...,
        content: collections.abc.Iterable[Global___ConversationMessageContent] | None = ...,
    ) -> None: ...
    _HasFieldArgType: typing_extensions.TypeAlias = typing.Literal["_name", b"_name", "name", b"name"]
    def HasField(self, field_name: _HasFieldArgType) -> builtins.bool: ...
    _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["_name", b"_name", "content", b"content", "name", b"name"]
    def ClearField(self, field_name: _ClearFieldArgType) -> None: ...
    _WhichOneofReturnType__name: typing_extensions.TypeAlias = typing.Literal["name"]
    _WhichOneofArgType__name: typing_extensions.TypeAlias = typing.Literal["_name", b"_name"]
    def WhichOneof(self, oneof_group: _WhichOneofArgType__name) -> _WhichOneofReturnType__name | None: ...

Global___ConversationMessageOfUser: typing_extensions.TypeAlias = ConversationMessageOfUser

@typing.final
class ConversationMessageOfAssistant(google.protobuf.message.Message):
    """inspired by openai.ChatCompletionAssistantMessageParam
    https://github.com/openai/openai-go/blob/main/chatcompletion.go#L310
    https://github.com/openai/openai-go/blob/main/chatcompletion.go#L2060C6-L2060C36
    ConversationMessageOfAssistant is intended to be the contents of a conversation message,
    as the role of an assistant.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    CONTENT_FIELD_NUMBER: builtins.int
    TOOL_CALLS_FIELD_NUMBER: builtins.int
    name: builtins.str
    @property
    def content(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[Global___ConversationMessageContent]:
        """TODO: there is an audio field here to bring in when the time comes 1.17 or later."""

    @property
    def tool_calls(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[Global___ConversationToolCalls]:
        """Tool calls generated by the model, such as function calls for the client to then make."""

    def __init__(
        self,
        *,
        name: builtins.str | None = ...,
        content: collections.abc.Iterable[Global___ConversationMessageContent] | None = ...,
        tool_calls: collections.abc.Iterable[Global___ConversationToolCalls] | None = ...,
    ) -> None: ...
    _HasFieldArgType: typing_extensions.TypeAlias = typing.Literal["_name", b"_name", "name", b"name"]
    def HasField(self, field_name: _HasFieldArgType) -> builtins.bool: ...
    _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["_name", b"_name", "content", b"content", "name", b"name", "tool_calls", b"tool_calls"]
    def ClearField(self, field_name: _ClearFieldArgType) -> None: ...
    _WhichOneofReturnType__name: typing_extensions.TypeAlias = typing.Literal["name"]
    _WhichOneofArgType__name: typing_extensions.TypeAlias = typing.Literal["_name", b"_name"]
    def WhichOneof(self, oneof_group: _WhichOneofArgType__name) -> _WhichOneofReturnType__name | None: ...

Global___ConversationMessageOfAssistant: typing_extensions.TypeAlias = ConversationMessageOfAssistant

@typing.final
class ConversationMessageOfTool(google.protobuf.message.Message):
    """inspired by openai.ChatCompletionToolMessageParam
    https://github.com/openai/openai-go/blob/main/chatcompletion.go#L2011
    ConversationMessageOfTool is intended to be the contents of a conversation message,
    as the role of a tool.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TOOL_ID_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    CONTENT_FIELD_NUMBER: builtins.int
    tool_id: builtins.str
    """Tool ID is helpful for tracking tool history"""
    name: builtins.str
    """Name of tool associated with the message"""
    @property
    def content(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[Global___ConversationMessageContent]: ...
    def __init__(
        self,
        *,
        tool_id: builtins.str | None = ...,
        name: builtins.str = ...,
        content: collections.abc.Iterable[Global___ConversationMessageContent] | None = ...,
    ) -> None: ...
    _HasFieldArgType: typing_extensions.TypeAlias = typing.Literal["_tool_id", b"_tool_id", "tool_id", b"tool_id"]
    def HasField(self, field_name: _HasFieldArgType) -> builtins.bool: ...
    _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["_tool_id", b"_tool_id", "content", b"content", "name", b"name", "tool_id", b"tool_id"]
    def ClearField(self, field_name: _ClearFieldArgType) -> None: ...
    _WhichOneofReturnType__tool_id: typing_extensions.TypeAlias = typing.Literal["tool_id"]
    _WhichOneofArgType__tool_id: typing_extensions.TypeAlias = typing.Literal["_tool_id", b"_tool_id"]
    def WhichOneof(self, oneof_group: _WhichOneofArgType__tool_id) -> _WhichOneofReturnType__tool_id | None: ...

Global___ConversationMessageOfTool: typing_extensions.TypeAlias = ConversationMessageOfTool

@typing.final
class ConversationToolCalls(google.protobuf.message.Message):
    """inspired by openai.ChatCompletionMessageToolCallParam and openai.ChatCompletionMessageToolCall
    https://github.com/openai/openai-go/blob/main/chatcompletion.go#L1669
    https://github.com/openai/openai-go/blob/main/chatcompletion.go#L1611
    ConversationToolCalls is the tool call request sent from the llm to the client to then call to execute.
    This assumes that in our api if a client makes a request that would get a tool call response from the llm,
    that this client can also have the tool handy itself to execute it.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    FUNCTION_FIELD_NUMBER: builtins.int
    id: builtins.str
    @property
    def function(self) -> Global___ConversationToolCallsOfFunction: ...
    def __init__(
        self,
        *,
        id: builtins.str | None = ...,
        function: Global___ConversationToolCallsOfFunction | None = ...,
    ) -> None: ...
    _HasFieldArgType: typing_extensions.TypeAlias = typing.Literal["_id", b"_id", "function", b"function", "id", b"id", "tool_types", b"tool_types"]
    def HasField(self, field_name: _HasFieldArgType) -> builtins.bool: ...
    _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["_id", b"_id", "function", b"function", "id", b"id", "tool_types", b"tool_types"]
    def ClearField(self, field_name: _ClearFieldArgType) -> None: ...
    _WhichOneofReturnType__id: typing_extensions.TypeAlias = typing.Literal["id"]
    _WhichOneofArgType__id: typing_extensions.TypeAlias = typing.Literal["_id", b"_id"]
    _WhichOneofReturnType_tool_types: typing_extensions.TypeAlias = typing.Literal["function"]
    _WhichOneofArgType_tool_types: typing_extensions.TypeAlias = typing.Literal["tool_types", b"tool_types"]
    @typing.overload
    def WhichOneof(self, oneof_group: _WhichOneofArgType__id) -> _WhichOneofReturnType__id | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: _WhichOneofArgType_tool_types) -> _WhichOneofReturnType_tool_types | None: ...

Global___ConversationToolCalls: typing_extensions.TypeAlias = ConversationToolCalls

@typing.final
class ConversationToolCallsOfFunction(google.protobuf.message.Message):
    """inspired by openai.ChatCompletionMessageToolCallFunctionParam
    https://github.com/openai/openai-go/blob/main/chatcompletion.go#L1692
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    ARGUMENTS_FIELD_NUMBER: builtins.int
    name: builtins.str
    arguments: builtins.str
    """The arguments to call the function with, as generated by the model in JSON
    format. Note that the model does not always generate valid JSON, and may
    hallucinate parameters not defined by your function schema. Validate the
    arguments in your code before calling your function.
    """
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        arguments: builtins.str = ...,
    ) -> None: ...
    _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["arguments", b"arguments", "name", b"name"]
    def ClearField(self, field_name: _ClearFieldArgType) -> None: ...

Global___ConversationToolCallsOfFunction: typing_extensions.TypeAlias = ConversationToolCallsOfFunction

@typing.final
class ConversationMessageContent(google.protobuf.message.Message):
    """inspired by openai.ChatCompletionContentPartTextParam & openai.ChatCompletionDeveloperMessageParamContentUnion
    https://github.com/openai/openai-go/blob/main/chatcompletion.go#L1084
    https://github.com/openai/openai-go/blob/main/chatcompletion.go#L1154C6-L1154C53
    Note: openai has this message be either a message of string or message of array type,
    so instead of this, we support that in one message type instead.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TEXT_FIELD_NUMBER: builtins.int
    text: builtins.str
    def __init__(
        self,
        *,
        text: builtins.str = ...,
    ) -> None: ...
    _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["text", b"text"]
    def ClearField(self, field_name: _ClearFieldArgType) -> None: ...

Global___ConversationMessageContent: typing_extensions.TypeAlias = ConversationMessageContent

@deprecated("""This message has been marked as deprecated using proto message options.""")
@typing.final
class ConversationResult(google.protobuf.message.Message):
    """ConversationResult is the result for one input."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class ParametersEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        @property
        def value(self) -> google.protobuf.any_pb2.Any: ...
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: google.protobuf.any_pb2.Any | None = ...,
        ) -> None: ...
        _HasFieldArgType: typing_extensions.TypeAlias = typing.Literal["value", b"value"]
        def HasField(self, field_name: _HasFieldArgType) -> builtins.bool: ...
        _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["key", b"key", "value", b"value"]
        def ClearField(self, field_name: _ClearFieldArgType) -> None: ...

    RESULT_FIELD_NUMBER: builtins.int
    PARAMETERS_FIELD_NUMBER: builtins.int
    result: builtins.str
    """Result for the one conversation input."""
    @property
    def parameters(self) -> google.protobuf.internal.containers.MessageMap[builtins.str, google.protobuf.any_pb2.Any]:
        """Parameters for all custom fields."""

    def __init__(
        self,
        *,
        result: builtins.str = ...,
        parameters: collections.abc.Mapping[builtins.str, google.protobuf.any_pb2.Any] | None = ...,
    ) -> None: ...
    _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["parameters", b"parameters", "result", b"result"]
    def ClearField(self, field_name: _ClearFieldArgType) -> None: ...

Global___ConversationResult: typing_extensions.TypeAlias = ConversationResult

@typing.final
class ConversationResultAlpha2(google.protobuf.message.Message):
    """inspired by openai.ChatCompletion
    ConversationResultAlpha2 is the result for one input.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CHOICES_FIELD_NUMBER: builtins.int
    @property
    def choices(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[Global___ConversationResultChoices]:
        """Result for the conversation input."""

    def __init__(
        self,
        *,
        choices: collections.abc.Iterable[Global___ConversationResultChoices] | None = ...,
    ) -> None: ...
    _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["choices", b"choices"]
    def ClearField(self, field_name: _ClearFieldArgType) -> None: ...

Global___ConversationResultAlpha2: typing_extensions.TypeAlias = ConversationResultAlpha2

@typing.final
class ConversationResultChoices(google.protobuf.message.Message):
    """inspired by openai.ChatCompletionChoice
    based on https://github.com/openai/openai-go/blob/main/chatcompletion.go#L226
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FINISH_REASON_FIELD_NUMBER: builtins.int
    INDEX_FIELD_NUMBER: builtins.int
    MESSAGE_FIELD_NUMBER: builtins.int
    finish_reason: builtins.str
    """The reason the model stopped generating tokens. This will be `stop` if the model
    hit a natural stop point or a provided stop sequence, `length` if the maximum
    number of tokens specified in the request was reached, `content_filter` if
    content was omitted due to a flag from our content filters, `tool_calls` if the
    model called a tool.
    Any of "stop", "length", "tool_calls", "content_filter".
    """
    index: builtins.int
    """The index of the choice in the list of choices."""
    @property
    def message(self) -> Global___ConversationResultMessage: ...
    def __init__(
        self,
        *,
        finish_reason: builtins.str = ...,
        index: builtins.int = ...,
        message: Global___ConversationResultMessage | None = ...,
    ) -> None: ...
    _HasFieldArgType: typing_extensions.TypeAlias = typing.Literal["message", b"message"]
    def HasField(self, field_name: _HasFieldArgType) -> builtins.bool: ...
    _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["finish_reason", b"finish_reason", "index", b"index", "message", b"message"]
    def ClearField(self, field_name: _ClearFieldArgType) -> None: ...

Global___ConversationResultChoices: typing_extensions.TypeAlias = ConversationResultChoices

@typing.final
class ConversationResultMessage(google.protobuf.message.Message):
    """inspired by openai.ChatCompletionMessage
    based on https://github.com/openai/openai-go/blob/main/chatcompletion.go#L1218C6-L1218C27
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONTENT_FIELD_NUMBER: builtins.int
    TOOL_CALLS_FIELD_NUMBER: builtins.int
    content: builtins.str
    """The contents of the message."""
    @property
    def tool_calls(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[Global___ConversationToolCalls]:
        """The tool calls generated by the model."""

    def __init__(
        self,
        *,
        content: builtins.str = ...,
        tool_calls: collections.abc.Iterable[Global___ConversationToolCalls] | None = ...,
    ) -> None: ...
    _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["content", b"content", "tool_calls", b"tool_calls"]
    def ClearField(self, field_name: _ClearFieldArgType) -> None: ...

Global___ConversationResultMessage: typing_extensions.TypeAlias = ConversationResultMessage

@deprecated("""This message has been marked as deprecated using proto message options.""")
@typing.final
class ConversationResponse(google.protobuf.message.Message):
    """ConversationResponse is the response for Conversation."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONTEXTID_FIELD_NUMBER: builtins.int
    OUTPUTS_FIELD_NUMBER: builtins.int
    contextID: builtins.str
    """The ID of an existing chat (like in ChatGPT)"""
    @property
    def outputs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[Global___ConversationResult]:
        """An array of results."""

    def __init__(
        self,
        *,
        contextID: builtins.str | None = ...,
        outputs: collections.abc.Iterable[Global___ConversationResult] | None = ...,
    ) -> None: ...
    _HasFieldArgType: typing_extensions.TypeAlias = typing.Literal["_contextID", b"_contextID", "contextID", b"contextID"]
    def HasField(self, field_name: _HasFieldArgType) -> builtins.bool: ...
    _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["_contextID", b"_contextID", "contextID", b"contextID", "outputs", b"outputs"]
    def ClearField(self, field_name: _ClearFieldArgType) -> None: ...
    _WhichOneofReturnType__contextID: typing_extensions.TypeAlias = typing.Literal["contextID"]
    _WhichOneofArgType__contextID: typing_extensions.TypeAlias = typing.Literal["_contextID", b"_contextID"]
    def WhichOneof(self, oneof_group: _WhichOneofArgType__contextID) -> _WhichOneofReturnType__contextID | None: ...

Global___ConversationResponse: typing_extensions.TypeAlias = ConversationResponse

@typing.final
class ConversationResponseAlpha2(google.protobuf.message.Message):
    """ConversationResponseAlpha2 is the Alpha2 response for Conversation."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONTEXT_ID_FIELD_NUMBER: builtins.int
    OUTPUTS_FIELD_NUMBER: builtins.int
    context_id: builtins.str
    """The ID of an existing chat (like in ChatGPT)"""
    @property
    def outputs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[Global___ConversationResultAlpha2]:
        """An array of results."""

    def __init__(
        self,
        *,
        context_id: builtins.str | None = ...,
        outputs: collections.abc.Iterable[Global___ConversationResultAlpha2] | None = ...,
    ) -> None: ...
    _HasFieldArgType: typing_extensions.TypeAlias = typing.Literal["_context_id", b"_context_id", "context_id", b"context_id"]
    def HasField(self, field_name: _HasFieldArgType) -> builtins.bool: ...
    _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["_context_id", b"_context_id", "context_id", b"context_id", "outputs", b"outputs"]
    def ClearField(self, field_name: _ClearFieldArgType) -> None: ...
    _WhichOneofReturnType__context_id: typing_extensions.TypeAlias = typing.Literal["context_id"]
    _WhichOneofArgType__context_id: typing_extensions.TypeAlias = typing.Literal["_context_id", b"_context_id"]
    def WhichOneof(self, oneof_group: _WhichOneofArgType__context_id) -> _WhichOneofReturnType__context_id | None: ...

Global___ConversationResponseAlpha2: typing_extensions.TypeAlias = ConversationResponseAlpha2

@typing.final
class ConversationTools(google.protobuf.message.Message):
    """ConversationTools are the typed tools available to be called.
    inspired by openai.ChatCompletionToolParam
    https://github.com/openai/openai-go/blob/main/chatcompletion.go#L1950
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FUNCTION_FIELD_NUMBER: builtins.int
    @property
    def function(self) -> Global___ConversationToolsFunction: ...
    def __init__(
        self,
        *,
        function: Global___ConversationToolsFunction | None = ...,
    ) -> None: ...
    _HasFieldArgType: typing_extensions.TypeAlias = typing.Literal["function", b"function", "tool_types", b"tool_types"]
    def HasField(self, field_name: _HasFieldArgType) -> builtins.bool: ...
    _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["function", b"function", "tool_types", b"tool_types"]
    def ClearField(self, field_name: _ClearFieldArgType) -> None: ...
    _WhichOneofReturnType_tool_types: typing_extensions.TypeAlias = typing.Literal["function"]
    _WhichOneofArgType_tool_types: typing_extensions.TypeAlias = typing.Literal["tool_types", b"tool_types"]
    def WhichOneof(self, oneof_group: _WhichOneofArgType_tool_types) -> _WhichOneofReturnType_tool_types | None: ...

Global___ConversationTools: typing_extensions.TypeAlias = ConversationTools

@typing.final
class ConversationToolsFunction(google.protobuf.message.Message):
    """ConversationToolsFunction is the main tool type to be used in a conversation.
    inspired by openai.FunctionDefinitionParam
    https://pkg.go.dev/github.com/openai/openai-go/shared#FunctionDefinitionParam
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    PARAMETERS_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The name of the function to be called."""
    description: builtins.str
    """A description of what the function does, 
    used by the model to choose when and how to call the function.
    """
    @property
    def parameters(self) -> google.protobuf.struct_pb2.Struct:
        """The parameters the functions accepts, described as a JSON Schema object. 
        See the [guide](https://platform.openai.com/docs/guides/function-calling) for examples,
        and the [JSON Schema reference](https://json-schema.org/understanding-json-schema/) for documentation about the format.
        Omitting `parameters` defines a function with an empty parameter list.
        """

    def __init__(
        self,
        *,
        name: builtins.str = ...,
        description: builtins.str | None = ...,
        parameters: google.protobuf.struct_pb2.Struct | None = ...,
    ) -> None: ...
    _HasFieldArgType: typing_extensions.TypeAlias = typing.Literal["_description", b"_description", "description", b"description", "parameters", b"parameters"]
    def HasField(self, field_name: _HasFieldArgType) -> builtins.bool: ...
    _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["_description", b"_description", "description", b"description", "name", b"name", "parameters", b"parameters"]
    def ClearField(self, field_name: _ClearFieldArgType) -> None: ...
    _WhichOneofReturnType__description: typing_extensions.TypeAlias = typing.Literal["description"]
    _WhichOneofArgType__description: typing_extensions.TypeAlias = typing.Literal["_description", b"_description"]
    def WhichOneof(self, oneof_group: _WhichOneofArgType__description) -> _WhichOneofReturnType__description | None: ...

Global___ConversationToolsFunction: typing_extensions.TypeAlias = ConversationToolsFunction
