"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file

Copyright 2025 The Dapr Authors
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
"""

import builtins
import collections.abc
import dapr.proto.common.v1.common_pb2
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.message
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class GetConfigurationRequest(google.protobuf.message.Message):
    """GetConfigurationRequest is the message to get a list of key-value configuration from specified configuration store."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class MetadataEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["key", b"key", "value", b"value"]
        def ClearField(self, field_name: _ClearFieldArgType) -> None: ...

    STORE_NAME_FIELD_NUMBER: builtins.int
    KEYS_FIELD_NUMBER: builtins.int
    METADATA_FIELD_NUMBER: builtins.int
    store_name: builtins.str
    """Required. The name of configuration store."""
    @property
    def keys(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Optional. The key of the configuration item to fetch.
        If set, only query for the specified configuration items.
        Empty list means fetch all.
        """

    @property
    def metadata(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Optional. The metadata which will be sent to configuration store components."""

    def __init__(
        self,
        *,
        store_name: builtins.str = ...,
        keys: collections.abc.Iterable[builtins.str] | None = ...,
        metadata: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
    ) -> None: ...
    _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["keys", b"keys", "metadata", b"metadata", "store_name", b"store_name"]
    def ClearField(self, field_name: _ClearFieldArgType) -> None: ...

Global___GetConfigurationRequest: typing_extensions.TypeAlias = GetConfigurationRequest

@typing.final
class GetConfigurationResponse(google.protobuf.message.Message):
    """GetConfigurationResponse is the response conveying the list of configuration values.
    It should be the FULL configuration of specified application which contains all of its configuration items.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class ItemsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        @property
        def value(self) -> dapr.proto.common.v1.common_pb2.ConfigurationItem: ...
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: dapr.proto.common.v1.common_pb2.ConfigurationItem | None = ...,
        ) -> None: ...
        _HasFieldArgType: typing_extensions.TypeAlias = typing.Literal["value", b"value"]
        def HasField(self, field_name: _HasFieldArgType) -> builtins.bool: ...
        _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["key", b"key", "value", b"value"]
        def ClearField(self, field_name: _ClearFieldArgType) -> None: ...

    ITEMS_FIELD_NUMBER: builtins.int
    @property
    def items(self) -> google.protobuf.internal.containers.MessageMap[builtins.str, dapr.proto.common.v1.common_pb2.ConfigurationItem]: ...
    def __init__(
        self,
        *,
        items: collections.abc.Mapping[builtins.str, dapr.proto.common.v1.common_pb2.ConfigurationItem] | None = ...,
    ) -> None: ...
    _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["items", b"items"]
    def ClearField(self, field_name: _ClearFieldArgType) -> None: ...

Global___GetConfigurationResponse: typing_extensions.TypeAlias = GetConfigurationResponse

@typing.final
class SubscribeConfigurationRequest(google.protobuf.message.Message):
    """SubscribeConfigurationRequest is the message to get a list of key-value configuration from specified configuration store."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class MetadataEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["key", b"key", "value", b"value"]
        def ClearField(self, field_name: _ClearFieldArgType) -> None: ...

    STORE_NAME_FIELD_NUMBER: builtins.int
    KEYS_FIELD_NUMBER: builtins.int
    METADATA_FIELD_NUMBER: builtins.int
    store_name: builtins.str
    """The name of configuration store."""
    @property
    def keys(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Optional. The key of the configuration item to fetch.
        If set, only query for the specified configuration items.
        Empty list means fetch all.
        """

    @property
    def metadata(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """The metadata which will be sent to configuration store components."""

    def __init__(
        self,
        *,
        store_name: builtins.str = ...,
        keys: collections.abc.Iterable[builtins.str] | None = ...,
        metadata: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
    ) -> None: ...
    _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["keys", b"keys", "metadata", b"metadata", "store_name", b"store_name"]
    def ClearField(self, field_name: _ClearFieldArgType) -> None: ...

Global___SubscribeConfigurationRequest: typing_extensions.TypeAlias = SubscribeConfigurationRequest

@typing.final
class UnsubscribeConfigurationRequest(google.protobuf.message.Message):
    """UnSubscribeConfigurationRequest is the message to stop watching the key-value configuration."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    STORE_NAME_FIELD_NUMBER: builtins.int
    ID_FIELD_NUMBER: builtins.int
    store_name: builtins.str
    """The name of configuration store."""
    id: builtins.str
    """The id to unsubscribe."""
    def __init__(
        self,
        *,
        store_name: builtins.str = ...,
        id: builtins.str = ...,
    ) -> None: ...
    _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["id", b"id", "store_name", b"store_name"]
    def ClearField(self, field_name: _ClearFieldArgType) -> None: ...

Global___UnsubscribeConfigurationRequest: typing_extensions.TypeAlias = UnsubscribeConfigurationRequest

@typing.final
class SubscribeConfigurationResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class ItemsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        @property
        def value(self) -> dapr.proto.common.v1.common_pb2.ConfigurationItem: ...
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: dapr.proto.common.v1.common_pb2.ConfigurationItem | None = ...,
        ) -> None: ...
        _HasFieldArgType: typing_extensions.TypeAlias = typing.Literal["value", b"value"]
        def HasField(self, field_name: _HasFieldArgType) -> builtins.bool: ...
        _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["key", b"key", "value", b"value"]
        def ClearField(self, field_name: _ClearFieldArgType) -> None: ...

    ID_FIELD_NUMBER: builtins.int
    ITEMS_FIELD_NUMBER: builtins.int
    id: builtins.str
    """Subscribe id, used to stop subscription."""
    @property
    def items(self) -> google.protobuf.internal.containers.MessageMap[builtins.str, dapr.proto.common.v1.common_pb2.ConfigurationItem]:
        """The list of items containing configuration values"""

    def __init__(
        self,
        *,
        id: builtins.str = ...,
        items: collections.abc.Mapping[builtins.str, dapr.proto.common.v1.common_pb2.ConfigurationItem] | None = ...,
    ) -> None: ...
    _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["id", b"id", "items", b"items"]
    def ClearField(self, field_name: _ClearFieldArgType) -> None: ...

Global___SubscribeConfigurationResponse: typing_extensions.TypeAlias = SubscribeConfigurationResponse

@typing.final
class UnsubscribeConfigurationResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    OK_FIELD_NUMBER: builtins.int
    MESSAGE_FIELD_NUMBER: builtins.int
    ok: builtins.bool
    message: builtins.str
    def __init__(
        self,
        *,
        ok: builtins.bool = ...,
        message: builtins.str = ...,
    ) -> None: ...
    _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["message", b"message", "ok", b"ok"]
    def ClearField(self, field_name: _ClearFieldArgType) -> None: ...

Global___UnsubscribeConfigurationResponse: typing_extensions.TypeAlias = UnsubscribeConfigurationResponse
