"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file

Copyright 2025 The Dapr Authors
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
"""

import builtins
import dapr.proto.common.v1.common_pb2
import google.protobuf.descriptor
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class SubtleGetKeyRequest(google.protobuf.message.Message):
    """SubtleGetKeyRequest is the request object for SubtleGetKeyAlpha1."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _KeyFormat:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _KeyFormatEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[SubtleGetKeyRequest._KeyFormat.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        PEM: SubtleGetKeyRequest._KeyFormat.ValueType  # 0
        """PEM (PKIX) (default)"""
        JSON: SubtleGetKeyRequest._KeyFormat.ValueType  # 1
        """JSON (JSON Web Key) as string"""

    class KeyFormat(_KeyFormat, metaclass=_KeyFormatEnumTypeWrapper): ...
    PEM: SubtleGetKeyRequest.KeyFormat.ValueType  # 0
    """PEM (PKIX) (default)"""
    JSON: SubtleGetKeyRequest.KeyFormat.ValueType  # 1
    """JSON (JSON Web Key) as string"""

    COMPONENT_NAME_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    FORMAT_FIELD_NUMBER: builtins.int
    component_name: builtins.str
    """Name of the component"""
    name: builtins.str
    """Name (or name/version) of the key to use in the key vault"""
    format: Global___SubtleGetKeyRequest.KeyFormat.ValueType
    """Response format"""
    def __init__(
        self,
        *,
        component_name: builtins.str = ...,
        name: builtins.str = ...,
        format: Global___SubtleGetKeyRequest.KeyFormat.ValueType = ...,
    ) -> None: ...
    _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["component_name", b"component_name", "format", b"format", "name", b"name"]
    def ClearField(self, field_name: _ClearFieldArgType) -> None: ...

Global___SubtleGetKeyRequest: typing_extensions.TypeAlias = SubtleGetKeyRequest

@typing.final
class SubtleGetKeyResponse(google.protobuf.message.Message):
    """SubtleGetKeyResponse is the response for SubtleGetKeyAlpha1."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    PUBLIC_KEY_FIELD_NUMBER: builtins.int
    name: builtins.str
    """Name (or name/version) of the key.
    This is returned as response too in case there is a version.
    """
    public_key: builtins.str
    """Public key, encoded in the requested format"""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        public_key: builtins.str = ...,
    ) -> None: ...
    _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["name", b"name", "public_key", b"public_key"]
    def ClearField(self, field_name: _ClearFieldArgType) -> None: ...

Global___SubtleGetKeyResponse: typing_extensions.TypeAlias = SubtleGetKeyResponse

@typing.final
class SubtleEncryptRequest(google.protobuf.message.Message):
    """SubtleEncryptRequest is the request for SubtleEncryptAlpha1."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    COMPONENT_NAME_FIELD_NUMBER: builtins.int
    PLAINTEXT_FIELD_NUMBER: builtins.int
    ALGORITHM_FIELD_NUMBER: builtins.int
    KEY_NAME_FIELD_NUMBER: builtins.int
    NONCE_FIELD_NUMBER: builtins.int
    ASSOCIATED_DATA_FIELD_NUMBER: builtins.int
    component_name: builtins.str
    """Name of the component"""
    plaintext: builtins.bytes
    """Message to encrypt."""
    algorithm: builtins.str
    """Algorithm to use, as in the JWA standard."""
    key_name: builtins.str
    """Name (or name/version) of the key."""
    nonce: builtins.bytes
    """Nonce / initialization vector.
    Ignored with asymmetric ciphers.
    """
    associated_data: builtins.bytes
    """Associated Data when using AEAD ciphers (optional)."""
    def __init__(
        self,
        *,
        component_name: builtins.str = ...,
        plaintext: builtins.bytes = ...,
        algorithm: builtins.str = ...,
        key_name: builtins.str = ...,
        nonce: builtins.bytes = ...,
        associated_data: builtins.bytes = ...,
    ) -> None: ...
    _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["algorithm", b"algorithm", "associated_data", b"associated_data", "component_name", b"component_name", "key_name", b"key_name", "nonce", b"nonce", "plaintext", b"plaintext"]
    def ClearField(self, field_name: _ClearFieldArgType) -> None: ...

Global___SubtleEncryptRequest: typing_extensions.TypeAlias = SubtleEncryptRequest

@typing.final
class SubtleEncryptResponse(google.protobuf.message.Message):
    """SubtleEncryptResponse is the response for SubtleEncryptAlpha1."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CIPHERTEXT_FIELD_NUMBER: builtins.int
    TAG_FIELD_NUMBER: builtins.int
    ciphertext: builtins.bytes
    """Encrypted ciphertext."""
    tag: builtins.bytes
    """Authentication tag.
    This is nil when not using an authenticated cipher.
    """
    def __init__(
        self,
        *,
        ciphertext: builtins.bytes = ...,
        tag: builtins.bytes = ...,
    ) -> None: ...
    _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["ciphertext", b"ciphertext", "tag", b"tag"]
    def ClearField(self, field_name: _ClearFieldArgType) -> None: ...

Global___SubtleEncryptResponse: typing_extensions.TypeAlias = SubtleEncryptResponse

@typing.final
class SubtleDecryptRequest(google.protobuf.message.Message):
    """SubtleDecryptRequest is the request for SubtleDecryptAlpha1."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    COMPONENT_NAME_FIELD_NUMBER: builtins.int
    CIPHERTEXT_FIELD_NUMBER: builtins.int
    ALGORITHM_FIELD_NUMBER: builtins.int
    KEY_NAME_FIELD_NUMBER: builtins.int
    NONCE_FIELD_NUMBER: builtins.int
    TAG_FIELD_NUMBER: builtins.int
    ASSOCIATED_DATA_FIELD_NUMBER: builtins.int
    component_name: builtins.str
    """Name of the component"""
    ciphertext: builtins.bytes
    """Message to decrypt."""
    algorithm: builtins.str
    """Algorithm to use, as in the JWA standard."""
    key_name: builtins.str
    """Name (or name/version) of the key."""
    nonce: builtins.bytes
    """Nonce / initialization vector.
    Ignored with asymmetric ciphers.
    """
    tag: builtins.bytes
    """Authentication tag.
    This is nil when not using an authenticated cipher.
    """
    associated_data: builtins.bytes
    """Associated Data when using AEAD ciphers (optional)."""
    def __init__(
        self,
        *,
        component_name: builtins.str = ...,
        ciphertext: builtins.bytes = ...,
        algorithm: builtins.str = ...,
        key_name: builtins.str = ...,
        nonce: builtins.bytes = ...,
        tag: builtins.bytes = ...,
        associated_data: builtins.bytes = ...,
    ) -> None: ...
    _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["algorithm", b"algorithm", "associated_data", b"associated_data", "ciphertext", b"ciphertext", "component_name", b"component_name", "key_name", b"key_name", "nonce", b"nonce", "tag", b"tag"]
    def ClearField(self, field_name: _ClearFieldArgType) -> None: ...

Global___SubtleDecryptRequest: typing_extensions.TypeAlias = SubtleDecryptRequest

@typing.final
class SubtleDecryptResponse(google.protobuf.message.Message):
    """SubtleDecryptResponse is the response for SubtleDecryptAlpha1."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PLAINTEXT_FIELD_NUMBER: builtins.int
    plaintext: builtins.bytes
    """Decrypted plaintext."""
    def __init__(
        self,
        *,
        plaintext: builtins.bytes = ...,
    ) -> None: ...
    _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["plaintext", b"plaintext"]
    def ClearField(self, field_name: _ClearFieldArgType) -> None: ...

Global___SubtleDecryptResponse: typing_extensions.TypeAlias = SubtleDecryptResponse

@typing.final
class SubtleWrapKeyRequest(google.protobuf.message.Message):
    """SubtleWrapKeyRequest is the request for SubtleWrapKeyAlpha1."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    COMPONENT_NAME_FIELD_NUMBER: builtins.int
    PLAINTEXT_KEY_FIELD_NUMBER: builtins.int
    ALGORITHM_FIELD_NUMBER: builtins.int
    KEY_NAME_FIELD_NUMBER: builtins.int
    NONCE_FIELD_NUMBER: builtins.int
    ASSOCIATED_DATA_FIELD_NUMBER: builtins.int
    component_name: builtins.str
    """Name of the component"""
    plaintext_key: builtins.bytes
    """Key to wrap"""
    algorithm: builtins.str
    """Algorithm to use, as in the JWA standard."""
    key_name: builtins.str
    """Name (or name/version) of the key."""
    nonce: builtins.bytes
    """Nonce / initialization vector.
    Ignored with asymmetric ciphers.
    """
    associated_data: builtins.bytes
    """Associated Data when using AEAD ciphers (optional)."""
    def __init__(
        self,
        *,
        component_name: builtins.str = ...,
        plaintext_key: builtins.bytes = ...,
        algorithm: builtins.str = ...,
        key_name: builtins.str = ...,
        nonce: builtins.bytes = ...,
        associated_data: builtins.bytes = ...,
    ) -> None: ...
    _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["algorithm", b"algorithm", "associated_data", b"associated_data", "component_name", b"component_name", "key_name", b"key_name", "nonce", b"nonce", "plaintext_key", b"plaintext_key"]
    def ClearField(self, field_name: _ClearFieldArgType) -> None: ...

Global___SubtleWrapKeyRequest: typing_extensions.TypeAlias = SubtleWrapKeyRequest

@typing.final
class SubtleWrapKeyResponse(google.protobuf.message.Message):
    """SubtleWrapKeyResponse is the response for SubtleWrapKeyAlpha1."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    WRAPPED_KEY_FIELD_NUMBER: builtins.int
    TAG_FIELD_NUMBER: builtins.int
    wrapped_key: builtins.bytes
    """Wrapped key."""
    tag: builtins.bytes
    """Authentication tag.
    This is nil when not using an authenticated cipher.
    """
    def __init__(
        self,
        *,
        wrapped_key: builtins.bytes = ...,
        tag: builtins.bytes = ...,
    ) -> None: ...
    _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["tag", b"tag", "wrapped_key", b"wrapped_key"]
    def ClearField(self, field_name: _ClearFieldArgType) -> None: ...

Global___SubtleWrapKeyResponse: typing_extensions.TypeAlias = SubtleWrapKeyResponse

@typing.final
class SubtleUnwrapKeyRequest(google.protobuf.message.Message):
    """SubtleUnwrapKeyRequest is the request for SubtleUnwrapKeyAlpha1."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    COMPONENT_NAME_FIELD_NUMBER: builtins.int
    WRAPPED_KEY_FIELD_NUMBER: builtins.int
    ALGORITHM_FIELD_NUMBER: builtins.int
    KEY_NAME_FIELD_NUMBER: builtins.int
    NONCE_FIELD_NUMBER: builtins.int
    TAG_FIELD_NUMBER: builtins.int
    ASSOCIATED_DATA_FIELD_NUMBER: builtins.int
    component_name: builtins.str
    """Name of the component"""
    wrapped_key: builtins.bytes
    """Wrapped key."""
    algorithm: builtins.str
    """Algorithm to use, as in the JWA standard."""
    key_name: builtins.str
    """Name (or name/version) of the key."""
    nonce: builtins.bytes
    """Nonce / initialization vector.
    Ignored with asymmetric ciphers.
    """
    tag: builtins.bytes
    """Authentication tag.
    This is nil when not using an authenticated cipher.
    """
    associated_data: builtins.bytes
    """Associated Data when using AEAD ciphers (optional)."""
    def __init__(
        self,
        *,
        component_name: builtins.str = ...,
        wrapped_key: builtins.bytes = ...,
        algorithm: builtins.str = ...,
        key_name: builtins.str = ...,
        nonce: builtins.bytes = ...,
        tag: builtins.bytes = ...,
        associated_data: builtins.bytes = ...,
    ) -> None: ...
    _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["algorithm", b"algorithm", "associated_data", b"associated_data", "component_name", b"component_name", "key_name", b"key_name", "nonce", b"nonce", "tag", b"tag", "wrapped_key", b"wrapped_key"]
    def ClearField(self, field_name: _ClearFieldArgType) -> None: ...

Global___SubtleUnwrapKeyRequest: typing_extensions.TypeAlias = SubtleUnwrapKeyRequest

@typing.final
class SubtleUnwrapKeyResponse(google.protobuf.message.Message):
    """SubtleUnwrapKeyResponse is the response for SubtleUnwrapKeyAlpha1."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PLAINTEXT_KEY_FIELD_NUMBER: builtins.int
    plaintext_key: builtins.bytes
    """Key in plaintext"""
    def __init__(
        self,
        *,
        plaintext_key: builtins.bytes = ...,
    ) -> None: ...
    _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["plaintext_key", b"plaintext_key"]
    def ClearField(self, field_name: _ClearFieldArgType) -> None: ...

Global___SubtleUnwrapKeyResponse: typing_extensions.TypeAlias = SubtleUnwrapKeyResponse

@typing.final
class SubtleSignRequest(google.protobuf.message.Message):
    """SubtleSignRequest is the request for SubtleSignAlpha1."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    COMPONENT_NAME_FIELD_NUMBER: builtins.int
    DIGEST_FIELD_NUMBER: builtins.int
    ALGORITHM_FIELD_NUMBER: builtins.int
    KEY_NAME_FIELD_NUMBER: builtins.int
    component_name: builtins.str
    """Name of the component"""
    digest: builtins.bytes
    """Digest to sign."""
    algorithm: builtins.str
    """Algorithm to use, as in the JWA standard."""
    key_name: builtins.str
    """Name (or name/version) of the key."""
    def __init__(
        self,
        *,
        component_name: builtins.str = ...,
        digest: builtins.bytes = ...,
        algorithm: builtins.str = ...,
        key_name: builtins.str = ...,
    ) -> None: ...
    _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["algorithm", b"algorithm", "component_name", b"component_name", "digest", b"digest", "key_name", b"key_name"]
    def ClearField(self, field_name: _ClearFieldArgType) -> None: ...

Global___SubtleSignRequest: typing_extensions.TypeAlias = SubtleSignRequest

@typing.final
class SubtleSignResponse(google.protobuf.message.Message):
    """SubtleSignResponse is the response for SubtleSignAlpha1."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SIGNATURE_FIELD_NUMBER: builtins.int
    signature: builtins.bytes
    """The signature that was computed"""
    def __init__(
        self,
        *,
        signature: builtins.bytes = ...,
    ) -> None: ...
    _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["signature", b"signature"]
    def ClearField(self, field_name: _ClearFieldArgType) -> None: ...

Global___SubtleSignResponse: typing_extensions.TypeAlias = SubtleSignResponse

@typing.final
class SubtleVerifyRequest(google.protobuf.message.Message):
    """SubtleVerifyRequest is the request for SubtleVerifyAlpha1."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    COMPONENT_NAME_FIELD_NUMBER: builtins.int
    DIGEST_FIELD_NUMBER: builtins.int
    ALGORITHM_FIELD_NUMBER: builtins.int
    KEY_NAME_FIELD_NUMBER: builtins.int
    SIGNATURE_FIELD_NUMBER: builtins.int
    component_name: builtins.str
    """Name of the component"""
    digest: builtins.bytes
    """Digest of the message."""
    algorithm: builtins.str
    """Algorithm to use, as in the JWA standard."""
    key_name: builtins.str
    """Name (or name/version) of the key."""
    signature: builtins.bytes
    """Signature to verify."""
    def __init__(
        self,
        *,
        component_name: builtins.str = ...,
        digest: builtins.bytes = ...,
        algorithm: builtins.str = ...,
        key_name: builtins.str = ...,
        signature: builtins.bytes = ...,
    ) -> None: ...
    _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["algorithm", b"algorithm", "component_name", b"component_name", "digest", b"digest", "key_name", b"key_name", "signature", b"signature"]
    def ClearField(self, field_name: _ClearFieldArgType) -> None: ...

Global___SubtleVerifyRequest: typing_extensions.TypeAlias = SubtleVerifyRequest

@typing.final
class SubtleVerifyResponse(google.protobuf.message.Message):
    """SubtleVerifyResponse is the response for SubtleVerifyAlpha1."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    VALID_FIELD_NUMBER: builtins.int
    valid: builtins.bool
    """True if the signature is valid."""
    def __init__(
        self,
        *,
        valid: builtins.bool = ...,
    ) -> None: ...
    _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["valid", b"valid"]
    def ClearField(self, field_name: _ClearFieldArgType) -> None: ...

Global___SubtleVerifyResponse: typing_extensions.TypeAlias = SubtleVerifyResponse

@typing.final
class EncryptRequest(google.protobuf.message.Message):
    """EncryptRequest is the request for EncryptAlpha1."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    OPTIONS_FIELD_NUMBER: builtins.int
    PAYLOAD_FIELD_NUMBER: builtins.int
    @property
    def options(self) -> Global___EncryptRequestOptions:
        """Request details. Must be present in the first message only."""

    @property
    def payload(self) -> dapr.proto.common.v1.common_pb2.StreamPayload:
        """Chunk of data of arbitrary size."""

    def __init__(
        self,
        *,
        options: Global___EncryptRequestOptions | None = ...,
        payload: dapr.proto.common.v1.common_pb2.StreamPayload | None = ...,
    ) -> None: ...
    _HasFieldArgType: typing_extensions.TypeAlias = typing.Literal["options", b"options", "payload", b"payload"]
    def HasField(self, field_name: _HasFieldArgType) -> builtins.bool: ...
    _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["options", b"options", "payload", b"payload"]
    def ClearField(self, field_name: _ClearFieldArgType) -> None: ...

Global___EncryptRequest: typing_extensions.TypeAlias = EncryptRequest

@typing.final
class EncryptRequestOptions(google.protobuf.message.Message):
    """EncryptRequestOptions contains options for the first message in the EncryptAlpha1 request."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    COMPONENT_NAME_FIELD_NUMBER: builtins.int
    KEY_NAME_FIELD_NUMBER: builtins.int
    KEY_WRAP_ALGORITHM_FIELD_NUMBER: builtins.int
    DATA_ENCRYPTION_CIPHER_FIELD_NUMBER: builtins.int
    OMIT_DECRYPTION_KEY_NAME_FIELD_NUMBER: builtins.int
    DECRYPTION_KEY_NAME_FIELD_NUMBER: builtins.int
    component_name: builtins.str
    """Name of the component. Required."""
    key_name: builtins.str
    """Name (or name/version) of the key. Required."""
    key_wrap_algorithm: builtins.str
    """Key wrapping algorithm to use. Required.
    Supported options include: A256KW (alias: AES), A128CBC, A192CBC, A256CBC, RSA-OAEP-256 (alias: RSA).
    """
    data_encryption_cipher: builtins.str
    """Cipher used to encrypt data (optional): "aes-gcm" (default) or "chacha20-poly1305" """
    omit_decryption_key_name: builtins.bool
    """If true, the encrypted document does not contain a key reference.
    In that case, calls to the Decrypt method must provide a key reference (name or name/version).
    Defaults to false.
    """
    decryption_key_name: builtins.str
    """Key reference to embed in the encrypted document (name or name/version).
    This is helpful if the reference of the key used to decrypt the document is different from the one used to encrypt it.
    If unset, uses the reference of the key used to encrypt the document (this is the default behavior).
    This option is ignored if omit_decryption_key_name is true.
    """
    def __init__(
        self,
        *,
        component_name: builtins.str = ...,
        key_name: builtins.str = ...,
        key_wrap_algorithm: builtins.str = ...,
        data_encryption_cipher: builtins.str = ...,
        omit_decryption_key_name: builtins.bool = ...,
        decryption_key_name: builtins.str = ...,
    ) -> None: ...
    _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["component_name", b"component_name", "data_encryption_cipher", b"data_encryption_cipher", "decryption_key_name", b"decryption_key_name", "key_name", b"key_name", "key_wrap_algorithm", b"key_wrap_algorithm", "omit_decryption_key_name", b"omit_decryption_key_name"]
    def ClearField(self, field_name: _ClearFieldArgType) -> None: ...

Global___EncryptRequestOptions: typing_extensions.TypeAlias = EncryptRequestOptions

@typing.final
class EncryptResponse(google.protobuf.message.Message):
    """EncryptResponse is the response for EncryptAlpha1."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PAYLOAD_FIELD_NUMBER: builtins.int
    @property
    def payload(self) -> dapr.proto.common.v1.common_pb2.StreamPayload:
        """Chunk of data."""

    def __init__(
        self,
        *,
        payload: dapr.proto.common.v1.common_pb2.StreamPayload | None = ...,
    ) -> None: ...
    _HasFieldArgType: typing_extensions.TypeAlias = typing.Literal["payload", b"payload"]
    def HasField(self, field_name: _HasFieldArgType) -> builtins.bool: ...
    _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["payload", b"payload"]
    def ClearField(self, field_name: _ClearFieldArgType) -> None: ...

Global___EncryptResponse: typing_extensions.TypeAlias = EncryptResponse

@typing.final
class DecryptRequest(google.protobuf.message.Message):
    """DecryptRequest is the request for DecryptAlpha1."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    OPTIONS_FIELD_NUMBER: builtins.int
    PAYLOAD_FIELD_NUMBER: builtins.int
    @property
    def options(self) -> Global___DecryptRequestOptions:
        """Request details. Must be present in the first message only."""

    @property
    def payload(self) -> dapr.proto.common.v1.common_pb2.StreamPayload:
        """Chunk of data of arbitrary size."""

    def __init__(
        self,
        *,
        options: Global___DecryptRequestOptions | None = ...,
        payload: dapr.proto.common.v1.common_pb2.StreamPayload | None = ...,
    ) -> None: ...
    _HasFieldArgType: typing_extensions.TypeAlias = typing.Literal["options", b"options", "payload", b"payload"]
    def HasField(self, field_name: _HasFieldArgType) -> builtins.bool: ...
    _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["options", b"options", "payload", b"payload"]
    def ClearField(self, field_name: _ClearFieldArgType) -> None: ...

Global___DecryptRequest: typing_extensions.TypeAlias = DecryptRequest

@typing.final
class DecryptRequestOptions(google.protobuf.message.Message):
    """DecryptRequestOptions contains options for the first message in the DecryptAlpha1 request."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    COMPONENT_NAME_FIELD_NUMBER: builtins.int
    KEY_NAME_FIELD_NUMBER: builtins.int
    component_name: builtins.str
    """Name of the component"""
    key_name: builtins.str
    """Name (or name/version) of the key to decrypt the message.
    Overrides any key reference included in the message if present.
    This is required if the message doesn't include a key reference (i.e. was created with omit_decryption_key_name set to true).
    """
    def __init__(
        self,
        *,
        component_name: builtins.str = ...,
        key_name: builtins.str = ...,
    ) -> None: ...
    _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["component_name", b"component_name", "key_name", b"key_name"]
    def ClearField(self, field_name: _ClearFieldArgType) -> None: ...

Global___DecryptRequestOptions: typing_extensions.TypeAlias = DecryptRequestOptions

@typing.final
class DecryptResponse(google.protobuf.message.Message):
    """DecryptResponse is the response for DecryptAlpha1."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PAYLOAD_FIELD_NUMBER: builtins.int
    @property
    def payload(self) -> dapr.proto.common.v1.common_pb2.StreamPayload:
        """Chunk of data."""

    def __init__(
        self,
        *,
        payload: dapr.proto.common.v1.common_pb2.StreamPayload | None = ...,
    ) -> None: ...
    _HasFieldArgType: typing_extensions.TypeAlias = typing.Literal["payload", b"payload"]
    def HasField(self, field_name: _HasFieldArgType) -> builtins.bool: ...
    _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["payload", b"payload"]
    def ClearField(self, field_name: _ClearFieldArgType) -> None: ...

Global___DecryptResponse: typing_extensions.TypeAlias = DecryptResponse
