"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file

Copyright 2025 The Dapr Authors
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
"""

import builtins
import collections.abc
import dapr.proto.common.v1.common_pb2
import google.protobuf.any_pb2
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.message
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class Job(google.protobuf.message.Message):
    """Job is the definition of a job. At least one of schedule or due_time must be
    provided but can also be provided together.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    SCHEDULE_FIELD_NUMBER: builtins.int
    REPEATS_FIELD_NUMBER: builtins.int
    DUE_TIME_FIELD_NUMBER: builtins.int
    TTL_FIELD_NUMBER: builtins.int
    DATA_FIELD_NUMBER: builtins.int
    FAILURE_POLICY_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The unique name for the job."""
    schedule: builtins.str
    """schedule is an optional schedule at which the job is to be run.
    Accepts both systemd timer style cron expressions, as well as human
    readable '@' prefixed period strings as defined below.

    Systemd timer style cron accepts 6 fields:
    seconds | minutes | hours | day of month | month        | day of week
    0-59    | 0-59    | 0-23  | 1-31         | 1-12/jan-dec | 0-6/sun-sat

    "0 30 * * * *" - every hour on the half hour
    "0 15 3 * * *" - every day at 03:15

    Period string expressions:
    Entry                  | Description                                  | Equivalent To
    -----                  | -----------                                  | -------------
    @every `<duration>`    | Run every `<duration>` (e.g. '@every 1h30m') | N/A
    @yearly (or @annually) | Run once a year, midnight, Jan. 1st          | 0 0 0 1 1 *
    @monthly               | Run once a month, midnight, first of month   | 0 0 0 1 * *
    @weekly                | Run once a week, midnight on Sunday          | 0 0 0 * * 0
    @daily (or @midnight)  | Run once a day, midnight                     | 0 0 0 * * *
    @hourly                | Run once an hour, beginning of hour          | 0 0 * * * *
    """
    repeats: builtins.int
    """repeats is the optional number of times in which the job should be
    triggered. If not set, the job will run indefinitely or until expiration.
    """
    due_time: builtins.str
    """due_time is the optional time at which the job should be active, or the
    "one shot" time if other scheduling type fields are not provided. Accepts
    a "point in time" string in the format of RFC3339, Go duration string
    (calculated from job creation time), or non-repeating ISO8601.
    """
    ttl: builtins.str
    """ttl is the optional time to live or expiration of the job. Accepts a
    "point in time" string in the format of RFC3339, Go duration string
    (calculated from job creation time), or non-repeating ISO8601.
    """
    @property
    def data(self) -> google.protobuf.any_pb2.Any:
        """payload is the serialized job payload that will be sent to the recipient
        when the job is triggered.
        """

    @property
    def failure_policy(self) -> dapr.proto.common.v1.common_pb2.JobFailurePolicy:
        """failure_policy is the optional policy for handling job failures."""

    def __init__(
        self,
        *,
        name: builtins.str = ...,
        schedule: builtins.str | None = ...,
        repeats: builtins.int | None = ...,
        due_time: builtins.str | None = ...,
        ttl: builtins.str | None = ...,
        data: google.protobuf.any_pb2.Any | None = ...,
        failure_policy: dapr.proto.common.v1.common_pb2.JobFailurePolicy | None = ...,
    ) -> None: ...
    _HasFieldArgType: typing_extensions.TypeAlias = typing.Literal["_due_time", b"_due_time", "_failure_policy", b"_failure_policy", "_repeats", b"_repeats", "_schedule", b"_schedule", "_ttl", b"_ttl", "data", b"data", "due_time", b"due_time", "failure_policy", b"failure_policy", "repeats", b"repeats", "schedule", b"schedule", "ttl", b"ttl"]
    def HasField(self, field_name: _HasFieldArgType) -> builtins.bool: ...
    _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["_due_time", b"_due_time", "_failure_policy", b"_failure_policy", "_repeats", b"_repeats", "_schedule", b"_schedule", "_ttl", b"_ttl", "data", b"data", "due_time", b"due_time", "failure_policy", b"failure_policy", "name", b"name", "repeats", b"repeats", "schedule", b"schedule", "ttl", b"ttl"]
    def ClearField(self, field_name: _ClearFieldArgType) -> None: ...
    _WhichOneofReturnType__due_time: typing_extensions.TypeAlias = typing.Literal["due_time"]
    _WhichOneofArgType__due_time: typing_extensions.TypeAlias = typing.Literal["_due_time", b"_due_time"]
    _WhichOneofReturnType__failure_policy: typing_extensions.TypeAlias = typing.Literal["failure_policy"]
    _WhichOneofArgType__failure_policy: typing_extensions.TypeAlias = typing.Literal["_failure_policy", b"_failure_policy"]
    _WhichOneofReturnType__repeats: typing_extensions.TypeAlias = typing.Literal["repeats"]
    _WhichOneofArgType__repeats: typing_extensions.TypeAlias = typing.Literal["_repeats", b"_repeats"]
    _WhichOneofReturnType__schedule: typing_extensions.TypeAlias = typing.Literal["schedule"]
    _WhichOneofArgType__schedule: typing_extensions.TypeAlias = typing.Literal["_schedule", b"_schedule"]
    _WhichOneofReturnType__ttl: typing_extensions.TypeAlias = typing.Literal["ttl"]
    _WhichOneofArgType__ttl: typing_extensions.TypeAlias = typing.Literal["_ttl", b"_ttl"]
    @typing.overload
    def WhichOneof(self, oneof_group: _WhichOneofArgType__due_time) -> _WhichOneofReturnType__due_time | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: _WhichOneofArgType__failure_policy) -> _WhichOneofReturnType__failure_policy | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: _WhichOneofArgType__repeats) -> _WhichOneofReturnType__repeats | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: _WhichOneofArgType__schedule) -> _WhichOneofReturnType__schedule | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: _WhichOneofArgType__ttl) -> _WhichOneofReturnType__ttl | None: ...

Global___Job: typing_extensions.TypeAlias = Job

@typing.final
class ScheduleJobRequest(google.protobuf.message.Message):
    """ScheduleJobRequest is the message to create/schedule the job."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    JOB_FIELD_NUMBER: builtins.int
    OVERWRITE_FIELD_NUMBER: builtins.int
    overwrite: builtins.bool
    """If true, allows this job to overwrite an existing job with the same name."""
    @property
    def job(self) -> Global___Job:
        """The job details."""

    def __init__(
        self,
        *,
        job: Global___Job | None = ...,
        overwrite: builtins.bool = ...,
    ) -> None: ...
    _HasFieldArgType: typing_extensions.TypeAlias = typing.Literal["job", b"job"]
    def HasField(self, field_name: _HasFieldArgType) -> builtins.bool: ...
    _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["job", b"job", "overwrite", b"overwrite"]
    def ClearField(self, field_name: _ClearFieldArgType) -> None: ...

Global___ScheduleJobRequest: typing_extensions.TypeAlias = ScheduleJobRequest

@typing.final
class ScheduleJobResponse(google.protobuf.message.Message):
    """ScheduleJobResponse is the message response to create/schedule the job.
    Empty
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

Global___ScheduleJobResponse: typing_extensions.TypeAlias = ScheduleJobResponse

@typing.final
class GetJobRequest(google.protobuf.message.Message):
    """GetJobRequest is the message to retrieve a job."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The name of the job."""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
    ) -> None: ...
    _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["name", b"name"]
    def ClearField(self, field_name: _ClearFieldArgType) -> None: ...

Global___GetJobRequest: typing_extensions.TypeAlias = GetJobRequest

@typing.final
class GetJobResponse(google.protobuf.message.Message):
    """GetJobResponse is the message's response for a job retrieved."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    JOB_FIELD_NUMBER: builtins.int
    @property
    def job(self) -> Global___Job:
        """The job details."""

    def __init__(
        self,
        *,
        job: Global___Job | None = ...,
    ) -> None: ...
    _HasFieldArgType: typing_extensions.TypeAlias = typing.Literal["job", b"job"]
    def HasField(self, field_name: _HasFieldArgType) -> builtins.bool: ...
    _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["job", b"job"]
    def ClearField(self, field_name: _ClearFieldArgType) -> None: ...

Global___GetJobResponse: typing_extensions.TypeAlias = GetJobResponse

@typing.final
class DeleteJobRequest(google.protobuf.message.Message):
    """DeleteJobRequest is the message to delete the job by name."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    name: builtins.str
    """The name of the job."""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
    ) -> None: ...
    _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["name", b"name"]
    def ClearField(self, field_name: _ClearFieldArgType) -> None: ...

Global___DeleteJobRequest: typing_extensions.TypeAlias = DeleteJobRequest

@typing.final
class DeleteJobResponse(google.protobuf.message.Message):
    """DeleteJobResponse is the message response to delete the job by name.
    Empty
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

Global___DeleteJobResponse: typing_extensions.TypeAlias = DeleteJobResponse

@typing.final
class DeleteJobsByPrefixRequestAlpha1(google.protobuf.message.Message):
    """DeleteJobsByPrefixRequest is the message to delete jobs by name prefix."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_PREFIX_FIELD_NUMBER: builtins.int
    name_prefix: builtins.str
    """name_prefix is the prefix of the job names to delete. If not provided, all
    jobs associated with this app ID will be deleted.
    """
    def __init__(
        self,
        *,
        name_prefix: builtins.str | None = ...,
    ) -> None: ...
    _HasFieldArgType: typing_extensions.TypeAlias = typing.Literal["_name_prefix", b"_name_prefix", "name_prefix", b"name_prefix"]
    def HasField(self, field_name: _HasFieldArgType) -> builtins.bool: ...
    _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["_name_prefix", b"_name_prefix", "name_prefix", b"name_prefix"]
    def ClearField(self, field_name: _ClearFieldArgType) -> None: ...
    _WhichOneofReturnType__name_prefix: typing_extensions.TypeAlias = typing.Literal["name_prefix"]
    _WhichOneofArgType__name_prefix: typing_extensions.TypeAlias = typing.Literal["_name_prefix", b"_name_prefix"]
    def WhichOneof(self, oneof_group: _WhichOneofArgType__name_prefix) -> _WhichOneofReturnType__name_prefix | None: ...

Global___DeleteJobsByPrefixRequestAlpha1: typing_extensions.TypeAlias = DeleteJobsByPrefixRequestAlpha1

@typing.final
class DeleteJobsByPrefixResponseAlpha1(google.protobuf.message.Message):
    """Empty"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

Global___DeleteJobsByPrefixResponseAlpha1: typing_extensions.TypeAlias = DeleteJobsByPrefixResponseAlpha1

@typing.final
class ListJobsRequestAlpha1(google.protobuf.message.Message):
    """Empty"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

Global___ListJobsRequestAlpha1: typing_extensions.TypeAlias = ListJobsRequestAlpha1

@typing.final
class ListJobsResponseAlpha1(google.protobuf.message.Message):
    """ListJobsResponse is the message response containing the list of jobs."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    JOBS_FIELD_NUMBER: builtins.int
    @property
    def jobs(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[Global___Job]:
        """The list of jobs."""

    def __init__(
        self,
        *,
        jobs: collections.abc.Iterable[Global___Job] | None = ...,
    ) -> None: ...
    _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["jobs", b"jobs"]
    def ClearField(self, field_name: _ClearFieldArgType) -> None: ...

Global___ListJobsResponseAlpha1: typing_extensions.TypeAlias = ListJobsResponseAlpha1
