"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file

Copyright 2025 The Dapr Authors
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
"""

import builtins
import google.protobuf.descriptor
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class TryLockRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    STORE_NAME_FIELD_NUMBER: builtins.int
    RESOURCE_ID_FIELD_NUMBER: builtins.int
    LOCK_OWNER_FIELD_NUMBER: builtins.int
    EXPIRY_IN_SECONDS_FIELD_NUMBER: builtins.int
    store_name: builtins.str
    """Required. The lock store name,e.g. `redis`."""
    resource_id: builtins.str
    """Required. resource_id is the lock key. e.g. `order_id_111`
    It stands for "which resource I want to protect"
    """
    lock_owner: builtins.str
    """Required. lock_owner indicate the identifier of lock owner.
    You can generate a uuid as lock_owner.For example,in golang:

    req.LockOwner = uuid.New().String()

    This field is per request,not per process,so it is different for each request,
    which aims to prevent multi-thread in the same process trying the same lock concurrently.

    The reason why we don't make it automatically generated is:
    1. If it is automatically generated,there must be a 'my_lock_owner_id' field in the response.
      This name is so weird that we think it is inappropriate to put it into the api spec
    2. If we change the field 'my_lock_owner_id' in the response to 'lock_owner',which means the current lock owner of this lock,
      we find that in some lock services users can't get the current lock owner.Actually users don't need it at all.
    3. When reentrant lock is needed,the existing lock_owner is required to identify client and check "whether this client can reenter this lock".
      So this field in the request shouldn't be removed.
    """
    expiry_in_seconds: builtins.int
    """Required. The time before expiry.The time unit is second."""
    def __init__(
        self,
        *,
        store_name: builtins.str = ...,
        resource_id: builtins.str = ...,
        lock_owner: builtins.str = ...,
        expiry_in_seconds: builtins.int = ...,
    ) -> None: ...
    _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["expiry_in_seconds", b"expiry_in_seconds", "lock_owner", b"lock_owner", "resource_id", b"resource_id", "store_name", b"store_name"]
    def ClearField(self, field_name: _ClearFieldArgType) -> None: ...

Global___TryLockRequest: typing_extensions.TypeAlias = TryLockRequest

@typing.final
class TryLockResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SUCCESS_FIELD_NUMBER: builtins.int
    success: builtins.bool
    def __init__(
        self,
        *,
        success: builtins.bool = ...,
    ) -> None: ...
    _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["success", b"success"]
    def ClearField(self, field_name: _ClearFieldArgType) -> None: ...

Global___TryLockResponse: typing_extensions.TypeAlias = TryLockResponse

@typing.final
class UnlockRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    STORE_NAME_FIELD_NUMBER: builtins.int
    RESOURCE_ID_FIELD_NUMBER: builtins.int
    LOCK_OWNER_FIELD_NUMBER: builtins.int
    store_name: builtins.str
    resource_id: builtins.str
    """resource_id is the lock key."""
    lock_owner: builtins.str
    def __init__(
        self,
        *,
        store_name: builtins.str = ...,
        resource_id: builtins.str = ...,
        lock_owner: builtins.str = ...,
    ) -> None: ...
    _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["lock_owner", b"lock_owner", "resource_id", b"resource_id", "store_name", b"store_name"]
    def ClearField(self, field_name: _ClearFieldArgType) -> None: ...

Global___UnlockRequest: typing_extensions.TypeAlias = UnlockRequest

@typing.final
class UnlockResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Status:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _StatusEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[UnlockResponse._Status.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        SUCCESS: UnlockResponse._Status.ValueType  # 0
        LOCK_DOES_NOT_EXIST: UnlockResponse._Status.ValueType  # 1
        LOCK_BELONGS_TO_OTHERS: UnlockResponse._Status.ValueType  # 2
        INTERNAL_ERROR: UnlockResponse._Status.ValueType  # 3

    class Status(_Status, metaclass=_StatusEnumTypeWrapper): ...
    SUCCESS: UnlockResponse.Status.ValueType  # 0
    LOCK_DOES_NOT_EXIST: UnlockResponse.Status.ValueType  # 1
    LOCK_BELONGS_TO_OTHERS: UnlockResponse.Status.ValueType  # 2
    INTERNAL_ERROR: UnlockResponse.Status.ValueType  # 3

    STATUS_FIELD_NUMBER: builtins.int
    status: Global___UnlockResponse.Status.ValueType
    def __init__(
        self,
        *,
        status: Global___UnlockResponse.Status.ValueType = ...,
    ) -> None: ...
    _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["status", b"status"]
    def ClearField(self, field_name: _ClearFieldArgType) -> None: ...

Global___UnlockResponse: typing_extensions.TypeAlias = UnlockResponse
