"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file

Copyright 2025 The Dapr Authors
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class _PubsubSubscriptionType:
    ValueType = typing.NewType("ValueType", builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _PubsubSubscriptionTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_PubsubSubscriptionType.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    UNKNOWN: _PubsubSubscriptionType.ValueType  # 0
    """UNKNOWN is the default value for the subscription type."""
    DECLARATIVE: _PubsubSubscriptionType.ValueType  # 1
    """Declarative subscription (k8s CRD)"""
    PROGRAMMATIC: _PubsubSubscriptionType.ValueType  # 2
    """Programmatically created subscription"""
    STREAMING: _PubsubSubscriptionType.ValueType  # 3
    """Bidirectional Streaming subscription"""

class PubsubSubscriptionType(_PubsubSubscriptionType, metaclass=_PubsubSubscriptionTypeEnumTypeWrapper):
    """PubsubSubscriptionType indicates the type of subscription"""

UNKNOWN: PubsubSubscriptionType.ValueType  # 0
"""UNKNOWN is the default value for the subscription type."""
DECLARATIVE: PubsubSubscriptionType.ValueType  # 1
"""Declarative subscription (k8s CRD)"""
PROGRAMMATIC: PubsubSubscriptionType.ValueType  # 2
"""Programmatically created subscription"""
STREAMING: PubsubSubscriptionType.ValueType  # 3
"""Bidirectional Streaming subscription"""
Global___PubsubSubscriptionType: typing_extensions.TypeAlias = PubsubSubscriptionType

@typing.final
class GetMetadataRequest(google.protobuf.message.Message):
    """GetMetadataRequest is the message for the GetMetadata request.
    Empty
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

Global___GetMetadataRequest: typing_extensions.TypeAlias = GetMetadataRequest

@typing.final
class GetMetadataResponse(google.protobuf.message.Message):
    """GetMetadataResponse is a message that is returned on GetMetadata rpc call."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class ExtendedMetadataEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["key", b"key", "value", b"value"]
        def ClearField(self, field_name: _ClearFieldArgType) -> None: ...

    ID_FIELD_NUMBER: builtins.int
    ACTIVE_ACTORS_COUNT_FIELD_NUMBER: builtins.int
    REGISTERED_COMPONENTS_FIELD_NUMBER: builtins.int
    EXTENDED_METADATA_FIELD_NUMBER: builtins.int
    SUBSCRIPTIONS_FIELD_NUMBER: builtins.int
    HTTP_ENDPOINTS_FIELD_NUMBER: builtins.int
    APP_CONNECTION_PROPERTIES_FIELD_NUMBER: builtins.int
    RUNTIME_VERSION_FIELD_NUMBER: builtins.int
    ENABLED_FEATURES_FIELD_NUMBER: builtins.int
    ACTOR_RUNTIME_FIELD_NUMBER: builtins.int
    SCHEDULER_FIELD_NUMBER: builtins.int
    WORKFLOWS_FIELD_NUMBER: builtins.int
    id: builtins.str
    runtime_version: builtins.str
    @property
    def active_actors_count(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[Global___ActiveActorsCount]:
        """Deprecated alias for actor_runtime.active_actors."""

    @property
    def registered_components(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[Global___RegisteredComponents]: ...
    @property
    def extended_metadata(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]: ...
    @property
    def subscriptions(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[Global___PubsubSubscription]: ...
    @property
    def http_endpoints(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[Global___MetadataHTTPEndpoint]: ...
    @property
    def app_connection_properties(self) -> Global___AppConnectionProperties: ...
    @property
    def enabled_features(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]: ...
    @property
    def actor_runtime(self) -> Global___ActorRuntime: ...
    @property
    def scheduler(self) -> Global___MetadataScheduler: ...
    @property
    def workflows(self) -> Global___MetadataWorkflows: ...
    def __init__(
        self,
        *,
        id: builtins.str = ...,
        active_actors_count: collections.abc.Iterable[Global___ActiveActorsCount] | None = ...,
        registered_components: collections.abc.Iterable[Global___RegisteredComponents] | None = ...,
        extended_metadata: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        subscriptions: collections.abc.Iterable[Global___PubsubSubscription] | None = ...,
        http_endpoints: collections.abc.Iterable[Global___MetadataHTTPEndpoint] | None = ...,
        app_connection_properties: Global___AppConnectionProperties | None = ...,
        runtime_version: builtins.str = ...,
        enabled_features: collections.abc.Iterable[builtins.str] | None = ...,
        actor_runtime: Global___ActorRuntime | None = ...,
        scheduler: Global___MetadataScheduler | None = ...,
        workflows: Global___MetadataWorkflows | None = ...,
    ) -> None: ...
    _HasFieldArgType: typing_extensions.TypeAlias = typing.Literal["_scheduler", b"_scheduler", "_workflows", b"_workflows", "actor_runtime", b"actor_runtime", "app_connection_properties", b"app_connection_properties", "scheduler", b"scheduler", "workflows", b"workflows"]
    def HasField(self, field_name: _HasFieldArgType) -> builtins.bool: ...
    _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["_scheduler", b"_scheduler", "_workflows", b"_workflows", "active_actors_count", b"active_actors_count", "actor_runtime", b"actor_runtime", "app_connection_properties", b"app_connection_properties", "enabled_features", b"enabled_features", "extended_metadata", b"extended_metadata", "http_endpoints", b"http_endpoints", "id", b"id", "registered_components", b"registered_components", "runtime_version", b"runtime_version", "scheduler", b"scheduler", "subscriptions", b"subscriptions", "workflows", b"workflows"]
    def ClearField(self, field_name: _ClearFieldArgType) -> None: ...
    _WhichOneofReturnType__scheduler: typing_extensions.TypeAlias = typing.Literal["scheduler"]
    _WhichOneofArgType__scheduler: typing_extensions.TypeAlias = typing.Literal["_scheduler", b"_scheduler"]
    _WhichOneofReturnType__workflows: typing_extensions.TypeAlias = typing.Literal["workflows"]
    _WhichOneofArgType__workflows: typing_extensions.TypeAlias = typing.Literal["_workflows", b"_workflows"]
    @typing.overload
    def WhichOneof(self, oneof_group: _WhichOneofArgType__scheduler) -> _WhichOneofReturnType__scheduler | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: _WhichOneofArgType__workflows) -> _WhichOneofReturnType__workflows | None: ...

Global___GetMetadataResponse: typing_extensions.TypeAlias = GetMetadataResponse

@typing.final
class MetadataWorkflows(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONNECTED_WORKERS_FIELD_NUMBER: builtins.int
    connected_workers: builtins.int
    def __init__(
        self,
        *,
        connected_workers: builtins.int = ...,
    ) -> None: ...
    _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["connected_workers", b"connected_workers"]
    def ClearField(self, field_name: _ClearFieldArgType) -> None: ...

Global___MetadataWorkflows: typing_extensions.TypeAlias = MetadataWorkflows

@typing.final
class MetadataScheduler(google.protobuf.message.Message):
    """MetadataScheduler is a message that contains the list of addresses of the
    scheduler connections.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONNECTED_ADDRESSES_FIELD_NUMBER: builtins.int
    @property
    def connected_addresses(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """connected_addresses the list of addresses of the scheduler connections."""

    def __init__(
        self,
        *,
        connected_addresses: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["connected_addresses", b"connected_addresses"]
    def ClearField(self, field_name: _ClearFieldArgType) -> None: ...

Global___MetadataScheduler: typing_extensions.TypeAlias = MetadataScheduler

@typing.final
class ActorRuntime(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _ActorRuntimeStatus:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _ActorRuntimeStatusEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[ActorRuntime._ActorRuntimeStatus.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        INITIALIZING: ActorRuntime._ActorRuntimeStatus.ValueType  # 0
        """Indicates that the actor runtime is still being initialized."""
        DISABLED: ActorRuntime._ActorRuntimeStatus.ValueType  # 1
        """Indicates that the actor runtime is disabled.
        This normally happens when Dapr is started without "placement-host-address"
        """
        RUNNING: ActorRuntime._ActorRuntimeStatus.ValueType  # 2
        """Indicates the actor runtime is running, either as an actor host or client."""

    class ActorRuntimeStatus(_ActorRuntimeStatus, metaclass=_ActorRuntimeStatusEnumTypeWrapper): ...
    INITIALIZING: ActorRuntime.ActorRuntimeStatus.ValueType  # 0
    """Indicates that the actor runtime is still being initialized."""
    DISABLED: ActorRuntime.ActorRuntimeStatus.ValueType  # 1
    """Indicates that the actor runtime is disabled.
    This normally happens when Dapr is started without "placement-host-address"
    """
    RUNNING: ActorRuntime.ActorRuntimeStatus.ValueType  # 2
    """Indicates the actor runtime is running, either as an actor host or client."""

    RUNTIME_STATUS_FIELD_NUMBER: builtins.int
    ACTIVE_ACTORS_FIELD_NUMBER: builtins.int
    HOST_READY_FIELD_NUMBER: builtins.int
    PLACEMENT_FIELD_NUMBER: builtins.int
    runtime_status: Global___ActorRuntime.ActorRuntimeStatus.ValueType
    """Contains an enum indicating whether the actor runtime has been initialized."""
    host_ready: builtins.bool
    """Indicates whether the actor runtime is ready to host actors."""
    placement: builtins.str
    """Custom message from the placement provider."""
    @property
    def active_actors(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[Global___ActiveActorsCount]:
        """Count of active actors per type."""

    def __init__(
        self,
        *,
        runtime_status: Global___ActorRuntime.ActorRuntimeStatus.ValueType = ...,
        active_actors: collections.abc.Iterable[Global___ActiveActorsCount] | None = ...,
        host_ready: builtins.bool = ...,
        placement: builtins.str = ...,
    ) -> None: ...
    _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["active_actors", b"active_actors", "host_ready", b"host_ready", "placement", b"placement", "runtime_status", b"runtime_status"]
    def ClearField(self, field_name: _ClearFieldArgType) -> None: ...

Global___ActorRuntime: typing_extensions.TypeAlias = ActorRuntime

@typing.final
class ActiveActorsCount(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TYPE_FIELD_NUMBER: builtins.int
    COUNT_FIELD_NUMBER: builtins.int
    type: builtins.str
    count: builtins.int
    def __init__(
        self,
        *,
        type: builtins.str = ...,
        count: builtins.int = ...,
    ) -> None: ...
    _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["count", b"count", "type", b"type"]
    def ClearField(self, field_name: _ClearFieldArgType) -> None: ...

Global___ActiveActorsCount: typing_extensions.TypeAlias = ActiveActorsCount

@typing.final
class RegisteredComponents(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    TYPE_FIELD_NUMBER: builtins.int
    VERSION_FIELD_NUMBER: builtins.int
    CAPABILITIES_FIELD_NUMBER: builtins.int
    name: builtins.str
    type: builtins.str
    version: builtins.str
    @property
    def capabilities(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]: ...
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        type: builtins.str = ...,
        version: builtins.str = ...,
        capabilities: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["capabilities", b"capabilities", "name", b"name", "type", b"type", "version", b"version"]
    def ClearField(self, field_name: _ClearFieldArgType) -> None: ...

Global___RegisteredComponents: typing_extensions.TypeAlias = RegisteredComponents

@typing.final
class MetadataHTTPEndpoint(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    name: builtins.str
    def __init__(
        self,
        *,
        name: builtins.str = ...,
    ) -> None: ...
    _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["name", b"name"]
    def ClearField(self, field_name: _ClearFieldArgType) -> None: ...

Global___MetadataHTTPEndpoint: typing_extensions.TypeAlias = MetadataHTTPEndpoint

@typing.final
class AppConnectionProperties(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PORT_FIELD_NUMBER: builtins.int
    PROTOCOL_FIELD_NUMBER: builtins.int
    CHANNEL_ADDRESS_FIELD_NUMBER: builtins.int
    MAX_CONCURRENCY_FIELD_NUMBER: builtins.int
    HEALTH_FIELD_NUMBER: builtins.int
    port: builtins.int
    protocol: builtins.str
    channel_address: builtins.str
    max_concurrency: builtins.int
    @property
    def health(self) -> Global___AppConnectionHealthProperties: ...
    def __init__(
        self,
        *,
        port: builtins.int = ...,
        protocol: builtins.str = ...,
        channel_address: builtins.str = ...,
        max_concurrency: builtins.int = ...,
        health: Global___AppConnectionHealthProperties | None = ...,
    ) -> None: ...
    _HasFieldArgType: typing_extensions.TypeAlias = typing.Literal["health", b"health"]
    def HasField(self, field_name: _HasFieldArgType) -> builtins.bool: ...
    _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["channel_address", b"channel_address", "health", b"health", "max_concurrency", b"max_concurrency", "port", b"port", "protocol", b"protocol"]
    def ClearField(self, field_name: _ClearFieldArgType) -> None: ...

Global___AppConnectionProperties: typing_extensions.TypeAlias = AppConnectionProperties

@typing.final
class AppConnectionHealthProperties(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    HEALTH_CHECK_PATH_FIELD_NUMBER: builtins.int
    HEALTH_PROBE_INTERVAL_FIELD_NUMBER: builtins.int
    HEALTH_PROBE_TIMEOUT_FIELD_NUMBER: builtins.int
    HEALTH_THRESHOLD_FIELD_NUMBER: builtins.int
    health_check_path: builtins.str
    health_probe_interval: builtins.str
    health_probe_timeout: builtins.str
    health_threshold: builtins.int
    def __init__(
        self,
        *,
        health_check_path: builtins.str = ...,
        health_probe_interval: builtins.str = ...,
        health_probe_timeout: builtins.str = ...,
        health_threshold: builtins.int = ...,
    ) -> None: ...
    _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["health_check_path", b"health_check_path", "health_probe_interval", b"health_probe_interval", "health_probe_timeout", b"health_probe_timeout", "health_threshold", b"health_threshold"]
    def ClearField(self, field_name: _ClearFieldArgType) -> None: ...

Global___AppConnectionHealthProperties: typing_extensions.TypeAlias = AppConnectionHealthProperties

@typing.final
class PubsubSubscription(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class MetadataEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["key", b"key", "value", b"value"]
        def ClearField(self, field_name: _ClearFieldArgType) -> None: ...

    PUBSUB_NAME_FIELD_NUMBER: builtins.int
    TOPIC_FIELD_NUMBER: builtins.int
    METADATA_FIELD_NUMBER: builtins.int
    RULES_FIELD_NUMBER: builtins.int
    DEAD_LETTER_TOPIC_FIELD_NUMBER: builtins.int
    TYPE_FIELD_NUMBER: builtins.int
    pubsub_name: builtins.str
    topic: builtins.str
    dead_letter_topic: builtins.str
    type: Global___PubsubSubscriptionType.ValueType
    @property
    def metadata(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]: ...
    @property
    def rules(self) -> Global___PubsubSubscriptionRules: ...
    def __init__(
        self,
        *,
        pubsub_name: builtins.str = ...,
        topic: builtins.str = ...,
        metadata: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        rules: Global___PubsubSubscriptionRules | None = ...,
        dead_letter_topic: builtins.str = ...,
        type: Global___PubsubSubscriptionType.ValueType = ...,
    ) -> None: ...
    _HasFieldArgType: typing_extensions.TypeAlias = typing.Literal["rules", b"rules"]
    def HasField(self, field_name: _HasFieldArgType) -> builtins.bool: ...
    _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["dead_letter_topic", b"dead_letter_topic", "metadata", b"metadata", "pubsub_name", b"pubsub_name", "rules", b"rules", "topic", b"topic", "type", b"type"]
    def ClearField(self, field_name: _ClearFieldArgType) -> None: ...

Global___PubsubSubscription: typing_extensions.TypeAlias = PubsubSubscription

@typing.final
class PubsubSubscriptionRules(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RULES_FIELD_NUMBER: builtins.int
    @property
    def rules(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[Global___PubsubSubscriptionRule]: ...
    def __init__(
        self,
        *,
        rules: collections.abc.Iterable[Global___PubsubSubscriptionRule] | None = ...,
    ) -> None: ...
    _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["rules", b"rules"]
    def ClearField(self, field_name: _ClearFieldArgType) -> None: ...

Global___PubsubSubscriptionRules: typing_extensions.TypeAlias = PubsubSubscriptionRules

@typing.final
class PubsubSubscriptionRule(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    MATCH_FIELD_NUMBER: builtins.int
    PATH_FIELD_NUMBER: builtins.int
    match: builtins.str
    path: builtins.str
    def __init__(
        self,
        *,
        match: builtins.str = ...,
        path: builtins.str = ...,
    ) -> None: ...
    _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["match", b"match", "path", b"path"]
    def ClearField(self, field_name: _ClearFieldArgType) -> None: ...

Global___PubsubSubscriptionRule: typing_extensions.TypeAlias = PubsubSubscriptionRule

@typing.final
class SetMetadataRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    KEY_FIELD_NUMBER: builtins.int
    VALUE_FIELD_NUMBER: builtins.int
    key: builtins.str
    value: builtins.str
    def __init__(
        self,
        *,
        key: builtins.str = ...,
        value: builtins.str = ...,
    ) -> None: ...
    _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["key", b"key", "value", b"value"]
    def ClearField(self, field_name: _ClearFieldArgType) -> None: ...

Global___SetMetadataRequest: typing_extensions.TypeAlias = SetMetadataRequest
