"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file

Copyright 2025 The Dapr Authors
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
"""

import builtins
import collections.abc
import dapr.proto.runtime.v1.appcallback_pb2
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.message
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class PublishEventRequest(google.protobuf.message.Message):
    """PublishEventRequest is the message to publish event data to pubsub topic"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class MetadataEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["key", b"key", "value", b"value"]
        def ClearField(self, field_name: _ClearFieldArgType) -> None: ...

    PUBSUB_NAME_FIELD_NUMBER: builtins.int
    TOPIC_FIELD_NUMBER: builtins.int
    DATA_FIELD_NUMBER: builtins.int
    DATA_CONTENT_TYPE_FIELD_NUMBER: builtins.int
    METADATA_FIELD_NUMBER: builtins.int
    pubsub_name: builtins.str
    """The name of the pubsub component"""
    topic: builtins.str
    """The pubsub topic"""
    data: builtins.bytes
    """The data which will be published to topic."""
    data_content_type: builtins.str
    """The content type for the data (optional)."""
    @property
    def metadata(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """The metadata passing to pub components

        metadata property:
        - key : the key of the message.
        """

    def __init__(
        self,
        *,
        pubsub_name: builtins.str = ...,
        topic: builtins.str = ...,
        data: builtins.bytes = ...,
        data_content_type: builtins.str = ...,
        metadata: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
    ) -> None: ...
    _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["data", b"data", "data_content_type", b"data_content_type", "metadata", b"metadata", "pubsub_name", b"pubsub_name", "topic", b"topic"]
    def ClearField(self, field_name: _ClearFieldArgType) -> None: ...

Global___PublishEventRequest: typing_extensions.TypeAlias = PublishEventRequest

@typing.final
class BulkPublishRequest(google.protobuf.message.Message):
    """BulkPublishRequest is the message to bulk publish events to pubsub topic"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class MetadataEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["key", b"key", "value", b"value"]
        def ClearField(self, field_name: _ClearFieldArgType) -> None: ...

    PUBSUB_NAME_FIELD_NUMBER: builtins.int
    TOPIC_FIELD_NUMBER: builtins.int
    ENTRIES_FIELD_NUMBER: builtins.int
    METADATA_FIELD_NUMBER: builtins.int
    pubsub_name: builtins.str
    """The name of the pubsub component"""
    topic: builtins.str
    """The pubsub topic"""
    @property
    def entries(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[Global___BulkPublishRequestEntry]:
        """The entries which contain the individual events and associated details to be published"""

    @property
    def metadata(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """The request level metadata passing to to the pubsub components"""

    def __init__(
        self,
        *,
        pubsub_name: builtins.str = ...,
        topic: builtins.str = ...,
        entries: collections.abc.Iterable[Global___BulkPublishRequestEntry] | None = ...,
        metadata: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
    ) -> None: ...
    _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["entries", b"entries", "metadata", b"metadata", "pubsub_name", b"pubsub_name", "topic", b"topic"]
    def ClearField(self, field_name: _ClearFieldArgType) -> None: ...

Global___BulkPublishRequest: typing_extensions.TypeAlias = BulkPublishRequest

@typing.final
class BulkPublishRequestEntry(google.protobuf.message.Message):
    """BulkPublishRequestEntry is the message containing the event to be bulk published"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class MetadataEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["key", b"key", "value", b"value"]
        def ClearField(self, field_name: _ClearFieldArgType) -> None: ...

    ENTRY_ID_FIELD_NUMBER: builtins.int
    EVENT_FIELD_NUMBER: builtins.int
    CONTENT_TYPE_FIELD_NUMBER: builtins.int
    METADATA_FIELD_NUMBER: builtins.int
    entry_id: builtins.str
    """The request scoped unique ID referring to this message. Used to map status in response"""
    event: builtins.bytes
    """The event which will be pulished to the topic"""
    content_type: builtins.str
    """The content type for the event"""
    @property
    def metadata(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """The event level metadata passing to the pubsub component"""

    def __init__(
        self,
        *,
        entry_id: builtins.str = ...,
        event: builtins.bytes = ...,
        content_type: builtins.str = ...,
        metadata: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
    ) -> None: ...
    _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["content_type", b"content_type", "entry_id", b"entry_id", "event", b"event", "metadata", b"metadata"]
    def ClearField(self, field_name: _ClearFieldArgType) -> None: ...

Global___BulkPublishRequestEntry: typing_extensions.TypeAlias = BulkPublishRequestEntry

@typing.final
class BulkPublishResponse(google.protobuf.message.Message):
    """BulkPublishResponse is the message returned from a BulkPublishEvent call"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    FAILEDENTRIES_FIELD_NUMBER: builtins.int
    @property
    def failedEntries(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[Global___BulkPublishResponseFailedEntry]:
        """The entries for different events that failed publish in the BulkPublishEvent call"""

    def __init__(
        self,
        *,
        failedEntries: collections.abc.Iterable[Global___BulkPublishResponseFailedEntry] | None = ...,
    ) -> None: ...
    _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["failedEntries", b"failedEntries"]
    def ClearField(self, field_name: _ClearFieldArgType) -> None: ...

Global___BulkPublishResponse: typing_extensions.TypeAlias = BulkPublishResponse

@typing.final
class BulkPublishResponseFailedEntry(google.protobuf.message.Message):
    """BulkPublishResponseFailedEntry is the message containing the entryID and error of a failed event in BulkPublishEvent call"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ENTRY_ID_FIELD_NUMBER: builtins.int
    ERROR_FIELD_NUMBER: builtins.int
    entry_id: builtins.str
    """The response scoped unique ID referring to this message"""
    error: builtins.str
    """The error message if any on failure"""
    def __init__(
        self,
        *,
        entry_id: builtins.str = ...,
        error: builtins.str = ...,
    ) -> None: ...
    _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["entry_id", b"entry_id", "error", b"error"]
    def ClearField(self, field_name: _ClearFieldArgType) -> None: ...

Global___BulkPublishResponseFailedEntry: typing_extensions.TypeAlias = BulkPublishResponseFailedEntry

@typing.final
class SubscribeTopicEventsRequestAlpha1(google.protobuf.message.Message):
    """SubscribeTopicEventsRequestAlpha1 is a message containing the details for
    subscribing to a topic via streaming.
    The first message must always be the initial request. All subsequent
    messages must be event processed responses.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INITIAL_REQUEST_FIELD_NUMBER: builtins.int
    EVENT_PROCESSED_FIELD_NUMBER: builtins.int
    @property
    def initial_request(self) -> Global___SubscribeTopicEventsRequestInitialAlpha1: ...
    @property
    def event_processed(self) -> Global___SubscribeTopicEventsRequestProcessedAlpha1: ...
    def __init__(
        self,
        *,
        initial_request: Global___SubscribeTopicEventsRequestInitialAlpha1 | None = ...,
        event_processed: Global___SubscribeTopicEventsRequestProcessedAlpha1 | None = ...,
    ) -> None: ...
    _HasFieldArgType: typing_extensions.TypeAlias = typing.Literal["event_processed", b"event_processed", "initial_request", b"initial_request", "subscribe_topic_events_request_type", b"subscribe_topic_events_request_type"]
    def HasField(self, field_name: _HasFieldArgType) -> builtins.bool: ...
    _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["event_processed", b"event_processed", "initial_request", b"initial_request", "subscribe_topic_events_request_type", b"subscribe_topic_events_request_type"]
    def ClearField(self, field_name: _ClearFieldArgType) -> None: ...
    _WhichOneofReturnType_subscribe_topic_events_request_type: typing_extensions.TypeAlias = typing.Literal["initial_request", "event_processed"]
    _WhichOneofArgType_subscribe_topic_events_request_type: typing_extensions.TypeAlias = typing.Literal["subscribe_topic_events_request_type", b"subscribe_topic_events_request_type"]
    def WhichOneof(self, oneof_group: _WhichOneofArgType_subscribe_topic_events_request_type) -> _WhichOneofReturnType_subscribe_topic_events_request_type | None: ...

Global___SubscribeTopicEventsRequestAlpha1: typing_extensions.TypeAlias = SubscribeTopicEventsRequestAlpha1

@typing.final
class SubscribeTopicEventsRequestInitialAlpha1(google.protobuf.message.Message):
    """SubscribeTopicEventsRequestInitialAlpha1 is the initial message containing
    the details for subscribing to a topic via streaming.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class MetadataEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["key", b"key", "value", b"value"]
        def ClearField(self, field_name: _ClearFieldArgType) -> None: ...

    PUBSUB_NAME_FIELD_NUMBER: builtins.int
    TOPIC_FIELD_NUMBER: builtins.int
    METADATA_FIELD_NUMBER: builtins.int
    DEAD_LETTER_TOPIC_FIELD_NUMBER: builtins.int
    pubsub_name: builtins.str
    """The name of the pubsub component"""
    topic: builtins.str
    """The pubsub topic"""
    dead_letter_topic: builtins.str
    """dead_letter_topic is the topic to which messages that fail to be processed
    are sent.
    """
    @property
    def metadata(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """The metadata passing to pub components

        metadata property:
        - key : the key of the message.
        """

    def __init__(
        self,
        *,
        pubsub_name: builtins.str = ...,
        topic: builtins.str = ...,
        metadata: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        dead_letter_topic: builtins.str | None = ...,
    ) -> None: ...
    _HasFieldArgType: typing_extensions.TypeAlias = typing.Literal["_dead_letter_topic", b"_dead_letter_topic", "dead_letter_topic", b"dead_letter_topic"]
    def HasField(self, field_name: _HasFieldArgType) -> builtins.bool: ...
    _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["_dead_letter_topic", b"_dead_letter_topic", "dead_letter_topic", b"dead_letter_topic", "metadata", b"metadata", "pubsub_name", b"pubsub_name", "topic", b"topic"]
    def ClearField(self, field_name: _ClearFieldArgType) -> None: ...
    _WhichOneofReturnType__dead_letter_topic: typing_extensions.TypeAlias = typing.Literal["dead_letter_topic"]
    _WhichOneofArgType__dead_letter_topic: typing_extensions.TypeAlias = typing.Literal["_dead_letter_topic", b"_dead_letter_topic"]
    def WhichOneof(self, oneof_group: _WhichOneofArgType__dead_letter_topic) -> _WhichOneofReturnType__dead_letter_topic | None: ...

Global___SubscribeTopicEventsRequestInitialAlpha1: typing_extensions.TypeAlias = SubscribeTopicEventsRequestInitialAlpha1

@typing.final
class SubscribeTopicEventsRequestProcessedAlpha1(google.protobuf.message.Message):
    """SubscribeTopicEventsRequestProcessedAlpha1 is the message containing the
    subscription to a topic.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ID_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    id: builtins.str
    """id is the unique identifier for the subscription request."""
    @property
    def status(self) -> dapr.proto.runtime.v1.appcallback_pb2.TopicEventResponse:
        """status is the result of the subscription request."""

    def __init__(
        self,
        *,
        id: builtins.str = ...,
        status: dapr.proto.runtime.v1.appcallback_pb2.TopicEventResponse | None = ...,
    ) -> None: ...
    _HasFieldArgType: typing_extensions.TypeAlias = typing.Literal["status", b"status"]
    def HasField(self, field_name: _HasFieldArgType) -> builtins.bool: ...
    _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["id", b"id", "status", b"status"]
    def ClearField(self, field_name: _ClearFieldArgType) -> None: ...

Global___SubscribeTopicEventsRequestProcessedAlpha1: typing_extensions.TypeAlias = SubscribeTopicEventsRequestProcessedAlpha1

@typing.final
class SubscribeTopicEventsResponseAlpha1(google.protobuf.message.Message):
    """SubscribeTopicEventsResponseAlpha1 is a message returned from daprd
    when subscribing to a topic via streaming.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INITIAL_RESPONSE_FIELD_NUMBER: builtins.int
    EVENT_MESSAGE_FIELD_NUMBER: builtins.int
    @property
    def initial_response(self) -> Global___SubscribeTopicEventsResponseInitialAlpha1: ...
    @property
    def event_message(self) -> dapr.proto.runtime.v1.appcallback_pb2.TopicEventRequest: ...
    def __init__(
        self,
        *,
        initial_response: Global___SubscribeTopicEventsResponseInitialAlpha1 | None = ...,
        event_message: dapr.proto.runtime.v1.appcallback_pb2.TopicEventRequest | None = ...,
    ) -> None: ...
    _HasFieldArgType: typing_extensions.TypeAlias = typing.Literal["event_message", b"event_message", "initial_response", b"initial_response", "subscribe_topic_events_response_type", b"subscribe_topic_events_response_type"]
    def HasField(self, field_name: _HasFieldArgType) -> builtins.bool: ...
    _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["event_message", b"event_message", "initial_response", b"initial_response", "subscribe_topic_events_response_type", b"subscribe_topic_events_response_type"]
    def ClearField(self, field_name: _ClearFieldArgType) -> None: ...
    _WhichOneofReturnType_subscribe_topic_events_response_type: typing_extensions.TypeAlias = typing.Literal["initial_response", "event_message"]
    _WhichOneofArgType_subscribe_topic_events_response_type: typing_extensions.TypeAlias = typing.Literal["subscribe_topic_events_response_type", b"subscribe_topic_events_response_type"]
    def WhichOneof(self, oneof_group: _WhichOneofArgType_subscribe_topic_events_response_type) -> _WhichOneofReturnType_subscribe_topic_events_response_type | None: ...

Global___SubscribeTopicEventsResponseAlpha1: typing_extensions.TypeAlias = SubscribeTopicEventsResponseAlpha1

@typing.final
class SubscribeTopicEventsResponseInitialAlpha1(google.protobuf.message.Message):
    """SubscribeTopicEventsResponseInitialAlpha1 is the initial response from daprd
    when subscribing to a topic.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

Global___SubscribeTopicEventsResponseInitialAlpha1: typing_extensions.TypeAlias = SubscribeTopicEventsResponseInitialAlpha1
