"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file

Copyright 2025 The Dapr Authors
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.message
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class GetSecretRequest(google.protobuf.message.Message):
    """GetSecretRequest is the message to get secret from secret store."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class MetadataEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["key", b"key", "value", b"value"]
        def ClearField(self, field_name: _ClearFieldArgType) -> None: ...

    STORE_NAME_FIELD_NUMBER: builtins.int
    KEY_FIELD_NUMBER: builtins.int
    METADATA_FIELD_NUMBER: builtins.int
    store_name: builtins.str
    """The name of secret store."""
    key: builtins.str
    """The name of secret key."""
    @property
    def metadata(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """The metadata which will be sent to secret store components."""

    def __init__(
        self,
        *,
        store_name: builtins.str = ...,
        key: builtins.str = ...,
        metadata: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
    ) -> None: ...
    _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["key", b"key", "metadata", b"metadata", "store_name", b"store_name"]
    def ClearField(self, field_name: _ClearFieldArgType) -> None: ...

Global___GetSecretRequest: typing_extensions.TypeAlias = GetSecretRequest

@typing.final
class GetSecretResponse(google.protobuf.message.Message):
    """GetSecretResponse is the response message to convey the requested secret."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class DataEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["key", b"key", "value", b"value"]
        def ClearField(self, field_name: _ClearFieldArgType) -> None: ...

    DATA_FIELD_NUMBER: builtins.int
    @property
    def data(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """data is the secret value. Some secret store, such as kubernetes secret
        store, can save multiple secrets for single secret key.
        """

    def __init__(
        self,
        *,
        data: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
    ) -> None: ...
    _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["data", b"data"]
    def ClearField(self, field_name: _ClearFieldArgType) -> None: ...

Global___GetSecretResponse: typing_extensions.TypeAlias = GetSecretResponse

@typing.final
class GetBulkSecretRequest(google.protobuf.message.Message):
    """GetBulkSecretRequest is the message to get the secrets from secret store."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class MetadataEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["key", b"key", "value", b"value"]
        def ClearField(self, field_name: _ClearFieldArgType) -> None: ...

    STORE_NAME_FIELD_NUMBER: builtins.int
    METADATA_FIELD_NUMBER: builtins.int
    store_name: builtins.str
    """The name of secret store."""
    @property
    def metadata(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """The metadata which will be sent to secret store components."""

    def __init__(
        self,
        *,
        store_name: builtins.str = ...,
        metadata: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
    ) -> None: ...
    _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["metadata", b"metadata", "store_name", b"store_name"]
    def ClearField(self, field_name: _ClearFieldArgType) -> None: ...

Global___GetBulkSecretRequest: typing_extensions.TypeAlias = GetBulkSecretRequest

@typing.final
class SecretResponse(google.protobuf.message.Message):
    """SecretResponse is a map of decrypted string/string values"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class SecretsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["key", b"key", "value", b"value"]
        def ClearField(self, field_name: _ClearFieldArgType) -> None: ...

    SECRETS_FIELD_NUMBER: builtins.int
    @property
    def secrets(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]: ...
    def __init__(
        self,
        *,
        secrets: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
    ) -> None: ...
    _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["secrets", b"secrets"]
    def ClearField(self, field_name: _ClearFieldArgType) -> None: ...

Global___SecretResponse: typing_extensions.TypeAlias = SecretResponse

@typing.final
class GetBulkSecretResponse(google.protobuf.message.Message):
    """GetBulkSecretResponse is the response message to convey the requested secrets."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class DataEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        @property
        def value(self) -> Global___SecretResponse: ...
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: Global___SecretResponse | None = ...,
        ) -> None: ...
        _HasFieldArgType: typing_extensions.TypeAlias = typing.Literal["value", b"value"]
        def HasField(self, field_name: _HasFieldArgType) -> builtins.bool: ...
        _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["key", b"key", "value", b"value"]
        def ClearField(self, field_name: _ClearFieldArgType) -> None: ...

    DATA_FIELD_NUMBER: builtins.int
    @property
    def data(self) -> google.protobuf.internal.containers.MessageMap[builtins.str, Global___SecretResponse]:
        """data hold the secret values. Some secret store, such as kubernetes secret
        store, can save multiple secrets for single secret key.
        """

    def __init__(
        self,
        *,
        data: collections.abc.Mapping[builtins.str, Global___SecretResponse] | None = ...,
    ) -> None: ...
    _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["data", b"data"]
    def ClearField(self, field_name: _ClearFieldArgType) -> None: ...

Global___GetBulkSecretResponse: typing_extensions.TypeAlias = GetBulkSecretResponse
