"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file

Copyright 2025 The Dapr Authors
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
"""

import builtins
import collections.abc
import dapr.proto.common.v1.common_pb2
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.message
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class GetStateRequest(google.protobuf.message.Message):
    """GetStateRequest is the message to get key-value states from specific state store."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class MetadataEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["key", b"key", "value", b"value"]
        def ClearField(self, field_name: _ClearFieldArgType) -> None: ...

    STORE_NAME_FIELD_NUMBER: builtins.int
    KEY_FIELD_NUMBER: builtins.int
    CONSISTENCY_FIELD_NUMBER: builtins.int
    METADATA_FIELD_NUMBER: builtins.int
    store_name: builtins.str
    """The name of state store."""
    key: builtins.str
    """The key of the desired state"""
    consistency: dapr.proto.common.v1.common_pb2.StateOptions.StateConsistency.ValueType
    """The read consistency of the state store."""
    @property
    def metadata(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """The metadata which will be sent to state store components."""

    def __init__(
        self,
        *,
        store_name: builtins.str = ...,
        key: builtins.str = ...,
        consistency: dapr.proto.common.v1.common_pb2.StateOptions.StateConsistency.ValueType = ...,
        metadata: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
    ) -> None: ...
    _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["consistency", b"consistency", "key", b"key", "metadata", b"metadata", "store_name", b"store_name"]
    def ClearField(self, field_name: _ClearFieldArgType) -> None: ...

Global___GetStateRequest: typing_extensions.TypeAlias = GetStateRequest

@typing.final
class GetBulkStateRequest(google.protobuf.message.Message):
    """GetBulkStateRequest is the message to get a list of key-value states from specific state store."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class MetadataEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["key", b"key", "value", b"value"]
        def ClearField(self, field_name: _ClearFieldArgType) -> None: ...

    STORE_NAME_FIELD_NUMBER: builtins.int
    KEYS_FIELD_NUMBER: builtins.int
    PARALLELISM_FIELD_NUMBER: builtins.int
    METADATA_FIELD_NUMBER: builtins.int
    store_name: builtins.str
    """The name of state store."""
    parallelism: builtins.int
    """The number of parallel operations executed on the state store for a get operation."""
    @property
    def keys(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """The keys to get."""

    @property
    def metadata(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """The metadata which will be sent to state store components."""

    def __init__(
        self,
        *,
        store_name: builtins.str = ...,
        keys: collections.abc.Iterable[builtins.str] | None = ...,
        parallelism: builtins.int = ...,
        metadata: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
    ) -> None: ...
    _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["keys", b"keys", "metadata", b"metadata", "parallelism", b"parallelism", "store_name", b"store_name"]
    def ClearField(self, field_name: _ClearFieldArgType) -> None: ...

Global___GetBulkStateRequest: typing_extensions.TypeAlias = GetBulkStateRequest

@typing.final
class GetBulkStateResponse(google.protobuf.message.Message):
    """GetBulkStateResponse is the response conveying the list of state values."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ITEMS_FIELD_NUMBER: builtins.int
    @property
    def items(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[Global___BulkStateItem]:
        """The list of items containing the keys to get values for."""

    def __init__(
        self,
        *,
        items: collections.abc.Iterable[Global___BulkStateItem] | None = ...,
    ) -> None: ...
    _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["items", b"items"]
    def ClearField(self, field_name: _ClearFieldArgType) -> None: ...

Global___GetBulkStateResponse: typing_extensions.TypeAlias = GetBulkStateResponse

@typing.final
class BulkStateItem(google.protobuf.message.Message):
    """BulkStateItem is the response item for a bulk get operation.
    Return values include the item key, data and etag.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class MetadataEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["key", b"key", "value", b"value"]
        def ClearField(self, field_name: _ClearFieldArgType) -> None: ...

    KEY_FIELD_NUMBER: builtins.int
    DATA_FIELD_NUMBER: builtins.int
    ETAG_FIELD_NUMBER: builtins.int
    ERROR_FIELD_NUMBER: builtins.int
    METADATA_FIELD_NUMBER: builtins.int
    key: builtins.str
    """state item key"""
    data: builtins.bytes
    """The byte array data"""
    etag: builtins.str
    """The entity tag which represents the specific version of data.
    ETag format is defined by the corresponding data store.
    """
    error: builtins.str
    """The error that was returned from the state store in case of a failed get operation."""
    @property
    def metadata(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """The metadata which will be sent to app."""

    def __init__(
        self,
        *,
        key: builtins.str = ...,
        data: builtins.bytes = ...,
        etag: builtins.str = ...,
        error: builtins.str = ...,
        metadata: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
    ) -> None: ...
    _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["data", b"data", "error", b"error", "etag", b"etag", "key", b"key", "metadata", b"metadata"]
    def ClearField(self, field_name: _ClearFieldArgType) -> None: ...

Global___BulkStateItem: typing_extensions.TypeAlias = BulkStateItem

@typing.final
class GetStateResponse(google.protobuf.message.Message):
    """GetStateResponse is the response conveying the state value and etag."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class MetadataEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["key", b"key", "value", b"value"]
        def ClearField(self, field_name: _ClearFieldArgType) -> None: ...

    DATA_FIELD_NUMBER: builtins.int
    ETAG_FIELD_NUMBER: builtins.int
    METADATA_FIELD_NUMBER: builtins.int
    data: builtins.bytes
    """The byte array data"""
    etag: builtins.str
    """The entity tag which represents the specific version of data.
    ETag format is defined by the corresponding data store.
    """
    @property
    def metadata(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """The metadata which will be sent to app."""

    def __init__(
        self,
        *,
        data: builtins.bytes = ...,
        etag: builtins.str = ...,
        metadata: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
    ) -> None: ...
    _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["data", b"data", "etag", b"etag", "metadata", b"metadata"]
    def ClearField(self, field_name: _ClearFieldArgType) -> None: ...

Global___GetStateResponse: typing_extensions.TypeAlias = GetStateResponse

@typing.final
class DeleteStateRequest(google.protobuf.message.Message):
    """DeleteStateRequest is the message to delete key-value states in the specific state store."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class MetadataEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["key", b"key", "value", b"value"]
        def ClearField(self, field_name: _ClearFieldArgType) -> None: ...

    STORE_NAME_FIELD_NUMBER: builtins.int
    KEY_FIELD_NUMBER: builtins.int
    ETAG_FIELD_NUMBER: builtins.int
    OPTIONS_FIELD_NUMBER: builtins.int
    METADATA_FIELD_NUMBER: builtins.int
    store_name: builtins.str
    """The name of state store."""
    key: builtins.str
    """The key of the desired state"""
    @property
    def etag(self) -> dapr.proto.common.v1.common_pb2.Etag:
        """The entity tag which represents the specific version of data.
        The exact ETag format is defined by the corresponding data store.
        """

    @property
    def options(self) -> dapr.proto.common.v1.common_pb2.StateOptions:
        """State operation options which includes concurrency/
        consistency/retry_policy.
        """

    @property
    def metadata(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """The metadata which will be sent to state store components."""

    def __init__(
        self,
        *,
        store_name: builtins.str = ...,
        key: builtins.str = ...,
        etag: dapr.proto.common.v1.common_pb2.Etag | None = ...,
        options: dapr.proto.common.v1.common_pb2.StateOptions | None = ...,
        metadata: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
    ) -> None: ...
    _HasFieldArgType: typing_extensions.TypeAlias = typing.Literal["etag", b"etag", "options", b"options"]
    def HasField(self, field_name: _HasFieldArgType) -> builtins.bool: ...
    _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["etag", b"etag", "key", b"key", "metadata", b"metadata", "options", b"options", "store_name", b"store_name"]
    def ClearField(self, field_name: _ClearFieldArgType) -> None: ...

Global___DeleteStateRequest: typing_extensions.TypeAlias = DeleteStateRequest

@typing.final
class DeleteBulkStateRequest(google.protobuf.message.Message):
    """DeleteBulkStateRequest is the message to delete a list of key-value states from specific state store."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    STORE_NAME_FIELD_NUMBER: builtins.int
    STATES_FIELD_NUMBER: builtins.int
    store_name: builtins.str
    """The name of state store."""
    @property
    def states(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[dapr.proto.common.v1.common_pb2.StateItem]:
        """The array of the state key values."""

    def __init__(
        self,
        *,
        store_name: builtins.str = ...,
        states: collections.abc.Iterable[dapr.proto.common.v1.common_pb2.StateItem] | None = ...,
    ) -> None: ...
    _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["states", b"states", "store_name", b"store_name"]
    def ClearField(self, field_name: _ClearFieldArgType) -> None: ...

Global___DeleteBulkStateRequest: typing_extensions.TypeAlias = DeleteBulkStateRequest

@typing.final
class SaveStateRequest(google.protobuf.message.Message):
    """SaveStateRequest is the message to save multiple states into state store."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    STORE_NAME_FIELD_NUMBER: builtins.int
    STATES_FIELD_NUMBER: builtins.int
    store_name: builtins.str
    """The name of state store."""
    @property
    def states(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[dapr.proto.common.v1.common_pb2.StateItem]:
        """The array of the state key values."""

    def __init__(
        self,
        *,
        store_name: builtins.str = ...,
        states: collections.abc.Iterable[dapr.proto.common.v1.common_pb2.StateItem] | None = ...,
    ) -> None: ...
    _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["states", b"states", "store_name", b"store_name"]
    def ClearField(self, field_name: _ClearFieldArgType) -> None: ...

Global___SaveStateRequest: typing_extensions.TypeAlias = SaveStateRequest

@typing.final
class QueryStateRequest(google.protobuf.message.Message):
    """QueryStateRequest is the message to query state store."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class MetadataEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["key", b"key", "value", b"value"]
        def ClearField(self, field_name: _ClearFieldArgType) -> None: ...

    STORE_NAME_FIELD_NUMBER: builtins.int
    QUERY_FIELD_NUMBER: builtins.int
    METADATA_FIELD_NUMBER: builtins.int
    store_name: builtins.str
    """The name of state store."""
    query: builtins.str
    """The query in JSON format."""
    @property
    def metadata(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """The metadata which will be sent to state store components."""

    def __init__(
        self,
        *,
        store_name: builtins.str = ...,
        query: builtins.str = ...,
        metadata: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
    ) -> None: ...
    _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["metadata", b"metadata", "query", b"query", "store_name", b"store_name"]
    def ClearField(self, field_name: _ClearFieldArgType) -> None: ...

Global___QueryStateRequest: typing_extensions.TypeAlias = QueryStateRequest

@typing.final
class QueryStateItem(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    KEY_FIELD_NUMBER: builtins.int
    DATA_FIELD_NUMBER: builtins.int
    ETAG_FIELD_NUMBER: builtins.int
    ERROR_FIELD_NUMBER: builtins.int
    key: builtins.str
    """The object key."""
    data: builtins.bytes
    """The object value."""
    etag: builtins.str
    """The entity tag which represents the specific version of data.
    ETag format is defined by the corresponding data store.
    """
    error: builtins.str
    """The error message indicating an error in processing of the query result."""
    def __init__(
        self,
        *,
        key: builtins.str = ...,
        data: builtins.bytes = ...,
        etag: builtins.str = ...,
        error: builtins.str = ...,
    ) -> None: ...
    _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["data", b"data", "error", b"error", "etag", b"etag", "key", b"key"]
    def ClearField(self, field_name: _ClearFieldArgType) -> None: ...

Global___QueryStateItem: typing_extensions.TypeAlias = QueryStateItem

@typing.final
class QueryStateResponse(google.protobuf.message.Message):
    """QueryStateResponse is the response conveying the query results."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class MetadataEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["key", b"key", "value", b"value"]
        def ClearField(self, field_name: _ClearFieldArgType) -> None: ...

    RESULTS_FIELD_NUMBER: builtins.int
    TOKEN_FIELD_NUMBER: builtins.int
    METADATA_FIELD_NUMBER: builtins.int
    token: builtins.str
    """Pagination token."""
    @property
    def results(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[Global___QueryStateItem]:
        """An array of query results."""

    @property
    def metadata(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """The metadata which will be sent to app."""

    def __init__(
        self,
        *,
        results: collections.abc.Iterable[Global___QueryStateItem] | None = ...,
        token: builtins.str = ...,
        metadata: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
    ) -> None: ...
    _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["metadata", b"metadata", "results", b"results", "token", b"token"]
    def ClearField(self, field_name: _ClearFieldArgType) -> None: ...

Global___QueryStateResponse: typing_extensions.TypeAlias = QueryStateResponse

@typing.final
class TransactionalStateOperation(google.protobuf.message.Message):
    """TransactionalStateOperation is the message to execute a specified operation with a key-value pair."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    OPERATIONTYPE_FIELD_NUMBER: builtins.int
    REQUEST_FIELD_NUMBER: builtins.int
    operationType: builtins.str
    """The type of operation to be executed"""
    @property
    def request(self) -> dapr.proto.common.v1.common_pb2.StateItem:
        """State values to be operated on"""

    def __init__(
        self,
        *,
        operationType: builtins.str = ...,
        request: dapr.proto.common.v1.common_pb2.StateItem | None = ...,
    ) -> None: ...
    _HasFieldArgType: typing_extensions.TypeAlias = typing.Literal["request", b"request"]
    def HasField(self, field_name: _HasFieldArgType) -> builtins.bool: ...
    _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["operationType", b"operationType", "request", b"request"]
    def ClearField(self, field_name: _ClearFieldArgType) -> None: ...

Global___TransactionalStateOperation: typing_extensions.TypeAlias = TransactionalStateOperation

@typing.final
class ExecuteStateTransactionRequest(google.protobuf.message.Message):
    """ExecuteStateTransactionRequest is the message to execute multiple operations on a specified store."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class MetadataEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["key", b"key", "value", b"value"]
        def ClearField(self, field_name: _ClearFieldArgType) -> None: ...

    STORENAME_FIELD_NUMBER: builtins.int
    OPERATIONS_FIELD_NUMBER: builtins.int
    METADATA_FIELD_NUMBER: builtins.int
    storeName: builtins.str
    """Required. name of state store."""
    @property
    def operations(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[Global___TransactionalStateOperation]:
        """Required. transactional operation list."""

    @property
    def metadata(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """The metadata used for transactional operations."""

    def __init__(
        self,
        *,
        storeName: builtins.str = ...,
        operations: collections.abc.Iterable[Global___TransactionalStateOperation] | None = ...,
        metadata: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
    ) -> None: ...
    _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["metadata", b"metadata", "operations", b"operations", "storeName", b"storeName"]
    def ClearField(self, field_name: _ClearFieldArgType) -> None: ...

Global___ExecuteStateTransactionRequest: typing_extensions.TypeAlias = ExecuteStateTransactionRequest
