"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file

Copyright 2025 The Dapr Authors
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.message
import google.protobuf.timestamp_pb2
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class GetWorkflowRequest(google.protobuf.message.Message):
    """GetWorkflowRequest is the request for GetWorkflowBeta1."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INSTANCE_ID_FIELD_NUMBER: builtins.int
    WORKFLOW_COMPONENT_FIELD_NUMBER: builtins.int
    instance_id: builtins.str
    """ID of the workflow instance to query."""
    workflow_component: builtins.str
    """Name of the workflow component."""
    def __init__(
        self,
        *,
        instance_id: builtins.str = ...,
        workflow_component: builtins.str = ...,
    ) -> None: ...
    _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["instance_id", b"instance_id", "workflow_component", b"workflow_component"]
    def ClearField(self, field_name: _ClearFieldArgType) -> None: ...

Global___GetWorkflowRequest: typing_extensions.TypeAlias = GetWorkflowRequest

@typing.final
class GetWorkflowResponse(google.protobuf.message.Message):
    """GetWorkflowResponse is the response for GetWorkflowBeta1."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class PropertiesEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["key", b"key", "value", b"value"]
        def ClearField(self, field_name: _ClearFieldArgType) -> None: ...

    INSTANCE_ID_FIELD_NUMBER: builtins.int
    WORKFLOW_NAME_FIELD_NUMBER: builtins.int
    CREATED_AT_FIELD_NUMBER: builtins.int
    LAST_UPDATED_AT_FIELD_NUMBER: builtins.int
    RUNTIME_STATUS_FIELD_NUMBER: builtins.int
    PROPERTIES_FIELD_NUMBER: builtins.int
    instance_id: builtins.str
    """ID of the workflow instance."""
    workflow_name: builtins.str
    """Name of the workflow."""
    runtime_status: builtins.str
    """The current status of the workflow instance, for example, "PENDING", "RUNNING", "SUSPENDED", "COMPLETED", "FAILED", and "TERMINATED"."""
    @property
    def created_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """The time at which the workflow instance was created."""

    @property
    def last_updated_at(self) -> google.protobuf.timestamp_pb2.Timestamp:
        """The last time at which the workflow instance had its state changed."""

    @property
    def properties(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Additional component-specific properties of the workflow instance."""

    def __init__(
        self,
        *,
        instance_id: builtins.str = ...,
        workflow_name: builtins.str = ...,
        created_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        last_updated_at: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        runtime_status: builtins.str = ...,
        properties: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
    ) -> None: ...
    _HasFieldArgType: typing_extensions.TypeAlias = typing.Literal["created_at", b"created_at", "last_updated_at", b"last_updated_at"]
    def HasField(self, field_name: _HasFieldArgType) -> builtins.bool: ...
    _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["created_at", b"created_at", "instance_id", b"instance_id", "last_updated_at", b"last_updated_at", "properties", b"properties", "runtime_status", b"runtime_status", "workflow_name", b"workflow_name"]
    def ClearField(self, field_name: _ClearFieldArgType) -> None: ...

Global___GetWorkflowResponse: typing_extensions.TypeAlias = GetWorkflowResponse

@typing.final
class StartWorkflowRequest(google.protobuf.message.Message):
    """StartWorkflowRequest is the request for StartWorkflowBeta1."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing.final
    class OptionsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: builtins.str = ...,
        ) -> None: ...
        _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["key", b"key", "value", b"value"]
        def ClearField(self, field_name: _ClearFieldArgType) -> None: ...

    INSTANCE_ID_FIELD_NUMBER: builtins.int
    WORKFLOW_COMPONENT_FIELD_NUMBER: builtins.int
    WORKFLOW_NAME_FIELD_NUMBER: builtins.int
    OPTIONS_FIELD_NUMBER: builtins.int
    INPUT_FIELD_NUMBER: builtins.int
    instance_id: builtins.str
    """The ID to assign to the started workflow instance. If empty, a random ID is generated."""
    workflow_component: builtins.str
    """Name of the workflow component."""
    workflow_name: builtins.str
    """Name of the workflow."""
    input: builtins.bytes
    """Input data for the workflow instance."""
    @property
    def options(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """Additional component-specific options for starting the workflow instance."""

    def __init__(
        self,
        *,
        instance_id: builtins.str = ...,
        workflow_component: builtins.str = ...,
        workflow_name: builtins.str = ...,
        options: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        input: builtins.bytes = ...,
    ) -> None: ...
    _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["input", b"input", "instance_id", b"instance_id", "options", b"options", "workflow_component", b"workflow_component", "workflow_name", b"workflow_name"]
    def ClearField(self, field_name: _ClearFieldArgType) -> None: ...

Global___StartWorkflowRequest: typing_extensions.TypeAlias = StartWorkflowRequest

@typing.final
class StartWorkflowResponse(google.protobuf.message.Message):
    """StartWorkflowResponse is the response for StartWorkflowBeta1."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INSTANCE_ID_FIELD_NUMBER: builtins.int
    instance_id: builtins.str
    """ID of the started workflow instance."""
    def __init__(
        self,
        *,
        instance_id: builtins.str = ...,
    ) -> None: ...
    _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["instance_id", b"instance_id"]
    def ClearField(self, field_name: _ClearFieldArgType) -> None: ...

Global___StartWorkflowResponse: typing_extensions.TypeAlias = StartWorkflowResponse

@typing.final
class TerminateWorkflowRequest(google.protobuf.message.Message):
    """TerminateWorkflowRequest is the request for TerminateWorkflowBeta1."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INSTANCE_ID_FIELD_NUMBER: builtins.int
    WORKFLOW_COMPONENT_FIELD_NUMBER: builtins.int
    instance_id: builtins.str
    """ID of the workflow instance to terminate."""
    workflow_component: builtins.str
    """Name of the workflow component."""
    def __init__(
        self,
        *,
        instance_id: builtins.str = ...,
        workflow_component: builtins.str = ...,
    ) -> None: ...
    _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["instance_id", b"instance_id", "workflow_component", b"workflow_component"]
    def ClearField(self, field_name: _ClearFieldArgType) -> None: ...

Global___TerminateWorkflowRequest: typing_extensions.TypeAlias = TerminateWorkflowRequest

@typing.final
class PauseWorkflowRequest(google.protobuf.message.Message):
    """PauseWorkflowRequest is the request for PauseWorkflowBeta1."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INSTANCE_ID_FIELD_NUMBER: builtins.int
    WORKFLOW_COMPONENT_FIELD_NUMBER: builtins.int
    instance_id: builtins.str
    """ID of the workflow instance to pause."""
    workflow_component: builtins.str
    """Name of the workflow component."""
    def __init__(
        self,
        *,
        instance_id: builtins.str = ...,
        workflow_component: builtins.str = ...,
    ) -> None: ...
    _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["instance_id", b"instance_id", "workflow_component", b"workflow_component"]
    def ClearField(self, field_name: _ClearFieldArgType) -> None: ...

Global___PauseWorkflowRequest: typing_extensions.TypeAlias = PauseWorkflowRequest

@typing.final
class ResumeWorkflowRequest(google.protobuf.message.Message):
    """ResumeWorkflowRequest is the request for ResumeWorkflowBeta1."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INSTANCE_ID_FIELD_NUMBER: builtins.int
    WORKFLOW_COMPONENT_FIELD_NUMBER: builtins.int
    instance_id: builtins.str
    """ID of the workflow instance to resume."""
    workflow_component: builtins.str
    """Name of the workflow component."""
    def __init__(
        self,
        *,
        instance_id: builtins.str = ...,
        workflow_component: builtins.str = ...,
    ) -> None: ...
    _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["instance_id", b"instance_id", "workflow_component", b"workflow_component"]
    def ClearField(self, field_name: _ClearFieldArgType) -> None: ...

Global___ResumeWorkflowRequest: typing_extensions.TypeAlias = ResumeWorkflowRequest

@typing.final
class RaiseEventWorkflowRequest(google.protobuf.message.Message):
    """RaiseEventWorkflowRequest is the request for RaiseEventWorkflowBeta1."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INSTANCE_ID_FIELD_NUMBER: builtins.int
    WORKFLOW_COMPONENT_FIELD_NUMBER: builtins.int
    EVENT_NAME_FIELD_NUMBER: builtins.int
    EVENT_DATA_FIELD_NUMBER: builtins.int
    instance_id: builtins.str
    """ID of the workflow instance to raise an event for."""
    workflow_component: builtins.str
    """Name of the workflow component."""
    event_name: builtins.str
    """Name of the event."""
    event_data: builtins.bytes
    """Data associated with the event."""
    def __init__(
        self,
        *,
        instance_id: builtins.str = ...,
        workflow_component: builtins.str = ...,
        event_name: builtins.str = ...,
        event_data: builtins.bytes = ...,
    ) -> None: ...
    _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["event_data", b"event_data", "event_name", b"event_name", "instance_id", b"instance_id", "workflow_component", b"workflow_component"]
    def ClearField(self, field_name: _ClearFieldArgType) -> None: ...

Global___RaiseEventWorkflowRequest: typing_extensions.TypeAlias = RaiseEventWorkflowRequest

@typing.final
class PurgeWorkflowRequest(google.protobuf.message.Message):
    """PurgeWorkflowRequest is the request for PurgeWorkflowBeta1."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    INSTANCE_ID_FIELD_NUMBER: builtins.int
    WORKFLOW_COMPONENT_FIELD_NUMBER: builtins.int
    instance_id: builtins.str
    """ID of the workflow instance to purge."""
    workflow_component: builtins.str
    """Name of the workflow component."""
    def __init__(
        self,
        *,
        instance_id: builtins.str = ...,
        workflow_component: builtins.str = ...,
    ) -> None: ...
    _ClearFieldArgType: typing_extensions.TypeAlias = typing.Literal["instance_id", b"instance_id", "workflow_component", b"workflow_component"]
    def ClearField(self, field_name: _ClearFieldArgType) -> None: ...

Global___PurgeWorkflowRequest: typing_extensions.TypeAlias = PurgeWorkflowRequest
