# -*- coding: utf-8 -*-
# Generated by Django 1.11.29 on 2022-07-24 00:50
import django.contrib.postgres.fields
import django.db.models.deletion
from django.db import (
    migrations,
    models,
)


class Migration(migrations.Migration):
    dependencies = [
        ('function_tools', '0004_implementationstrategy_order_number'),
    ]

    operations = [
        migrations.CreateModel(
            name='Entity',
            fields=[
                (
                    'uuid',
                    models.UUIDField(
                        primary_key=True, serialize=False, unique=True, verbose_name='Уникальный идентификатор'
                    ),
                ),
                ('class_name', models.CharField(max_length=256, verbose_name='Название класса')),
                ('import_path', models.CharField(max_length=512, verbose_name='Путь до модуля для импорта')),
                (
                    'verbose_name',
                    models.CharField(
                        default='Имя сущности не определено', max_length=512, verbose_name='Человеко читаемое название'
                    ),
                ),
                (
                    'tags',
                    django.contrib.postgres.fields.ArrayField(
                        base_field=models.CharField(blank=True, max_length=128), default=list, size=None
                    ),
                ),
                ('created_at', models.DateTimeField(auto_now_add=True, verbose_name='Дата и время создания')),
                ('updated_at', models.DateTimeField(auto_now=True, verbose_name='Дата и время обновления')),
            ],
            options={
                'verbose_name': 'Сущность',
                'verbose_name_plural': 'Сущности',
                'db_table': 'function_tools_entity',
            },
        ),
        migrations.CreateModel(
            name='EntityType',
            fields=[
                ('title', models.TextField(verbose_name='расшифровка значения')),
                (
                    'key',
                    models.CharField(
                        db_index=True, max_length=512, primary_key=True, serialize=False, verbose_name='ключ'
                    ),
                ),
                ('order_number', models.PositiveIntegerField(default=100000, verbose_name='Порядковый номер')),
            ],
            options={
                'verbose_name': 'Тип сущности',
                'verbose_name_plural': 'Типы сущностей',
                'db_table': 'function_tools_entity_type',
            },
        ),
        migrations.DeleteModel(
            name='RegisteredFunction',
        ),
        migrations.AddField(
            model_name='entity',
            name='type',
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE, to='function_tools.EntityType', verbose_name='Тип сущности'
            ),
        ),
    ]
