import type { IConstruct } from "constructs";
/**
 * A deployment environment with a specific purpose and audience.
 *
 * You can create any Tier you like, but we include those explained by DTAP.
 *
 * @see https://en.wikipedia.org/wiki/Development,_testing,_acceptance_and_production
 */
export declare class Tier {
    /**
     * A tier that represents a production environment.
     */
    static readonly PRODUCTION: Tier;
    /**
     * A tier that represents an acceptance environment.
     */
    static readonly ACCEPTANCE: Tier;
    /**
     * A tier that represents a testing environment.
     */
    static readonly TESTING: Tier;
    /**
     * A tier that represents a development environment.
     */
    static readonly DEVELOPMENT: Tier;
    /**
     * The machine-readable identifier for this tier (e.g. prod)
     */
    readonly id: string;
    /**
     * The human-readable label for this tier (e.g. Production)
     */
    readonly label: string;
    /**
     * Creates a new Tier.
     *
     * @param id - The machine-readable identifier for this tier (e.g. prod)
     * @param label - The human-readable label for this tier (e.g. Production)
     */
    constructor(id: string, label: string);
    /**
     * Compares this tier to the provided value and tests for equality.
     *
     * @param other - The value to compare.
     * @returns Whether the provided value is equal to this tier.
     */
    matches(other: Tier): boolean;
    /**
     * Adds the label of this tier as a tag to the provided construct.
     */
    applyTags(construct: IConstruct): void;
}
