#!/usr/bin/env python
# -*- coding: utf-8 -*-
#
# ***** BEGIN LICENSE BLOCK *****
# Copyright (C) 2012  Hayaki Saito <user@zuse.jp>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
# ***** END LICENSE BLOCK *****

_rule = {'a': u'あ',
         'i': u'い',
         'u': u'う',
         'e': u'え',
         'o': u'お',
         'xa': u'ぁ',
         'xi': u'ぃ',
         'xu': u'ぅ',
         'xe': u'ぇ',
         'xo': u'ぉ',
         'va': u'う゛ぁ',
         'vi': u'う゛ぃ',
         'vu': u'う゛',
         've': u'う゛ぇ',
         'vo': u'う゛ぉ',
         'ka': u'か',
         'ki': u'き',
         'ku': u'く',
         'ke': u'け',
         'ko': u'こ',
         'ga': u'が',
         'gi': u'ぎ',
         'gu': u'ぐ',
         'ge': u'げ',
         'go': u'ご',
         'kya': u'きゃ',
         'kyi': u'きぃ',
         'kyu': u'きゅ',
         'kye': u'きぇ',
         'kyo': u'きょ',
         'gya': u'ぎゃ',
         'gyi': u'ぎぃ',
         'gyu': u'ぎゅ',
         'gye': u'ぎぇ',
         'gyo': u'ぎょ',
         'sa': u'さ',
         'si': u'し',
         'su': u'す',
         'se': u'せ',
         'so': u'そ',
         'za': u'ざ',
         'zi': u'じ',
         'zu': u'ず',
         'ze': u'ぜ',
         'zo': u'ぞ',
         'sya': u'しゃ',
         'syi': u'しぃ',
         'syu': u'しゅ',
         'sye': u'しぇ',
         'syo': u'しょ',
         'sha': u'しゃ',
         'shi': u'し',
         'shu': u'しゅ',
         'she': u'しぇ',
         'sho': u'しょ',
         'ja': u'じゃ',
         'ji': u'じ',
         'ju': u'じゅ',
         'je': u'じぇ',
         'jo': u'じょ',
         'jya': u'じゃ',
         'jyi': u'じぃ',
         'jyu': u'じゅ',
         'jye': u'じぇ',
         'jyo': u'じょ',
         'zya': u'じゃ',
         'zyi': u'じぃ',
         'zyu': u'じゅ',
         'zye': u'じぇ',
         'zyo': u'じょ',
         'ta': u'た',
         'ti': u'ち',
         'tu': u'つ',
         'te': u'て',
         'to': u'と',
         'da': u'だ',
         'di': u'ぢ',
         'du': u'づ',
         'de': u'で',
         'do': u'ど',
         'cha': u'ちゃ',
         'chi': u'ち',
         'chu': u'ちゅ',
         'che': u'ちぇ',
         'cho': u'ちょ',
         'tya': u'ちゃ',
         'tyi': u'ちぃ',
         'tyu': u'ちゅ',
         'tye': u'ちぇ',
         'tyo': u'ちょ',
         'tha': u'てぁ',
         'thi': u'てぃ',
         'thu': u'てゅ',
         'the': u'てぇ',
         'tho': u'てょ',
         'dya': u'ぢゃ',
         'dyi': u'ぢぃ',
         'dyu': u'ぢゅ',
         'dye': u'ぢぇ',
         'dyo': u'ぢょ',
         'dha': u'でゃ',
         'dhi': u'でぃ',
         'dhu': u'でゅ',
         'dhe': u'でぇ',
         'dho': u'でょ',
         'na': u'な',
         'ni': u'に',
         'nu': u'ぬ',
         'ne': u'ね',
         'no': u'の',
         'nya': u'にゃ',
         'nyi': u'にぃ',
         'nyu': u'にゅ',
         'nye': u'にぇ',
         'nyo': u'にょ',
         'ha': u'は',
         'hi': u'ひ',
         'hu': u'ふ',
         'he': u'へ',
         'ho': u'ほ',
         'pa': u'ぱ',
         'pi': u'ぴ',
         'pu': u'ぷ',
         'pe': u'ぺ',
         'po': u'ぽ',
         'ba': u'ば',
         'bi': u'び',
         'bu': u'ぶ',
         'be': u'べ',
         'bo': u'ぼ',
         'fa': u'ふぁ',
         'fi': u'ふぃ',
         'fu': u'ふ',
         'fe': u'ふぇ',
         'fo': u'ふぉ',
         'hya': u'ひゃ',
         'hyi': u'ひぃ',
         'hyu': u'ひゅ',
         'hye': u'ひぇ',
         'hyo': u'ひょ',
         'fya': u'ふゃ',
         'fyi': u'ふぃ',
         'fyu': u'ふゅ',
         'fye': u'ふぇ',
         'fyo': u'ふょ',
         'bya': u'びゃ',
         'byi': u'びぃ',
         'byu': u'びゅ',
         'bye': u'びぇ',
         'byo': u'びょ',
         'pya': u'ぴゃ',
         'pyi': u'ぴぃ',
         'pyu': u'ぴゅ',
         'pye': u'ぴぇ',
         'pyo': u'ぴょ',
         'ma': u'ま',
         'mi': u'み',
         'mu': u'む',
         'me': u'め',
         'mo': u'も',
         'mya': u'みゃ',
         'myi': u'みぃ',
         'myu': u'みゅ',
         'mye': u'みぇ',
         'myo': u'みょ',
         'ya': u'や',
         'yi': u'い',
         'yu': u'ゆ',
         'ye': u'いぇ',
         'yo': u'よ',
         'ra': u'ら',
         'ri': u'り',
         'ru': u'る',
         're': u'れ',
         'ro': u'ろ',
         'rya': u'りゃ',
         'ryi': u'りぃ',
         'ryu': u'りゅ',
         'rye': u'りぇ',
         'ryo': u'りょ',
         'wa': u'わ',
         'wi': u'うぃ',
         'wu': u'う',
         'we': u'うぇ',
         'wo': u'を',
         'nn': u'ん',
         'tsu': u'つ',
         'xtu': u'っ',
         'xtsu': u'っ',
         '-': u'ー',
         ',': u'、',
         '.': u'。',
         'z:': u'：',
         'z;': u'；',
         'zh': u'←',
         'zj': u'↓',
         'zk': u'↑',
         'zl': u'→',
         'z-': u'〜',
         'z,': u'‥',
         'z.': u'…',
         'z/': u'・',
         'z[': u'『',
         'z]': u'』',
         'z?': u'？',
         'z(': u'（',
         'z)': u'）',
         'z{': u'【',
         'z}': u'】',
         'zL': u'⇒',
         'z ': u'　',
         '[': u'「',
         ']': u'」',
         ':': u'：',
         ';': u'；',
         '`|': u'|',
         '\'': u'っ',
         '`\'': u'\'',
         '`;': u';',
         '`:': u':',
         '`\"': u'\"',
         '`a': u'ぁ',
         '`i': u'ぃ',
         '`u': u'ぅ',
         '`e': u'ぇ',
         '`o': u'ぉ',
         '`ca': u'か',
         '`ce': u'け',
         '`wa': u'ゎ',
         '`we': u'ゑ',
         '`wi': u'ゐ',
         '`ya': u'ゃ',
         '`yo': u'ょ',
         '`yu': u'ゅ',
         '`ys': u'ゃ',
         '`yn': u'ょ',
         '`yh': u'ゅ',
         '`,': u'‥',
         '`-': u'～',
         '`.': u'…',
         '`/': u'・',
         '`[': u'『',
         '`]': u'』',
         '`d': u'←',
         '`h': u'↓',
         '`t': u'↑',
         '`n': u'→',
         'ca': u'か',
         'ci': u'き',
         'cu': u'く',
         'ce': u'け',
         'co': u'こ',
         ';': u'あん',
         'x': u'いん',
         'k': u'うん',
         'j': u'えん',
         'q': u'おん',
         'c;': u'かん',
         'cx': u'きん',
         'ck': u'くん',
         'cj': u'けん',
         'cq': u'こん',
         'c\'': u'かい',
         'cp': u'くう',
         'c.': u'けい',
         'c,': u'こう',
         's;': u'さん',
         'sx': u'しん',
         'sk': u'すん',
         'sj': u'せん',
         'sq': u'そん',
         's\'': u'さい',
         'sp': u'すう',
         's.': u'せい',
         's,': u'そう',
         't;': u'たん',
         'tx': u'ちん',
         'tk': u'つん',
         'tj': u'てん',
         'tq': u'とん',
         't\'': u'たい',
         'tp': u'つう',
         't.': u'てい',
         't,': u'とう',
         'n;': u'なん',
         'nx': u'にん',
         'nk': u'ぬん',
         'nj': u'ねん',
         'nq': u'のん',
         'n\'': u'ない',
         'np': u'ぬう',
         'n.': u'ねい',
         'n,': u'のう',
         'h;': u'はん',
         'hx': u'ひん',
         'hk': u'ふん',
         'hj': u'へん',
         'hq': u'ほん',
         'h\'': u'はい',
         'hp': u'ふう',
         'h.': u'へい',
         'h,': u'ほう',
         'm;': u'まん',
         'mx': u'みん',
         'mk': u'むん',
         'mj': u'めん',
         'mq': u'もん',
         'm\'': u'まい',
         'mp': u'むう',
         'm.': u'めい',
         'm,': u'もう',
         'y;': u'やん',
         'yk': u'ゆん',
         'yq': u'よん',
         'y\'': u'やい',
         'yp': u'ゆう',
         'y.': u'いう',
         'y,': u'よう',
         'r;': u'らん',
         'rx': u'りん',
         'rk': u'るん',
         'rj': u'れん',
         'rq': u'ろん',
         'r\'': u'らい',
         'rp': u'るう',
         'r.': u'れい',
         'r,': u'ろう',
         'w;': u'わん',
         'wx': u'うぃん',
         'wk': u'うん',
         'wj': u'うぇん',
         'wq': u'うぉん',
         'w\'': u'わい',
         'wp': u'うぅ',
         'w.': u'うぇい',
         'w,': u'うぉー',
         'g;': u'がん',
         'gx': u'ぎん',
         'gk': u'ぐん',
         'gj': u'げん',
         'gq': u'ごん',
         'g\'': u'がい',
         'gp': u'ぐう',
         'g.': u'げい',
         'g,': u'ごう',
         'z;': u'ざん',
         'zx': u'じん',
         'zk': u'ずん',
         'zj': u'ぜん',
         'zq': u'ぞん',
         'z\'': u'ざい',
         'zp': u'ずう',
         'z.': u'ぜい',
         'z,': u'ぞう',
         'd;': u'だん',
         'dx': u'ぢん',
         'dk': u'づん',
         'dj': u'でん',
         'dq': u'どん',
         'd\'': u'だい',
         'dp': u'づう',
         'd.': u'でい',
         'd,': u'どう',
         'b;': u'ばん',
         'bx': u'びん',
         'bk': u'ぶん',
         'bj': u'べん',
         'bq': u'ぼん',
         'b\'': u'ばい',
         'bp': u'ぶう',
         'b.': u'べい',
         'b,': u'ぼう',
         'p;': u'ぱん',
         'px': u'ぴん',
         'pk': u'ぷん',
         'pj': u'ぺん',
         'pq': u'ぽん',
         'p\'': u'ぱい',
         'pp': u'ぷう',
         'p.': u'ぺい',
         'p,': u'ぽう',
         'cga': u'きゃ',
         'cgi': u'きぃ',
         'cgu': u'きゅ',
         'cge': u'きぇ',
         'cgo': u'きょ',
         'cg;': u'きゃん',
         'cgx': u'きぃん',
         'cgk': u'きゅん',
         'cgj': u'きぇん',
         'cgq': u'きょん',
         'cg\'': u'きゃい',
         'cgp': u'きゅう',
         'cg.': u'きぇい',
         'cg,': u'きょう',
         'sha': u'しゃ',
         'shi': u'しぃ',
         'shu': u'しゅ',
         'she': u'しぇ',
         'sho': u'しょ',
         'sh;': u'しゃん',
         'shx': u'しぃん',
         'shk': u'しゅん',
         'shj': u'しぇん',
         'shq': u'しょん',
         'sh\'': u'しゃい',
         'shp': u'しゅう',
         'sh.': u'しぇい',
         'sh,': u'しょう',
         'tha': u'ちゃ',
         'thi': u'ちぃ',
         'thu': u'ちゅ',
         'the': u'ちぇ',
         'tho': u'ちょ',
         'th;': u'ちゃん',
         'thx': u'ちぃん',
         'thk': u'ちゅん',
         'thj': u'ちぇん',
         'thq': u'ちょん',
         'th\'': u'ちゃい',
         'thp': u'ちゅう',
         'th.': u'ちぇい',
         'th,': u'ちょう',
         'nha': u'にゃ',
         'nhi': u'にぃ',
         'nhu': u'にゅ',
         'nhe': u'にぇ',
         'nho': u'にょ',
         'nh;': u'にゃん',
         'nhx': u'にぃん',
         'nhk': u'にゅん',
         'nhj': u'にぇん',
         'nhq': u'にょん',
         'nh\'': u'にゃい',
         'nhp': u'にゅう',
         'nh.': u'にぇい',
         'nh,': u'にょう',
         'hna': u'ひゃ',
         'hni': u'ひぃ',
         'hnu': u'ひゅ',
         'hne': u'ひぇ',
         'hno': u'ひょ',
         'hn;': u'ひゃん',
         'hnx': u'ひぃん',
         'hnk': u'ひゅん',
         'hnj': u'ひぇん',
         'hnq': u'ひょん',
         'hn\'': u'ひゃい',
         'hnp': u'ひゅう',
         'hn.': u'ひぇい',
         'hn,': u'ひょう',
         'mva': u'みゃ',
         'mvi': u'みぃ',
         'mvu': u'みゅ',
         'mve': u'みぇ',
         'mvo': u'みょ',
         'mv;': u'みゃん',
         'mvx': u'みぃん',
         'mvk': u'みゅん',
         'mvj': u'みぇん',
         'mvq': u'みょん',
         'mv\'': u'みゃい',
         'mvp': u'みゅう',
         'mv.': u'みぇい',
         'mv,': u'みょう',
         'rga': u'りゃ',
         'rgi': u'りぃ',
         'rgu': u'りゅ',
         'rge': u'りぇ',
         'rgo': u'りょ',
         'rg;': u'りゃん',
         'rgx': u'りぃん',
         'rgk': u'りゅん',
         'rgj': u'りぇん',
         'rgq': u'りょん',
         'rg\'': u'りゃい',
         'rgp': u'りゅう',
         'rg.': u'りぇい',
         'rg,': u'りょう',
         'gra': u'ぎゃ',
         'gri': u'ぎぃ',
         'gru': u'ぎゅ',
         'gre': u'ぎぇ',
         'gro': u'ぎょ',
         'gr;': u'ぎゃん',
         'grx': u'ぎぃん',
         'grk': u'ぎゅん',
         'grj': u'ぎぇん',
         'grq': u'ぎょん',
         'gr\'': u'ぎゃい',
         'grp': u'ぎゅう',
         'gr.': u'ぎぇい',
         'gr,': u'ぎょう',
         'zma': u'じゃ',
         'zmi': u'じぃ',
         'zmu': u'じゅ',
         'zme': u'じぇ',
         'zmo': u'じょ',
         'zm;': u'じゃん',
         'zmx': u'じぃん',
         'zmk': u'じゅん',
         'zmj': u'じぇん',
         'zmq': u'じょん',
         'zm\'': u'じゃい',
         'zmp': u'じゅう',
         'zm.': u'じぇい',
         'zm,': u'じょう',
         'dna': u'ぢゃ',
         'dni': u'ぢぃ',
         'dnu': u'ぢゅ',
         'dne': u'ぢぇ',
         'dno': u'ぢょ',
         'dn;': u'ぢゃん',
         'dnx': u'ぢぃん',
         'dnk': u'ぢゅん',
         'dnj': u'ぢぇん',
         'dnq': u'ぢょん',
         'dn\'': u'ぢゃい',
         'dnp': u'ぢゅう',
         'dn.': u'ぢぇい',
         'dn,': u'ぢょう',
         'bva': u'びゃ',
         'bvi': u'びぃ',
         'bvu': u'びゅ',
         'bve': u'びぇ',
         'bvo': u'びょ',
         'bv;': u'びゃん',
         'bvx': u'びぃん',
         'bvk': u'びゅん',
         'bvj': u'びぇん',
         'bvq': u'びょん',
         'bv\'': u'びゃい',
         'bvp': u'びゅう',
         'bv.': u'びぇい',
         'bv,': u'びょう',
         'pna': u'ぴゃ',
         'pni': u'ぴぃ',
         'pnu': u'ぴゅ',
         'pne': u'ぴぇ',
         'pno': u'ぴょ',
         'pn;': u'ぴゃん',
         'pnx': u'ぴぃん',
         'pnk': u'ぴゅん',
         'pnj': u'ぴぇん',
         'pnq': u'ぴょん',
         'pn\'': u'ぴゃい',
         'pnp': u'ぴゅう',
         'pn.': u'ぴぇい',
         'pn,': u'ぴょう',
         'f;': u'ふぁん',
         'fx': u'ふぃん',
         'fk': u'ふん',
         'fj': u'ふぇん',
         'fq': u'ふぉん',
         'f\'': u'ふぁい',
         'fp': u'ふう',
         'f.': u'ふぇい',
         'f,': u'ふぉー',
         'v;': u'う゛ぁん',
         'vx': u'う゛ぃん',
         'vk': u'う゛ん',
         'vj': u'う゛ぇん',
         'vq': u'う゛ぉん',
         'v\'': u'う゛ぁい',
         'vp': u'う゛ー',
         'v.': u'う゛ぇい',
         'v,': u'う゛ぉー',
         'pc': u'ぴゅう',
         'pl': u'ぴょう',
         'fc': u'ふゅー',
         'fl': u'ふぉー',
         'gc': u'ぎゅう',
         'gl': u'ぎょう',
         'cc': u'きゅう',
         'cl': u'きょう',
         'rc': u'りゅう',
         'rl': u'りょう',
         'ht': u'ひゅう',
         'hs': u'ひょう',
         'tt': u'ちゅう',
         'ts': u'ちょう',
         'nt': u'にゅう',
         'ns': u'にょう',
         'st': u'しゅう',
         'ss': u'しょう',
         'bw': u'びゅう',
         'bz': u'びょう',
         'mw': u'みゅー',
         'mz': u'みょう',
         'wz': u'うぉー',
         'vw': u'う゛ゅー',
         'vz': u'う゛ぉー',
         'zw': u'じゅう',
         'zz': u'じょう',
         'grr': u'ぎょく',
         'grl': u'ぎゃく',
         'cgr': u'きょく',
         'cgl': u'きゃく',
         'rgr': u'りょく',
         'rgl': u'りゃく',
         'hns': u'ひゃく',
         'thn': u'ちょく',
         'ths': u'ちゃく',
         'nhn': u'にょく',
         'nhs': u'にゃく',
         'shn': u'しょく',
         'shs': u'しゃく',
         'sht': u'しゅつ',
         'pns': u'ぴゃく',
         'bvv': u'びょく',
         'bvz': u'びゃく',
         'mvv': u'みょく',
         'mvz': u'みゃく',
         'zmv': u'じょく',
         'zmz': u'じゃく',
         'zmw': u'じゅつ',
         'shh': u'しゅく',
         'zmm': u'じゅく',
         'yh': u'ゆ',
         'yg': u'ゆう',
         'yz': u'やん',
         'ym': u'ゆん',
         'yv': u'よん',
         'ps': u'ぱ',
         'pd': u'ぴ',
         'ph': u'ぷ',
         'pt': u'ぺ',
         'pz': u'ぱん',
         'pb': u'ぴん',
         'pm': u'ぷん',
         'pw': u'ぺん',
         'pv': u'ぽん',
         'yy': u'いう',
         'yf': u'より',
         'yc': u'いう',
         'yr': u'よる',
         'yl': u'やる',
         'yd': u'よい',
         'yt': u'よって',
         'yn': u'よく',
         'ys': u'やく',
         'yb': u'ゆび',
         'yw': u'いわれ',
         'ff': u'ふり',
         'fg': u'ふる',
         'fr': u'ふる',
         'fn': u'ふぁん',
         'fm': u'ふむ',
         'gt': u'ごと',
         'gn': u'ごく',
         'gs': u'がく',
         'cr': u'から',
         'cd': u'かた',
         'ct': u'こと',
         'cb': u'かんがえ',
         'cn': u'こく',
         'cs': u'かく',
         'rr': u'られ',
         'rn': u'らん',
         'dg': u'だが',
         'dc': u'でき',
         'dr': u'である',
         'dl': u'でしょう',
         'dd': u'ので',
         'dt': u'だち',
         'ds': u'です',
         'dm': u'でも',
         'hg': u'ふる',
         'hc': u'ひゅう',
         'hr': u'ひとり',
         'hl': u'ひょう',
         'hd': u'ほど',
         'hh': u'ひと',
         'hz': u'ひじょう',
         'tf': u'とり',
         'tg': u'として',
         'tc': u'ついて',
         'tr': u'ところ',
         'tl': u'とく',
         'td': u'という',
         'tn': u'との',
         'tb': u'たび',
         'tm': u'ため',
         'tv': u'とき',
         'tz': u'てき',
         'nf': u'なり',
         'nc': u'について',
         'nr': u'なる',
         'nl': u'なった',
         'nd': u'など',
         'nb': u'なければ',
         'nm': u'なくても',
         'nw': u'なくては',
         'nz': u'なく',
         'sf': u'さり',
         'sg': u'され',
         'sc': u'した',
         'sr': u'する',
         'sd': u'され',
         'sm': u'しも',
         'snb': u'しなければ',
         'snm': u'しなくても',
         'snt': u'しなくて',
         'snw': u'しなくては',
         'sz': u'それぞれ',
         'bc': u'びゅう',
         'br': u'ばら',
         'bl': u'びょう',
         'bh': u'ぶつ',
         'bt': u'べつ',
         'mc': u'みゅー',
         'mr': u'まる',
         'ml': u'みょう',
         'md': u'まで',
         'mt': u'また',
         'mn': u'もの',
         'ms': u'ます',
         'mm': u'おも',
         'wr': u'われ',
         'wt': u'わたし',
         'wn': u'われわれ',
         'vm': u'ことな',
         'vv': u'おなじ',
         'zc': u'じゅう',
         'zr': u'ざる',
         'zt': u'ずつ',
         'zn': u'ぞく',
         'zs': u'ざく',
         'pf': u'ぷり',
         'pg': u'ぷる',
         'pr': u'ぷろ',
         'twa': u'てゃ',
         'twi': u'てぃ',
         'twu': u'てゅ',
         'twe': u'てぇ',
         'two': u'てょ',
         'tw;': u'てゃん',
         'twx': u'てぃん',
         'twk': u'てゅん',
         'twj': u'てぇん',
         'twq': u'てょん',
         'tw\'': u'てゃう',
         'twp': u'てゅう',
         'tw.': u'てぇい',
         'tw,': u'てょう',
         'dba': u'でゃ',
         'dbi': u'でぃ',
         'dbu': u'でゅ',
         'dbe': u'でぇ',
         'dbo': u'でょ',
         'db;': u'でゃん',
         'dbx': u'でぃん',
         'dbk': u'でゅん',
         'dbj': u'でぇん',
         'dbq': u'でょん',
         'db\'': u'でゃう',
         'dbp': u'でゅう',
         'db.': u'でぇい',
         'db,': u'でょう',
         'wma': u'うぁ',
         'wmi': u'うぃ',
         'wmu': u'うぅ',
         'wme': u'うぇ',
         'wmo': u'うぉ',
         'wm;': u'うぁん',
         'wmx': u'うぃん',
         'wmk': u'うぅん',
         'wmj': u'うぇん',
         'wmq': u'うぉん',
         'wm\'': u'うぁう',
         'wmp': u'うぅう',
         'wm.': u'うぇい',
         'wm,': u'うぉう',
         'cy': u'くい',
         'sy': u'すい',
         'ty': u'つい',
         'ny': u'ぬい',
         'hy': u'ふい',
         'my': u'むい',
         'yy': u'ゆい',
         'ry': u'るい',
         'wy': u'うい',
         'gy': u'ぐい',
         'zy': u'ずい',
         'dy': u'づい',
         'by': u'ぶい',
         'py': u'ぷい',
         'cgy': u'きゅい',
         'shy': u'しゅい',
         'thy': u'ちゅい',
         'nhy': u'にゅい',
         'hny': u'ひゅい',
         'mvy': u'みゅい',
         'rgy': u'りゅい',
         'gry': u'ぎゅい',
         'zmy': u'じゅい',
         'dny': u'ぢゅい',
         'bvy': u'びゅい',
         'pny': u'ぴゅい',
         'fy': u'ふい',
         'vy': u'う゛い',
         'twy': u'てゅい',
         'dby': u'でゅい',
         'wmy': u'うぅい',
         'c<': u'こう',
         's<': u'そう',
         't<': u'とう',
         'n<': u'のう',
         'h<': u'ほう',
         'm<': u'もう',
         'y<': u'よう',
         'r<': u'ろう',
         'w<': u'うぉー',
         'g<': u'ごう',
         'z<': u'ぞう',
         'd<': u'どう',
         'b<': u'ぼう',
         'p<': u'ぽう',
         'cg<': u'きょう',
         'sh<': u'しょう',
         'th<': u'ちょう',
         'nh<': u'にょう',
         'hn<': u'ひょう',
         'mv<': u'みょう',
         'rg<': u'りょう',
         'gr<': u'ぎょう',
         'zm<': u'じょう',
         'dn<': u'ぢょう',
         'bv<': u'びょう',
         'pn<': u'ぴょう',
         'f<': u'ふぉー',
         'v<': u'う゛ぉー',
         'tw<': u'てょう',
         'db<': u'でょう',
         'wm<': u'うぉう',
         'c>': u'けい',
         's>': u'せい',
         't>': u'てい',
         'n>': u'ねい',
         'h>': u'へい',
         'm>': u'めい',
         'y>': u'いう',
         'r>': u'れい',
         'w>': u'うぇい',
         'g>': u'げい',
         'z>': u'ぜい',
         'd>': u'でい',
         'b>': u'べい',
         'p>': u'ぺい',
         'cg>': u'きぇい',
         'sh>': u'しぇい',
         'th>': u'ちぇい',
         'nh>': u'にぇい',
         'hn>': u'ひぇい',
         'mv>': u'みぇい',
         'rg>': u'りぇい',
         'gr>': u'ぎぇい',
         'zm>': u'じぇい',
         'dn>': u'ぢぇい',
         'bv>': u'びぇい',
         'pn>': u'ぴぇい',
         'f>': u'ふぇい',
         'v>': u'う゛ぇい',
         'tw>': u'てぇい',
         'db>': u'でぇい',
         'wm>': u'うぇい'}


def get():
    """
    >>> rule = get()
    >>> rule['xa']
    u'\u3041'
    >>> rule['wu']
    u'\u3046'
    """
    return _rule


def test():
    import doctest
    doctest.testmod()


if __name__ == "__main__":
    test()
