/*
* Created on Feb 26, 2018
*
* \author: maxime
* \file : SegmentationLabelsProgram.qml
*/

/*
COLORS = [
    (255, 255, 255),
    (242, 132, 48),
    (48, 242, 183),
    (241, 48, 242),
    (183, 242, 48),
    (48, 125, 242),
    (242, 48, 74),
    (48, 242, 80),
    (138, 48, 242),
    (242, 196, 48),
    (48, 235, 242),
    (242, 48, 177),
    (119, 242, 48),
    (48, 61, 242),
    (242, 87, 48),
    (48, 242, 145),
    (203, 48, 242),
    (222, 242, 48),
    (48, 171, 242),
    (242, 48, 112),
    (54, 242, 48),
    (100, 48, 242),
    (242, 151, 48),
    (48, 242, 209),
    (242, 48, 216),
    (158, 242, 48),
    (48, 106, 242),
    (242, 48, 48),
    (48, 242, 106),
    (164, 48, 242),
    (242, 216, 48),
    (48, 209, 242),
    (242, 48, 151),
    (93, 242, 48),
    (54, 48, 242),
    (242, 112, 48),
    (48, 242, 171),
    (229, 48, 242),
    (203, 242, 48),
    (48, 145, 242),
    (242, 48, 87),
    (48, 242, 67),
    (125, 48, 242),
    (242, 177, 48),
    (48, 242, 235),
    (242, 48, 190),
    (132, 242, 48),
    (48, 80, 242),
    (242, 74, 48),
    (48, 242, 132),
    (190, 48, 242),
    (242, 241, 48),
    (48, 183, 242),
    (242, 48, 125),
    (67, 242, 48),
    (80, 48, 242),
    (242, 138, 48),
    (48, 242, 196),
    (242, 48, 229),
    (177, 242, 48),
    (48, 119, 242),
    (242, 48, 61),
    (48, 242, 93),
    (145, 48, 242),
    (242, 203, 48),
    (48, 222, 242),
    (242, 48, 164),
    (112, 242, 48),
    (48, 54, 242),
    (242, 100, 48),
    (48, 242, 158),
    (209, 48, 242),
    (216, 242, 48),
    (48, 158, 242),
    (242, 48, 100),
    (48, 242, 48),
    (106, 48, 242),
    (242, 164, 48),
    (48, 242, 222),
    (242, 48, 209),
    (151, 242, 48),
]

*/

import QtQuick 2.5
import UI3D 1.0

EmissiveProgram
{
    vertexShader: "
                        #version 410
                        uniform highp mat4 matrix;
                        in highp vec4 vertices;
                        in highp vec3 normals;
                        in highp float labels;

                        out float l;
                        void main()
                        {
                            gl_Position = matrix*vertices;
                            l = labels;
                        }
                   "
    fragmentShader: "
                        #version 410
                        uniform highp vec4 color;
                        uniform highp vec4 backColor;
                        in float l;
                        out vec4 frag_color;
                        void main()
                        {
                            if(l == 0)
                            {
                                frag_color = vec4(0.25, 0.25, 0.25, 1.0);
                            }
                            else if(l > 0.9 && l < 1.1)
                            {
                                frag_color = vec4( 48.0/255.0, 132.0/255.0, 242.0/255.0, 1.0);
                            }
                            else if(l > 1.9 && l < 2.1)
                            {
                                frag_color = vec4(183.0/255.0, 242.0/255.0,  48.0/255.0, 1.0);
                            }
                            else if(l > 2.9 && l < 3.1)
                            {
                                frag_color = vec4(242.0/255.0,  48.0/255.0, 241.0/255.0, 1.0);
                            }
                            else if(l > 3.9 && l < 4.1)
                            {
                                frag_color = vec4( 48.0/255.0, 242.0/255.0, 183.0/255.0, 1.0);
                            }
                            else if(l > 4.9 && l < 5.1)
                            {
                                frag_color = vec4(242.0/255.0, 125.0/255.0,  48.0/255.0, 1.0);
                            }
                            else if(l > 5.9 && l < 6.1)
                            {
                                frag_color = vec4( 74.0/255.0,  48.0/255.0, 242.0/255.0, 1.0);
                            }
                            else if(l > 6.9 && l < 7.1)
                            {
                                frag_color = vec4( 80.0/255.0, 242.0/255.0,  48.0/255.0, 1.0);
                            }
                            else if(l > 7.9 && l < 8.1)
                            {
                                frag_color = vec4(242.0/255.0,  48.0/255.0, 138.0/255.0, 1.0);
                            }
                            else if(l > 8.9 && l < 9.1)
                            {
                                frag_color = vec4( 48.0/255.0, 196.0/255.0, 242.0/255.0, 1.0);
                            }
                            else
                            {
                                frag_color = vec4(0.25, 0.25, 0.25, 1.0);
                            }
                            // switch(l) {
                            //     case 0:
                            //         frag_color = vec4(0.25, 0.25, 0.25, 1.0);
                            //         break;
                            //     case 1:
                            //         frag_color = vec4( 48.0/255.0, 132.0/255.0, 242.0/255.0, 1.0);
                            //         break;
                            //     case 2:
                            //         frag_color = vec4(183.0/255.0, 242.0/255.0,  48.0/255.0, 1.0);
                            //         break;
                            //     case 3:
                            //         frag_color = vec4(242.0/255.0,  48.0/255.0, 241.0/255.0, 1.0);
                            //         break;
                            //     case 4:
                            //         frag_color = vec4( 48.0/255.0, 242.0/255.0, 183.0/255.0, 1.0);
                            //         break;
                            //     case 5:
                            //         frag_color = vec4(242.0/255.0, 125.0/255.0,  48.0/255.0, 1.0);
                            //         break;
                            //     case 6:
                            //         frag_color = vec4( 74.0/255.0,  48.0/255.0, 242.0/255.0, 1.0);
                            //         break;
                            //     case 7:
                            //         frag_color = vec4( 80.0/255.0, 242.0/255.0,  48.0/255.0, 1.0);
                            //         break;
                            //     case 8:
                            //         frag_color = vec4(242.0/255.0,  48.0/255.0, 138.0/255.0, 1.0);
                            //         break;
                            //     case 9:
                            //         frag_color = vec4( 48.0/255.0, 196.0/255.0, 242.0/255.0, 1.0);
                            //         break;
                            //     default:
                            //         frag_color = vec4( color.x, color.y, color.z, color.w);
                            //         break;
                            // }
                        }
                    "
}

