# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['EksKubeConfigArgs', 'EksKubeConfig']

@pulumi.input_type
class EksKubeConfigArgs:
    def __init__(__self__, *,
                 cluster_endpoint: pulumi.Input[_builtins.str],
                 cluster_name: pulumi.Input[_builtins.str],
                 certificate_data: Optional[pulumi.Input[_builtins.str]] = None,
                 profile: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 role_arn: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a EksKubeConfig resource.
        :param pulumi.Input[_builtins.str] cluster_endpoint: Endpoint for your Kubernetes API server.
        :param pulumi.Input[_builtins.str] cluster_name: Name of the EKS cluster you want to generate the kubeconfig for
        :param pulumi.Input[_builtins.str] certificate_data: Base64 encoded certificate data required to communicate with your cluster.
        :param pulumi.Input[_builtins.str] profile: AWS Profile name. This will overwrite any environment variables set.
        :param pulumi.Input[_builtins.str] region: Region that the EKS cluster is in. Optional
        :param pulumi.Input[_builtins.str] role_arn: Role arn that you want the kubeconfig to use. Optional
        """
        pulumi.set(__self__, "cluster_endpoint", cluster_endpoint)
        pulumi.set(__self__, "cluster_name", cluster_name)
        if certificate_data is not None:
            pulumi.set(__self__, "certificate_data", certificate_data)
        if profile is not None:
            pulumi.set(__self__, "profile", profile)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if role_arn is not None:
            pulumi.set(__self__, "role_arn", role_arn)

    @_builtins.property
    @pulumi.getter(name="clusterEndpoint")
    def cluster_endpoint(self) -> pulumi.Input[_builtins.str]:
        """
        Endpoint for your Kubernetes API server.
        """
        return pulumi.get(self, "cluster_endpoint")

    @cluster_endpoint.setter
    def cluster_endpoint(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "cluster_endpoint", value)

    @_builtins.property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> pulumi.Input[_builtins.str]:
        """
        Name of the EKS cluster you want to generate the kubeconfig for
        """
        return pulumi.get(self, "cluster_name")

    @cluster_name.setter
    def cluster_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "cluster_name", value)

    @_builtins.property
    @pulumi.getter(name="certificateData")
    def certificate_data(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Base64 encoded certificate data required to communicate with your cluster.
        """
        return pulumi.get(self, "certificate_data")

    @certificate_data.setter
    def certificate_data(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "certificate_data", value)

    @_builtins.property
    @pulumi.getter
    def profile(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        AWS Profile name. This will overwrite any environment variables set.
        """
        return pulumi.get(self, "profile")

    @profile.setter
    def profile(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "profile", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Region that the EKS cluster is in. Optional
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Role arn that you want the kubeconfig to use. Optional
        """
        return pulumi.get(self, "role_arn")

    @role_arn.setter
    def role_arn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "role_arn", value)


@pulumi.type_token("kubeconfig:index:EksKubeConfig")
class EksKubeConfig(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 certificate_data: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_name: Optional[pulumi.Input[_builtins.str]] = None,
                 profile: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 role_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Create a EksKubeConfig resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] certificate_data: Base64 encoded certificate data required to communicate with your cluster.
        :param pulumi.Input[_builtins.str] cluster_endpoint: Endpoint for your Kubernetes API server.
        :param pulumi.Input[_builtins.str] cluster_name: Name of the EKS cluster you want to generate the kubeconfig for
        :param pulumi.Input[_builtins.str] profile: AWS Profile name. This will overwrite any environment variables set.
        :param pulumi.Input[_builtins.str] region: Region that the EKS cluster is in. Optional
        :param pulumi.Input[_builtins.str] role_arn: Role arn that you want the kubeconfig to use. Optional
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EksKubeConfigArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a EksKubeConfig resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param EksKubeConfigArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EksKubeConfigArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 certificate_data: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_name: Optional[pulumi.Input[_builtins.str]] = None,
                 profile: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 role_arn: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EksKubeConfigArgs.__new__(EksKubeConfigArgs)

            __props__.__dict__["certificate_data"] = certificate_data
            if cluster_endpoint is None and not opts.urn:
                raise TypeError("Missing required property 'cluster_endpoint'")
            __props__.__dict__["cluster_endpoint"] = cluster_endpoint
            if cluster_name is None and not opts.urn:
                raise TypeError("Missing required property 'cluster_name'")
            __props__.__dict__["cluster_name"] = cluster_name
            __props__.__dict__["profile"] = profile
            __props__.__dict__["region"] = region
            __props__.__dict__["role_arn"] = role_arn
            __props__.__dict__["kubeconfig"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["kubeconfig"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(EksKubeConfig, __self__).__init__(
            'kubeconfig:index:EksKubeConfig',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'EksKubeConfig':
        """
        Get an existing EksKubeConfig resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = EksKubeConfigArgs.__new__(EksKubeConfigArgs)

        __props__.__dict__["certificate_data"] = None
        __props__.__dict__["cluster_endpoint"] = None
        __props__.__dict__["cluster_name"] = None
        __props__.__dict__["kubeconfig"] = None
        __props__.__dict__["profile"] = None
        __props__.__dict__["region"] = None
        __props__.__dict__["role_arn"] = None
        return EksKubeConfig(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="certificateData")
    def certificate_data(self) -> pulumi.Output[_builtins.str]:
        """
        Base64 encoded certificate data required to communicate with your cluster.
        """
        return pulumi.get(self, "certificate_data")

    @_builtins.property
    @pulumi.getter(name="clusterEndpoint")
    def cluster_endpoint(self) -> pulumi.Output[_builtins.str]:
        """
        Endpoint for your Kubernetes API server.
        """
        return pulumi.get(self, "cluster_endpoint")

    @_builtins.property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the EKS cluster you want to generate the kubeconfig for
        """
        return pulumi.get(self, "cluster_name")

    @_builtins.property
    @pulumi.getter
    def kubeconfig(self) -> pulumi.Output[_builtins.str]:
        """
        Generated Kubeconfig for working with your EKS cluster
        """
        return pulumi.get(self, "kubeconfig")

    @_builtins.property
    @pulumi.getter
    def profile(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        AWS Profile name. This will overwrite any environment variables set.
        """
        return pulumi.get(self, "profile")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="roleArn")
    def role_arn(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Role arn that you want the kubeconfig to use. Optional
        """
        return pulumi.get(self, "role_arn")

