﻿'''_773.py

ContactResultType
'''


from enum import Enum

from mastapy._internal.python_net import python_net_import

_CONTACT_RESULT_TYPE = python_net_import('SMT.MastaAPI.Gears.LTCA', 'ContactResultType')


__docformat__ = 'restructuredtext en'
__all__ = ('ContactResultType',)


class ContactResultType(Enum):
    '''ContactResultType

    This is a mastapy class.

    Note:
        This class is an Enum.
    '''

    @classmethod
    def type_(cls):
        return _CONTACT_RESULT_TYPE

    __hash__ = None

    MAX_PRESSURE = 0
    FORCE_PER_UNIT_LENGTH = 1
    HERTZIAN_CONTACT_HALF_WIDTH = 2
    MAX_SHEAR_STRESS = 3
    DEPTH_OF_MAX_SHEAR_STRESS = 4
    TOTAL_DEFLECTION_FOR_MESH = 5
    SLIDING_VELOCITY = 6
    PRESSURE_VELOCITY_PV = 7
    MINIMUM_LUBRICANT_FILM_THICKNESS_ISOTR_1514412010 = 8
    SPECIFIC_LUBRICANT_FILM_THICKNESS_ISOTR_1514412010 = 9
    MICROPITTING_SAFETY_FACTOR_ISOTR_1514412010 = 10
    MICROPITTING_FLASH_TEMPERATURE_ISOTR_1514412010 = 11
    MICROPITTING_CONTACT_TEMPERATURE_ISOTR_1514412010 = 12
    MINIMUM_LUBRICANT_FILM_THICKNESS_ISOTR_1514412014 = 13
    SPECIFIC_LUBRICANT_FILM_THICKNESS_ISOTR_1514412014 = 14
    MICROPITTING_SAFETY_FACTOR_ISOTR_1514412014 = 15
    MICROPITTING_FLASH_TEMPERATURE_ISOTR_1514412014 = 16
    MICROPITTING_CONTACT_TEMPERATURE_ISOTR_1514412014 = 17
    MINIMUM_LUBRICANT_FILM_THICKNESS_ISOTS_6336222018 = 18
    SPECIFIC_LUBRICANT_FILM_THICKNESS_ISOTS_6336222018 = 19
    MICROPITTING_SAFETY_FACTOR_ISOTS_6336222018 = 20
    MICROPITTING_FLASH_TEMPERATURE_ISOTS_6336222018 = 21
    MICROPITTING_CONTACT_TEMPERATURE_ISOTS_6336222018 = 22
    COEFFICIENT_OF_FRICTION_BENEDICT_AND_KELLEY = 23
    SLIDING_POWER_LOSS = 24
    SCUFFING_FLASH_TEMPERATURE_ISOTR_1398912000 = 25
    SCUFFING_CONTACT_TEMPERATURE_ISOTR_1398912000 = 26
    SCUFFING_SAFETY_FACTOR_ISOTR_1398912000 = 27
    SCUFFING_FLASH_TEMPERATURE_ISOTS_6336202017 = 28
    SCUFFING_CONTACT_TEMPERATURE_ISOTS_6336202017 = 29
    SCUFFING_SAFETY_FACTOR_ISOTS_6336202017 = 30
    SCUFFING_FLASH_TEMPERATURE_AGMA_925A03 = 31
    SCUFFING_CONTACT_TEMPERATURE_AGMA_925A03 = 32
    SCUFFING_SAFETY_FACTOR_AGMA_925A03 = 33
    SCUFFING_FLASH_TEMPERATURE_DIN_399041987 = 34
    SCUFFING_CONTACT_TEMPERATURE_DIN_399041987 = 35
    SCUFFING_SAFETY_FACTOR_DIN_399041987 = 36
    GAP_BETWEEN_LOADED_FLANKS_TRANSVERSE = 37
    GAP_BETWEEN_UNLOADED_FLANKS_TRANSVERSE = 38


def __enum_setattr(self, attr, value):
    raise AttributeError('Cannot set the attributes of an Enum.') from None


def __enum_delattr(self, attr):
    raise AttributeError('Cannot delete the attributes of an Enum.') from None


ContactResultType.__setattr__ = __enum_setattr
ContactResultType.__delattr__ = __enum_delattr
