import * as acm from 'aws-cdk-lib/aws-certificatemanager';
import * as cloudfront from 'aws-cdk-lib/aws-cloudfront';
import * as s3 from 'aws-cdk-lib/aws-s3';
import { Construct } from 'constructs';
export declare enum S3OriginAccessType {
    ORIGIN_ACCESS_IDENTITY = 0,
    ORIGIN_ACCESS_CONTROL = 1
}
interface BaseSecureFrontendWebAppCloudFrontDistributionProps {
    readonly comment?: string;
    readonly domainName: string;
    readonly s3OriginAccessType: S3OriginAccessType;
    readonly certificate: acm.ICertificate;
    readonly originBucket: s3.IBucket;
    readonly accessLogBucket?: s3.IBucket;
}
export interface SecureFrontendWebAppCloudFrontDistributionOriginAccessIdentityProps extends BaseSecureFrontendWebAppCloudFrontDistributionProps {
    readonly s3OriginAccessType: S3OriginAccessType.ORIGIN_ACCESS_IDENTITY;
    readonly originAccessIdentity: cloudfront.IOriginAccessIdentity;
}
export interface SecureFrontendWebAppCloudFrontDistributionOriginAccessControlProps extends BaseSecureFrontendWebAppCloudFrontDistributionProps {
    readonly s3OriginAccessType: S3OriginAccessType.ORIGIN_ACCESS_CONTROL;
    readonly originAccessControlId: string;
}
export declare class SecureFrontendWebAppCloudFrontDistribution extends cloudfront.Distribution {
    constructor(scope: Construct, id: string, props: SecureFrontendWebAppCloudFrontDistributionOriginAccessControlProps | SecureFrontendWebAppCloudFrontDistributionOriginAccessIdentityProps);
}
export {};
