"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SecureFrontendWebAppCloudFrontDistribution = exports.S3OriginAccessType = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("aws-cdk-lib");
const cloudfront = require("aws-cdk-lib/aws-cloudfront");
const origins = require("aws-cdk-lib/aws-cloudfront-origins");
var S3OriginAccessType;
(function (S3OriginAccessType) {
    S3OriginAccessType[S3OriginAccessType["ORIGIN_ACCESS_IDENTITY"] = 0] = "ORIGIN_ACCESS_IDENTITY";
    S3OriginAccessType[S3OriginAccessType["ORIGIN_ACCESS_CONTROL"] = 1] = "ORIGIN_ACCESS_CONTROL";
})(S3OriginAccessType || (exports.S3OriginAccessType = S3OriginAccessType = {}));
class SecureFrontendWebAppCloudFrontDistribution extends cloudfront.Distribution {
    // eslint-disable-next-line max-len
    constructor(scope, id, props) {
        super(scope, id, {
            enabled: true,
            comment: props.comment,
            defaultRootObject: 'index.html',
            certificate: props.certificate,
            domainNames: [props.domainName],
            minimumProtocolVersion: cloudfront.SecurityPolicyProtocol.TLS_V1_2_2021,
            sslSupportMethod: cloudfront.SSLMethod.SNI,
            httpVersion: cloudfront.HttpVersion.HTTP2_AND_3,
            // webAclId: props.wafAclId,
            logBucket: props.accessLogBucket,
            logFilePrefix: props.accessLogBucket ? `${props.domainName}/` : undefined,
            defaultBehavior: {
                allowedMethods: cloudfront.AllowedMethods.ALLOW_GET_HEAD_OPTIONS,
                cachedMethods: cloudfront.CachedMethods.CACHE_GET_HEAD_OPTIONS,
                cachePolicy: cloudfront.CachePolicy.CACHING_OPTIMIZED,
                compress: true,
                viewerProtocolPolicy: cloudfront.ViewerProtocolPolicy.HTTPS_ONLY,
                origin: (() => {
                    switch (props.s3OriginAccessType) {
                        case S3OriginAccessType.ORIGIN_ACCESS_IDENTITY:
                            return new origins.S3Origin(props.originBucket, {
                                originAccessIdentity: props.originAccessIdentity,
                            });
                        case S3OriginAccessType.ORIGIN_ACCESS_CONTROL:
                            return new origins.S3Origin(props.originBucket);
                    }
                })(),
                responseHeadersPolicy: new cloudfront.ResponseHeadersPolicy(scope, 'ResponseHeadersPolicy', {
                    //responseHeadersPolicyName: ,
                    comment: 'A default policy',
                    securityHeadersBehavior: {
                        //contentSecurityPolicy: { contentSecurityPolicy: 'default-src https:;', override: true },
                        contentTypeOptions: { override: true },
                        frameOptions: {
                            frameOption: cloudfront.HeadersFrameOption.SAMEORIGIN,
                            override: true,
                        },
                        referrerPolicy: {
                            referrerPolicy: cloudfront.HeadersReferrerPolicy.STRICT_ORIGIN_WHEN_CROSS_ORIGIN,
                            override: true,
                        },
                        strictTransportSecurity: {
                            accessControlMaxAge: cdk.Duration.seconds(31536000), // 1 year
                            preload: true,
                            includeSubdomains: true,
                            override: true,
                        },
                        xssProtection: {
                            protection: true,
                            modeBlock: true,
                            override: true,
                        },
                    },
                    customHeadersBehavior: {
                        customHeaders: [
                            {
                                header: 'Cache-Control',
                                value: 'no-cache, no-store, private',
                                override: true,
                            },
                            {
                                header: 'pragma',
                                value: 'no-cache',
                                override: true,
                            },
                        ],
                    },
                }),
            },
            errorResponses: [
                {
                    ttl: cdk.Duration.seconds(300),
                    httpStatus: 403,
                    responseHttpStatus: 200,
                    responsePagePath: '/index.html',
                },
                {
                    ttl: cdk.Duration.seconds(300),
                    httpStatus: 404,
                    responseHttpStatus: 200,
                    responsePagePath: '/index.html',
                },
            ],
            priceClass: cloudfront.PriceClass.PRICE_CLASS_ALL,
        });
        if (props.s3OriginAccessType === S3OriginAccessType.ORIGIN_ACCESS_CONTROL) {
            const cfnDistribution = this.node.defaultChild;
            cfnDistribution.addPropertyOverride('DistributionConfig.Origins.0.OriginAccessControlId', props.originAccessControlId);
            cfnDistribution.addPropertyOverride('DistributionConfig.Origins.0.DomainName', props.originBucket.bucketRegionalDomainName);
            cfnDistribution.addOverride('Properties.DistributionConfig.Origins.0.S3OriginConfig.OriginAccessIdentity', '');
            cfnDistribution.addPropertyDeletionOverride('DistributionConfig.Origins.0.CustomOriginConfig');
        }
    }
}
exports.SecureFrontendWebAppCloudFrontDistribution = SecureFrontendWebAppCloudFrontDistribution;
_a = JSII_RTTI_SYMBOL_1;
SecureFrontendWebAppCloudFrontDistribution[_a] = { fqn: "@gammarers/aws-secure-frontend-web-app-cloudfront-distribution.SecureFrontendWebAppCloudFrontDistribution", version: "1.4.17" };
//# sourceMappingURL=data:application/json;base64,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