# -*- coding: utf-8 -*-
# Generated by Django 1.11.1 on 2017-12-16 19:48
from __future__ import unicode_literals

from django.db import migrations, models
import django.db.models.deletion
import django.db.models.manager
import django.utils.timezone
import model_utils.fields


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('contacts', '0001_initial'),
        ('organizations', '0002_model_update'),
    ]

    operations = [
        migrations.CreateModel(
            name='Campaign',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('is_removed', models.BooleanField(default=False)),
                ('name', models.CharField(max_length=200)),
                ('start_date', models.DateTimeField()),
                ('message', models.TextField(max_length=200)),
                ('contacts_group', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='contacts.ContactsGroup')),
                ('organization', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='organizations.Organization')),
            ],
            managers=[
                ('all', django.db.models.manager.Manager()),
            ],
        ),
        migrations.CreateModel(
            name='Notification',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('is_removed', models.BooleanField(default=False)),
                ('status', models.SmallIntegerField(choices=[(None, ''), (-1, 'Failed'), (0, 'Progress'), (1, 'Sent')], default=None, null=True)),
                ('send_date', models.DateTimeField(blank=True, null=True)),
                ('campaign', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='notifications', to='campaigns.Campaign')),
                ('contact', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='contacts.Contact')),
                ('contacts_group', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='contacts.ContactsGroup')),
                ('organization', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='organizations.Organization')),
            ],
            options={
                'ordering': ['status'],
            },
            managers=[
                ('all', django.db.models.manager.Manager()),
            ],
        ),
        migrations.AlterUniqueTogether(
            name='notification',
            unique_together=set([('campaign', 'contacts_group', 'contact')]),
        ),
        migrations.AlterUniqueTogether(
            name='campaign',
            unique_together=set([('organization', 'name')]),
        ),
    ]
