# coding: utf-8
"""
Django settings for djotali project.

Generated by 'django-admin startproject' using Django 1.11.

For more information on this file, see
https://docs.djangoproject.com/en/1.11/topics/settings/

For the full list of settings and their values, see
https://docs.djangoproject.com/en/1.11/ref/settings/
"""

import os
import sys

import dj_database_url
import dotenv
from decouple import config
from django.contrib.messages import constants as message_constants

# Load .env if it exists
dotenv_path = dotenv.find_dotenv()
if dotenv_path != '':
    dotenv.load_dotenv(dotenv_path)

BASE_DIR = os.path.dirname(os.path.dirname(os.path.dirname(os.path.abspath(__file__))))

TESTING = len(sys.argv) > 1 and sys.argv[1] == 'test'

# Quick-start development settings - unsuitable for production
# See https://docs.djangoproject.com/en/1.11/howto/deployment/checklist/

# SECURITY WARNING: keep the secret key used in production secret!
SECRET_KEY = config('SECRET_KEY', default='vumrpne5wvp499q632@#s+ik*0vh^(&il!+9&0m0s7c*mhcd1^')

# Application definition

INSTALLED_APPS = [
    'django.contrib.admin',
    'django.contrib.auth',
    'django.contrib.contenttypes',
    'django.contrib.sessions',
    'django.contrib.messages',
    'django.contrib.staticfiles',
    'django.contrib.sites',

    # 3rd Party
    'compressor',
    'rest_framework',
    'allauth',
    'allauth.account',
    'allauth.socialaccount',
    'django_extensions',
    'organizations',
    'compat',
    'hijack',
    'django_celery_beat',

    # apps
    'djotali.core',
    'djotali.dashboard',
    'djotali.contacts',
    'djotali.campaigns',
    'djotali.profile',
    'djotali.billing',

]

MIDDLEWARE = [
    'django.middleware.security.SecurityMiddleware',
    'django.contrib.sessions.middleware.SessionMiddleware',
    'django.middleware.common.CommonMiddleware',
    'django.middleware.csrf.CsrfViewMiddleware',
    'django.contrib.auth.middleware.AuthenticationMiddleware',
    'django.contrib.messages.middleware.MessageMiddleware',
    'django.middleware.clickjacking.XFrameOptionsMiddleware',
    'djotali.profile.middleware.OrganizationMiddleware',
    'djotali.billing.middleware.CreditMiddleware',
]

ROOT_URLCONF = 'djotali.urls'

TEMPLATES = [
    {
        'BACKEND': 'django.template.backends.django.DjangoTemplates',
        'DIRS': [os.path.join(BASE_DIR, 'djotali', 'templates')],
        'APP_DIRS': True,
        'OPTIONS': {
            'context_processors': [
                'django.template.context_processors.debug',
                'django.template.context_processors.request',
                'django.contrib.auth.context_processors.auth',
                'django.contrib.messages.context_processors.messages',
                'djotali.core.context_processors.settings_context_processor',
                'djotali.profile.context_processors.profile_context_processor',
            ],
        },
    },
]

SESSION_ENGINE = 'django.contrib.sessions.backends.cached_db'
# WARN Change if session goes into cookies instead of db https://docs.djangoproject.com/fr/1.11/topics/http/sessions/#using-cookie-based-sessions
SESSION_SERIALIZER = 'django.contrib.sessions.serializers.PickleSerializer'

WSGI_APPLICATION = 'djotali.wsgi.application'

MESSAGE_TAGS = {
    message_constants.DEBUG: 'alert-info',
    message_constants.INFO: 'alert-info',
    message_constants.SUCCESS: 'alert-success',
    message_constants.WARNING: 'alert-warning',
    message_constants.ERROR: 'alert-danger',
}
# Database
# https://docs.djangoproject.com/en/1.11/ref/settings/#databases

DB_URL = config('DB_URL', default='mysql://root:root@127.0.0.1:3306/djotali')

DATABASES = {
    'default': dj_database_url.config(default=DB_URL, conn_max_age=600)
}

# Password validation
# https://docs.djangoproject.com/en/1.11/ref/settings/#auth-password-validators

AUTH_PASSWORD_VALIDATORS = [
    {
        'NAME': 'django.contrib.auth.password_validation.UserAttributeSimilarityValidator',
    },
    {
        'NAME': 'django.contrib.auth.password_validation.MinimumLengthValidator',
    },
    {
        'NAME': 'django.contrib.auth.password_validation.CommonPasswordValidator',
    },
    {
        'NAME': 'django.contrib.auth.password_validation.NumericPasswordValidator',
    },
]

# Internationalization
# https://docs.djangoproject.com/en/1.11/topics/i18n/

LANGUAGE_CODE = 'fr-fr'

TIME_ZONE = 'UTC'

USE_I18N = True

USE_L10N = True

USE_TZ = True

# Static files (CSS, JavaScript, Images)
# https://docs.djangoproject.com/en/1.11/howto/static-files/

STATIC_URL = '/static/'

STATICFILES_DIRS = [
    os.path.join(BASE_DIR, 'djotali/static')
]
STATIC_ROOT = os.path.join(BASE_DIR, 'static')

MEDIA_ROOT = os.path.join(BASE_DIR, 'storage')

# CELERY Config
CELERY_ACCEPT_CONTENT = ['json']
CELERY_TASK_SERIALIZER = 'json'
CELERY_RESULT_SERIALIZER = 'json'
CELERY_RESULT_BACKEND = 'db+' + os.getenv('DATABASE_URL', DB_URL)
CELERY_CELERYD_REDIRECT_STDOUTS = False
CELERY_CELERYD_REDIRECT_STDOUTS_LEVEL = 0

BROKER_HOST = config('REDIS_HOST', default='127.0.0.1')
BROKER_PORT = config('REDIS_PORT', default=6379)
CELERY_BROKER_URL = config('CELERY_BROKER_URL', default='redis://{}:{}/0'.format(BROKER_HOST, BROKER_PORT))

REST_FRAMEWORK = {
    'DEFAULT_AUTHENTICATION_CLASSES': (
        'rest_framework_jwt.authentication.JSONWebTokenAuthentication',
        'rest_framework.authentication.SessionAuthentication',
        'rest_framework.authentication.BasicAuthentication',
    ),
    'DEFAULT_PERMISSION_CLASSES': [
        'rest_framework.permissions.IsAuthenticated',
    ],
    'PAGE_SIZE': 5
}

SITE_ID = 1
SITE_NAME = os.getenv('SERVER_NAME', 'app.djotali.com')

LOGIN_REDIRECT_URL = '/dashboard'
ACCOUNT_LOGOUT_REDIRECT_URL = '/accounts/login'
ACCOUNT_SIGNUP_PASSWORD_ENTER_TWICE = False
ACCOUNT_SIGNUP_FORM_CLASS = 'djotali.profile.forms.SignupWithOrganizationForm'
ACCOUNT_LOGIN_ON_PASSWORD_RESET = True
ACCOUNT_EMAIL_CONFIRMATION_ANONYMOUS_REDIRECT_URL = '/'
ACCOUNT_EMAIL_CONFIRMATION_AUTHENTICATED_REDIRECT_URL = '/'

EMAIL_BACKEND = 'django.core.mail.backends.console.EmailBackend'
HIJACK_LOGIN_REDIRECT_URL = '/'  # Where admins are redirected to after hijacking a user
HIJACK_LOGOUT_REDIRECT_URL = '/admin'  # Where admins are redirected to after releasing a user

# Custom settings

# SMS Related
MESSAGEBIRD_TOKEN = config('MESSAGEBIRD_TOKEN', default=None)
CONSOLE_SMS_MAX_TIMEOUT = 10
CONSOLE_SMS_MIN_TIMEOUT = 1

# Change in production!
INVITATION_SIGNING_KEY = config('INVITATION_SIGNING_KEY', default='&>HELwy5c*x}HrKH;ZxGuAv,/GLPaM-vgeJpHj!}q6>s8<2vyz')
INVITATION_TIMEOUT_DAYS = 30

DEFAULT_CURRENCY = 'XOF'

VUE_LIB = 'https://cdnjs.cloudflare.com/ajax/libs/vue/2.3.4/vue.min.js'
VUEX_LIB = 'https://cdnjs.cloudflare.com/ajax/libs/vuex/2.3.1/vuex.min.js'
AXIOS_LIB = 'https://cdnjs.cloudflare.com/ajax/libs/axios/0.16.2/axios.min.js'
