from seed.models.bussiness import Bussiness
from seed.models.role import Role
from seed.models.menu import Menu
from seed.models.rolemenu import RoleMenu
from seed.models.panels import Panels
from seed.models.filters import Filters
from seed.models.databases import Databases
from seed.models._base import session

from flask import current_app, g


def is_new_databases():
    if session.query(Panels).first():
        return False

    if session.query(Filters).first():
        return False

    return True


def init_analogdata():
    sql = """
        insert into analogdata_dimensions
        (game_id, game_name, platform_id, platform_name, version_id, version_name)
        VALUES
        (1,'斗地主', 1, '北京', 1, 'PC'),
        (1,'斗地主', 1, '北京', 2, 'Android'),
        (1,'斗地主', 1, '北京', 3, 'IOS'),
        (1,'斗地主', 2, '广东', 1, 'PC'),
        (1,'斗地主', 2, '广东', 2, 'Android'),
        (1,'斗地主', 2, '广东', 3, 'IOS'),
        (1,'斗地主', 3, '四川', 1, 'PC'),
        (1,'斗地主', 3, '四川', 2, 'Android'),
        (1,'斗地主', 3, '四川', 3, 'IOS'),
        (2,'德州扑克', 1, '北京', 1, 'PC'),
        (2,'德州扑克', 1, '北京', 2, 'Android'),
        (2,'德州扑克', 1, '北京', 3, 'IOS'),
        (2,'德州扑克', 2, '广东', 1, 'PC'),
        (2,'德州扑克', 2, '广东', 2, 'Android'),
        (2,'德州扑克', 2, '广东', 3, 'IOS'),
        (2,'德州扑克', 3, '四川', 1, 'PC'),
        (2,'德州扑克', 3, '四川', 2, 'Android'),
        (2,'德州扑克', 3, '四川', 3, 'IOS'),
        (3,'四国军棋', 1, '北京', 1, 'PC'),
        (3,'四国军棋', 1, '北京', 2, 'Android'),
        (3,'四国军棋', 1, '北京', 3, 'IOS'),
        (3,'四国军棋', 2, '广东', 1, 'PC'),
        (3,'四国军棋', 2, '广东', 2, 'Android'),
        (3,'四国军棋', 2, '广东', 3, 'IOS'),
        (3,'四国军棋', 3, '四川', 1, 'PC'),
        (3,'四国军棋', 3, '四川', 2, 'Android'),
        (3,'四国军棋', 3, '四川', 3, 'IOS');

    """
    session.execute(sql)

    sql = """
        insert into analogdata_gamedatas
        (fdate, game_id, platform_id, version_id, factucnt, fregucnt, fpayucnt, fincome)
        values ('2010/10/1', 1, 1, 1,  3517, 1238, 76, 1544.583171),
        ('2010/10/1', 1, 1, 2,  3906, 1894, 102, 501.8143992),
        ('2010/10/1', 1, 1, 3,  1641, 1299, 173, 511.4530204),
        ('2010/10/1', 1, 2, 1,  3852, 1125, 91, 627.649184),
        ('2010/10/1', 1, 2, 2,  293, 354, 116, 1580.034723),
        ('2010/10/1', 1, 2, 3,  912, 1258, 120, 521.0781578),
        ('2010/10/1', 1, 3, 1,  1504, 1809, 177, 421.1933997),
        ('2010/10/1', 1, 3, 2,  950, 685, 84, 132.6647156),
        ('2010/10/1', 1, 3, 3,  1942, 922, 188, 1558.818233),
        ('2010/10/1', 2, 1, 1,  2541, 1323, 146, 461.853575),
        ('2010/10/1', 2, 1, 2,  1367, 1673, 72, 552.8812972),
        ('2010/10/1', 2, 1, 3,  773, 1492, 148, 118.8945375),
        ('2010/10/1', 2, 2, 1,  2798, 158, 107, 1701.958186),
        ('2010/10/1', 2, 2, 2,  1042, 131, 77, 686.9671485),
        ('2010/10/1', 2, 2, 3,  574, 39, 72, 425.1627938),
        ('2010/10/1', 2, 3, 1,  2891, 1892, 182, 563.8005411),
        ('2010/10/1', 2, 3, 2,  339, 1909, 31, 1766.646763),
        ('2010/10/1', 2, 3, 3,  861, 1026, 132, 794.9009483),
        ('2010/10/1', 3, 1, 1,  615, 350, 94, 1844.447407),
        ('2010/10/1', 3, 1, 2,  2841, 603, 89, 991.8886101),
        ('2010/10/1', 3, 1, 3,  1088, 1845, 12, 62.13154766),
        ('2010/10/1', 3, 2, 1,  1782, 425, 86, 610.209719),
        ('2010/10/1', 3, 2, 2,  401, 504, 148, 1126.993035),
        ('2010/10/1', 3, 2, 3,  744, 774, 152, 816.7608816),
        ('2010/10/1', 3, 3, 1,  87, 771, 133, 1021.256408),
        ('2010/10/1', 3, 3, 2,  2888, 1846, 52, 1737.952722),
        ('2010/10/1', 3, 3, 3,  2582, 36, 16, 804.5053499),
        ('2010/10/2', 1, 1, 1,  3368, 1111, 111, 1916.765861),
        ('2010/10/2', 1, 1, 2,  1001, 1016, 187, 844.8430684),
        ('2010/10/2', 1, 1, 3,  533, 1127, 30, 1533.87283),
        ('2010/10/2', 1, 2, 1,  3869, 1004, 105, 551.1391953),
        ('2010/10/2', 1, 2, 2,  1241, 1054, 66, 1487.989407),
        ('2010/10/2', 1, 2, 3,  1928, 591, 132, 1295.211785),
        ('2010/10/2', 1, 3, 1,  1112, 835, 125, 739.0700778),
        ('2010/10/2', 1, 3, 2,  126, 404, 139, 1884.812572),
        ('2010/10/2', 1, 3, 3,  1945, 96, 7, 1453.742487),
        ('2010/10/2', 2, 1, 1,  3563, 73, 198, 187.3296855),
        ('2010/10/2', 2, 1, 2,  218, 149, 33, 1360.160016),
        ('2010/10/2', 2, 1, 3,  3658, 1580, 162, 755.7374809),
        ('2010/10/2', 2, 2, 1,  3049, 238, 12, 652.5243926),
        ('2010/10/2', 2, 2, 2,  343, 1424, 31, 1304.229077),
        ('2010/10/2', 2, 2, 3,  3166, 811, 196, 1831.061833),
        ('2010/10/2', 2, 3, 1,  1579, 1188, 88, 1208.444511),
        ('2010/10/2', 2, 3, 2,  3370, 858, 132, 1745.970867),
        ('2010/10/2', 2, 3, 3,  2136, 533, 111, 45.59693162),
        ('2010/10/2', 3, 1, 1,  384, 595, 121, 722.1768001),
        ('2010/10/2', 3, 1, 2,  189, 622, 49, 709.0769211),
        ('2010/10/2', 3, 1, 3,  1010, 612, 181, 777.4758941),
        ('2010/10/2', 3, 2, 1,  3932, 459, 68, 944.9215389),
        ('2010/10/2', 3, 2, 2,  1688, 1286, 170, 1179.626028),
        ('2010/10/2', 3, 2, 3,  815, 653, 192, 1813.644208),
        ('2010/10/2', 3, 3, 1,  1994, 1280, 5, 336.5597391),
        ('2010/10/2', 3, 3, 2,  3476, 610, 83, 1800.056721),
        ('2010/10/2', 3, 3, 3,  2139, 712, 182, 1117.059597),
        ('2010/10/3', 1, 1, 1,  3528, 74, 173, 1203.99203),
        ('2010/10/3', 1, 1, 2,  655, 1031, 151, 952.4970464),
        ('2010/10/3', 1, 1, 3,  636, 1714, 28, 461.7477343),
        ('2010/10/3', 1, 2, 1,  3468, 5, 64, 1548.296249),
        ('2010/10/3', 1, 2, 2,  2360, 1082, 97, 1263.318734),
        ('2010/10/3', 1, 2, 3,  397, 35, 48, 720.2217209),
        ('2010/10/3', 1, 3, 1,  937, 809, 135, 1463.847264),
        ('2010/10/3', 1, 3, 2,  1091, 635, 89, 95.89328215),
        ('2010/10/3', 1, 3, 3,  1680, 937, 95, 1296.854456),
        ('2010/10/3', 2, 1, 1,  3984, 458, 184, 1587.488429),
        ('2010/10/3', 2, 1, 2,  3110, 1425, 96, 590.0244428),
        ('2010/10/3', 2, 1, 3,  3766, 1877, 167, 174.5445534),
        ('2010/10/3', 2, 2, 1,  1948, 521, 48, 1956.006211),
        ('2010/10/3', 2, 2, 2,  1256, 1168, 159, 699.6759713),
        ('2010/10/3', 2, 2, 3,  1141, 554, 131, 1002.591501),
        ('2010/10/3', 2, 3, 1,  205, 558, 4, 1256.487683),
        ('2010/10/3', 2, 3, 2,  558, 1669, 18, 705.7151021),
        ('2010/10/3', 2, 3, 3,  261, 1556, 72, 1970.916415),
        ('2010/10/3', 3, 1, 1,  1914, 1698, 187, 128.202628),
        ('2010/10/3', 3, 1, 2,  742, 1725, 187, 53.47206634),
        ('2010/10/3', 3, 1, 3,  2768, 1853, 22, 218.7842182),
        ('2010/10/3', 3, 2, 1,  570, 668, 175, 825.1048929),
        ('2010/10/3', 3, 2, 2,  314, 342, 69, 506.1233115),
        ('2010/10/3', 3, 2, 3,  1577, 76, 99, 69.82709588),
        ('2010/10/3', 3, 3, 1,  2206, 1351, 160, 123.1352996),
        ('2010/10/3', 3, 3, 2,  3336, 1029, 127, 1254.030499),
        ('2010/10/3', 3, 3, 3,  2122, 1997, 136, 1001.708678),
        ('2010/10/4', 1, 1, 1,  1161, 212, 8, 1712.278109),
        ('2010/10/4', 1, 1, 2,  2883, 1108, 135, 264.6216236),
        ('2010/10/4', 1, 1, 3,  3305, 1172, 17, 3.603404972),
        ('2010/10/4', 1, 2, 1,  1791, 676, 190, 1153.559275),
        ('2010/10/4', 1, 2, 2,  1601, 1829, 98, 483.809121),
        ('2010/10/4', 1, 2, 3,  2639, 246, 9, 954.1461912),
        ('2010/10/4', 1, 3, 1,  1802, 1514, 152, 47.74153739),
        ('2010/10/4', 1, 3, 2,  2549, 675, 137, 1649.384309),
        ('2010/10/4', 1, 3, 3,  3103, 1783, 196, 1009.23577),
        ('2010/10/4', 2, 1, 1,  3944, 734, 84, 1407.675219),
        ('2010/10/4', 2, 1, 2,  3229, 636, 160, 805.280163),
        ('2010/10/4', 2, 1, 3,  1725, 508, 42, 149.693279),
        ('2010/10/4', 2, 2, 1,  3335, 904, 129, 519.4361562),
        ('2010/10/4', 2, 2, 2,  2718, 402, 27, 821.3040786),
        ('2010/10/4', 2, 2, 3,  2449, 1704, 164, 1851.075327),
        ('2010/10/4', 2, 3, 1,  3413, 320, 24, 147.4309023),
        ('2010/10/4', 2, 3, 2,  1898, 1033, 183, 1880.264265),
        ('2010/10/4', 2, 3, 3,  2000, 1197, 17, 1599.105787),
        ('2010/10/4', 3, 1, 1,  353, 491, 10, 1577.820526),
        ('2010/10/4', 3, 1, 2,  2531, 287, 199, 340.9140812),
        ('2010/10/4', 3, 1, 3,  1398, 89, 90, 1228.893277),
        ('2010/10/4', 3, 2, 1,  1326, 811, 13, 566.5390641),
        ('2010/10/4', 3, 2, 2,  3134, 1977, 154, 721.8719815),
        ('2010/10/4', 3, 2, 3,  587, 472, 197, 962.1384129),
        ('2010/10/4', 3, 3, 1,  2050, 152, 130, 1656.566032),
        ('2010/10/4', 3, 3, 2,  3159, 578, 192, 833.1682637),
        ('2010/10/4', 3, 3, 3,  1235, 1695, 139, 1816.382134),
        ('2010/10/5', 1, 1, 1,  3859, 1575, 137, 1150.413667),
        ('2010/10/5', 1, 1, 2,  3718, 1198, 97, 1031.027548),
        ('2010/10/5', 1, 1, 3,  2281, 1993, 199, 44.98144431),
        ('2010/10/5', 1, 2, 1,  3431, 437, 62, 52.64219431),
        ('2010/10/5', 1, 2, 2,  1579, 948, 145, 1352.467561),
        ('2010/10/5', 1, 2, 3,  678, 1714, 61, 217.6215096),
        ('2010/10/5', 1, 3, 1,  495, 1929, 148, 1784.935473),
        ('2010/10/5', 1, 3, 2,  598, 743, 14, 1014.200484),
        ('2010/10/5', 1, 3, 3,  1298, 1263, 187, 319.3128556),
        ('2010/10/5', 2, 1, 1,  3684, 301, 100, 599.6438135),
        ('2010/10/5', 2, 1, 2,  2593, 1351, 94, 897.1990512),
        ('2010/10/5', 2, 1, 3,  2577, 767, 150, 1771.75673),
        ('2010/10/5', 2, 2, 1,  2202, 685, 131, 1428.957621),
        ('2010/10/5', 2, 2, 2,  2917, 177, 62, 1470.162441),
        ('2010/10/5', 2, 2, 3,  2177, 255, 31, 1580.440915),
        ('2010/10/5', 2, 3, 1,  2066, 1456, 107, 626.1927701),
        ('2010/10/5', 2, 3, 2,  1516, 1060, 21, 1477.179419),
        ('2010/10/5', 2, 3, 3,  3152, 1626, 75, 1365.73783),
        ('2010/10/5', 3, 1, 1,  2179, 1905, 64, 655.8639932),
        ('2010/10/5', 3, 1, 2,  626, 1532, 74, 1476.47364),
        ('2010/10/5', 3, 1, 3,  196, 1625, 5, 1551.59615),
        ('2010/10/5', 3, 2, 1,  3692, 1461, 133, 1748.973097),
        ('2010/10/5', 3, 2, 2,  1907, 165, 194, 1783.673137),
        ('2010/10/5', 3, 2, 3,  3441, 1419, 19, 1459.416986),
        ('2010/10/5', 3, 3, 1,  3369, 801, 88, 1586.199657),
        ('2010/10/5', 3, 3, 2,  1124, 792, 106, 1979.559076),
        ('2010/10/5', 3, 3, 3,  955, 746, 172, 617.6427426),
        ('2010/10/6', 1, 1, 1,  3128, 790, 186, 1156.002039),
        ('2010/10/6', 1, 1, 2,  3341, 153, 139, 155.6379873),
        ('2010/10/6', 1, 1, 3,  2516, 684, 174, 1680.745832),
        ('2010/10/6', 1, 2, 1,  1105, 1709, 144, 1926.258474),
        ('2010/10/6', 1, 2, 2,  1629, 533, 100, 302.6362451),
        ('2010/10/6', 1, 2, 3,  418, 1389, 110, 1436.165774),
        ('2010/10/6', 1, 3, 1,  3790, 344, 136, 1965.458104),
        ('2010/10/6', 1, 3, 2,  3107, 566, 102, 177.6956296),
        ('2010/10/6', 1, 3, 3,  841, 1324, 115, 1109.902891),
        ('2010/10/6', 2, 1, 1,  90, 1396, 21, 179.1697745),
        ('2010/10/6', 2, 1, 2,  3232, 1436, 129, 283.9521291),
        ('2010/10/6', 2, 1, 3,  1850, 64, 159, 1759.018688),
        ('2010/10/6', 2, 2, 1,  2220, 1379, 46, 1505.687023),
        ('2010/10/6', 2, 2, 2,  1430, 1397, 137, 1505.945284),
        ('2010/10/6', 2, 2, 3,  31, 1610, 140, 1773.638481),
        ('2010/10/6', 2, 3, 1,  2935, 944, 143, 1096.206374),
        ('2010/10/6', 2, 3, 2,  2746, 149, 42, 1968.45008),
        ('2010/10/6', 2, 3, 3,  74, 442, 53, 561.5680078),
        ('2010/10/6', 3, 1, 1,  0, 1579, 126, 742.6638183),
        ('2010/10/6', 3, 1, 2,  793, 743, 67, 3.810487505),
        ('2010/10/6', 3, 1, 3,  3868, 896, 167, 1915.116742),
        ('2010/10/6', 3, 2, 1,  2536, 1024, 83, 1453.794585),
        ('2010/10/6', 3, 2, 2,  177, 905, 50, 1739.566804),
        ('2010/10/6', 3, 2, 3,  2463, 44, 166, 1863.474631),
        ('2010/10/6', 3, 3, 1,  976, 1505, 39, 762.7264864),
        ('2010/10/6', 3, 3, 2,  259, 83, 184, 358.9650338),
        ('2010/10/6', 3, 3, 3,  2184, 1593, 73, 223.3142757),
        ('2010/10/7', 1, 1, 1,  2182, 712, 29, 1745.978712),
        ('2010/10/7', 1, 1, 2,  3513, 828, 167, 817.441096),
        ('2010/10/7', 1, 1, 3,  2483, 921, 130, 974.8343697),
        ('2010/10/7', 1, 2, 1,  2766, 512, 45, 646.4832591),
        ('2010/10/7', 1, 2, 2,  2206, 750, 132, 1977.569612),
        ('2010/10/7', 1, 2, 3,  1134, 132, 6, 22.69032482),
        ('2010/10/7', 1, 3, 1,  165, 1938, 128, 150.992916),
        ('2010/10/7', 1, 3, 2,  1962, 1557, 10, 1754.658907),
        ('2010/10/7', 1, 3, 3,  3015, 1751, 6, 313.3061262),
        ('2010/10/7', 2, 1, 1,  1519, 700, 115, 312.9356498),
        ('2010/10/7', 2, 1, 2,  1662, 949, 187, 1267.121552),
        ('2010/10/7', 2, 1, 3,  3024, 748, 189, 1777.834094),
        ('2010/10/7', 2, 2, 1,  2335, 1625, 150, 915.4248814),
        ('2010/10/7', 2, 2, 2,  388, 1524, 168, 1036.24703),
        ('2010/10/7', 2, 2, 3,  2847, 504, 5, 165.5439921),
        ('2010/10/7', 2, 3, 1,  473, 1382, 177, 815.1611824),
        ('2010/10/7', 2, 3, 2,  3105, 432, 41, 1033.507995),
        ('2010/10/7', 2, 3, 3,  1120, 1951, 138, 392.570251),
        ('2010/10/7', 3, 1, 1,  2427, 531, 104, 886.3219644),
        ('2010/10/7', 3, 1, 2,  2604, 903, 126, 1482.793981),
        ('2010/10/7', 3, 1, 3,  1780, 939, 27, 58.5110859),
        ('2010/10/7', 3, 2, 1,  624, 1902, 193, 619.6596574),
        ('2010/10/7', 3, 2, 2,  2067, 1752, 88, 1492.819601),
        ('2010/10/7', 3, 2, 3,  2064, 1481, 85, 1713.026504),
        ('2010/10/7', 3, 3, 1,  1975, 1622, 130, 33.72261196),
        ('2010/10/7', 3, 3, 2,  3037, 244, 162, 282.8109935),
        ('2010/10/7', 3, 3, 3,  3338, 1133, 28, 1986.518171),
        ('2010/10/8', 1, 1, 1,  1353, 1509, 6, 1236.446301),
        ('2010/10/8', 1, 1, 2,  3565, 962, 167, 1131.820036),
        ('2010/10/8', 1, 1, 3,  1311, 1145, 127, 1342.822955),
        ('2010/10/8', 1, 2, 1,  1519, 604, 114, 1660.762734),
        ('2010/10/8', 1, 2, 2,  1543, 818, 140, 1631.890879),
        ('2010/10/8', 1, 2, 3,  3596, 1589, 118, 1410.692005),
        ('2010/10/8', 1, 3, 1,  2967, 1707, 115, 189.883407),
        ('2010/10/8', 1, 3, 2,  3550, 129, 55, 816.2029026),
        ('2010/10/8', 1, 3, 3,  3624, 206, 59, 807.7045897),
        ('2010/10/8', 2, 1, 1,  3563, 1128, 111, 685.3187149),
        ('2010/10/8', 2, 1, 2,  936, 1740, 146, 1661.534693),
        ('2010/10/8', 2, 1, 3,  640, 1147, 178, 843.6185613),
        ('2010/10/8', 2, 2, 1,  3658, 461, 47, 1575.484639),
        ('2010/10/8', 2, 2, 2,  875, 1223, 103, 75.15500584),
        ('2010/10/8', 2, 2, 3,  2425, 417, 98, 142.676487),
        ('2010/10/8', 2, 3, 1,  129, 1342, 5, 809.3231927),
        ('2010/10/8', 2, 3, 2,  1539, 1604, 46, 1566.929771),
        ('2010/10/8', 2, 3, 3,  3801, 1759, 177, 315.7080066),
        ('2010/10/8', 3, 1, 1,  744, 189, 31, 756.2699505),
        ('2010/10/8', 3, 1, 2,  235, 1387, 186, 1123.163985),
        ('2010/10/8', 3, 1, 3,  3823, 707, 193, 183.3620458),
        ('2010/10/8', 3, 2, 1,  1823, 267, 139, 276.8700165),
        ('2010/10/8', 3, 2, 2,  2416, 349, 110, 723.6663314),
        ('2010/10/8', 3, 2, 3,  2604, 1726, 80, 151.1447307),
        ('2010/10/8', 3, 3, 1,  3652, 1548, 154, 1778.193178),
        ('2010/10/8', 3, 3, 2,  2997, 319, 187, 536.1369681),
        ('2010/10/8', 3, 3, 3,  280, 520, 68, 207.2066721),
        ('2010/10/9', 1, 1, 1,  1846, 1864, 2, 584.2823369),
        ('2010/10/9', 1, 1, 2,  1703, 813, 162, 727.3300268),
        ('2010/10/9', 1, 1, 3,  3981, 1694, 164, 1235.456072),
        ('2010/10/9', 1, 2, 1,  84, 1385, 189, 1559.049516),
        ('2010/10/9', 1, 2, 2,  3200, 1370, 81, 985.7140242),
        ('2010/10/9', 1, 2, 3,  250, 821, 130, 1481.8339),
        ('2010/10/9', 1, 3, 1,  2715, 1967, 5, 254.8510765),
        ('2010/10/9', 1, 3, 2,  1060, 697, 36, 1094.35268),
        ('2010/10/9', 1, 3, 3,  2395, 1992, 89, 1804.311432),
        ('2010/10/9', 2, 1, 1,  1774, 1652, 69, 657.2556818),
        ('2010/10/9', 2, 1, 2,  3753, 1411, 73, 1783.225744),
        ('2010/10/9', 2, 1, 3,  3651, 504, 188, 1731.45159),
        ('2010/10/9', 2, 2, 1,  2057, 27, 192, 1297.759365),
        ('2010/10/9', 2, 2, 2,  234, 117, 66, 1956.862237),
        ('2010/10/9', 2, 2, 3,  801, 224, 59, 24.22285199),
        ('2010/10/9', 2, 3, 1,  354, 1142, 32, 228.1867647),
        ('2010/10/9', 2, 3, 2,  3751, 1622, 88, 1350.527414),
        ('2010/10/9', 2, 3, 3,  642, 1034, 66, 1939.370172),
        ('2010/10/9', 3, 1, 1,  1253, 132, 93, 1973.726688),
        ('2010/10/9', 3, 1, 2,  3749, 811, 190, 67.92766258),
        ('2010/10/9', 3, 1, 3,  970, 960, 25, 231.9017937),
        ('2010/10/9', 3, 2, 1,  762, 113, 96, 1680.354816),
        ('2010/10/9', 3, 2, 2,  137, 1116, 91, 1817.732657),
        ('2010/10/9', 3, 2, 3,  1245, 1174, 23, 215.9404164),
        ('2010/10/9', 3, 3, 1,  470, 2000, 75, 909.7427537),
        ('2010/10/9', 3, 3, 2,  1545, 1116, 136, 1964.654155),
        ('2010/10/9', 3, 3, 3,  803, 1907, 27, 218.0660491);
    """
    session.execute(sql)


def init_databases():
    # 创建业务
    bussiness = Bussiness(name='默认业务', description='这是默认业务')
    bussiness.save()

    g.bussiness_id = bussiness.id

    # 创建业务数据库
    database = Databases(
        bussiness_id=bussiness.id,
        dtype='mysql',
        name=current_app.config['DATABASES']['default']['NAME'],
        ip=current_app.config['DATABASES']['default']['HOST'],
        port=current_app.config['DATABASES']['default']['PORT'],
        user=current_app.config['DATABASES']['default']['USER'],
        password=current_app.config['DATABASES']['default']['PASSWORD']
    )
    database.save()

    # 创建角色
    program_role = Role(bussiness_id=bussiness.id, role='开发')
    program_role.save()

    # 创建菜单
    game_play_menu = Menu(bussiness_id=bussiness.id, name='游戏玩家')
    game_play_menu.save()
    act_user_menu = Menu(
        bussiness_id=bussiness.id,
        name='活跃用户分析',
        parent_id=game_play_menu.id
    )
    act_user_menu.save()

    # 创建角色菜单
    RoleMenu(bussiness_id=bussiness.id, role_id=program_role.id, menu_id=game_play_menu.id).save()
    RoleMenu(bussiness_id=bussiness.id, role_id=program_role.id, menu_id=act_user_menu.id).save()

    # 创建全局过滤条件
    Filters(
        bussiness_id=bussiness.id,
        page_id=act_user_menu.id,
        dtype='page',
        stype='multiSelect',
        ename='game_id',
        cname='游戏',
        conditions='"select DISTINCT game_name as label, game_id as value from analogdata_dimensions"',
        condition_type='sql',
        db_source=database.id,
        cascades='{"parent": []}'
    ).save()

    # 创建数据面板
    first_panel = Panels(
        bussiness_id=bussiness.id,
        page_id=act_user_menu.id,
        x=0,
        y=0,
        w=48,
        h=30,
        charttype='line',
        sql='select fdate, sum(fregucnt) dsu, sum(factucnt) dau from analogdata_gamedatas where game_id in  {game_id} and platform_id =  {platform_id}  group by fdate',
        indexs='[{"index": "dsu", "name": "\u65b0\u589e\u7528\u6237\u6570", "rate": false, "show_type": "", "sort": "default", "yAxis": ""}, {"index": "dau", "name": "\u6d3b\u8dc3\u7528\u6237\u6570", "rate": false, "show_type": "", "sort": "default", "yAxis": ""}]',
        dimensions='[{"default": false, "dimension": "fdate", "name": "\u65e5\u671f", "sort": "default"}]',
        db_source=database.id,
        desc='活跃用户数 和 新增用户数的对比',
        name='活跃/新增用户(折线图)',
        sort=0
    ).save()

    # 创建数据面板局部条件
    Filters(
        bussiness_id=bussiness.id,
        page_id=act_user_menu.id,
        dtype='model',
        stype='singleSelect',
        ename='platform_id',
        cname='平台',
        conditions='"select DISTINCT platform_id value, platform_name label from analogdata_dimensions"',
        belong_id=first_panel.id,
        condition_type='sql',
        db_source=database.id,
        cascades='{"parent": []}'
    ).save()

    Panels(
        bussiness_id=bussiness.id,
        page_id=act_user_menu.id,
        x=0,
        y=0,
        w=48,
        h=30,
        charttype='bar_cross',
        sql="""
            select
                game_name,
                    platform_name,
                sum( fregucnt ) dsu,
                sum( factucnt ) dau
            from
                analogdata_gamedatas a
            left join(
                    select
                        DISTINCT game_name,
                        game_id
                    from
                        analogdata_dimensions
                ) b on
                a.game_id = b.game_id
            left join
                (select DISTINCT platform_name, platform_id from analogdata_dimensions) c
                on a.platform_id = c.platform_id
            group by
                game_name,platform_name
        """,
        indexs='[{"index": "dsu", "name": "\u65b0\u589e\u7528\u6237\u6570", "rate": false, "sort": "default"}, {"index": "dau", "name": "\u6d3b\u8dc3\u7528\u6237\u6570", "rate": false, "sort": "default"}]',
        dimensions='[{"default": true, "dimension": "game_name", "name": "\u6e38\u620f", "sort": "default"}, {"default": false, "dimension": "platform_name", "name": "\u5e73\u53f0", "sort": "default"}]',
        db_source=database.id,
        desc='游戏用户对比图',
        name='游戏活跃/新增用户对比(对比图)',
        sort=1
    ).save()

    Panels(
        bussiness_id=bussiness.id,
        page_id=act_user_menu.id,
        x=0,
        y=0,
        w=48,
        h=30,
        charttype='pie',
        sql="""
            select
                game_name,
                platform_name,
                sum( fregucnt ) dsu,
                sum( factucnt ) dau
            from
                analogdata_gamedatas a
            left join(
                    select
                        DISTINCT game_name,
                        game_id
                    from
                        analogdata_dimensions
                ) b on
                a.game_id = b.game_id
            left join
                (select DISTINCT platform_name, platform_id from analogdata_dimensions) c
                on a.platform_id = c.platform_id
            where a.game_id in  {game_id}
            group by
                game_name,platform_name
        """,
        indexs='[{"index": "dsu", "name": "\u65b0\u589e\u7528\u6237\u6570", "rate": false, "sort": "default"}, {"index": "dau", "name": "\u6d3b\u8dc3\u7528\u6237\u6570", "rate": false, "sort": "default"}]',
        dimensions='[{"dimension": "game_name", "name": "\u6e38\u620f\u540d\u79f0", "sort": "default", "default": false}, {"dimension": "platform_name", "name": "\u5e73\u53f0\u540d\u79f0", "sort": "default", "default": true}]',
        db_source=database.id,
        desc='游戏，平台维度下用户分析',
        name='游戏用户分析(饼图)',
        sort=2
    ).save()

    Panels(
        bussiness_id=bussiness.id,
        page_id=act_user_menu.id,
        x=0,
        y=0,
        w=48,
        h=30,
        charttype='linestack',
        sql="""
            select
                fdate,
                platform_name,
                sum( fregucnt ) dsu,
                sum( factucnt ) dau
            from
                analogdata_gamedatas a
            left join
                (select DISTINCT platform_name, platform_id from analogdata_dimensions) b
                on a.platform_id = b.platform_id
            where a.game_id in  {game_id} 
            group by
                fdate, platform_name
        """,
        indexs='[{"index": "dsu", "name": "\u65b0\u589e\u7528\u6237\u6570", "rate": false, "sort": "default"}, {"index": "dau", "name": "\u6d3b\u8dc3\u7528\u6237\u6570", "rate": false, "sort": "default"}]',
        dimensions='[{"default": false, "dimension": "fdate", "name": "\u65e5\u671f", "sort": "default"}, {"default": false, "dimension": "platform_name", "name": "\u5e73\u53f0", "sort": "default"}]',
        db_source=database.id,
        desc='平台维度下活跃/新增用户分析',
        name='平台活跃/新增用户分析(对比趋势图)',
        sort=3
    ).save()
