# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SwitchPortsArgs', 'SwitchPorts']

@pulumi.input_type
class SwitchPortsArgs:
    def __init__(__self__, *,
                 port_id: pulumi.Input[str],
                 serial: pulumi.Input[str],
                 access_policy_number: Optional[pulumi.Input[int]] = None,
                 access_policy_type: Optional[pulumi.Input[str]] = None,
                 adaptive_policy_group_id: Optional[pulumi.Input[str]] = None,
                 allowed_vlans: Optional[pulumi.Input[str]] = None,
                 dai_trusted: Optional[pulumi.Input[bool]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 flexible_stacking_enabled: Optional[pulumi.Input[bool]] = None,
                 isolation_enabled: Optional[pulumi.Input[bool]] = None,
                 link_negotiation: Optional[pulumi.Input[str]] = None,
                 mac_allow_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 peer_sgt_capable: Optional[pulumi.Input[bool]] = None,
                 poe_enabled: Optional[pulumi.Input[bool]] = None,
                 port_schedule_id: Optional[pulumi.Input[str]] = None,
                 profile: Optional[pulumi.Input['SwitchPortsProfileArgs']] = None,
                 rstp_enabled: Optional[pulumi.Input[bool]] = None,
                 sticky_mac_allow_list_limit: Optional[pulumi.Input[int]] = None,
                 sticky_mac_allow_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 storm_control_enabled: Optional[pulumi.Input[bool]] = None,
                 stp_guard: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 udld: Optional[pulumi.Input[str]] = None,
                 vlan: Optional[pulumi.Input[int]] = None,
                 voice_vlan: Optional[pulumi.Input[int]] = None):
        """
        The set of arguments for constructing a SwitchPorts resource.
        :param pulumi.Input[str] port_id: The identifier of the switch port.
        :param pulumi.Input[str] serial: serial path parameter.
        :param pulumi.Input[int] access_policy_number: The number of a custom access policy to configure on the switch port. Only applicable when 'accessPolicyType' is 'Custom access policy'.
        :param pulumi.Input[str] access_policy_type: The type of the access policy of the switch port. Only applicable to access ports. Can be one of 'Open', 'Custom access policy', 'MAC allow list' or 'Sticky MAC allow list'.
        :param pulumi.Input[str] adaptive_policy_group_id: The adaptive policy group ID that will be used to tag traffic through this switch port. This ID must pre-exist during the configuration, else needs to be created using adaptivePolicy/groups API. Cannot be applied to a port on a switch bound to profile.
        :param pulumi.Input[str] allowed_vlans: The VLANs allowed on the switch port. Only applicable to trunk ports.
        :param pulumi.Input[bool] dai_trusted: If true, ARP packets for this port will be considered trusted, and Dynamic ARP Inspection will allow the traffic.
        :param pulumi.Input[bool] enabled: The status of the switch port.
        :param pulumi.Input[bool] flexible_stacking_enabled: For supported switches (e.g. MS420/MS425), whether or not the port has flexible stacking enabled.
        :param pulumi.Input[bool] isolation_enabled: The isolation status of the switch port.
        :param pulumi.Input[str] link_negotiation: The link speed for the switch port.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] mac_allow_lists: Only devices with MAC addresses specified in this list will have access to this port. Up to 20 MAC addresses can be defined. Only applicable when 'accessPolicyType' is 'MAC allow list'.
        :param pulumi.Input[str] name: The name of the switch port.
        :param pulumi.Input[bool] peer_sgt_capable: If true, Peer SGT is enabled for traffic through this switch port. Applicable to trunk port only, not access port. Cannot be applied to a port on a switch bound to profile.
        :param pulumi.Input[bool] poe_enabled: The PoE status of the switch port.
        :param pulumi.Input[str] port_schedule_id: The ID of the port schedule. A value of null will clear the port schedule.
        :param pulumi.Input['SwitchPortsProfileArgs'] profile: Profile attributes
        :param pulumi.Input[bool] rstp_enabled: The rapid spanning tree protocol status.
        :param pulumi.Input[int] sticky_mac_allow_list_limit: The maximum number of MAC addresses for sticky MAC allow list. Only applicable when 'accessPolicyType' is 'Sticky MAC allow list'.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] sticky_mac_allow_lists: The initial list of MAC addresses for sticky Mac allow list. Only applicable when 'accessPolicyType' is 'Sticky MAC allow list'.
        :param pulumi.Input[bool] storm_control_enabled: The storm control status of the switch port.
        :param pulumi.Input[str] stp_guard: The state of the STP guard ('disabled', 'root guard', 'bpdu guard' or 'loop guard').
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: The list of tags of the switch port.
        :param pulumi.Input[str] type: The type of the switch port ('trunk' or 'access').
        :param pulumi.Input[str] udld: The action to take when Unidirectional Link is detected (Alert only, Enforce). Default configuration is Alert only.
        :param pulumi.Input[int] vlan: The VLAN of the switch port. For a trunk port, this is the native VLAN. A null value will clear the value set for trunk ports.
        :param pulumi.Input[int] voice_vlan: The voice VLAN of the switch port. Only applicable to access ports.
        """
        pulumi.set(__self__, "port_id", port_id)
        pulumi.set(__self__, "serial", serial)
        if access_policy_number is not None:
            pulumi.set(__self__, "access_policy_number", access_policy_number)
        if access_policy_type is not None:
            pulumi.set(__self__, "access_policy_type", access_policy_type)
        if adaptive_policy_group_id is not None:
            pulumi.set(__self__, "adaptive_policy_group_id", adaptive_policy_group_id)
        if allowed_vlans is not None:
            pulumi.set(__self__, "allowed_vlans", allowed_vlans)
        if dai_trusted is not None:
            pulumi.set(__self__, "dai_trusted", dai_trusted)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if flexible_stacking_enabled is not None:
            pulumi.set(__self__, "flexible_stacking_enabled", flexible_stacking_enabled)
        if isolation_enabled is not None:
            pulumi.set(__self__, "isolation_enabled", isolation_enabled)
        if link_negotiation is not None:
            pulumi.set(__self__, "link_negotiation", link_negotiation)
        if mac_allow_lists is not None:
            pulumi.set(__self__, "mac_allow_lists", mac_allow_lists)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if peer_sgt_capable is not None:
            pulumi.set(__self__, "peer_sgt_capable", peer_sgt_capable)
        if poe_enabled is not None:
            pulumi.set(__self__, "poe_enabled", poe_enabled)
        if port_schedule_id is not None:
            pulumi.set(__self__, "port_schedule_id", port_schedule_id)
        if profile is not None:
            pulumi.set(__self__, "profile", profile)
        if rstp_enabled is not None:
            pulumi.set(__self__, "rstp_enabled", rstp_enabled)
        if sticky_mac_allow_list_limit is not None:
            pulumi.set(__self__, "sticky_mac_allow_list_limit", sticky_mac_allow_list_limit)
        if sticky_mac_allow_lists is not None:
            pulumi.set(__self__, "sticky_mac_allow_lists", sticky_mac_allow_lists)
        if storm_control_enabled is not None:
            pulumi.set(__self__, "storm_control_enabled", storm_control_enabled)
        if stp_guard is not None:
            pulumi.set(__self__, "stp_guard", stp_guard)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if udld is not None:
            pulumi.set(__self__, "udld", udld)
        if vlan is not None:
            pulumi.set(__self__, "vlan", vlan)
        if voice_vlan is not None:
            pulumi.set(__self__, "voice_vlan", voice_vlan)

    @property
    @pulumi.getter(name="portId")
    def port_id(self) -> pulumi.Input[str]:
        """
        The identifier of the switch port.
        """
        return pulumi.get(self, "port_id")

    @port_id.setter
    def port_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "port_id", value)

    @property
    @pulumi.getter
    def serial(self) -> pulumi.Input[str]:
        """
        serial path parameter.
        """
        return pulumi.get(self, "serial")

    @serial.setter
    def serial(self, value: pulumi.Input[str]):
        pulumi.set(self, "serial", value)

    @property
    @pulumi.getter(name="accessPolicyNumber")
    def access_policy_number(self) -> Optional[pulumi.Input[int]]:
        """
        The number of a custom access policy to configure on the switch port. Only applicable when 'accessPolicyType' is 'Custom access policy'.
        """
        return pulumi.get(self, "access_policy_number")

    @access_policy_number.setter
    def access_policy_number(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "access_policy_number", value)

    @property
    @pulumi.getter(name="accessPolicyType")
    def access_policy_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of the access policy of the switch port. Only applicable to access ports. Can be one of 'Open', 'Custom access policy', 'MAC allow list' or 'Sticky MAC allow list'.
        """
        return pulumi.get(self, "access_policy_type")

    @access_policy_type.setter
    def access_policy_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "access_policy_type", value)

    @property
    @pulumi.getter(name="adaptivePolicyGroupId")
    def adaptive_policy_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The adaptive policy group ID that will be used to tag traffic through this switch port. This ID must pre-exist during the configuration, else needs to be created using adaptivePolicy/groups API. Cannot be applied to a port on a switch bound to profile.
        """
        return pulumi.get(self, "adaptive_policy_group_id")

    @adaptive_policy_group_id.setter
    def adaptive_policy_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "adaptive_policy_group_id", value)

    @property
    @pulumi.getter(name="allowedVlans")
    def allowed_vlans(self) -> Optional[pulumi.Input[str]]:
        """
        The VLANs allowed on the switch port. Only applicable to trunk ports.
        """
        return pulumi.get(self, "allowed_vlans")

    @allowed_vlans.setter
    def allowed_vlans(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "allowed_vlans", value)

    @property
    @pulumi.getter(name="daiTrusted")
    def dai_trusted(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, ARP packets for this port will be considered trusted, and Dynamic ARP Inspection will allow the traffic.
        """
        return pulumi.get(self, "dai_trusted")

    @dai_trusted.setter
    def dai_trusted(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "dai_trusted", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        The status of the switch port.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="flexibleStackingEnabled")
    def flexible_stacking_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        For supported switches (e.g. MS420/MS425), whether or not the port has flexible stacking enabled.
        """
        return pulumi.get(self, "flexible_stacking_enabled")

    @flexible_stacking_enabled.setter
    def flexible_stacking_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "flexible_stacking_enabled", value)

    @property
    @pulumi.getter(name="isolationEnabled")
    def isolation_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        The isolation status of the switch port.
        """
        return pulumi.get(self, "isolation_enabled")

    @isolation_enabled.setter
    def isolation_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "isolation_enabled", value)

    @property
    @pulumi.getter(name="linkNegotiation")
    def link_negotiation(self) -> Optional[pulumi.Input[str]]:
        """
        The link speed for the switch port.
        """
        return pulumi.get(self, "link_negotiation")

    @link_negotiation.setter
    def link_negotiation(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "link_negotiation", value)

    @property
    @pulumi.getter(name="macAllowLists")
    def mac_allow_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Only devices with MAC addresses specified in this list will have access to this port. Up to 20 MAC addresses can be defined. Only applicable when 'accessPolicyType' is 'MAC allow list'.
        """
        return pulumi.get(self, "mac_allow_lists")

    @mac_allow_lists.setter
    def mac_allow_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "mac_allow_lists", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the switch port.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="peerSgtCapable")
    def peer_sgt_capable(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, Peer SGT is enabled for traffic through this switch port. Applicable to trunk port only, not access port. Cannot be applied to a port on a switch bound to profile.
        """
        return pulumi.get(self, "peer_sgt_capable")

    @peer_sgt_capable.setter
    def peer_sgt_capable(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "peer_sgt_capable", value)

    @property
    @pulumi.getter(name="poeEnabled")
    def poe_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        The PoE status of the switch port.
        """
        return pulumi.get(self, "poe_enabled")

    @poe_enabled.setter
    def poe_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "poe_enabled", value)

    @property
    @pulumi.getter(name="portScheduleId")
    def port_schedule_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the port schedule. A value of null will clear the port schedule.
        """
        return pulumi.get(self, "port_schedule_id")

    @port_schedule_id.setter
    def port_schedule_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "port_schedule_id", value)

    @property
    @pulumi.getter
    def profile(self) -> Optional[pulumi.Input['SwitchPortsProfileArgs']]:
        """
        Profile attributes
        """
        return pulumi.get(self, "profile")

    @profile.setter
    def profile(self, value: Optional[pulumi.Input['SwitchPortsProfileArgs']]):
        pulumi.set(self, "profile", value)

    @property
    @pulumi.getter(name="rstpEnabled")
    def rstp_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        The rapid spanning tree protocol status.
        """
        return pulumi.get(self, "rstp_enabled")

    @rstp_enabled.setter
    def rstp_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "rstp_enabled", value)

    @property
    @pulumi.getter(name="stickyMacAllowListLimit")
    def sticky_mac_allow_list_limit(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum number of MAC addresses for sticky MAC allow list. Only applicable when 'accessPolicyType' is 'Sticky MAC allow list'.
        """
        return pulumi.get(self, "sticky_mac_allow_list_limit")

    @sticky_mac_allow_list_limit.setter
    def sticky_mac_allow_list_limit(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "sticky_mac_allow_list_limit", value)

    @property
    @pulumi.getter(name="stickyMacAllowLists")
    def sticky_mac_allow_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The initial list of MAC addresses for sticky Mac allow list. Only applicable when 'accessPolicyType' is 'Sticky MAC allow list'.
        """
        return pulumi.get(self, "sticky_mac_allow_lists")

    @sticky_mac_allow_lists.setter
    def sticky_mac_allow_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "sticky_mac_allow_lists", value)

    @property
    @pulumi.getter(name="stormControlEnabled")
    def storm_control_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        The storm control status of the switch port.
        """
        return pulumi.get(self, "storm_control_enabled")

    @storm_control_enabled.setter
    def storm_control_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "storm_control_enabled", value)

    @property
    @pulumi.getter(name="stpGuard")
    def stp_guard(self) -> Optional[pulumi.Input[str]]:
        """
        The state of the STP guard ('disabled', 'root guard', 'bpdu guard' or 'loop guard').
        """
        return pulumi.get(self, "stp_guard")

    @stp_guard.setter
    def stp_guard(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "stp_guard", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of tags of the switch port.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of the switch port ('trunk' or 'access').
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def udld(self) -> Optional[pulumi.Input[str]]:
        """
        The action to take when Unidirectional Link is detected (Alert only, Enforce). Default configuration is Alert only.
        """
        return pulumi.get(self, "udld")

    @udld.setter
    def udld(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "udld", value)

    @property
    @pulumi.getter
    def vlan(self) -> Optional[pulumi.Input[int]]:
        """
        The VLAN of the switch port. For a trunk port, this is the native VLAN. A null value will clear the value set for trunk ports.
        """
        return pulumi.get(self, "vlan")

    @vlan.setter
    def vlan(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "vlan", value)

    @property
    @pulumi.getter(name="voiceVlan")
    def voice_vlan(self) -> Optional[pulumi.Input[int]]:
        """
        The voice VLAN of the switch port. Only applicable to access ports.
        """
        return pulumi.get(self, "voice_vlan")

    @voice_vlan.setter
    def voice_vlan(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "voice_vlan", value)


@pulumi.input_type
class _SwitchPortsState:
    def __init__(__self__, *,
                 access_policy_number: Optional[pulumi.Input[int]] = None,
                 access_policy_type: Optional[pulumi.Input[str]] = None,
                 adaptive_policy_group_id: Optional[pulumi.Input[str]] = None,
                 allowed_vlans: Optional[pulumi.Input[str]] = None,
                 dai_trusted: Optional[pulumi.Input[bool]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 flexible_stacking_enabled: Optional[pulumi.Input[bool]] = None,
                 isolation_enabled: Optional[pulumi.Input[bool]] = None,
                 link_negotiation: Optional[pulumi.Input[str]] = None,
                 link_negotiation_capabilities: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 mac_allow_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 mirror: Optional[pulumi.Input['SwitchPortsMirrorArgs']] = None,
                 module: Optional[pulumi.Input['SwitchPortsModuleArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 peer_sgt_capable: Optional[pulumi.Input[bool]] = None,
                 poe_enabled: Optional[pulumi.Input[bool]] = None,
                 port_id: Optional[pulumi.Input[str]] = None,
                 port_schedule_id: Optional[pulumi.Input[str]] = None,
                 profile: Optional[pulumi.Input['SwitchPortsProfileArgs']] = None,
                 rstp_enabled: Optional[pulumi.Input[bool]] = None,
                 serial: Optional[pulumi.Input[str]] = None,
                 sticky_mac_allow_list_limit: Optional[pulumi.Input[int]] = None,
                 sticky_mac_allow_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 storm_control_enabled: Optional[pulumi.Input[bool]] = None,
                 stp_guard: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 udld: Optional[pulumi.Input[str]] = None,
                 vlan: Optional[pulumi.Input[int]] = None,
                 voice_vlan: Optional[pulumi.Input[int]] = None):
        """
        Input properties used for looking up and filtering SwitchPorts resources.
        :param pulumi.Input[int] access_policy_number: The number of a custom access policy to configure on the switch port. Only applicable when 'accessPolicyType' is 'Custom access policy'.
        :param pulumi.Input[str] access_policy_type: The type of the access policy of the switch port. Only applicable to access ports. Can be one of 'Open', 'Custom access policy', 'MAC allow list' or 'Sticky MAC allow list'.
        :param pulumi.Input[str] adaptive_policy_group_id: The adaptive policy group ID that will be used to tag traffic through this switch port. This ID must pre-exist during the configuration, else needs to be created using adaptivePolicy/groups API. Cannot be applied to a port on a switch bound to profile.
        :param pulumi.Input[str] allowed_vlans: The VLANs allowed on the switch port. Only applicable to trunk ports.
        :param pulumi.Input[bool] dai_trusted: If true, ARP packets for this port will be considered trusted, and Dynamic ARP Inspection will allow the traffic.
        :param pulumi.Input[bool] enabled: The status of the switch port.
        :param pulumi.Input[bool] flexible_stacking_enabled: For supported switches (e.g. MS420/MS425), whether or not the port has flexible stacking enabled.
        :param pulumi.Input[bool] isolation_enabled: The isolation status of the switch port.
        :param pulumi.Input[str] link_negotiation: The link speed for the switch port.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] link_negotiation_capabilities: Available link speeds for the switch port.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] mac_allow_lists: Only devices with MAC addresses specified in this list will have access to this port. Up to 20 MAC addresses can be defined. Only applicable when 'accessPolicyType' is 'MAC allow list'.
        :param pulumi.Input['SwitchPortsMirrorArgs'] mirror: Port mirror
        :param pulumi.Input['SwitchPortsModuleArgs'] module: Expansion module
        :param pulumi.Input[str] name: The name of the switch port.
        :param pulumi.Input[bool] peer_sgt_capable: If true, Peer SGT is enabled for traffic through this switch port. Applicable to trunk port only, not access port. Cannot be applied to a port on a switch bound to profile.
        :param pulumi.Input[bool] poe_enabled: The PoE status of the switch port.
        :param pulumi.Input[str] port_id: The identifier of the switch port.
        :param pulumi.Input[str] port_schedule_id: The ID of the port schedule. A value of null will clear the port schedule.
        :param pulumi.Input['SwitchPortsProfileArgs'] profile: Profile attributes
        :param pulumi.Input[bool] rstp_enabled: The rapid spanning tree protocol status.
        :param pulumi.Input[str] serial: serial path parameter.
        :param pulumi.Input[int] sticky_mac_allow_list_limit: The maximum number of MAC addresses for sticky MAC allow list. Only applicable when 'accessPolicyType' is 'Sticky MAC allow list'.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] sticky_mac_allow_lists: The initial list of MAC addresses for sticky Mac allow list. Only applicable when 'accessPolicyType' is 'Sticky MAC allow list'.
        :param pulumi.Input[bool] storm_control_enabled: The storm control status of the switch port.
        :param pulumi.Input[str] stp_guard: The state of the STP guard ('disabled', 'root guard', 'bpdu guard' or 'loop guard').
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: The list of tags of the switch port.
        :param pulumi.Input[str] type: The type of the switch port ('trunk' or 'access').
        :param pulumi.Input[str] udld: The action to take when Unidirectional Link is detected (Alert only, Enforce). Default configuration is Alert only.
        :param pulumi.Input[int] vlan: The VLAN of the switch port. For a trunk port, this is the native VLAN. A null value will clear the value set for trunk ports.
        :param pulumi.Input[int] voice_vlan: The voice VLAN of the switch port. Only applicable to access ports.
        """
        if access_policy_number is not None:
            pulumi.set(__self__, "access_policy_number", access_policy_number)
        if access_policy_type is not None:
            pulumi.set(__self__, "access_policy_type", access_policy_type)
        if adaptive_policy_group_id is not None:
            pulumi.set(__self__, "adaptive_policy_group_id", adaptive_policy_group_id)
        if allowed_vlans is not None:
            pulumi.set(__self__, "allowed_vlans", allowed_vlans)
        if dai_trusted is not None:
            pulumi.set(__self__, "dai_trusted", dai_trusted)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if flexible_stacking_enabled is not None:
            pulumi.set(__self__, "flexible_stacking_enabled", flexible_stacking_enabled)
        if isolation_enabled is not None:
            pulumi.set(__self__, "isolation_enabled", isolation_enabled)
        if link_negotiation is not None:
            pulumi.set(__self__, "link_negotiation", link_negotiation)
        if link_negotiation_capabilities is not None:
            pulumi.set(__self__, "link_negotiation_capabilities", link_negotiation_capabilities)
        if mac_allow_lists is not None:
            pulumi.set(__self__, "mac_allow_lists", mac_allow_lists)
        if mirror is not None:
            pulumi.set(__self__, "mirror", mirror)
        if module is not None:
            pulumi.set(__self__, "module", module)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if peer_sgt_capable is not None:
            pulumi.set(__self__, "peer_sgt_capable", peer_sgt_capable)
        if poe_enabled is not None:
            pulumi.set(__self__, "poe_enabled", poe_enabled)
        if port_id is not None:
            pulumi.set(__self__, "port_id", port_id)
        if port_schedule_id is not None:
            pulumi.set(__self__, "port_schedule_id", port_schedule_id)
        if profile is not None:
            pulumi.set(__self__, "profile", profile)
        if rstp_enabled is not None:
            pulumi.set(__self__, "rstp_enabled", rstp_enabled)
        if serial is not None:
            pulumi.set(__self__, "serial", serial)
        if sticky_mac_allow_list_limit is not None:
            pulumi.set(__self__, "sticky_mac_allow_list_limit", sticky_mac_allow_list_limit)
        if sticky_mac_allow_lists is not None:
            pulumi.set(__self__, "sticky_mac_allow_lists", sticky_mac_allow_lists)
        if storm_control_enabled is not None:
            pulumi.set(__self__, "storm_control_enabled", storm_control_enabled)
        if stp_guard is not None:
            pulumi.set(__self__, "stp_guard", stp_guard)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if udld is not None:
            pulumi.set(__self__, "udld", udld)
        if vlan is not None:
            pulumi.set(__self__, "vlan", vlan)
        if voice_vlan is not None:
            pulumi.set(__self__, "voice_vlan", voice_vlan)

    @property
    @pulumi.getter(name="accessPolicyNumber")
    def access_policy_number(self) -> Optional[pulumi.Input[int]]:
        """
        The number of a custom access policy to configure on the switch port. Only applicable when 'accessPolicyType' is 'Custom access policy'.
        """
        return pulumi.get(self, "access_policy_number")

    @access_policy_number.setter
    def access_policy_number(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "access_policy_number", value)

    @property
    @pulumi.getter(name="accessPolicyType")
    def access_policy_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of the access policy of the switch port. Only applicable to access ports. Can be one of 'Open', 'Custom access policy', 'MAC allow list' or 'Sticky MAC allow list'.
        """
        return pulumi.get(self, "access_policy_type")

    @access_policy_type.setter
    def access_policy_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "access_policy_type", value)

    @property
    @pulumi.getter(name="adaptivePolicyGroupId")
    def adaptive_policy_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The adaptive policy group ID that will be used to tag traffic through this switch port. This ID must pre-exist during the configuration, else needs to be created using adaptivePolicy/groups API. Cannot be applied to a port on a switch bound to profile.
        """
        return pulumi.get(self, "adaptive_policy_group_id")

    @adaptive_policy_group_id.setter
    def adaptive_policy_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "adaptive_policy_group_id", value)

    @property
    @pulumi.getter(name="allowedVlans")
    def allowed_vlans(self) -> Optional[pulumi.Input[str]]:
        """
        The VLANs allowed on the switch port. Only applicable to trunk ports.
        """
        return pulumi.get(self, "allowed_vlans")

    @allowed_vlans.setter
    def allowed_vlans(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "allowed_vlans", value)

    @property
    @pulumi.getter(name="daiTrusted")
    def dai_trusted(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, ARP packets for this port will be considered trusted, and Dynamic ARP Inspection will allow the traffic.
        """
        return pulumi.get(self, "dai_trusted")

    @dai_trusted.setter
    def dai_trusted(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "dai_trusted", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        The status of the switch port.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="flexibleStackingEnabled")
    def flexible_stacking_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        For supported switches (e.g. MS420/MS425), whether or not the port has flexible stacking enabled.
        """
        return pulumi.get(self, "flexible_stacking_enabled")

    @flexible_stacking_enabled.setter
    def flexible_stacking_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "flexible_stacking_enabled", value)

    @property
    @pulumi.getter(name="isolationEnabled")
    def isolation_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        The isolation status of the switch port.
        """
        return pulumi.get(self, "isolation_enabled")

    @isolation_enabled.setter
    def isolation_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "isolation_enabled", value)

    @property
    @pulumi.getter(name="linkNegotiation")
    def link_negotiation(self) -> Optional[pulumi.Input[str]]:
        """
        The link speed for the switch port.
        """
        return pulumi.get(self, "link_negotiation")

    @link_negotiation.setter
    def link_negotiation(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "link_negotiation", value)

    @property
    @pulumi.getter(name="linkNegotiationCapabilities")
    def link_negotiation_capabilities(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Available link speeds for the switch port.
        """
        return pulumi.get(self, "link_negotiation_capabilities")

    @link_negotiation_capabilities.setter
    def link_negotiation_capabilities(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "link_negotiation_capabilities", value)

    @property
    @pulumi.getter(name="macAllowLists")
    def mac_allow_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Only devices with MAC addresses specified in this list will have access to this port. Up to 20 MAC addresses can be defined. Only applicable when 'accessPolicyType' is 'MAC allow list'.
        """
        return pulumi.get(self, "mac_allow_lists")

    @mac_allow_lists.setter
    def mac_allow_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "mac_allow_lists", value)

    @property
    @pulumi.getter
    def mirror(self) -> Optional[pulumi.Input['SwitchPortsMirrorArgs']]:
        """
        Port mirror
        """
        return pulumi.get(self, "mirror")

    @mirror.setter
    def mirror(self, value: Optional[pulumi.Input['SwitchPortsMirrorArgs']]):
        pulumi.set(self, "mirror", value)

    @property
    @pulumi.getter
    def module(self) -> Optional[pulumi.Input['SwitchPortsModuleArgs']]:
        """
        Expansion module
        """
        return pulumi.get(self, "module")

    @module.setter
    def module(self, value: Optional[pulumi.Input['SwitchPortsModuleArgs']]):
        pulumi.set(self, "module", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the switch port.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="peerSgtCapable")
    def peer_sgt_capable(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, Peer SGT is enabled for traffic through this switch port. Applicable to trunk port only, not access port. Cannot be applied to a port on a switch bound to profile.
        """
        return pulumi.get(self, "peer_sgt_capable")

    @peer_sgt_capable.setter
    def peer_sgt_capable(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "peer_sgt_capable", value)

    @property
    @pulumi.getter(name="poeEnabled")
    def poe_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        The PoE status of the switch port.
        """
        return pulumi.get(self, "poe_enabled")

    @poe_enabled.setter
    def poe_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "poe_enabled", value)

    @property
    @pulumi.getter(name="portId")
    def port_id(self) -> Optional[pulumi.Input[str]]:
        """
        The identifier of the switch port.
        """
        return pulumi.get(self, "port_id")

    @port_id.setter
    def port_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "port_id", value)

    @property
    @pulumi.getter(name="portScheduleId")
    def port_schedule_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the port schedule. A value of null will clear the port schedule.
        """
        return pulumi.get(self, "port_schedule_id")

    @port_schedule_id.setter
    def port_schedule_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "port_schedule_id", value)

    @property
    @pulumi.getter
    def profile(self) -> Optional[pulumi.Input['SwitchPortsProfileArgs']]:
        """
        Profile attributes
        """
        return pulumi.get(self, "profile")

    @profile.setter
    def profile(self, value: Optional[pulumi.Input['SwitchPortsProfileArgs']]):
        pulumi.set(self, "profile", value)

    @property
    @pulumi.getter(name="rstpEnabled")
    def rstp_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        The rapid spanning tree protocol status.
        """
        return pulumi.get(self, "rstp_enabled")

    @rstp_enabled.setter
    def rstp_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "rstp_enabled", value)

    @property
    @pulumi.getter
    def serial(self) -> Optional[pulumi.Input[str]]:
        """
        serial path parameter.
        """
        return pulumi.get(self, "serial")

    @serial.setter
    def serial(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "serial", value)

    @property
    @pulumi.getter(name="stickyMacAllowListLimit")
    def sticky_mac_allow_list_limit(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum number of MAC addresses for sticky MAC allow list. Only applicable when 'accessPolicyType' is 'Sticky MAC allow list'.
        """
        return pulumi.get(self, "sticky_mac_allow_list_limit")

    @sticky_mac_allow_list_limit.setter
    def sticky_mac_allow_list_limit(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "sticky_mac_allow_list_limit", value)

    @property
    @pulumi.getter(name="stickyMacAllowLists")
    def sticky_mac_allow_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The initial list of MAC addresses for sticky Mac allow list. Only applicable when 'accessPolicyType' is 'Sticky MAC allow list'.
        """
        return pulumi.get(self, "sticky_mac_allow_lists")

    @sticky_mac_allow_lists.setter
    def sticky_mac_allow_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "sticky_mac_allow_lists", value)

    @property
    @pulumi.getter(name="stormControlEnabled")
    def storm_control_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        The storm control status of the switch port.
        """
        return pulumi.get(self, "storm_control_enabled")

    @storm_control_enabled.setter
    def storm_control_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "storm_control_enabled", value)

    @property
    @pulumi.getter(name="stpGuard")
    def stp_guard(self) -> Optional[pulumi.Input[str]]:
        """
        The state of the STP guard ('disabled', 'root guard', 'bpdu guard' or 'loop guard').
        """
        return pulumi.get(self, "stp_guard")

    @stp_guard.setter
    def stp_guard(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "stp_guard", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of tags of the switch port.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of the switch port ('trunk' or 'access').
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def udld(self) -> Optional[pulumi.Input[str]]:
        """
        The action to take when Unidirectional Link is detected (Alert only, Enforce). Default configuration is Alert only.
        """
        return pulumi.get(self, "udld")

    @udld.setter
    def udld(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "udld", value)

    @property
    @pulumi.getter
    def vlan(self) -> Optional[pulumi.Input[int]]:
        """
        The VLAN of the switch port. For a trunk port, this is the native VLAN. A null value will clear the value set for trunk ports.
        """
        return pulumi.get(self, "vlan")

    @vlan.setter
    def vlan(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "vlan", value)

    @property
    @pulumi.getter(name="voiceVlan")
    def voice_vlan(self) -> Optional[pulumi.Input[int]]:
        """
        The voice VLAN of the switch port. Only applicable to access ports.
        """
        return pulumi.get(self, "voice_vlan")

    @voice_vlan.setter
    def voice_vlan(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "voice_vlan", value)


class SwitchPorts(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_policy_number: Optional[pulumi.Input[int]] = None,
                 access_policy_type: Optional[pulumi.Input[str]] = None,
                 adaptive_policy_group_id: Optional[pulumi.Input[str]] = None,
                 allowed_vlans: Optional[pulumi.Input[str]] = None,
                 dai_trusted: Optional[pulumi.Input[bool]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 flexible_stacking_enabled: Optional[pulumi.Input[bool]] = None,
                 isolation_enabled: Optional[pulumi.Input[bool]] = None,
                 link_negotiation: Optional[pulumi.Input[str]] = None,
                 mac_allow_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 peer_sgt_capable: Optional[pulumi.Input[bool]] = None,
                 poe_enabled: Optional[pulumi.Input[bool]] = None,
                 port_id: Optional[pulumi.Input[str]] = None,
                 port_schedule_id: Optional[pulumi.Input[str]] = None,
                 profile: Optional[pulumi.Input[Union['SwitchPortsProfileArgs', 'SwitchPortsProfileArgsDict']]] = None,
                 rstp_enabled: Optional[pulumi.Input[bool]] = None,
                 serial: Optional[pulumi.Input[str]] = None,
                 sticky_mac_allow_list_limit: Optional[pulumi.Input[int]] = None,
                 sticky_mac_allow_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 storm_control_enabled: Optional[pulumi.Input[bool]] = None,
                 stp_guard: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 udld: Optional[pulumi.Input[str]] = None,
                 vlan: Optional[pulumi.Input[int]] = None,
                 voice_vlan: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_meraki as meraki

        example = meraki.devices.SwitchPorts("example",
            access_policy_number=2,
            access_policy_type="Sticky MAC allow list",
            adaptive_policy_group_id="123",
            allowed_vlans="1,3,5-10",
            dai_trusted=False,
            enabled=True,
            flexible_stacking_enabled=True,
            isolation_enabled=False,
            link_negotiation="Auto negotiate",
            mac_allow_lists=[
                "34:56:fe:ce:8e:b0",
                "34:56:fe:ce:8e:b1",
            ],
            name="My switch port",
            peer_sgt_capable=False,
            poe_enabled=True,
            port_id="string",
            port_schedule_id="1234",
            profile={
                "enabled": False,
                "id": "1284392014819",
                "iname": "iname",
            },
            rstp_enabled=True,
            serial="string",
            sticky_mac_allow_lists=[
                "34:56:fe:ce:8e:b0",
                "34:56:fe:ce:8e:b1",
            ],
            sticky_mac_allow_list_limit=5,
            storm_control_enabled=True,
            stp_guard="disabled",
            tags=[
                "tag1",
                "tag2",
            ],
            type="access",
            udld="Alert only",
            vlan=10,
            voice_vlan=20)
        pulumi.export("merakiDevicesSwitchPortsExample", example)
        ```

        ## Import

        ```sh
        $ pulumi import meraki:devices/switchPorts:SwitchPorts example "port_id,serial"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] access_policy_number: The number of a custom access policy to configure on the switch port. Only applicable when 'accessPolicyType' is 'Custom access policy'.
        :param pulumi.Input[str] access_policy_type: The type of the access policy of the switch port. Only applicable to access ports. Can be one of 'Open', 'Custom access policy', 'MAC allow list' or 'Sticky MAC allow list'.
        :param pulumi.Input[str] adaptive_policy_group_id: The adaptive policy group ID that will be used to tag traffic through this switch port. This ID must pre-exist during the configuration, else needs to be created using adaptivePolicy/groups API. Cannot be applied to a port on a switch bound to profile.
        :param pulumi.Input[str] allowed_vlans: The VLANs allowed on the switch port. Only applicable to trunk ports.
        :param pulumi.Input[bool] dai_trusted: If true, ARP packets for this port will be considered trusted, and Dynamic ARP Inspection will allow the traffic.
        :param pulumi.Input[bool] enabled: The status of the switch port.
        :param pulumi.Input[bool] flexible_stacking_enabled: For supported switches (e.g. MS420/MS425), whether or not the port has flexible stacking enabled.
        :param pulumi.Input[bool] isolation_enabled: The isolation status of the switch port.
        :param pulumi.Input[str] link_negotiation: The link speed for the switch port.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] mac_allow_lists: Only devices with MAC addresses specified in this list will have access to this port. Up to 20 MAC addresses can be defined. Only applicable when 'accessPolicyType' is 'MAC allow list'.
        :param pulumi.Input[str] name: The name of the switch port.
        :param pulumi.Input[bool] peer_sgt_capable: If true, Peer SGT is enabled for traffic through this switch port. Applicable to trunk port only, not access port. Cannot be applied to a port on a switch bound to profile.
        :param pulumi.Input[bool] poe_enabled: The PoE status of the switch port.
        :param pulumi.Input[str] port_id: The identifier of the switch port.
        :param pulumi.Input[str] port_schedule_id: The ID of the port schedule. A value of null will clear the port schedule.
        :param pulumi.Input[Union['SwitchPortsProfileArgs', 'SwitchPortsProfileArgsDict']] profile: Profile attributes
        :param pulumi.Input[bool] rstp_enabled: The rapid spanning tree protocol status.
        :param pulumi.Input[str] serial: serial path parameter.
        :param pulumi.Input[int] sticky_mac_allow_list_limit: The maximum number of MAC addresses for sticky MAC allow list. Only applicable when 'accessPolicyType' is 'Sticky MAC allow list'.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] sticky_mac_allow_lists: The initial list of MAC addresses for sticky Mac allow list. Only applicable when 'accessPolicyType' is 'Sticky MAC allow list'.
        :param pulumi.Input[bool] storm_control_enabled: The storm control status of the switch port.
        :param pulumi.Input[str] stp_guard: The state of the STP guard ('disabled', 'root guard', 'bpdu guard' or 'loop guard').
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: The list of tags of the switch port.
        :param pulumi.Input[str] type: The type of the switch port ('trunk' or 'access').
        :param pulumi.Input[str] udld: The action to take when Unidirectional Link is detected (Alert only, Enforce). Default configuration is Alert only.
        :param pulumi.Input[int] vlan: The VLAN of the switch port. For a trunk port, this is the native VLAN. A null value will clear the value set for trunk ports.
        :param pulumi.Input[int] voice_vlan: The voice VLAN of the switch port. Only applicable to access ports.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SwitchPortsArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_meraki as meraki

        example = meraki.devices.SwitchPorts("example",
            access_policy_number=2,
            access_policy_type="Sticky MAC allow list",
            adaptive_policy_group_id="123",
            allowed_vlans="1,3,5-10",
            dai_trusted=False,
            enabled=True,
            flexible_stacking_enabled=True,
            isolation_enabled=False,
            link_negotiation="Auto negotiate",
            mac_allow_lists=[
                "34:56:fe:ce:8e:b0",
                "34:56:fe:ce:8e:b1",
            ],
            name="My switch port",
            peer_sgt_capable=False,
            poe_enabled=True,
            port_id="string",
            port_schedule_id="1234",
            profile={
                "enabled": False,
                "id": "1284392014819",
                "iname": "iname",
            },
            rstp_enabled=True,
            serial="string",
            sticky_mac_allow_lists=[
                "34:56:fe:ce:8e:b0",
                "34:56:fe:ce:8e:b1",
            ],
            sticky_mac_allow_list_limit=5,
            storm_control_enabled=True,
            stp_guard="disabled",
            tags=[
                "tag1",
                "tag2",
            ],
            type="access",
            udld="Alert only",
            vlan=10,
            voice_vlan=20)
        pulumi.export("merakiDevicesSwitchPortsExample", example)
        ```

        ## Import

        ```sh
        $ pulumi import meraki:devices/switchPorts:SwitchPorts example "port_id,serial"
        ```

        :param str resource_name: The name of the resource.
        :param SwitchPortsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SwitchPortsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_policy_number: Optional[pulumi.Input[int]] = None,
                 access_policy_type: Optional[pulumi.Input[str]] = None,
                 adaptive_policy_group_id: Optional[pulumi.Input[str]] = None,
                 allowed_vlans: Optional[pulumi.Input[str]] = None,
                 dai_trusted: Optional[pulumi.Input[bool]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 flexible_stacking_enabled: Optional[pulumi.Input[bool]] = None,
                 isolation_enabled: Optional[pulumi.Input[bool]] = None,
                 link_negotiation: Optional[pulumi.Input[str]] = None,
                 mac_allow_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 peer_sgt_capable: Optional[pulumi.Input[bool]] = None,
                 poe_enabled: Optional[pulumi.Input[bool]] = None,
                 port_id: Optional[pulumi.Input[str]] = None,
                 port_schedule_id: Optional[pulumi.Input[str]] = None,
                 profile: Optional[pulumi.Input[Union['SwitchPortsProfileArgs', 'SwitchPortsProfileArgsDict']]] = None,
                 rstp_enabled: Optional[pulumi.Input[bool]] = None,
                 serial: Optional[pulumi.Input[str]] = None,
                 sticky_mac_allow_list_limit: Optional[pulumi.Input[int]] = None,
                 sticky_mac_allow_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 storm_control_enabled: Optional[pulumi.Input[bool]] = None,
                 stp_guard: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 udld: Optional[pulumi.Input[str]] = None,
                 vlan: Optional[pulumi.Input[int]] = None,
                 voice_vlan: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SwitchPortsArgs.__new__(SwitchPortsArgs)

            __props__.__dict__["access_policy_number"] = access_policy_number
            __props__.__dict__["access_policy_type"] = access_policy_type
            __props__.__dict__["adaptive_policy_group_id"] = adaptive_policy_group_id
            __props__.__dict__["allowed_vlans"] = allowed_vlans
            __props__.__dict__["dai_trusted"] = dai_trusted
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["flexible_stacking_enabled"] = flexible_stacking_enabled
            __props__.__dict__["isolation_enabled"] = isolation_enabled
            __props__.__dict__["link_negotiation"] = link_negotiation
            __props__.__dict__["mac_allow_lists"] = mac_allow_lists
            __props__.__dict__["name"] = name
            __props__.__dict__["peer_sgt_capable"] = peer_sgt_capable
            __props__.__dict__["poe_enabled"] = poe_enabled
            if port_id is None and not opts.urn:
                raise TypeError("Missing required property 'port_id'")
            __props__.__dict__["port_id"] = port_id
            __props__.__dict__["port_schedule_id"] = port_schedule_id
            __props__.__dict__["profile"] = profile
            __props__.__dict__["rstp_enabled"] = rstp_enabled
            if serial is None and not opts.urn:
                raise TypeError("Missing required property 'serial'")
            __props__.__dict__["serial"] = serial
            __props__.__dict__["sticky_mac_allow_list_limit"] = sticky_mac_allow_list_limit
            __props__.__dict__["sticky_mac_allow_lists"] = sticky_mac_allow_lists
            __props__.__dict__["storm_control_enabled"] = storm_control_enabled
            __props__.__dict__["stp_guard"] = stp_guard
            __props__.__dict__["tags"] = tags
            __props__.__dict__["type"] = type
            __props__.__dict__["udld"] = udld
            __props__.__dict__["vlan"] = vlan
            __props__.__dict__["voice_vlan"] = voice_vlan
            __props__.__dict__["link_negotiation_capabilities"] = None
            __props__.__dict__["mirror"] = None
            __props__.__dict__["module"] = None
        super(SwitchPorts, __self__).__init__(
            'meraki:devices/switchPorts:SwitchPorts',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_policy_number: Optional[pulumi.Input[int]] = None,
            access_policy_type: Optional[pulumi.Input[str]] = None,
            adaptive_policy_group_id: Optional[pulumi.Input[str]] = None,
            allowed_vlans: Optional[pulumi.Input[str]] = None,
            dai_trusted: Optional[pulumi.Input[bool]] = None,
            enabled: Optional[pulumi.Input[bool]] = None,
            flexible_stacking_enabled: Optional[pulumi.Input[bool]] = None,
            isolation_enabled: Optional[pulumi.Input[bool]] = None,
            link_negotiation: Optional[pulumi.Input[str]] = None,
            link_negotiation_capabilities: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            mac_allow_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            mirror: Optional[pulumi.Input[Union['SwitchPortsMirrorArgs', 'SwitchPortsMirrorArgsDict']]] = None,
            module: Optional[pulumi.Input[Union['SwitchPortsModuleArgs', 'SwitchPortsModuleArgsDict']]] = None,
            name: Optional[pulumi.Input[str]] = None,
            peer_sgt_capable: Optional[pulumi.Input[bool]] = None,
            poe_enabled: Optional[pulumi.Input[bool]] = None,
            port_id: Optional[pulumi.Input[str]] = None,
            port_schedule_id: Optional[pulumi.Input[str]] = None,
            profile: Optional[pulumi.Input[Union['SwitchPortsProfileArgs', 'SwitchPortsProfileArgsDict']]] = None,
            rstp_enabled: Optional[pulumi.Input[bool]] = None,
            serial: Optional[pulumi.Input[str]] = None,
            sticky_mac_allow_list_limit: Optional[pulumi.Input[int]] = None,
            sticky_mac_allow_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            storm_control_enabled: Optional[pulumi.Input[bool]] = None,
            stp_guard: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            type: Optional[pulumi.Input[str]] = None,
            udld: Optional[pulumi.Input[str]] = None,
            vlan: Optional[pulumi.Input[int]] = None,
            voice_vlan: Optional[pulumi.Input[int]] = None) -> 'SwitchPorts':
        """
        Get an existing SwitchPorts resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] access_policy_number: The number of a custom access policy to configure on the switch port. Only applicable when 'accessPolicyType' is 'Custom access policy'.
        :param pulumi.Input[str] access_policy_type: The type of the access policy of the switch port. Only applicable to access ports. Can be one of 'Open', 'Custom access policy', 'MAC allow list' or 'Sticky MAC allow list'.
        :param pulumi.Input[str] adaptive_policy_group_id: The adaptive policy group ID that will be used to tag traffic through this switch port. This ID must pre-exist during the configuration, else needs to be created using adaptivePolicy/groups API. Cannot be applied to a port on a switch bound to profile.
        :param pulumi.Input[str] allowed_vlans: The VLANs allowed on the switch port. Only applicable to trunk ports.
        :param pulumi.Input[bool] dai_trusted: If true, ARP packets for this port will be considered trusted, and Dynamic ARP Inspection will allow the traffic.
        :param pulumi.Input[bool] enabled: The status of the switch port.
        :param pulumi.Input[bool] flexible_stacking_enabled: For supported switches (e.g. MS420/MS425), whether or not the port has flexible stacking enabled.
        :param pulumi.Input[bool] isolation_enabled: The isolation status of the switch port.
        :param pulumi.Input[str] link_negotiation: The link speed for the switch port.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] link_negotiation_capabilities: Available link speeds for the switch port.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] mac_allow_lists: Only devices with MAC addresses specified in this list will have access to this port. Up to 20 MAC addresses can be defined. Only applicable when 'accessPolicyType' is 'MAC allow list'.
        :param pulumi.Input[Union['SwitchPortsMirrorArgs', 'SwitchPortsMirrorArgsDict']] mirror: Port mirror
        :param pulumi.Input[Union['SwitchPortsModuleArgs', 'SwitchPortsModuleArgsDict']] module: Expansion module
        :param pulumi.Input[str] name: The name of the switch port.
        :param pulumi.Input[bool] peer_sgt_capable: If true, Peer SGT is enabled for traffic through this switch port. Applicable to trunk port only, not access port. Cannot be applied to a port on a switch bound to profile.
        :param pulumi.Input[bool] poe_enabled: The PoE status of the switch port.
        :param pulumi.Input[str] port_id: The identifier of the switch port.
        :param pulumi.Input[str] port_schedule_id: The ID of the port schedule. A value of null will clear the port schedule.
        :param pulumi.Input[Union['SwitchPortsProfileArgs', 'SwitchPortsProfileArgsDict']] profile: Profile attributes
        :param pulumi.Input[bool] rstp_enabled: The rapid spanning tree protocol status.
        :param pulumi.Input[str] serial: serial path parameter.
        :param pulumi.Input[int] sticky_mac_allow_list_limit: The maximum number of MAC addresses for sticky MAC allow list. Only applicable when 'accessPolicyType' is 'Sticky MAC allow list'.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] sticky_mac_allow_lists: The initial list of MAC addresses for sticky Mac allow list. Only applicable when 'accessPolicyType' is 'Sticky MAC allow list'.
        :param pulumi.Input[bool] storm_control_enabled: The storm control status of the switch port.
        :param pulumi.Input[str] stp_guard: The state of the STP guard ('disabled', 'root guard', 'bpdu guard' or 'loop guard').
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: The list of tags of the switch port.
        :param pulumi.Input[str] type: The type of the switch port ('trunk' or 'access').
        :param pulumi.Input[str] udld: The action to take when Unidirectional Link is detected (Alert only, Enforce). Default configuration is Alert only.
        :param pulumi.Input[int] vlan: The VLAN of the switch port. For a trunk port, this is the native VLAN. A null value will clear the value set for trunk ports.
        :param pulumi.Input[int] voice_vlan: The voice VLAN of the switch port. Only applicable to access ports.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SwitchPortsState.__new__(_SwitchPortsState)

        __props__.__dict__["access_policy_number"] = access_policy_number
        __props__.__dict__["access_policy_type"] = access_policy_type
        __props__.__dict__["adaptive_policy_group_id"] = adaptive_policy_group_id
        __props__.__dict__["allowed_vlans"] = allowed_vlans
        __props__.__dict__["dai_trusted"] = dai_trusted
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["flexible_stacking_enabled"] = flexible_stacking_enabled
        __props__.__dict__["isolation_enabled"] = isolation_enabled
        __props__.__dict__["link_negotiation"] = link_negotiation
        __props__.__dict__["link_negotiation_capabilities"] = link_negotiation_capabilities
        __props__.__dict__["mac_allow_lists"] = mac_allow_lists
        __props__.__dict__["mirror"] = mirror
        __props__.__dict__["module"] = module
        __props__.__dict__["name"] = name
        __props__.__dict__["peer_sgt_capable"] = peer_sgt_capable
        __props__.__dict__["poe_enabled"] = poe_enabled
        __props__.__dict__["port_id"] = port_id
        __props__.__dict__["port_schedule_id"] = port_schedule_id
        __props__.__dict__["profile"] = profile
        __props__.__dict__["rstp_enabled"] = rstp_enabled
        __props__.__dict__["serial"] = serial
        __props__.__dict__["sticky_mac_allow_list_limit"] = sticky_mac_allow_list_limit
        __props__.__dict__["sticky_mac_allow_lists"] = sticky_mac_allow_lists
        __props__.__dict__["storm_control_enabled"] = storm_control_enabled
        __props__.__dict__["stp_guard"] = stp_guard
        __props__.__dict__["tags"] = tags
        __props__.__dict__["type"] = type
        __props__.__dict__["udld"] = udld
        __props__.__dict__["vlan"] = vlan
        __props__.__dict__["voice_vlan"] = voice_vlan
        return SwitchPorts(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accessPolicyNumber")
    def access_policy_number(self) -> pulumi.Output[int]:
        """
        The number of a custom access policy to configure on the switch port. Only applicable when 'accessPolicyType' is 'Custom access policy'.
        """
        return pulumi.get(self, "access_policy_number")

    @property
    @pulumi.getter(name="accessPolicyType")
    def access_policy_type(self) -> pulumi.Output[str]:
        """
        The type of the access policy of the switch port. Only applicable to access ports. Can be one of 'Open', 'Custom access policy', 'MAC allow list' or 'Sticky MAC allow list'.
        """
        return pulumi.get(self, "access_policy_type")

    @property
    @pulumi.getter(name="adaptivePolicyGroupId")
    def adaptive_policy_group_id(self) -> pulumi.Output[str]:
        """
        The adaptive policy group ID that will be used to tag traffic through this switch port. This ID must pre-exist during the configuration, else needs to be created using adaptivePolicy/groups API. Cannot be applied to a port on a switch bound to profile.
        """
        return pulumi.get(self, "adaptive_policy_group_id")

    @property
    @pulumi.getter(name="allowedVlans")
    def allowed_vlans(self) -> pulumi.Output[str]:
        """
        The VLANs allowed on the switch port. Only applicable to trunk ports.
        """
        return pulumi.get(self, "allowed_vlans")

    @property
    @pulumi.getter(name="daiTrusted")
    def dai_trusted(self) -> pulumi.Output[bool]:
        """
        If true, ARP packets for this port will be considered trusted, and Dynamic ARP Inspection will allow the traffic.
        """
        return pulumi.get(self, "dai_trusted")

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[bool]:
        """
        The status of the switch port.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="flexibleStackingEnabled")
    def flexible_stacking_enabled(self) -> pulumi.Output[bool]:
        """
        For supported switches (e.g. MS420/MS425), whether or not the port has flexible stacking enabled.
        """
        return pulumi.get(self, "flexible_stacking_enabled")

    @property
    @pulumi.getter(name="isolationEnabled")
    def isolation_enabled(self) -> pulumi.Output[bool]:
        """
        The isolation status of the switch port.
        """
        return pulumi.get(self, "isolation_enabled")

    @property
    @pulumi.getter(name="linkNegotiation")
    def link_negotiation(self) -> pulumi.Output[str]:
        """
        The link speed for the switch port.
        """
        return pulumi.get(self, "link_negotiation")

    @property
    @pulumi.getter(name="linkNegotiationCapabilities")
    def link_negotiation_capabilities(self) -> pulumi.Output[Sequence[str]]:
        """
        Available link speeds for the switch port.
        """
        return pulumi.get(self, "link_negotiation_capabilities")

    @property
    @pulumi.getter(name="macAllowLists")
    def mac_allow_lists(self) -> pulumi.Output[Sequence[str]]:
        """
        Only devices with MAC addresses specified in this list will have access to this port. Up to 20 MAC addresses can be defined. Only applicable when 'accessPolicyType' is 'MAC allow list'.
        """
        return pulumi.get(self, "mac_allow_lists")

    @property
    @pulumi.getter
    def mirror(self) -> pulumi.Output['outputs.SwitchPortsMirror']:
        """
        Port mirror
        """
        return pulumi.get(self, "mirror")

    @property
    @pulumi.getter
    def module(self) -> pulumi.Output['outputs.SwitchPortsModule']:
        """
        Expansion module
        """
        return pulumi.get(self, "module")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the switch port.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="peerSgtCapable")
    def peer_sgt_capable(self) -> pulumi.Output[bool]:
        """
        If true, Peer SGT is enabled for traffic through this switch port. Applicable to trunk port only, not access port. Cannot be applied to a port on a switch bound to profile.
        """
        return pulumi.get(self, "peer_sgt_capable")

    @property
    @pulumi.getter(name="poeEnabled")
    def poe_enabled(self) -> pulumi.Output[bool]:
        """
        The PoE status of the switch port.
        """
        return pulumi.get(self, "poe_enabled")

    @property
    @pulumi.getter(name="portId")
    def port_id(self) -> pulumi.Output[str]:
        """
        The identifier of the switch port.
        """
        return pulumi.get(self, "port_id")

    @property
    @pulumi.getter(name="portScheduleId")
    def port_schedule_id(self) -> pulumi.Output[str]:
        """
        The ID of the port schedule. A value of null will clear the port schedule.
        """
        return pulumi.get(self, "port_schedule_id")

    @property
    @pulumi.getter
    def profile(self) -> pulumi.Output['outputs.SwitchPortsProfile']:
        """
        Profile attributes
        """
        return pulumi.get(self, "profile")

    @property
    @pulumi.getter(name="rstpEnabled")
    def rstp_enabled(self) -> pulumi.Output[bool]:
        """
        The rapid spanning tree protocol status.
        """
        return pulumi.get(self, "rstp_enabled")

    @property
    @pulumi.getter
    def serial(self) -> pulumi.Output[str]:
        """
        serial path parameter.
        """
        return pulumi.get(self, "serial")

    @property
    @pulumi.getter(name="stickyMacAllowListLimit")
    def sticky_mac_allow_list_limit(self) -> pulumi.Output[int]:
        """
        The maximum number of MAC addresses for sticky MAC allow list. Only applicable when 'accessPolicyType' is 'Sticky MAC allow list'.
        """
        return pulumi.get(self, "sticky_mac_allow_list_limit")

    @property
    @pulumi.getter(name="stickyMacAllowLists")
    def sticky_mac_allow_lists(self) -> pulumi.Output[Sequence[str]]:
        """
        The initial list of MAC addresses for sticky Mac allow list. Only applicable when 'accessPolicyType' is 'Sticky MAC allow list'.
        """
        return pulumi.get(self, "sticky_mac_allow_lists")

    @property
    @pulumi.getter(name="stormControlEnabled")
    def storm_control_enabled(self) -> pulumi.Output[bool]:
        """
        The storm control status of the switch port.
        """
        return pulumi.get(self, "storm_control_enabled")

    @property
    @pulumi.getter(name="stpGuard")
    def stp_guard(self) -> pulumi.Output[str]:
        """
        The state of the STP guard ('disabled', 'root guard', 'bpdu guard' or 'loop guard').
        """
        return pulumi.get(self, "stp_guard")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Sequence[str]]:
        """
        The list of tags of the switch port.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        The type of the switch port ('trunk' or 'access').
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def udld(self) -> pulumi.Output[str]:
        """
        The action to take when Unidirectional Link is detected (Alert only, Enforce). Default configuration is Alert only.
        """
        return pulumi.get(self, "udld")

    @property
    @pulumi.getter
    def vlan(self) -> pulumi.Output[int]:
        """
        The VLAN of the switch port. For a trunk port, this is the native VLAN. A null value will clear the value set for trunk ports.
        """
        return pulumi.get(self, "vlan")

    @property
    @pulumi.getter(name="voiceVlan")
    def voice_vlan(self) -> pulumi.Output[int]:
        """
        The voice VLAN of the switch port. Only applicable to access ports.
        """
        return pulumi.get(self, "voice_vlan")

