# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ApplianceSecurityIntrusionArgs', 'ApplianceSecurityIntrusion']

@pulumi.input_type
class ApplianceSecurityIntrusionArgs:
    def __init__(__self__, *,
                 network_id: pulumi.Input[str],
                 ids_rulesets: Optional[pulumi.Input[str]] = None,
                 mode: Optional[pulumi.Input[str]] = None,
                 protected_networks: Optional[pulumi.Input['ApplianceSecurityIntrusionProtectedNetworksArgs']] = None):
        """
        The set of arguments for constructing a ApplianceSecurityIntrusion resource.
        :param pulumi.Input[str] network_id: networkId path parameter. Network ID
        :param pulumi.Input[str] ids_rulesets: Intrusion detection ruleset
        :param pulumi.Input[str] mode: Intrusion detection mode
        :param pulumi.Input['ApplianceSecurityIntrusionProtectedNetworksArgs'] protected_networks: Networks included in and excluded from the detection engine
        """
        pulumi.set(__self__, "network_id", network_id)
        if ids_rulesets is not None:
            pulumi.set(__self__, "ids_rulesets", ids_rulesets)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if protected_networks is not None:
            pulumi.set(__self__, "protected_networks", protected_networks)

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Input[str]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "network_id", value)

    @property
    @pulumi.getter(name="idsRulesets")
    def ids_rulesets(self) -> Optional[pulumi.Input[str]]:
        """
        Intrusion detection ruleset
        """
        return pulumi.get(self, "ids_rulesets")

    @ids_rulesets.setter
    def ids_rulesets(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ids_rulesets", value)

    @property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input[str]]:
        """
        Intrusion detection mode
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mode", value)

    @property
    @pulumi.getter(name="protectedNetworks")
    def protected_networks(self) -> Optional[pulumi.Input['ApplianceSecurityIntrusionProtectedNetworksArgs']]:
        """
        Networks included in and excluded from the detection engine
        """
        return pulumi.get(self, "protected_networks")

    @protected_networks.setter
    def protected_networks(self, value: Optional[pulumi.Input['ApplianceSecurityIntrusionProtectedNetworksArgs']]):
        pulumi.set(self, "protected_networks", value)


@pulumi.input_type
class _ApplianceSecurityIntrusionState:
    def __init__(__self__, *,
                 ids_rulesets: Optional[pulumi.Input[str]] = None,
                 mode: Optional[pulumi.Input[str]] = None,
                 network_id: Optional[pulumi.Input[str]] = None,
                 protected_networks: Optional[pulumi.Input['ApplianceSecurityIntrusionProtectedNetworksArgs']] = None):
        """
        Input properties used for looking up and filtering ApplianceSecurityIntrusion resources.
        :param pulumi.Input[str] ids_rulesets: Intrusion detection ruleset
        :param pulumi.Input[str] mode: Intrusion detection mode
        :param pulumi.Input[str] network_id: networkId path parameter. Network ID
        :param pulumi.Input['ApplianceSecurityIntrusionProtectedNetworksArgs'] protected_networks: Networks included in and excluded from the detection engine
        """
        if ids_rulesets is not None:
            pulumi.set(__self__, "ids_rulesets", ids_rulesets)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if network_id is not None:
            pulumi.set(__self__, "network_id", network_id)
        if protected_networks is not None:
            pulumi.set(__self__, "protected_networks", protected_networks)

    @property
    @pulumi.getter(name="idsRulesets")
    def ids_rulesets(self) -> Optional[pulumi.Input[str]]:
        """
        Intrusion detection ruleset
        """
        return pulumi.get(self, "ids_rulesets")

    @ids_rulesets.setter
    def ids_rulesets(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ids_rulesets", value)

    @property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input[str]]:
        """
        Intrusion detection mode
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mode", value)

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> Optional[pulumi.Input[str]]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network_id", value)

    @property
    @pulumi.getter(name="protectedNetworks")
    def protected_networks(self) -> Optional[pulumi.Input['ApplianceSecurityIntrusionProtectedNetworksArgs']]:
        """
        Networks included in and excluded from the detection engine
        """
        return pulumi.get(self, "protected_networks")

    @protected_networks.setter
    def protected_networks(self, value: Optional[pulumi.Input['ApplianceSecurityIntrusionProtectedNetworksArgs']]):
        pulumi.set(self, "protected_networks", value)


class ApplianceSecurityIntrusion(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ids_rulesets: Optional[pulumi.Input[str]] = None,
                 mode: Optional[pulumi.Input[str]] = None,
                 network_id: Optional[pulumi.Input[str]] = None,
                 protected_networks: Optional[pulumi.Input[Union['ApplianceSecurityIntrusionProtectedNetworksArgs', 'ApplianceSecurityIntrusionProtectedNetworksArgsDict']]] = None,
                 __props__=None):
        """
        ## Example Usage

        ## Import

        ```sh
        $ pulumi import meraki:networks/applianceSecurityIntrusion:ApplianceSecurityIntrusion example "network_id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] ids_rulesets: Intrusion detection ruleset
        :param pulumi.Input[str] mode: Intrusion detection mode
        :param pulumi.Input[str] network_id: networkId path parameter. Network ID
        :param pulumi.Input[Union['ApplianceSecurityIntrusionProtectedNetworksArgs', 'ApplianceSecurityIntrusionProtectedNetworksArgsDict']] protected_networks: Networks included in and excluded from the detection engine
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ApplianceSecurityIntrusionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ## Import

        ```sh
        $ pulumi import meraki:networks/applianceSecurityIntrusion:ApplianceSecurityIntrusion example "network_id"
        ```

        :param str resource_name: The name of the resource.
        :param ApplianceSecurityIntrusionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ApplianceSecurityIntrusionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ids_rulesets: Optional[pulumi.Input[str]] = None,
                 mode: Optional[pulumi.Input[str]] = None,
                 network_id: Optional[pulumi.Input[str]] = None,
                 protected_networks: Optional[pulumi.Input[Union['ApplianceSecurityIntrusionProtectedNetworksArgs', 'ApplianceSecurityIntrusionProtectedNetworksArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ApplianceSecurityIntrusionArgs.__new__(ApplianceSecurityIntrusionArgs)

            __props__.__dict__["ids_rulesets"] = ids_rulesets
            __props__.__dict__["mode"] = mode
            if network_id is None and not opts.urn:
                raise TypeError("Missing required property 'network_id'")
            __props__.__dict__["network_id"] = network_id
            __props__.__dict__["protected_networks"] = protected_networks
        super(ApplianceSecurityIntrusion, __self__).__init__(
            'meraki:networks/applianceSecurityIntrusion:ApplianceSecurityIntrusion',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            ids_rulesets: Optional[pulumi.Input[str]] = None,
            mode: Optional[pulumi.Input[str]] = None,
            network_id: Optional[pulumi.Input[str]] = None,
            protected_networks: Optional[pulumi.Input[Union['ApplianceSecurityIntrusionProtectedNetworksArgs', 'ApplianceSecurityIntrusionProtectedNetworksArgsDict']]] = None) -> 'ApplianceSecurityIntrusion':
        """
        Get an existing ApplianceSecurityIntrusion resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] ids_rulesets: Intrusion detection ruleset
        :param pulumi.Input[str] mode: Intrusion detection mode
        :param pulumi.Input[str] network_id: networkId path parameter. Network ID
        :param pulumi.Input[Union['ApplianceSecurityIntrusionProtectedNetworksArgs', 'ApplianceSecurityIntrusionProtectedNetworksArgsDict']] protected_networks: Networks included in and excluded from the detection engine
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ApplianceSecurityIntrusionState.__new__(_ApplianceSecurityIntrusionState)

        __props__.__dict__["ids_rulesets"] = ids_rulesets
        __props__.__dict__["mode"] = mode
        __props__.__dict__["network_id"] = network_id
        __props__.__dict__["protected_networks"] = protected_networks
        return ApplianceSecurityIntrusion(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="idsRulesets")
    def ids_rulesets(self) -> pulumi.Output[str]:
        """
        Intrusion detection ruleset
        """
        return pulumi.get(self, "ids_rulesets")

    @property
    @pulumi.getter
    def mode(self) -> pulumi.Output[str]:
        """
        Intrusion detection mode
        """
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Output[str]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

    @property
    @pulumi.getter(name="protectedNetworks")
    def protected_networks(self) -> pulumi.Output['outputs.ApplianceSecurityIntrusionProtectedNetworks']:
        """
        Networks included in and excluded from the detection engine
        """
        return pulumi.get(self, "protected_networks")

