# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ClientsPolicyArgs', 'ClientsPolicy']

@pulumi.input_type
class ClientsPolicyArgs:
    def __init__(__self__, *,
                 client_id: pulumi.Input[str],
                 network_id: pulumi.Input[str],
                 device_policy: Optional[pulumi.Input[str]] = None,
                 group_policy_id: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a ClientsPolicy resource.
        :param pulumi.Input[str] client_id: clientId path parameter. Client ID
        :param pulumi.Input[str] network_id: networkId path parameter. Network ID
        :param pulumi.Input[str] device_policy: The name of the client's policy
        :param pulumi.Input[str] group_policy_id: The group policy identifier of the client
        """
        pulumi.set(__self__, "client_id", client_id)
        pulumi.set(__self__, "network_id", network_id)
        if device_policy is not None:
            pulumi.set(__self__, "device_policy", device_policy)
        if group_policy_id is not None:
            pulumi.set(__self__, "group_policy_id", group_policy_id)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> pulumi.Input[str]:
        """
        clientId path parameter. Client ID
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "client_id", value)

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Input[str]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "network_id", value)

    @property
    @pulumi.getter(name="devicePolicy")
    def device_policy(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the client's policy
        """
        return pulumi.get(self, "device_policy")

    @device_policy.setter
    def device_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "device_policy", value)

    @property
    @pulumi.getter(name="groupPolicyId")
    def group_policy_id(self) -> Optional[pulumi.Input[str]]:
        """
        The group policy identifier of the client
        """
        return pulumi.get(self, "group_policy_id")

    @group_policy_id.setter
    def group_policy_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "group_policy_id", value)


@pulumi.input_type
class _ClientsPolicyState:
    def __init__(__self__, *,
                 client_id: Optional[pulumi.Input[str]] = None,
                 device_policy: Optional[pulumi.Input[str]] = None,
                 group_policy_id: Optional[pulumi.Input[str]] = None,
                 mac: Optional[pulumi.Input[str]] = None,
                 network_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering ClientsPolicy resources.
        :param pulumi.Input[str] client_id: clientId path parameter. Client ID
        :param pulumi.Input[str] device_policy: The name of the client's policy
        :param pulumi.Input[str] group_policy_id: The group policy identifier of the client
        :param pulumi.Input[str] mac: The MAC address of the client
        :param pulumi.Input[str] network_id: networkId path parameter. Network ID
        """
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if device_policy is not None:
            pulumi.set(__self__, "device_policy", device_policy)
        if group_policy_id is not None:
            pulumi.set(__self__, "group_policy_id", group_policy_id)
        if mac is not None:
            pulumi.set(__self__, "mac", mac)
        if network_id is not None:
            pulumi.set(__self__, "network_id", network_id)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[pulumi.Input[str]]:
        """
        clientId path parameter. Client ID
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_id", value)

    @property
    @pulumi.getter(name="devicePolicy")
    def device_policy(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the client's policy
        """
        return pulumi.get(self, "device_policy")

    @device_policy.setter
    def device_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "device_policy", value)

    @property
    @pulumi.getter(name="groupPolicyId")
    def group_policy_id(self) -> Optional[pulumi.Input[str]]:
        """
        The group policy identifier of the client
        """
        return pulumi.get(self, "group_policy_id")

    @group_policy_id.setter
    def group_policy_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "group_policy_id", value)

    @property
    @pulumi.getter
    def mac(self) -> Optional[pulumi.Input[str]]:
        """
        The MAC address of the client
        """
        return pulumi.get(self, "mac")

    @mac.setter
    def mac(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mac", value)

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> Optional[pulumi.Input[str]]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network_id", value)


class ClientsPolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 client_id: Optional[pulumi.Input[str]] = None,
                 device_policy: Optional[pulumi.Input[str]] = None,
                 group_policy_id: Optional[pulumi.Input[str]] = None,
                 network_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_meraki as meraki

        example = meraki.networks.ClientsPolicy("example",
            client_id="string",
            device_policy="Group policy",
            group_policy_id="101",
            network_id="string")
        pulumi.export("merakiNetworksClientsPolicyExample", example)
        ```

        ## Import

        ```sh
        $ pulumi import meraki:networks/clientsPolicy:ClientsPolicy example "client_id,network_id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] client_id: clientId path parameter. Client ID
        :param pulumi.Input[str] device_policy: The name of the client's policy
        :param pulumi.Input[str] group_policy_id: The group policy identifier of the client
        :param pulumi.Input[str] network_id: networkId path parameter. Network ID
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ClientsPolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_meraki as meraki

        example = meraki.networks.ClientsPolicy("example",
            client_id="string",
            device_policy="Group policy",
            group_policy_id="101",
            network_id="string")
        pulumi.export("merakiNetworksClientsPolicyExample", example)
        ```

        ## Import

        ```sh
        $ pulumi import meraki:networks/clientsPolicy:ClientsPolicy example "client_id,network_id"
        ```

        :param str resource_name: The name of the resource.
        :param ClientsPolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ClientsPolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 client_id: Optional[pulumi.Input[str]] = None,
                 device_policy: Optional[pulumi.Input[str]] = None,
                 group_policy_id: Optional[pulumi.Input[str]] = None,
                 network_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ClientsPolicyArgs.__new__(ClientsPolicyArgs)

            if client_id is None and not opts.urn:
                raise TypeError("Missing required property 'client_id'")
            __props__.__dict__["client_id"] = client_id
            __props__.__dict__["device_policy"] = device_policy
            __props__.__dict__["group_policy_id"] = group_policy_id
            if network_id is None and not opts.urn:
                raise TypeError("Missing required property 'network_id'")
            __props__.__dict__["network_id"] = network_id
            __props__.__dict__["mac"] = None
        super(ClientsPolicy, __self__).__init__(
            'meraki:networks/clientsPolicy:ClientsPolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            client_id: Optional[pulumi.Input[str]] = None,
            device_policy: Optional[pulumi.Input[str]] = None,
            group_policy_id: Optional[pulumi.Input[str]] = None,
            mac: Optional[pulumi.Input[str]] = None,
            network_id: Optional[pulumi.Input[str]] = None) -> 'ClientsPolicy':
        """
        Get an existing ClientsPolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] client_id: clientId path parameter. Client ID
        :param pulumi.Input[str] device_policy: The name of the client's policy
        :param pulumi.Input[str] group_policy_id: The group policy identifier of the client
        :param pulumi.Input[str] mac: The MAC address of the client
        :param pulumi.Input[str] network_id: networkId path parameter. Network ID
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ClientsPolicyState.__new__(_ClientsPolicyState)

        __props__.__dict__["client_id"] = client_id
        __props__.__dict__["device_policy"] = device_policy
        __props__.__dict__["group_policy_id"] = group_policy_id
        __props__.__dict__["mac"] = mac
        __props__.__dict__["network_id"] = network_id
        return ClientsPolicy(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> pulumi.Output[str]:
        """
        clientId path parameter. Client ID
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="devicePolicy")
    def device_policy(self) -> pulumi.Output[str]:
        """
        The name of the client's policy
        """
        return pulumi.get(self, "device_policy")

    @property
    @pulumi.getter(name="groupPolicyId")
    def group_policy_id(self) -> pulumi.Output[str]:
        """
        The group policy identifier of the client
        """
        return pulumi.get(self, "group_policy_id")

    @property
    @pulumi.getter
    def mac(self) -> pulumi.Output[str]:
        """
        The MAC address of the client
        """
        return pulumi.get(self, "mac")

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Output[str]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

