# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['NetflowArgs', 'Netflow']

@pulumi.input_type
class NetflowArgs:
    def __init__(__self__, *,
                 network_id: pulumi.Input[str],
                 collector_ip: Optional[pulumi.Input[str]] = None,
                 collector_port: Optional[pulumi.Input[int]] = None,
                 eta_dst_port: Optional[pulumi.Input[int]] = None,
                 eta_enabled: Optional[pulumi.Input[bool]] = None,
                 reporting_enabled: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a Netflow resource.
        :param pulumi.Input[str] network_id: networkId path parameter. Network ID
        :param pulumi.Input[str] collector_ip: The IPv4 address of the NetFlow collector.
        :param pulumi.Input[int] collector_port: The port that the NetFlow collector will be listening on.
        :param pulumi.Input[int] eta_dst_port: The port that the Encrypted Traffic Analytics collector will be listening on.
        :param pulumi.Input[bool] eta_enabled: Boolean indicating whether Encrypted Traffic Analytics is enabled (true) or disabled (false).
        :param pulumi.Input[bool] reporting_enabled: Boolean indicating whether NetFlow traffic reporting is enabled (true) or disabled (false).
        """
        pulumi.set(__self__, "network_id", network_id)
        if collector_ip is not None:
            pulumi.set(__self__, "collector_ip", collector_ip)
        if collector_port is not None:
            pulumi.set(__self__, "collector_port", collector_port)
        if eta_dst_port is not None:
            pulumi.set(__self__, "eta_dst_port", eta_dst_port)
        if eta_enabled is not None:
            pulumi.set(__self__, "eta_enabled", eta_enabled)
        if reporting_enabled is not None:
            pulumi.set(__self__, "reporting_enabled", reporting_enabled)

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Input[str]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "network_id", value)

    @property
    @pulumi.getter(name="collectorIp")
    def collector_ip(self) -> Optional[pulumi.Input[str]]:
        """
        The IPv4 address of the NetFlow collector.
        """
        return pulumi.get(self, "collector_ip")

    @collector_ip.setter
    def collector_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "collector_ip", value)

    @property
    @pulumi.getter(name="collectorPort")
    def collector_port(self) -> Optional[pulumi.Input[int]]:
        """
        The port that the NetFlow collector will be listening on.
        """
        return pulumi.get(self, "collector_port")

    @collector_port.setter
    def collector_port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "collector_port", value)

    @property
    @pulumi.getter(name="etaDstPort")
    def eta_dst_port(self) -> Optional[pulumi.Input[int]]:
        """
        The port that the Encrypted Traffic Analytics collector will be listening on.
        """
        return pulumi.get(self, "eta_dst_port")

    @eta_dst_port.setter
    def eta_dst_port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "eta_dst_port", value)

    @property
    @pulumi.getter(name="etaEnabled")
    def eta_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Boolean indicating whether Encrypted Traffic Analytics is enabled (true) or disabled (false).
        """
        return pulumi.get(self, "eta_enabled")

    @eta_enabled.setter
    def eta_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "eta_enabled", value)

    @property
    @pulumi.getter(name="reportingEnabled")
    def reporting_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Boolean indicating whether NetFlow traffic reporting is enabled (true) or disabled (false).
        """
        return pulumi.get(self, "reporting_enabled")

    @reporting_enabled.setter
    def reporting_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "reporting_enabled", value)


@pulumi.input_type
class _NetflowState:
    def __init__(__self__, *,
                 collector_ip: Optional[pulumi.Input[str]] = None,
                 collector_port: Optional[pulumi.Input[int]] = None,
                 eta_dst_port: Optional[pulumi.Input[int]] = None,
                 eta_enabled: Optional[pulumi.Input[bool]] = None,
                 network_id: Optional[pulumi.Input[str]] = None,
                 reporting_enabled: Optional[pulumi.Input[bool]] = None):
        """
        Input properties used for looking up and filtering Netflow resources.
        :param pulumi.Input[str] collector_ip: The IPv4 address of the NetFlow collector.
        :param pulumi.Input[int] collector_port: The port that the NetFlow collector will be listening on.
        :param pulumi.Input[int] eta_dst_port: The port that the Encrypted Traffic Analytics collector will be listening on.
        :param pulumi.Input[bool] eta_enabled: Boolean indicating whether Encrypted Traffic Analytics is enabled (true) or disabled (false).
        :param pulumi.Input[str] network_id: networkId path parameter. Network ID
        :param pulumi.Input[bool] reporting_enabled: Boolean indicating whether NetFlow traffic reporting is enabled (true) or disabled (false).
        """
        if collector_ip is not None:
            pulumi.set(__self__, "collector_ip", collector_ip)
        if collector_port is not None:
            pulumi.set(__self__, "collector_port", collector_port)
        if eta_dst_port is not None:
            pulumi.set(__self__, "eta_dst_port", eta_dst_port)
        if eta_enabled is not None:
            pulumi.set(__self__, "eta_enabled", eta_enabled)
        if network_id is not None:
            pulumi.set(__self__, "network_id", network_id)
        if reporting_enabled is not None:
            pulumi.set(__self__, "reporting_enabled", reporting_enabled)

    @property
    @pulumi.getter(name="collectorIp")
    def collector_ip(self) -> Optional[pulumi.Input[str]]:
        """
        The IPv4 address of the NetFlow collector.
        """
        return pulumi.get(self, "collector_ip")

    @collector_ip.setter
    def collector_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "collector_ip", value)

    @property
    @pulumi.getter(name="collectorPort")
    def collector_port(self) -> Optional[pulumi.Input[int]]:
        """
        The port that the NetFlow collector will be listening on.
        """
        return pulumi.get(self, "collector_port")

    @collector_port.setter
    def collector_port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "collector_port", value)

    @property
    @pulumi.getter(name="etaDstPort")
    def eta_dst_port(self) -> Optional[pulumi.Input[int]]:
        """
        The port that the Encrypted Traffic Analytics collector will be listening on.
        """
        return pulumi.get(self, "eta_dst_port")

    @eta_dst_port.setter
    def eta_dst_port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "eta_dst_port", value)

    @property
    @pulumi.getter(name="etaEnabled")
    def eta_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Boolean indicating whether Encrypted Traffic Analytics is enabled (true) or disabled (false).
        """
        return pulumi.get(self, "eta_enabled")

    @eta_enabled.setter
    def eta_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "eta_enabled", value)

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> Optional[pulumi.Input[str]]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network_id", value)

    @property
    @pulumi.getter(name="reportingEnabled")
    def reporting_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Boolean indicating whether NetFlow traffic reporting is enabled (true) or disabled (false).
        """
        return pulumi.get(self, "reporting_enabled")

    @reporting_enabled.setter
    def reporting_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "reporting_enabled", value)


class Netflow(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 collector_ip: Optional[pulumi.Input[str]] = None,
                 collector_port: Optional[pulumi.Input[int]] = None,
                 eta_dst_port: Optional[pulumi.Input[int]] = None,
                 eta_enabled: Optional[pulumi.Input[bool]] = None,
                 network_id: Optional[pulumi.Input[str]] = None,
                 reporting_enabled: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_meraki as meraki

        example = meraki.networks.Netflow("example",
            collector_ip="1.2.3.4",
            collector_port=443,
            eta_dst_port=443,
            eta_enabled=True,
            network_id="string",
            reporting_enabled=True)
        pulumi.export("merakiNetworksNetflowExample", example)
        ```

        ## Import

        ```sh
        $ pulumi import meraki:networks/netflow:Netflow example "network_id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] collector_ip: The IPv4 address of the NetFlow collector.
        :param pulumi.Input[int] collector_port: The port that the NetFlow collector will be listening on.
        :param pulumi.Input[int] eta_dst_port: The port that the Encrypted Traffic Analytics collector will be listening on.
        :param pulumi.Input[bool] eta_enabled: Boolean indicating whether Encrypted Traffic Analytics is enabled (true) or disabled (false).
        :param pulumi.Input[str] network_id: networkId path parameter. Network ID
        :param pulumi.Input[bool] reporting_enabled: Boolean indicating whether NetFlow traffic reporting is enabled (true) or disabled (false).
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NetflowArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_meraki as meraki

        example = meraki.networks.Netflow("example",
            collector_ip="1.2.3.4",
            collector_port=443,
            eta_dst_port=443,
            eta_enabled=True,
            network_id="string",
            reporting_enabled=True)
        pulumi.export("merakiNetworksNetflowExample", example)
        ```

        ## Import

        ```sh
        $ pulumi import meraki:networks/netflow:Netflow example "network_id"
        ```

        :param str resource_name: The name of the resource.
        :param NetflowArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NetflowArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 collector_ip: Optional[pulumi.Input[str]] = None,
                 collector_port: Optional[pulumi.Input[int]] = None,
                 eta_dst_port: Optional[pulumi.Input[int]] = None,
                 eta_enabled: Optional[pulumi.Input[bool]] = None,
                 network_id: Optional[pulumi.Input[str]] = None,
                 reporting_enabled: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NetflowArgs.__new__(NetflowArgs)

            __props__.__dict__["collector_ip"] = collector_ip
            __props__.__dict__["collector_port"] = collector_port
            __props__.__dict__["eta_dst_port"] = eta_dst_port
            __props__.__dict__["eta_enabled"] = eta_enabled
            if network_id is None and not opts.urn:
                raise TypeError("Missing required property 'network_id'")
            __props__.__dict__["network_id"] = network_id
            __props__.__dict__["reporting_enabled"] = reporting_enabled
        super(Netflow, __self__).__init__(
            'meraki:networks/netflow:Netflow',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            collector_ip: Optional[pulumi.Input[str]] = None,
            collector_port: Optional[pulumi.Input[int]] = None,
            eta_dst_port: Optional[pulumi.Input[int]] = None,
            eta_enabled: Optional[pulumi.Input[bool]] = None,
            network_id: Optional[pulumi.Input[str]] = None,
            reporting_enabled: Optional[pulumi.Input[bool]] = None) -> 'Netflow':
        """
        Get an existing Netflow resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] collector_ip: The IPv4 address of the NetFlow collector.
        :param pulumi.Input[int] collector_port: The port that the NetFlow collector will be listening on.
        :param pulumi.Input[int] eta_dst_port: The port that the Encrypted Traffic Analytics collector will be listening on.
        :param pulumi.Input[bool] eta_enabled: Boolean indicating whether Encrypted Traffic Analytics is enabled (true) or disabled (false).
        :param pulumi.Input[str] network_id: networkId path parameter. Network ID
        :param pulumi.Input[bool] reporting_enabled: Boolean indicating whether NetFlow traffic reporting is enabled (true) or disabled (false).
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NetflowState.__new__(_NetflowState)

        __props__.__dict__["collector_ip"] = collector_ip
        __props__.__dict__["collector_port"] = collector_port
        __props__.__dict__["eta_dst_port"] = eta_dst_port
        __props__.__dict__["eta_enabled"] = eta_enabled
        __props__.__dict__["network_id"] = network_id
        __props__.__dict__["reporting_enabled"] = reporting_enabled
        return Netflow(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="collectorIp")
    def collector_ip(self) -> pulumi.Output[str]:
        """
        The IPv4 address of the NetFlow collector.
        """
        return pulumi.get(self, "collector_ip")

    @property
    @pulumi.getter(name="collectorPort")
    def collector_port(self) -> pulumi.Output[int]:
        """
        The port that the NetFlow collector will be listening on.
        """
        return pulumi.get(self, "collector_port")

    @property
    @pulumi.getter(name="etaDstPort")
    def eta_dst_port(self) -> pulumi.Output[int]:
        """
        The port that the Encrypted Traffic Analytics collector will be listening on.
        """
        return pulumi.get(self, "eta_dst_port")

    @property
    @pulumi.getter(name="etaEnabled")
    def eta_enabled(self) -> pulumi.Output[bool]:
        """
        Boolean indicating whether Encrypted Traffic Analytics is enabled (true) or disabled (false).
        """
        return pulumi.get(self, "eta_enabled")

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Output[str]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

    @property
    @pulumi.getter(name="reportingEnabled")
    def reporting_enabled(self) -> pulumi.Output[bool]:
        """
        Boolean indicating whether NetFlow traffic reporting is enabled (true) or disabled (false).
        """
        return pulumi.get(self, "reporting_enabled")

