# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['SwitchStacksArgs', 'SwitchStacks']

@pulumi.input_type
class SwitchStacksArgs:
    def __init__(__self__, *,
                 network_id: pulumi.Input[str],
                 name: Optional[pulumi.Input[str]] = None,
                 serials: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 switch_stack_id: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a SwitchStacks resource.
        :param pulumi.Input[str] network_id: networkId path parameter. Network ID
        :param pulumi.Input[str] name: Name of the Switch stack
        :param pulumi.Input[Sequence[pulumi.Input[str]]] serials: Serials of the switches in the switch stack
        :param pulumi.Input[str] switch_stack_id: switchStackId path parameter. Switch stack ID
        """
        pulumi.set(__self__, "network_id", network_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if serials is not None:
            pulumi.set(__self__, "serials", serials)
        if switch_stack_id is not None:
            pulumi.set(__self__, "switch_stack_id", switch_stack_id)

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Input[str]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "network_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the Switch stack
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def serials(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Serials of the switches in the switch stack
        """
        return pulumi.get(self, "serials")

    @serials.setter
    def serials(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "serials", value)

    @property
    @pulumi.getter(name="switchStackId")
    def switch_stack_id(self) -> Optional[pulumi.Input[str]]:
        """
        switchStackId path parameter. Switch stack ID
        """
        return pulumi.get(self, "switch_stack_id")

    @switch_stack_id.setter
    def switch_stack_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "switch_stack_id", value)


@pulumi.input_type
class _SwitchStacksState:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 network_id: Optional[pulumi.Input[str]] = None,
                 serials: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 switch_stack_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering SwitchStacks resources.
        :param pulumi.Input[str] name: Name of the Switch stack
        :param pulumi.Input[str] network_id: networkId path parameter. Network ID
        :param pulumi.Input[Sequence[pulumi.Input[str]]] serials: Serials of the switches in the switch stack
        :param pulumi.Input[str] switch_stack_id: switchStackId path parameter. Switch stack ID
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_id is not None:
            pulumi.set(__self__, "network_id", network_id)
        if serials is not None:
            pulumi.set(__self__, "serials", serials)
        if switch_stack_id is not None:
            pulumi.set(__self__, "switch_stack_id", switch_stack_id)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the Switch stack
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> Optional[pulumi.Input[str]]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network_id", value)

    @property
    @pulumi.getter
    def serials(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Serials of the switches in the switch stack
        """
        return pulumi.get(self, "serials")

    @serials.setter
    def serials(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "serials", value)

    @property
    @pulumi.getter(name="switchStackId")
    def switch_stack_id(self) -> Optional[pulumi.Input[str]]:
        """
        switchStackId path parameter. Switch stack ID
        """
        return pulumi.get(self, "switch_stack_id")

    @switch_stack_id.setter
    def switch_stack_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "switch_stack_id", value)


class SwitchStacks(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network_id: Optional[pulumi.Input[str]] = None,
                 serials: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 switch_stack_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_meraki as meraki

        example = meraki.networks.SwitchStacks("example",
            name="A cool stack",
            network_id="string",
            serials=[
                "QBZY-XWVU-TSRQ",
                "QBAB-CDEF-GHIJ",
            ])
        pulumi.export("merakiNetworksSwitchStacksExample", example)
        ```

        ## Import

        ```sh
        $ pulumi import meraki:networks/switchStacks:SwitchStacks example "network_id,switch_stack_id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] name: Name of the Switch stack
        :param pulumi.Input[str] network_id: networkId path parameter. Network ID
        :param pulumi.Input[Sequence[pulumi.Input[str]]] serials: Serials of the switches in the switch stack
        :param pulumi.Input[str] switch_stack_id: switchStackId path parameter. Switch stack ID
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SwitchStacksArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_meraki as meraki

        example = meraki.networks.SwitchStacks("example",
            name="A cool stack",
            network_id="string",
            serials=[
                "QBZY-XWVU-TSRQ",
                "QBAB-CDEF-GHIJ",
            ])
        pulumi.export("merakiNetworksSwitchStacksExample", example)
        ```

        ## Import

        ```sh
        $ pulumi import meraki:networks/switchStacks:SwitchStacks example "network_id,switch_stack_id"
        ```

        :param str resource_name: The name of the resource.
        :param SwitchStacksArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SwitchStacksArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network_id: Optional[pulumi.Input[str]] = None,
                 serials: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 switch_stack_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SwitchStacksArgs.__new__(SwitchStacksArgs)

            __props__.__dict__["name"] = name
            if network_id is None and not opts.urn:
                raise TypeError("Missing required property 'network_id'")
            __props__.__dict__["network_id"] = network_id
            __props__.__dict__["serials"] = serials
            __props__.__dict__["switch_stack_id"] = switch_stack_id
        super(SwitchStacks, __self__).__init__(
            'meraki:networks/switchStacks:SwitchStacks',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            name: Optional[pulumi.Input[str]] = None,
            network_id: Optional[pulumi.Input[str]] = None,
            serials: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            switch_stack_id: Optional[pulumi.Input[str]] = None) -> 'SwitchStacks':
        """
        Get an existing SwitchStacks resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] name: Name of the Switch stack
        :param pulumi.Input[str] network_id: networkId path parameter. Network ID
        :param pulumi.Input[Sequence[pulumi.Input[str]]] serials: Serials of the switches in the switch stack
        :param pulumi.Input[str] switch_stack_id: switchStackId path parameter. Switch stack ID
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SwitchStacksState.__new__(_SwitchStacksState)

        __props__.__dict__["name"] = name
        __props__.__dict__["network_id"] = network_id
        __props__.__dict__["serials"] = serials
        __props__.__dict__["switch_stack_id"] = switch_stack_id
        return SwitchStacks(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of the Switch stack
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Output[str]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

    @property
    @pulumi.getter
    def serials(self) -> pulumi.Output[Sequence[str]]:
        """
        Serials of the switches in the switch stack
        """
        return pulumi.get(self, "serials")

    @property
    @pulumi.getter(name="switchStackId")
    def switch_stack_id(self) -> pulumi.Output[str]:
        """
        switchStackId path parameter. Switch stack ID
        """
        return pulumi.get(self, "switch_stack_id")

