# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['WirelessAlternateManagementInterfaceArgs', 'WirelessAlternateManagementInterface']

@pulumi.input_type
class WirelessAlternateManagementInterfaceArgs:
    def __init__(__self__, *,
                 network_id: pulumi.Input[str],
                 access_points: Optional[pulumi.Input[Sequence[pulumi.Input['WirelessAlternateManagementInterfaceAccessPointArgs']]]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 protocols: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 vlan_id: Optional[pulumi.Input[int]] = None):
        """
        The set of arguments for constructing a WirelessAlternateManagementInterface resource.
        :param pulumi.Input[str] network_id: networkId path parameter. Network ID
        :param pulumi.Input[Sequence[pulumi.Input['WirelessAlternateManagementInterfaceAccessPointArgs']]] access_points: Array of access point serial number and IP assignment. Note: accessPoints IP assignment is not applicable for template networks, in other words, do not put 'accessPoints' in the body when updating template networks. Also, an empty 'accessPoints' array will remove all previous static IP assignments
        :param pulumi.Input[bool] enabled: Boolean value to enable or disable alternate management interface
        :param pulumi.Input[Sequence[pulumi.Input[str]]] protocols: Can be one or more of the following values: 'radius', 'snmp', 'syslog' or 'ldap'
        :param pulumi.Input[int] vlan_id: Alternate management interface VLAN, must be between 1 and 4094
        """
        pulumi.set(__self__, "network_id", network_id)
        if access_points is not None:
            pulumi.set(__self__, "access_points", access_points)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if protocols is not None:
            pulumi.set(__self__, "protocols", protocols)
        if vlan_id is not None:
            pulumi.set(__self__, "vlan_id", vlan_id)

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Input[str]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "network_id", value)

    @property
    @pulumi.getter(name="accessPoints")
    def access_points(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WirelessAlternateManagementInterfaceAccessPointArgs']]]]:
        """
        Array of access point serial number and IP assignment. Note: accessPoints IP assignment is not applicable for template networks, in other words, do not put 'accessPoints' in the body when updating template networks. Also, an empty 'accessPoints' array will remove all previous static IP assignments
        """
        return pulumi.get(self, "access_points")

    @access_points.setter
    def access_points(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WirelessAlternateManagementInterfaceAccessPointArgs']]]]):
        pulumi.set(self, "access_points", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Boolean value to enable or disable alternate management interface
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def protocols(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Can be one or more of the following values: 'radius', 'snmp', 'syslog' or 'ldap'
        """
        return pulumi.get(self, "protocols")

    @protocols.setter
    def protocols(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "protocols", value)

    @property
    @pulumi.getter(name="vlanId")
    def vlan_id(self) -> Optional[pulumi.Input[int]]:
        """
        Alternate management interface VLAN, must be between 1 and 4094
        """
        return pulumi.get(self, "vlan_id")

    @vlan_id.setter
    def vlan_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "vlan_id", value)


@pulumi.input_type
class _WirelessAlternateManagementInterfaceState:
    def __init__(__self__, *,
                 access_points: Optional[pulumi.Input[Sequence[pulumi.Input['WirelessAlternateManagementInterfaceAccessPointArgs']]]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 network_id: Optional[pulumi.Input[str]] = None,
                 protocols: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 vlan_id: Optional[pulumi.Input[int]] = None):
        """
        Input properties used for looking up and filtering WirelessAlternateManagementInterface resources.
        :param pulumi.Input[Sequence[pulumi.Input['WirelessAlternateManagementInterfaceAccessPointArgs']]] access_points: Array of access point serial number and IP assignment. Note: accessPoints IP assignment is not applicable for template networks, in other words, do not put 'accessPoints' in the body when updating template networks. Also, an empty 'accessPoints' array will remove all previous static IP assignments
        :param pulumi.Input[bool] enabled: Boolean value to enable or disable alternate management interface
        :param pulumi.Input[str] network_id: networkId path parameter. Network ID
        :param pulumi.Input[Sequence[pulumi.Input[str]]] protocols: Can be one or more of the following values: 'radius', 'snmp', 'syslog' or 'ldap'
        :param pulumi.Input[int] vlan_id: Alternate management interface VLAN, must be between 1 and 4094
        """
        if access_points is not None:
            pulumi.set(__self__, "access_points", access_points)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if network_id is not None:
            pulumi.set(__self__, "network_id", network_id)
        if protocols is not None:
            pulumi.set(__self__, "protocols", protocols)
        if vlan_id is not None:
            pulumi.set(__self__, "vlan_id", vlan_id)

    @property
    @pulumi.getter(name="accessPoints")
    def access_points(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WirelessAlternateManagementInterfaceAccessPointArgs']]]]:
        """
        Array of access point serial number and IP assignment. Note: accessPoints IP assignment is not applicable for template networks, in other words, do not put 'accessPoints' in the body when updating template networks. Also, an empty 'accessPoints' array will remove all previous static IP assignments
        """
        return pulumi.get(self, "access_points")

    @access_points.setter
    def access_points(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WirelessAlternateManagementInterfaceAccessPointArgs']]]]):
        pulumi.set(self, "access_points", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Boolean value to enable or disable alternate management interface
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> Optional[pulumi.Input[str]]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network_id", value)

    @property
    @pulumi.getter
    def protocols(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Can be one or more of the following values: 'radius', 'snmp', 'syslog' or 'ldap'
        """
        return pulumi.get(self, "protocols")

    @protocols.setter
    def protocols(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "protocols", value)

    @property
    @pulumi.getter(name="vlanId")
    def vlan_id(self) -> Optional[pulumi.Input[int]]:
        """
        Alternate management interface VLAN, must be between 1 and 4094
        """
        return pulumi.get(self, "vlan_id")

    @vlan_id.setter
    def vlan_id(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "vlan_id", value)


class WirelessAlternateManagementInterface(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_points: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WirelessAlternateManagementInterfaceAccessPointArgs', 'WirelessAlternateManagementInterfaceAccessPointArgsDict']]]]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 network_id: Optional[pulumi.Input[str]] = None,
                 protocols: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 vlan_id: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        """
        ## Example Usage

        ## Import

        ```sh
        $ pulumi import meraki:networks/wirelessAlternateManagementInterface:WirelessAlternateManagementInterface example "network_id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['WirelessAlternateManagementInterfaceAccessPointArgs', 'WirelessAlternateManagementInterfaceAccessPointArgsDict']]]] access_points: Array of access point serial number and IP assignment. Note: accessPoints IP assignment is not applicable for template networks, in other words, do not put 'accessPoints' in the body when updating template networks. Also, an empty 'accessPoints' array will remove all previous static IP assignments
        :param pulumi.Input[bool] enabled: Boolean value to enable or disable alternate management interface
        :param pulumi.Input[str] network_id: networkId path parameter. Network ID
        :param pulumi.Input[Sequence[pulumi.Input[str]]] protocols: Can be one or more of the following values: 'radius', 'snmp', 'syslog' or 'ldap'
        :param pulumi.Input[int] vlan_id: Alternate management interface VLAN, must be between 1 and 4094
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: WirelessAlternateManagementInterfaceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ## Import

        ```sh
        $ pulumi import meraki:networks/wirelessAlternateManagementInterface:WirelessAlternateManagementInterface example "network_id"
        ```

        :param str resource_name: The name of the resource.
        :param WirelessAlternateManagementInterfaceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(WirelessAlternateManagementInterfaceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_points: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WirelessAlternateManagementInterfaceAccessPointArgs', 'WirelessAlternateManagementInterfaceAccessPointArgsDict']]]]] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 network_id: Optional[pulumi.Input[str]] = None,
                 protocols: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 vlan_id: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = WirelessAlternateManagementInterfaceArgs.__new__(WirelessAlternateManagementInterfaceArgs)

            __props__.__dict__["access_points"] = access_points
            __props__.__dict__["enabled"] = enabled
            if network_id is None and not opts.urn:
                raise TypeError("Missing required property 'network_id'")
            __props__.__dict__["network_id"] = network_id
            __props__.__dict__["protocols"] = protocols
            __props__.__dict__["vlan_id"] = vlan_id
        super(WirelessAlternateManagementInterface, __self__).__init__(
            'meraki:networks/wirelessAlternateManagementInterface:WirelessAlternateManagementInterface',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_points: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WirelessAlternateManagementInterfaceAccessPointArgs', 'WirelessAlternateManagementInterfaceAccessPointArgsDict']]]]] = None,
            enabled: Optional[pulumi.Input[bool]] = None,
            network_id: Optional[pulumi.Input[str]] = None,
            protocols: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            vlan_id: Optional[pulumi.Input[int]] = None) -> 'WirelessAlternateManagementInterface':
        """
        Get an existing WirelessAlternateManagementInterface resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['WirelessAlternateManagementInterfaceAccessPointArgs', 'WirelessAlternateManagementInterfaceAccessPointArgsDict']]]] access_points: Array of access point serial number and IP assignment. Note: accessPoints IP assignment is not applicable for template networks, in other words, do not put 'accessPoints' in the body when updating template networks. Also, an empty 'accessPoints' array will remove all previous static IP assignments
        :param pulumi.Input[bool] enabled: Boolean value to enable or disable alternate management interface
        :param pulumi.Input[str] network_id: networkId path parameter. Network ID
        :param pulumi.Input[Sequence[pulumi.Input[str]]] protocols: Can be one or more of the following values: 'radius', 'snmp', 'syslog' or 'ldap'
        :param pulumi.Input[int] vlan_id: Alternate management interface VLAN, must be between 1 and 4094
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _WirelessAlternateManagementInterfaceState.__new__(_WirelessAlternateManagementInterfaceState)

        __props__.__dict__["access_points"] = access_points
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["network_id"] = network_id
        __props__.__dict__["protocols"] = protocols
        __props__.__dict__["vlan_id"] = vlan_id
        return WirelessAlternateManagementInterface(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accessPoints")
    def access_points(self) -> pulumi.Output[Sequence['outputs.WirelessAlternateManagementInterfaceAccessPoint']]:
        """
        Array of access point serial number and IP assignment. Note: accessPoints IP assignment is not applicable for template networks, in other words, do not put 'accessPoints' in the body when updating template networks. Also, an empty 'accessPoints' array will remove all previous static IP assignments
        """
        return pulumi.get(self, "access_points")

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[bool]:
        """
        Boolean value to enable or disable alternate management interface
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Output[str]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

    @property
    @pulumi.getter
    def protocols(self) -> pulumi.Output[Sequence[str]]:
        """
        Can be one or more of the following values: 'radius', 'snmp', 'syslog' or 'ldap'
        """
        return pulumi.get(self, "protocols")

    @property
    @pulumi.getter(name="vlanId")
    def vlan_id(self) -> pulumi.Output[int]:
        """
        Alternate management interface VLAN, must be between 1 and 4094
        """
        return pulumi.get(self, "vlan_id")

