# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['WirelessSsidsVpnArgs', 'WirelessSsidsVpn']

@pulumi.input_type
class WirelessSsidsVpnArgs:
    def __init__(__self__, *,
                 network_id: pulumi.Input[str],
                 number: pulumi.Input[str],
                 concentrator: Optional[pulumi.Input['WirelessSsidsVpnConcentratorArgs']] = None,
                 failover: Optional[pulumi.Input['WirelessSsidsVpnFailoverArgs']] = None,
                 split_tunnel: Optional[pulumi.Input['WirelessSsidsVpnSplitTunnelArgs']] = None):
        """
        The set of arguments for constructing a WirelessSsidsVpn resource.
        :param pulumi.Input[str] network_id: networkId path parameter. Network ID
        :param pulumi.Input[str] number: number path parameter.
        :param pulumi.Input['WirelessSsidsVpnConcentratorArgs'] concentrator: The VPN concentrator settings for this SSID.
        :param pulumi.Input['WirelessSsidsVpnFailoverArgs'] failover: Secondary VPN concentrator settings. This is only used when two VPN concentrators are configured on the SSID.
        :param pulumi.Input['WirelessSsidsVpnSplitTunnelArgs'] split_tunnel: The VPN split tunnel settings for this SSID.
        """
        pulumi.set(__self__, "network_id", network_id)
        pulumi.set(__self__, "number", number)
        if concentrator is not None:
            pulumi.set(__self__, "concentrator", concentrator)
        if failover is not None:
            pulumi.set(__self__, "failover", failover)
        if split_tunnel is not None:
            pulumi.set(__self__, "split_tunnel", split_tunnel)

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Input[str]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "network_id", value)

    @property
    @pulumi.getter
    def number(self) -> pulumi.Input[str]:
        """
        number path parameter.
        """
        return pulumi.get(self, "number")

    @number.setter
    def number(self, value: pulumi.Input[str]):
        pulumi.set(self, "number", value)

    @property
    @pulumi.getter
    def concentrator(self) -> Optional[pulumi.Input['WirelessSsidsVpnConcentratorArgs']]:
        """
        The VPN concentrator settings for this SSID.
        """
        return pulumi.get(self, "concentrator")

    @concentrator.setter
    def concentrator(self, value: Optional[pulumi.Input['WirelessSsidsVpnConcentratorArgs']]):
        pulumi.set(self, "concentrator", value)

    @property
    @pulumi.getter
    def failover(self) -> Optional[pulumi.Input['WirelessSsidsVpnFailoverArgs']]:
        """
        Secondary VPN concentrator settings. This is only used when two VPN concentrators are configured on the SSID.
        """
        return pulumi.get(self, "failover")

    @failover.setter
    def failover(self, value: Optional[pulumi.Input['WirelessSsidsVpnFailoverArgs']]):
        pulumi.set(self, "failover", value)

    @property
    @pulumi.getter(name="splitTunnel")
    def split_tunnel(self) -> Optional[pulumi.Input['WirelessSsidsVpnSplitTunnelArgs']]:
        """
        The VPN split tunnel settings for this SSID.
        """
        return pulumi.get(self, "split_tunnel")

    @split_tunnel.setter
    def split_tunnel(self, value: Optional[pulumi.Input['WirelessSsidsVpnSplitTunnelArgs']]):
        pulumi.set(self, "split_tunnel", value)


@pulumi.input_type
class _WirelessSsidsVpnState:
    def __init__(__self__, *,
                 concentrator: Optional[pulumi.Input['WirelessSsidsVpnConcentratorArgs']] = None,
                 failover: Optional[pulumi.Input['WirelessSsidsVpnFailoverArgs']] = None,
                 network_id: Optional[pulumi.Input[str]] = None,
                 number: Optional[pulumi.Input[str]] = None,
                 split_tunnel: Optional[pulumi.Input['WirelessSsidsVpnSplitTunnelArgs']] = None):
        """
        Input properties used for looking up and filtering WirelessSsidsVpn resources.
        :param pulumi.Input['WirelessSsidsVpnConcentratorArgs'] concentrator: The VPN concentrator settings for this SSID.
        :param pulumi.Input['WirelessSsidsVpnFailoverArgs'] failover: Secondary VPN concentrator settings. This is only used when two VPN concentrators are configured on the SSID.
        :param pulumi.Input[str] network_id: networkId path parameter. Network ID
        :param pulumi.Input[str] number: number path parameter.
        :param pulumi.Input['WirelessSsidsVpnSplitTunnelArgs'] split_tunnel: The VPN split tunnel settings for this SSID.
        """
        if concentrator is not None:
            pulumi.set(__self__, "concentrator", concentrator)
        if failover is not None:
            pulumi.set(__self__, "failover", failover)
        if network_id is not None:
            pulumi.set(__self__, "network_id", network_id)
        if number is not None:
            pulumi.set(__self__, "number", number)
        if split_tunnel is not None:
            pulumi.set(__self__, "split_tunnel", split_tunnel)

    @property
    @pulumi.getter
    def concentrator(self) -> Optional[pulumi.Input['WirelessSsidsVpnConcentratorArgs']]:
        """
        The VPN concentrator settings for this SSID.
        """
        return pulumi.get(self, "concentrator")

    @concentrator.setter
    def concentrator(self, value: Optional[pulumi.Input['WirelessSsidsVpnConcentratorArgs']]):
        pulumi.set(self, "concentrator", value)

    @property
    @pulumi.getter
    def failover(self) -> Optional[pulumi.Input['WirelessSsidsVpnFailoverArgs']]:
        """
        Secondary VPN concentrator settings. This is only used when two VPN concentrators are configured on the SSID.
        """
        return pulumi.get(self, "failover")

    @failover.setter
    def failover(self, value: Optional[pulumi.Input['WirelessSsidsVpnFailoverArgs']]):
        pulumi.set(self, "failover", value)

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> Optional[pulumi.Input[str]]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network_id", value)

    @property
    @pulumi.getter
    def number(self) -> Optional[pulumi.Input[str]]:
        """
        number path parameter.
        """
        return pulumi.get(self, "number")

    @number.setter
    def number(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "number", value)

    @property
    @pulumi.getter(name="splitTunnel")
    def split_tunnel(self) -> Optional[pulumi.Input['WirelessSsidsVpnSplitTunnelArgs']]:
        """
        The VPN split tunnel settings for this SSID.
        """
        return pulumi.get(self, "split_tunnel")

    @split_tunnel.setter
    def split_tunnel(self, value: Optional[pulumi.Input['WirelessSsidsVpnSplitTunnelArgs']]):
        pulumi.set(self, "split_tunnel", value)


class WirelessSsidsVpn(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 concentrator: Optional[pulumi.Input[Union['WirelessSsidsVpnConcentratorArgs', 'WirelessSsidsVpnConcentratorArgsDict']]] = None,
                 failover: Optional[pulumi.Input[Union['WirelessSsidsVpnFailoverArgs', 'WirelessSsidsVpnFailoverArgsDict']]] = None,
                 network_id: Optional[pulumi.Input[str]] = None,
                 number: Optional[pulumi.Input[str]] = None,
                 split_tunnel: Optional[pulumi.Input[Union['WirelessSsidsVpnSplitTunnelArgs', 'WirelessSsidsVpnSplitTunnelArgsDict']]] = None,
                 __props__=None):
        """
        ## Example Usage

        ## Import

        ```sh
        $ pulumi import meraki:networks/wirelessSsidsVpn:WirelessSsidsVpn example "network_id,number"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['WirelessSsidsVpnConcentratorArgs', 'WirelessSsidsVpnConcentratorArgsDict']] concentrator: The VPN concentrator settings for this SSID.
        :param pulumi.Input[Union['WirelessSsidsVpnFailoverArgs', 'WirelessSsidsVpnFailoverArgsDict']] failover: Secondary VPN concentrator settings. This is only used when two VPN concentrators are configured on the SSID.
        :param pulumi.Input[str] network_id: networkId path parameter. Network ID
        :param pulumi.Input[str] number: number path parameter.
        :param pulumi.Input[Union['WirelessSsidsVpnSplitTunnelArgs', 'WirelessSsidsVpnSplitTunnelArgsDict']] split_tunnel: The VPN split tunnel settings for this SSID.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: WirelessSsidsVpnArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ## Import

        ```sh
        $ pulumi import meraki:networks/wirelessSsidsVpn:WirelessSsidsVpn example "network_id,number"
        ```

        :param str resource_name: The name of the resource.
        :param WirelessSsidsVpnArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(WirelessSsidsVpnArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 concentrator: Optional[pulumi.Input[Union['WirelessSsidsVpnConcentratorArgs', 'WirelessSsidsVpnConcentratorArgsDict']]] = None,
                 failover: Optional[pulumi.Input[Union['WirelessSsidsVpnFailoverArgs', 'WirelessSsidsVpnFailoverArgsDict']]] = None,
                 network_id: Optional[pulumi.Input[str]] = None,
                 number: Optional[pulumi.Input[str]] = None,
                 split_tunnel: Optional[pulumi.Input[Union['WirelessSsidsVpnSplitTunnelArgs', 'WirelessSsidsVpnSplitTunnelArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = WirelessSsidsVpnArgs.__new__(WirelessSsidsVpnArgs)

            __props__.__dict__["concentrator"] = concentrator
            __props__.__dict__["failover"] = failover
            if network_id is None and not opts.urn:
                raise TypeError("Missing required property 'network_id'")
            __props__.__dict__["network_id"] = network_id
            if number is None and not opts.urn:
                raise TypeError("Missing required property 'number'")
            __props__.__dict__["number"] = number
            __props__.__dict__["split_tunnel"] = split_tunnel
        super(WirelessSsidsVpn, __self__).__init__(
            'meraki:networks/wirelessSsidsVpn:WirelessSsidsVpn',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            concentrator: Optional[pulumi.Input[Union['WirelessSsidsVpnConcentratorArgs', 'WirelessSsidsVpnConcentratorArgsDict']]] = None,
            failover: Optional[pulumi.Input[Union['WirelessSsidsVpnFailoverArgs', 'WirelessSsidsVpnFailoverArgsDict']]] = None,
            network_id: Optional[pulumi.Input[str]] = None,
            number: Optional[pulumi.Input[str]] = None,
            split_tunnel: Optional[pulumi.Input[Union['WirelessSsidsVpnSplitTunnelArgs', 'WirelessSsidsVpnSplitTunnelArgsDict']]] = None) -> 'WirelessSsidsVpn':
        """
        Get an existing WirelessSsidsVpn resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['WirelessSsidsVpnConcentratorArgs', 'WirelessSsidsVpnConcentratorArgsDict']] concentrator: The VPN concentrator settings for this SSID.
        :param pulumi.Input[Union['WirelessSsidsVpnFailoverArgs', 'WirelessSsidsVpnFailoverArgsDict']] failover: Secondary VPN concentrator settings. This is only used when two VPN concentrators are configured on the SSID.
        :param pulumi.Input[str] network_id: networkId path parameter. Network ID
        :param pulumi.Input[str] number: number path parameter.
        :param pulumi.Input[Union['WirelessSsidsVpnSplitTunnelArgs', 'WirelessSsidsVpnSplitTunnelArgsDict']] split_tunnel: The VPN split tunnel settings for this SSID.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _WirelessSsidsVpnState.__new__(_WirelessSsidsVpnState)

        __props__.__dict__["concentrator"] = concentrator
        __props__.__dict__["failover"] = failover
        __props__.__dict__["network_id"] = network_id
        __props__.__dict__["number"] = number
        __props__.__dict__["split_tunnel"] = split_tunnel
        return WirelessSsidsVpn(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def concentrator(self) -> pulumi.Output['outputs.WirelessSsidsVpnConcentrator']:
        """
        The VPN concentrator settings for this SSID.
        """
        return pulumi.get(self, "concentrator")

    @property
    @pulumi.getter
    def failover(self) -> pulumi.Output['outputs.WirelessSsidsVpnFailover']:
        """
        Secondary VPN concentrator settings. This is only used when two VPN concentrators are configured on the SSID.
        """
        return pulumi.get(self, "failover")

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Output[str]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

    @property
    @pulumi.getter
    def number(self) -> pulumi.Output[str]:
        """
        number path parameter.
        """
        return pulumi.get(self, "number")

    @property
    @pulumi.getter(name="splitTunnel")
    def split_tunnel(self) -> pulumi.Output['outputs.WirelessSsidsVpnSplitTunnel']:
        """
        The VPN split tunnel settings for this SSID.
        """
        return pulumi.get(self, "split_tunnel")

