# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetCameraDetectionsHistoryByBoundaryByIntervalResult',
    'AwaitableGetCameraDetectionsHistoryByBoundaryByIntervalResult',
    'get_camera_detections_history_by_boundary_by_interval',
    'get_camera_detections_history_by_boundary_by_interval_output',
]

@pulumi.output_type
class GetCameraDetectionsHistoryByBoundaryByIntervalResult:
    """
    A collection of values returned by getCameraDetectionsHistoryByBoundaryByInterval.
    """
    def __init__(__self__, boundary_ids=None, boundary_types=None, duration=None, id=None, items=None, organization_id=None, per_page=None, ranges=None):
        if boundary_ids and not isinstance(boundary_ids, list):
            raise TypeError("Expected argument 'boundary_ids' to be a list")
        pulumi.set(__self__, "boundary_ids", boundary_ids)
        if boundary_types and not isinstance(boundary_types, list):
            raise TypeError("Expected argument 'boundary_types' to be a list")
        pulumi.set(__self__, "boundary_types", boundary_types)
        if duration and not isinstance(duration, int):
            raise TypeError("Expected argument 'duration' to be a int")
        pulumi.set(__self__, "duration", duration)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if items and not isinstance(items, list):
            raise TypeError("Expected argument 'items' to be a list")
        pulumi.set(__self__, "items", items)
        if organization_id and not isinstance(organization_id, str):
            raise TypeError("Expected argument 'organization_id' to be a str")
        pulumi.set(__self__, "organization_id", organization_id)
        if per_page and not isinstance(per_page, int):
            raise TypeError("Expected argument 'per_page' to be a int")
        pulumi.set(__self__, "per_page", per_page)
        if ranges and not isinstance(ranges, list):
            raise TypeError("Expected argument 'ranges' to be a list")
        pulumi.set(__self__, "ranges", ranges)

    @property
    @pulumi.getter(name="boundaryIds")
    def boundary_ids(self) -> Sequence[str]:
        """
        boundaryIds query parameter. A list of boundary ids. The returned cameras will be filtered to only include these ids.
        """
        return pulumi.get(self, "boundary_ids")

    @property
    @pulumi.getter(name="boundaryTypes")
    def boundary_types(self) -> Optional[Sequence[str]]:
        """
        boundaryTypes query parameter. The detection types. Defaults to 'person'.
        """
        return pulumi.get(self, "boundary_types")

    @property
    @pulumi.getter
    def duration(self) -> Optional[int]:
        """
        duration query parameter. The minimum time, in seconds, that the person or car remains in the area to be counted. Defaults to boundary configuration or 60.
        """
        return pulumi.get(self, "duration")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetCameraDetectionsHistoryByBoundaryByIntervalItemResult']:
        """
        Array of ResponseCameraGetOrganizationCameraDetectionsHistoryByBoundaryByInterval
        """
        return pulumi.get(self, "items")

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> str:
        """
        organizationId path parameter. Organization ID
        """
        return pulumi.get(self, "organization_id")

    @property
    @pulumi.getter(name="perPage")
    def per_page(self) -> Optional[int]:
        """
        perPage query parameter. The number of entries per page returned. Acceptable range is 1 1000. Defaults to 1000.
        """
        return pulumi.get(self, "per_page")

    @property
    @pulumi.getter
    def ranges(self) -> Sequence[str]:
        """
        ranges query parameter. A list of time ranges with intervals
        """
        return pulumi.get(self, "ranges")


class AwaitableGetCameraDetectionsHistoryByBoundaryByIntervalResult(GetCameraDetectionsHistoryByBoundaryByIntervalResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCameraDetectionsHistoryByBoundaryByIntervalResult(
            boundary_ids=self.boundary_ids,
            boundary_types=self.boundary_types,
            duration=self.duration,
            id=self.id,
            items=self.items,
            organization_id=self.organization_id,
            per_page=self.per_page,
            ranges=self.ranges)


def get_camera_detections_history_by_boundary_by_interval(boundary_ids: Optional[Sequence[str]] = None,
                                                          boundary_types: Optional[Sequence[str]] = None,
                                                          duration: Optional[int] = None,
                                                          organization_id: Optional[str] = None,
                                                          per_page: Optional[int] = None,
                                                          ranges: Optional[Sequence[str]] = None,
                                                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCameraDetectionsHistoryByBoundaryByIntervalResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_meraki as meraki

    example = meraki.organizations.get_camera_detections_history_by_boundary_by_interval(boundary_ids=["string"],
        boundary_types=["string"],
        duration=1,
        organization_id="string",
        per_page=1,
        ranges=["string"])
    pulumi.export("merakiOrganizationsCameraDetectionsHistoryByBoundaryByIntervalExample", example.items)
    ```


    :param Sequence[str] boundary_ids: boundaryIds query parameter. A list of boundary ids. The returned cameras will be filtered to only include these ids.
    :param Sequence[str] boundary_types: boundaryTypes query parameter. The detection types. Defaults to 'person'.
    :param int duration: duration query parameter. The minimum time, in seconds, that the person or car remains in the area to be counted. Defaults to boundary configuration or 60.
    :param str organization_id: organizationId path parameter. Organization ID
    :param int per_page: perPage query parameter. The number of entries per page returned. Acceptable range is 1 1000. Defaults to 1000.
    :param Sequence[str] ranges: ranges query parameter. A list of time ranges with intervals
    """
    __args__ = dict()
    __args__['boundaryIds'] = boundary_ids
    __args__['boundaryTypes'] = boundary_types
    __args__['duration'] = duration
    __args__['organizationId'] = organization_id
    __args__['perPage'] = per_page
    __args__['ranges'] = ranges
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('meraki:organizations/getCameraDetectionsHistoryByBoundaryByInterval:getCameraDetectionsHistoryByBoundaryByInterval', __args__, opts=opts, typ=GetCameraDetectionsHistoryByBoundaryByIntervalResult).value

    return AwaitableGetCameraDetectionsHistoryByBoundaryByIntervalResult(
        boundary_ids=pulumi.get(__ret__, 'boundary_ids'),
        boundary_types=pulumi.get(__ret__, 'boundary_types'),
        duration=pulumi.get(__ret__, 'duration'),
        id=pulumi.get(__ret__, 'id'),
        items=pulumi.get(__ret__, 'items'),
        organization_id=pulumi.get(__ret__, 'organization_id'),
        per_page=pulumi.get(__ret__, 'per_page'),
        ranges=pulumi.get(__ret__, 'ranges'))
def get_camera_detections_history_by_boundary_by_interval_output(boundary_ids: Optional[pulumi.Input[Sequence[str]]] = None,
                                                                 boundary_types: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                                                                 duration: Optional[pulumi.Input[Optional[int]]] = None,
                                                                 organization_id: Optional[pulumi.Input[str]] = None,
                                                                 per_page: Optional[pulumi.Input[Optional[int]]] = None,
                                                                 ranges: Optional[pulumi.Input[Sequence[str]]] = None,
                                                                 opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetCameraDetectionsHistoryByBoundaryByIntervalResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_meraki as meraki

    example = meraki.organizations.get_camera_detections_history_by_boundary_by_interval(boundary_ids=["string"],
        boundary_types=["string"],
        duration=1,
        organization_id="string",
        per_page=1,
        ranges=["string"])
    pulumi.export("merakiOrganizationsCameraDetectionsHistoryByBoundaryByIntervalExample", example.items)
    ```


    :param Sequence[str] boundary_ids: boundaryIds query parameter. A list of boundary ids. The returned cameras will be filtered to only include these ids.
    :param Sequence[str] boundary_types: boundaryTypes query parameter. The detection types. Defaults to 'person'.
    :param int duration: duration query parameter. The minimum time, in seconds, that the person or car remains in the area to be counted. Defaults to boundary configuration or 60.
    :param str organization_id: organizationId path parameter. Organization ID
    :param int per_page: perPage query parameter. The number of entries per page returned. Acceptable range is 1 1000. Defaults to 1000.
    :param Sequence[str] ranges: ranges query parameter. A list of time ranges with intervals
    """
    __args__ = dict()
    __args__['boundaryIds'] = boundary_ids
    __args__['boundaryTypes'] = boundary_types
    __args__['duration'] = duration
    __args__['organizationId'] = organization_id
    __args__['perPage'] = per_page
    __args__['ranges'] = ranges
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('meraki:organizations/getCameraDetectionsHistoryByBoundaryByInterval:getCameraDetectionsHistoryByBoundaryByInterval', __args__, opts=opts, typ=GetCameraDetectionsHistoryByBoundaryByIntervalResult)
    return __ret__.apply(lambda __response__: GetCameraDetectionsHistoryByBoundaryByIntervalResult(
        boundary_ids=pulumi.get(__response__, 'boundary_ids'),
        boundary_types=pulumi.get(__response__, 'boundary_types'),
        duration=pulumi.get(__response__, 'duration'),
        id=pulumi.get(__response__, 'id'),
        items=pulumi.get(__response__, 'items'),
        organization_id=pulumi.get(__response__, 'organization_id'),
        per_page=pulumi.get(__response__, 'per_page'),
        ranges=pulumi.get(__response__, 'ranges')))
