# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetOpenapiSpecResult',
    'AwaitableGetOpenapiSpecResult',
    'get_openapi_spec',
    'get_openapi_spec_output',
]

@pulumi.output_type
class GetOpenapiSpecResult:
    """
    A collection of values returned by getOpenapiSpec.
    """
    def __init__(__self__, id=None, item=None, organization_id=None, version=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if item and not isinstance(item, dict):
            raise TypeError("Expected argument 'item' to be a dict")
        pulumi.set(__self__, "item", item)
        if organization_id and not isinstance(organization_id, str):
            raise TypeError("Expected argument 'organization_id' to be a str")
        pulumi.set(__self__, "organization_id", organization_id)
        if version and not isinstance(version, int):
            raise TypeError("Expected argument 'version' to be a int")
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def item(self) -> 'outputs.GetOpenapiSpecItemResult':
        return pulumi.get(self, "item")

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> str:
        """
        organizationId path parameter. Organization ID
        """
        return pulumi.get(self, "organization_id")

    @property
    @pulumi.getter
    def version(self) -> Optional[int]:
        """
        version query parameter. OpenAPI Specification version to return. Default is 2
        """
        return pulumi.get(self, "version")


class AwaitableGetOpenapiSpecResult(GetOpenapiSpecResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetOpenapiSpecResult(
            id=self.id,
            item=self.item,
            organization_id=self.organization_id,
            version=self.version)


def get_openapi_spec(organization_id: Optional[str] = None,
                     version: Optional[int] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetOpenapiSpecResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_meraki as meraki

    example = meraki.organizations.get_openapi_spec(organization_id="string",
        version=1)
    pulumi.export("merakiOrganizationsOpenapiSpecExample", example.item)
    ```


    :param str organization_id: organizationId path parameter. Organization ID
    :param int version: version query parameter. OpenAPI Specification version to return. Default is 2
    """
    __args__ = dict()
    __args__['organizationId'] = organization_id
    __args__['version'] = version
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('meraki:organizations/getOpenapiSpec:getOpenapiSpec', __args__, opts=opts, typ=GetOpenapiSpecResult).value

    return AwaitableGetOpenapiSpecResult(
        id=pulumi.get(__ret__, 'id'),
        item=pulumi.get(__ret__, 'item'),
        organization_id=pulumi.get(__ret__, 'organization_id'),
        version=pulumi.get(__ret__, 'version'))
def get_openapi_spec_output(organization_id: Optional[pulumi.Input[str]] = None,
                            version: Optional[pulumi.Input[Optional[int]]] = None,
                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetOpenapiSpecResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_meraki as meraki

    example = meraki.organizations.get_openapi_spec(organization_id="string",
        version=1)
    pulumi.export("merakiOrganizationsOpenapiSpecExample", example.item)
    ```


    :param str organization_id: organizationId path parameter. Organization ID
    :param int version: version query parameter. OpenAPI Specification version to return. Default is 2
    """
    __args__ = dict()
    __args__['organizationId'] = organization_id
    __args__['version'] = version
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('meraki:organizations/getOpenapiSpec:getOpenapiSpec', __args__, opts=opts, typ=GetOpenapiSpecResult)
    return __ret__.apply(lambda __response__: GetOpenapiSpecResult(
        id=pulumi.get(__response__, 'id'),
        item=pulumi.get(__response__, 'item'),
        organization_id=pulumi.get(__response__, 'organization_id'),
        version=pulumi.get(__response__, 'version')))
