# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['ConfigstoreEntriesArgs', 'ConfigstoreEntries']

@pulumi.input_type
class ConfigstoreEntriesArgs:
    def __init__(__self__, *,
                 entries: pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]],
                 store_id: pulumi.Input[_builtins.str],
                 manage_entries: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a ConfigstoreEntries resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] entries: A map representing an entry in the Config Store, (key/value)
        :param pulumi.Input[_builtins.str] store_id: An alphanumeric string identifying the Config Store.
        """
        pulumi.set(__self__, "entries", entries)
        pulumi.set(__self__, "store_id", store_id)
        if manage_entries is not None:
            pulumi.set(__self__, "manage_entries", manage_entries)

    @_builtins.property
    @pulumi.getter
    def entries(self) -> pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]:
        """
        A map representing an entry in the Config Store, (key/value)
        """
        return pulumi.get(self, "entries")

    @entries.setter
    def entries(self, value: pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "entries", value)

    @_builtins.property
    @pulumi.getter(name="storeId")
    def store_id(self) -> pulumi.Input[_builtins.str]:
        """
        An alphanumeric string identifying the Config Store.
        """
        return pulumi.get(self, "store_id")

    @store_id.setter
    def store_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "store_id", value)

    @_builtins.property
    @pulumi.getter(name="manageEntries")
    def manage_entries(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "manage_entries")

    @manage_entries.setter
    def manage_entries(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "manage_entries", value)


@pulumi.input_type
class _ConfigstoreEntriesState:
    def __init__(__self__, *,
                 entries: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 manage_entries: Optional[pulumi.Input[_builtins.bool]] = None,
                 store_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ConfigstoreEntries resources.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] entries: A map representing an entry in the Config Store, (key/value)
        :param pulumi.Input[_builtins.str] store_id: An alphanumeric string identifying the Config Store.
        """
        if entries is not None:
            pulumi.set(__self__, "entries", entries)
        if manage_entries is not None:
            pulumi.set(__self__, "manage_entries", manage_entries)
        if store_id is not None:
            pulumi.set(__self__, "store_id", store_id)

    @_builtins.property
    @pulumi.getter
    def entries(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map representing an entry in the Config Store, (key/value)
        """
        return pulumi.get(self, "entries")

    @entries.setter
    def entries(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "entries", value)

    @_builtins.property
    @pulumi.getter(name="manageEntries")
    def manage_entries(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "manage_entries")

    @manage_entries.setter
    def manage_entries(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "manage_entries", value)

    @_builtins.property
    @pulumi.getter(name="storeId")
    def store_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        An alphanumeric string identifying the Config Store.
        """
        return pulumi.get(self, "store_id")

    @store_id.setter
    def store_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "store_id", value)


@pulumi.type_token("fastly:index/configstoreEntries:ConfigstoreEntries")
class ConfigstoreEntries(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 entries: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 manage_entries: Optional[pulumi.Input[_builtins.bool]] = None,
                 store_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        ## Import

        Fastly Config Stores entries can be imported using the corresponding Config Store ID with the `/entries` suffix, e.g.

        ```sh
        $ pulumi import fastly:index/configstoreEntries:ConfigstoreEntries example xxxxxxxxxxxxxxxxxxxx/entries
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] entries: A map representing an entry in the Config Store, (key/value)
        :param pulumi.Input[_builtins.str] store_id: An alphanumeric string identifying the Config Store.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ConfigstoreEntriesArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Import

        Fastly Config Stores entries can be imported using the corresponding Config Store ID with the `/entries` suffix, e.g.

        ```sh
        $ pulumi import fastly:index/configstoreEntries:ConfigstoreEntries example xxxxxxxxxxxxxxxxxxxx/entries
        ```

        :param str resource_name: The name of the resource.
        :param ConfigstoreEntriesArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ConfigstoreEntriesArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 entries: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 manage_entries: Optional[pulumi.Input[_builtins.bool]] = None,
                 store_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ConfigstoreEntriesArgs.__new__(ConfigstoreEntriesArgs)

            if entries is None and not opts.urn:
                raise TypeError("Missing required property 'entries'")
            __props__.__dict__["entries"] = entries
            __props__.__dict__["manage_entries"] = manage_entries
            if store_id is None and not opts.urn:
                raise TypeError("Missing required property 'store_id'")
            __props__.__dict__["store_id"] = store_id
        super(ConfigstoreEntries, __self__).__init__(
            'fastly:index/configstoreEntries:ConfigstoreEntries',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            entries: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            manage_entries: Optional[pulumi.Input[_builtins.bool]] = None,
            store_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'ConfigstoreEntries':
        """
        Get an existing ConfigstoreEntries resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] entries: A map representing an entry in the Config Store, (key/value)
        :param pulumi.Input[_builtins.str] store_id: An alphanumeric string identifying the Config Store.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ConfigstoreEntriesState.__new__(_ConfigstoreEntriesState)

        __props__.__dict__["entries"] = entries
        __props__.__dict__["manage_entries"] = manage_entries
        __props__.__dict__["store_id"] = store_id
        return ConfigstoreEntries(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def entries(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        A map representing an entry in the Config Store, (key/value)
        """
        return pulumi.get(self, "entries")

    @_builtins.property
    @pulumi.getter(name="manageEntries")
    def manage_entries(self) -> pulumi.Output[Optional[_builtins.bool]]:
        return pulumi.get(self, "manage_entries")

    @_builtins.property
    @pulumi.getter(name="storeId")
    def store_id(self) -> pulumi.Output[_builtins.str]:
        """
        An alphanumeric string identifying the Config Store.
        """
        return pulumi.get(self, "store_id")

