# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = [
    'GetTlsCertificateResult',
    'AwaitableGetTlsCertificateResult',
    'get_tls_certificate',
    'get_tls_certificate_output',
]

@pulumi.output_type
class GetTlsCertificateResult:
    """
    A collection of values returned by getTlsCertificate.
    """
    def __init__(__self__, created_at=None, domains=None, id=None, issued_to=None, issuer=None, name=None, replace=None, serial_number=None, signature_algorithm=None, updated_at=None):
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if domains and not isinstance(domains, list):
            raise TypeError("Expected argument 'domains' to be a list")
        pulumi.set(__self__, "domains", domains)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if issued_to and not isinstance(issued_to, str):
            raise TypeError("Expected argument 'issued_to' to be a str")
        pulumi.set(__self__, "issued_to", issued_to)
        if issuer and not isinstance(issuer, str):
            raise TypeError("Expected argument 'issuer' to be a str")
        pulumi.set(__self__, "issuer", issuer)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if replace and not isinstance(replace, bool):
            raise TypeError("Expected argument 'replace' to be a bool")
        pulumi.set(__self__, "replace", replace)
        if serial_number and not isinstance(serial_number, str):
            raise TypeError("Expected argument 'serial_number' to be a str")
        pulumi.set(__self__, "serial_number", serial_number)
        if signature_algorithm and not isinstance(signature_algorithm, str):
            raise TypeError("Expected argument 'signature_algorithm' to be a str")
        pulumi.set(__self__, "signature_algorithm", signature_algorithm)
        if updated_at and not isinstance(updated_at, str):
            raise TypeError("Expected argument 'updated_at' to be a str")
        pulumi.set(__self__, "updated_at", updated_at)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> _builtins.str:
        """
        Timestamp (GMT) when the certificate was created
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def domains(self) -> Sequence[_builtins.str]:
        """
        Domains that are listed in any certificates' Subject Alternative Names (SAN) list.
        """
        return pulumi.get(self, "domains")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        Unique ID assigned to certificate by Fastly
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="issuedTo")
    def issued_to(self) -> _builtins.str:
        """
        The hostname for which a certificate was issued.
        """
        return pulumi.get(self, "issued_to")

    @_builtins.property
    @pulumi.getter
    def issuer(self) -> _builtins.str:
        """
        The certificate authority that issued the certificate.
        """
        return pulumi.get(self, "issuer")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Human-readable name used to identify the certificate. Defaults to the certificate's Common Name or first Subject Alternative Name entry.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def replace(self) -> _builtins.bool:
        """
        A recommendation from Fastly indicating the key associated with this certificate is in need of rotation
        """
        return pulumi.get(self, "replace")

    @_builtins.property
    @pulumi.getter(name="serialNumber")
    def serial_number(self) -> _builtins.str:
        """
        A value assigned by the issuer that is unique to a certificate
        """
        return pulumi.get(self, "serial_number")

    @_builtins.property
    @pulumi.getter(name="signatureAlgorithm")
    def signature_algorithm(self) -> _builtins.str:
        """
        The algorithm used to sign the certificate
        """
        return pulumi.get(self, "signature_algorithm")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> _builtins.str:
        """
        Timestamp (GMT) when the certificate was last updated
        """
        return pulumi.get(self, "updated_at")


class AwaitableGetTlsCertificateResult(GetTlsCertificateResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetTlsCertificateResult(
            created_at=self.created_at,
            domains=self.domains,
            id=self.id,
            issued_to=self.issued_to,
            issuer=self.issuer,
            name=self.name,
            replace=self.replace,
            serial_number=self.serial_number,
            signature_algorithm=self.signature_algorithm,
            updated_at=self.updated_at)


def get_tls_certificate(domains: Optional[Sequence[_builtins.str]] = None,
                        id: Optional[_builtins.str] = None,
                        issued_to: Optional[_builtins.str] = None,
                        issuer: Optional[_builtins.str] = None,
                        name: Optional[_builtins.str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetTlsCertificateResult:
    """
    Use this data source to get information of a TLS certificate for use with other resources.

    > **Warning:** The data source's filters are applied using an **AND** boolean operator, so depending on the combination
    of filters, they may become mutually exclusive. The exception to this is `id` which must not be specified in combination
    with any of the others.

    > **Note:** If more or less than a single match is returned by the search, this provider will fail. Ensure that your search is specific enough to return a single key.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_fastly as fastly

    example = fastly.get_tls_certificate(name="example.com")
    ```


    :param Sequence[_builtins.str] domains: Domains that are listed in any certificates' Subject Alternative Names (SAN) list.
    :param _builtins.str id: Unique ID assigned to certificate by Fastly
    :param _builtins.str issued_to: The hostname for which a certificate was issued.
    :param _builtins.str issuer: The certificate authority that issued the certificate.
    :param _builtins.str name: Human-readable name used to identify the certificate. Defaults to the certificate's Common Name or first Subject Alternative Name entry.
    """
    __args__ = dict()
    __args__['domains'] = domains
    __args__['id'] = id
    __args__['issuedTo'] = issued_to
    __args__['issuer'] = issuer
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('fastly:index/getTlsCertificate:getTlsCertificate', __args__, opts=opts, typ=GetTlsCertificateResult).value

    return AwaitableGetTlsCertificateResult(
        created_at=pulumi.get(__ret__, 'created_at'),
        domains=pulumi.get(__ret__, 'domains'),
        id=pulumi.get(__ret__, 'id'),
        issued_to=pulumi.get(__ret__, 'issued_to'),
        issuer=pulumi.get(__ret__, 'issuer'),
        name=pulumi.get(__ret__, 'name'),
        replace=pulumi.get(__ret__, 'replace'),
        serial_number=pulumi.get(__ret__, 'serial_number'),
        signature_algorithm=pulumi.get(__ret__, 'signature_algorithm'),
        updated_at=pulumi.get(__ret__, 'updated_at'))
def get_tls_certificate_output(domains: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                               id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                               issued_to: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                               issuer: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                               name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                               opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetTlsCertificateResult]:
    """
    Use this data source to get information of a TLS certificate for use with other resources.

    > **Warning:** The data source's filters are applied using an **AND** boolean operator, so depending on the combination
    of filters, they may become mutually exclusive. The exception to this is `id` which must not be specified in combination
    with any of the others.

    > **Note:** If more or less than a single match is returned by the search, this provider will fail. Ensure that your search is specific enough to return a single key.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_fastly as fastly

    example = fastly.get_tls_certificate(name="example.com")
    ```


    :param Sequence[_builtins.str] domains: Domains that are listed in any certificates' Subject Alternative Names (SAN) list.
    :param _builtins.str id: Unique ID assigned to certificate by Fastly
    :param _builtins.str issued_to: The hostname for which a certificate was issued.
    :param _builtins.str issuer: The certificate authority that issued the certificate.
    :param _builtins.str name: Human-readable name used to identify the certificate. Defaults to the certificate's Common Name or first Subject Alternative Name entry.
    """
    __args__ = dict()
    __args__['domains'] = domains
    __args__['id'] = id
    __args__['issuedTo'] = issued_to
    __args__['issuer'] = issuer
    __args__['name'] = name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('fastly:index/getTlsCertificate:getTlsCertificate', __args__, opts=opts, typ=GetTlsCertificateResult)
    return __ret__.apply(lambda __response__: GetTlsCertificateResult(
        created_at=pulumi.get(__response__, 'created_at'),
        domains=pulumi.get(__response__, 'domains'),
        id=pulumi.get(__response__, 'id'),
        issued_to=pulumi.get(__response__, 'issued_to'),
        issuer=pulumi.get(__response__, 'issuer'),
        name=pulumi.get(__response__, 'name'),
        replace=pulumi.get(__response__, 'replace'),
        serial_number=pulumi.get(__response__, 'serial_number'),
        signature_algorithm=pulumi.get(__response__, 'signature_algorithm'),
        updated_at=pulumi.get(__response__, 'updated_at')))
