# To install this package
    cd python-django-injector
    pip install "dist/injector_arc-1.0.0-py3-none-any.whl"
# To build this package after making updates
    cd python-django-injector
    python setup.py bdist_wheel


### 🎯 Define Exposed Endpoints

####  Manager-based Endpoint

```python
# myapp/api.py
from Injection.utils import exposeable, expose
from myapp.models import Item
from myapp.serializers import ItemSerializer

@exposeable
class ItemManager:
    def __init__(self):
        pass

    @expose(
        method='POST',
        url='api/items/filter/',
        response_serializer=ItemSerializer
    )
    def filter_items(self, name: str):
        return Item.objects.filter(name__icontains=name)
```
### Utility Function Endpoint
```python
from Injection.utils import expose

@expose(method='GET', url='api/ping/')
def ping():
    return {'pong': True}
```


### Wire Up URL Patterns

```python 

from django.contrib import admin
from django.urls import path
from Injection.utils import root_instance

urlpatterns = [
    path('admin/', admin.site.urls),
    # Auto-add all @expose endpoints:
] + root_instance.export_urls()

```