# AUTOGENERATED! DO NOT EDIT! File to edit: ../nbs/03_pingme_api.ipynb.

# %% auto 0
__all__ = ['app', 'Settings', 'info', 'webhook_card_default', 'webhook_card_simple', 'webhook_card', 'send_webhook',
           'send_webhook_test', 'send_webhook_test_with_vars', 'webservice']

# %% ../nbs/03_pingme_api.ipynb 2
import json
import os
import re

import uvicorn
from fastapi import FastAPI
from fastapi.testclient import TestClient
from pydantic import BaseModel

from . import core
from .pingme_class import Card, PingMe
from pydantic_settings import BaseSettings
from .services import NotificationService

from fastapi import HTTPException
from fastapi.responses import JSONResponse

# %% ../nbs/03_pingme_api.ipynb 4
class Settings(BaseSettings):
    app_name: str = "PingMe"
    config_file: str = ""


if core.DEV_MODE:
    settings = Settings(config_file=f"{core.PROJECT_DIR}/config/config.env")
else:
    settings = Settings()

# %% ../nbs/03_pingme_api.ipynb 5
app = FastAPI()


@app.get("/")
async def info():
    # Using the default place as a information post
    return {
        "msg": "PingMe: please POST to /webhook or /email or /logfile or /webhook_card_default or /webhook_simple_card_to_default or /webhook_card}"
    }

# %% ../nbs/03_pingme_api.ipynb 6
@app.get("/webhook_card_default")
def webhook_card_default():
    try:
        response = NotificationService.send_default_card_to_webhook()
        return response
    except Exception as e:
        raise HTTPException(status_code=500, detail=str(e))


@app.post("/webhook_card_simple")
def webhook_card_simple(title: str, text: str) -> dict:
    try:
        response = NotificationService.send_simple_card_to_webhook(title, text)
        return response
    except Exception as e:
        raise HTTPException(status_code=500, detail=str(e))


@app.post("/webhook_card")
def webhook_card(card: Card):
    try:
        response = NotificationService.send_card_to_webhook(card)
        return response
    except Exception as e:
        raise HTTPException(status_code=500, detail=str(e))

# %% ../nbs/03_pingme_api.ipynb 10
@app.post("/webhook")
async def send_webhook(card: Card):
    try:
        notification = PingMe(card)
        response_body = notification.send_webhook()
        response = JSONResponse(content=response_body)
    except Exception as e:
        raise HTTPException(status_code=404, detail=f"Error: {e}")
    return response

# %% ../nbs/03_pingme_api.ipynb 12
@app.get("/webhook_test")
async def send_webhook_test():
    try:
        card = Card.model_validate(
            {
                "name": "default",
                "context": {"title": "Test Title", "text": "Test Text"},
            }
        )
        notification = PingMe(
            card,
            config_file=settings.config_file,
        )
        return notification.send_webhook()
    except Exception as e:
        raise HTTPException(status_code=404, detail=f"Error: {e}")

# %% ../nbs/03_pingme_api.ipynb 14
@app.post("/webhook_test_with_vars")
async def send_webhook_test_with_vars(title: str, text: str):
    try:
        card = Card.model_validate(
            {
                "name": "default",
                "context": {"title": title, "text": text},
            }
        )
        notification = PingMe(
            card,
            config_file=settings.config_file,
        )
        return notification.send_webhook()
    except Exception as e:
        raise HTTPException(status_code=404, detail=f"Error: {e}")

# %% ../nbs/03_pingme_api.ipynb 16
def webservice():
    uvicorn.run(app, port=5000, log_level="info")
