# AUTOGENERATED! DO NOT EDIT! File to edit: ../nbs/02_pingme_services.ipynb.

# %% auto 0
__all__ = ['Settings', 'NotificationService']

# %% ../nbs/02_pingme_services.ipynb 2
import json
import os
import re

from . import core
from .pingme_class import Card, PingMe
from pydantic_settings import BaseSettings
from fastapi.responses import JSONResponse

# %% ../nbs/02_pingme_services.ipynb 3
class Settings(BaseSettings):
    app_name: str = "PingMe"
    config_file: str = ""


if core.DEV_MODE:
    settings = Settings(config_file=f"{core.PROJECT_DIR}/config/config.env")
else:
    settings = Settings()


class NotificationService:
    @staticmethod
    def send_default_card_to_webhook():
        # Handles all logic for processing notifications
        card = Card.model_validate(
            {
                "name": "default",
                "context": {"title": "Test Title", "text": "Test Text"},
            }
        )
        notification = PingMe(
            card,
            config_file=settings.config_file,
        )
        response = notification.send_webhook()
        return {"status_code": response.status_code, "response": response.json()}
        # return notification.send_webhook()
        # response = JSONResponse(content=response_body.text)
        # return response.json()

    @staticmethod
    def send_simple_card_to_webhook(title: str, text: str):
        # Handles all logic for processing notifications
        card = Card.model_validate(
            {
                "name": "default",
                "context": {"title": title, "text": text},
            }
        )
        notification = PingMe(
            card,
            config_file=settings.config_file,
        )
        response = notification.send_webhook()
        return {"status_code": response.status_code, "response": response.json()}
        # return notification.send_webhook()
        # response = JSONResponse(content=response_body.text)
        # return response

    @staticmethod
    def send_card_to_webhook(card: Card):
        # Handles all logic for processing notifications
        notification = PingMe(
            card,
            config_file=settings.config_file,
        )
        response = notification.send_webhook()
        return {"status_code": response.status_code, "response": response.json()}
        # return notification.send_webhook()
        # response = JSONResponse(content=response_body.text)
        # return response
