# -*- coding: utf-8 -*-
"""
This module allow a connection to a haystack server Feautures provided allow
user to fetch data from the server and eventually, to post to it.

See http://www.project-haystack.org for more details

Project Haystack is an open source initiative to streamline working with data
from the Internet of Things. We standardize semantic data models and web
services with the goal of making it easier to unlock value from the vast
quantity of data being generated by the smart devices that permeate our homes,
buildings, factories, and cities. Applications include automation, control,
energy, HVAC, lighting, and other environmental systems.
"""

class HaystackError(Exception):
    '''
    Exception thrown when an error grid is returned by the Haystack server.
    See http://project-haystack.org/doc/Rest#errorGrid
    '''
    def __init__(self, message, traceback=None, *args, **kwargs):
        super(HaystackError, self).__init__(message, *args, **kwargs)
        self.traceback = traceback

# Those exceptions have been made when working with Niagara AX
class NoResponseFromServer(Exception):
    pass

class ProblemSendingRequestToServer(Exception):
    pass

class NoCookieReceived(Exception):
    pass

class ProblemReadingCookie(Exception):
    pass

class AuthenticationProblem(Exception):
    pass

class UnknownHistoryType(Exception):
    pass