# Cisco Meraki ChatOps

Using the [Nautobot ChatOps](https://github.com/nautobot/nautobot-plugin-chatops/) base framework, this Nautobot app (plugin) adds the ability to gather data as well as make basic changes communicating directly with the Meraki portal using Slack, Webex Teams, MS Teams, and Mattermost changing the way IT organizations support their Meraki infrastructure.

## Usage

### Command Setup
Add a slash command to Slack called `/meraki`.
See the [nautobot-chatops installation guide](https://github.com/nautobot/nautobot-plugin-chatops/blob/develop/docs/chat_setup/chat_setup.md) for instructions on adding a slash command to your Slack channel.

You may need to adjust your [Access Grants in Nautobot](https://github.com/nautobot/nautobot-plugin-chatops/blob/develop/docs/chat_setup/chat_setup.md#grant-access-to-the-chatbot) depending on your security requirements.

The following commands are available:

- `/meraki get-organizations`:  Gather all the Meraki Organizations.
- `/meraki get-admins [org-name]`: Based on an Organization Name Return the Admins.
- `/meraki get-devices [org-name] [device-type]`: Gathers devices from Meraki.
- `/meraki get-networks [org-name]`: Gathers networks from Meraki.
- `/meraki get-switchports [org-name] [device-name]`: Gathers switch ports from a MS switch device.
- `/meraki get-switchports-status [org-name] [device-name]`: Gathers switch ports status from a MS switch device.
- `/meraki get-firewall-performance [org-name] [device-name]`: Query Meraki with a firewall to device performance.
- `/meraki get-network-ssids [org-name] [net-name]`: Query Meraki for all SSIDs for a given Network.
- `/meraki get-camera-recent [org-name] [device-name]`: Query Meraki Recent Camera Analytics.
- `/meraki get-clients [org-name] [device-name]`: Query Meraki for List of Clients.
- `/meraki get-lldp-cdp [org-name] [device-name]`: Query Meraki for List of LLDP or CDP Neighbors.
- `/meraki configure-basic-access-port [org-name] [device-name] [port-number] [enabled] [vlan] [port-desc]`: Configure an access port with description, VLAN and state.
- `/meraki cycle-port [org-name] [device-name] [port-number]`: Cycles a port on a given switch.

## Screenshots

Running `/meraki get-organizations`.
![Example output for get-organizations](docs/images/00-meraki-get-orgs.png)

Running `/meraki get-networks`.
![Example output for get-networks](docs/images/00-meraki-get-networks.png)

Running `/meraki get-switchports-status`.
![Example output for get-networks](docs/images/00-meraki-get-port-stats.png)

Since the output was cut off the output example is below:
```
Port   Enabled      Status         Errors       Warnings   Speed    Duplex    Usage (Kb)    Client Count    Traffic In
                                                                                                              (Kbps)
========================================================================================================================
1      True      Connected                                 1 Gbps   full     total: 46687   1              total: 4.3
                                                                             sent: 27405                   sent: 2.5
                                                                             recv: 19282                   recv: 1.8
2      True      Connected                                 1 Gbps   full     total: 10086   1              total: 1.0
                                                                             sent: 9481                    sent: 0.9
                                                                             recv: 605                     recv: 0.1
3      True      Disconnected   Port                                         total: 0       0              total: 0
                                disconnected                                 sent: 0                       sent: 0
                                                                             recv: 0                       recv: 0
4      True      Disconnected   Port                                         total: 0       0              total: 0
                                disconnected                                 sent: 0                       sent: 0
                                                                             recv: 0                       recv: 0
 ```

To demonstrate a example of configuration updates.  There is a simple configuration ability for access ports.
`/meraki configure-basic-access-port`

Specify Org, Switch, and Port ID.
![Example output for config-port0](docs/images/00-meraki-port-config.png)

Fill out the Port Specific Configuration.
![Example output for config-port1](docs/images/01-meraki-port-config.png)

Result of the configuration.
![Example output for config-port2](docs/images/02-meraki-port-config.png)

## Installation

This plugin requires installation of the [Nautobot ChatOps plugin](https://github.com/nautobot/nautobot-plugin-chatops). Follow [this link](https://github.com/nautobot/nautobot-plugin-chatops/blob/develop/docs/chat_setup/chat_setup.md) to the installation instructions for that plugin.

The plugin is available as a Python package in PYPI and can be installed with pip

```shell
pip install git+https://github.com/networktocode-llc/nautobot-plugin-chatops-meraki.git
```

> The plugin is compatible with Nautobot 1.0.1 and higher

To ensure Nautobot Plugin Chatops Meraki is automatically re-installed during future upgrades, create a file named `local_requirements.txt` (if not already existing) in the Nautobot root directory (alongside `requirements.txt`) and list the `nautobot-plugin-chatops-meraki` package:

```no-highlight
# echo nautobot-plugin-chatops-meraki >> local_requirements.txt
```

Once installed, the plugin needs to be enabled in your `nautobot_config.py`

```python
# In your configuration.py
PLUGINS = ["nautobot_chatops", "nautobot_plugin_chatops_meraki"]

PLUGINS_CONFIG = {
  "nautobot_chatops": {
    # ADD SLACK/MS-TEAMS/WEBEX-TEAMS/MATTERMOST SETTINGS HERE
  }
}
```
> Note: There is currently no specific configuration needed for this plugin.  The only thing that is needed is below.

The plugin requires the use of a environment variable.  See below.

- `MERAKI_DASHBOARD_API_KEY`: Is set to the dashboard API key. See [Meraki Dashboard API Documentation](https://documentation.meraki.com/General_Administration/Other_Topics/Cisco_Meraki_Dashboard_API).

Add this variable and its value in the `creds.env` file.

## Contributing

Pull requests are welcomed and automatically built and tested against multiple version of Python and multiple version of Nautobot through TravisCI.

The project is packaged with a light development environment based on `docker-compose` to help with the local development of the project and to run the tests within TravisCI.

The project is following Network to Code software development guideline and is leveraging:

- Black, Pylint, Bandit and pydocstyle for Python linting and formatting.
- Django unit test to ensure the plugin is working properly.

### Development Environment

The development environment can be used in 2 ways. First, with a local poetry environment if you wish to develop outside of Docker. Second, inside of a docker container.

#### Invoke tasks

The [PyInvoke](http://www.pyinvoke.org/) library is used to provide some helper commands based on the environment.  There are a few configuration parameters which can be passed to PyInvoke to override the default configuration:

* `nautobot_ver`: the version of Nautobot to use as a base for any built docker containers (default: latest)
* `project_name`: the default docker compose project name (default: nautobot-plugin-chatops-meraki)
* `python_ver`: the version of Python to use as a base for any built docker containers (default: 3.6)
* `local`: a boolean flag indicating if invoke tasks should be run on the host or inside the docker containers (default: False, commands will be run in docker containers)
* `compose_dir`: the full path to a directory containing the project compose files
* `compose_files`: a list of compose files applied in order (see [Multiple Compose files](https://docs.docker.com/compose/extends/#multiple-compose-files) for more information)

Using PyInvoke these configuration options can be overridden using [several methods](http://docs.pyinvoke.org/en/stable/concepts/configuration.html).  Perhaps the simplest is simply setting an environment variable `INVOKE_NAUTOBOT-PLUGIN-CHATOPS-MERAKI_VARIABLE_NAME` where `VARIABLE_NAME` is the variable you are trying to override.  The only exception is `compose_files`, because it is a list it must be overridden in a yaml file.  There is an example `invoke.yml` in this directory which can be used as a starting point.

#### Local Poetry Development Environment

1.  Copy `development/creds.env.example` to `development/creds.env` (This file will be ignored by git and docker)
2.  Uncomment the `POSTGRES_HOST`, `REDIS_HOST`, and `NAUTOBOT_ROOT` variables in `development/creds.env`
3.  Create an invoke.yml with the following contents at the root of the repo:

```shell
---
nautobot_plugin_chatops_meraki:
  local: true
  compose_files:
    - "docker-compose.requirements.yml"
```

3.  Run the following commands:

```shell
poetry shell
poetry install
export $(cat development/dev.env | xargs)
export $(cat development/creds.env | xargs)
```

4.  You can now run nautobot-server commands as you would from the [Nautobot documentation](https://nautobot.readthedocs.io/en/latest/) for example to start the development server:

```shell
nautobot-server runserver 0.0.0.0:8080 --insecure
```

Nautobot server can now be accessed at [http://localhost:8080](http://localhost:8080).

#### Docker Development Environment

This project is managed by [Python Poetry](https://python-poetry.org/) and has a few requirements to setup your development environment:

1.  Install Poetry, see the [Poetry Documentation](https://python-poetry.org/docs/#installation) for your operating system.
2.  Install Docker, see the [Docker documentation](https://docs.docker.com/get-docker/) for your operating system.

Once you have Poetry and Docker installed you can run the following commands to install all other development dependencies in an isolated python virtual environment:

```shell
poetry shell
poetry install
invoke start
```

Nautobot server can now be accessed at [http://localhost:8080](http://localhost:8080).

### CLI Helper Commands

The project is coming with a CLI helper based on [invoke](http://www.pyinvoke.org/) to help setup the development environment. The commands are listed below in 3 categories `dev environment`, `utility` and `testing`.

Each command can be executed with `invoke <command>`. Environment variables `INVOKE_NAUTOBOT-PLUGIN-CHATOPS-MERAKI_PYTHON_VER` and `INVOKE_NAUTOBOT-PLUGIN-CHATOPS-MERAKI_NAUTOBOT_VER` may be specified to override the default versions. Each command also has its own help `invoke <command> --help`

#### Docker dev environment

```no-highlight
  build            Build all docker images.
  debug            Start Nautobot and its dependencies in debug mode.
  destroy          Destroy all containers and volumes.
  restart          Restart Nautobot and its dependencies.
  start            Start Nautobot and its dependencies in detached mode.
  stop             Stop Nautobot and its dependencies.
```

#### Utility

```no-highlight
  cli              Launch a bash shell inside the running Nautobot container.
  create-user      Create a new user in django (default: admin), will prompt for password.
  makemigrations   Run Make Migration in Django.
  nbshell          Launch a nbshell session.
```

#### Testing

```no-highlight
  bandit           Run bandit to validate basic static code security analysis.
  black            Run black to check that Python files adhere to its style standards.
  flake8           This will run flake8 for the specified name and Python version.
  pydocstyle       Run pydocstyle to validate docstring formatting adheres to NTC defined standards.
  pylint           Run pylint code analysis.
  tests            Run all tests for this plugin.
  unittest         Run Django unit tests for the plugin.
```

## Questions

For any questions or comments, please check the [FAQ](FAQ.md) first and feel free to swing by the [Network to Code slack channel](https://networktocode.slack.com/) (channel #networktocode).
Sign up [here](http://slack.networktocode.com/)
