DEFAULT_SCENE_SIZE = (1920, 1080)
"""
A default scene size (FullHD, 1080p) defined in
pixels. This size is the same as in moviepy
because this engine works also with pixels.
"""
DEFAULT_SCENE_WIDTH = DEFAULT_SCENE_SIZE[0]
"""
A default scene width (FullHD, 1080p) defined in
pixels.
"""
DEFAULT_SCENE_HEIGHT = DEFAULT_SCENE_SIZE[1]
"""
A default scene height (FullHD, 1080p) defined in
pixels.
"""
DEFAULT_MANIM_SCENE_SIZE = (14 + (2 / 9), 8)
"""
The manim equivalent size for a scene of 1920x1080
pixels, adapted to be able to work with it when using
the manim engine.
"""
DEFAULT_MANIM_SCENE_WIDTH = DEFAULT_MANIM_SCENE_SIZE[0]
"""
The manim equivalent width for a scene of 1920x1080
pixels, adapted to be able to work with it when using
the manim engine.
"""
DEFAULT_MANIM_SCENE_HEIGHT = DEFAULT_MANIM_SCENE_SIZE[1]
"""
The manim equivalent height for a scene of 1920x1080
pixels, adapted to be able to work with it when using
the manim engine.
"""