import os
import json
import click

APPROVAL_FILE = ".pdg/approved.json"

def init_approvals():
    """Initialize approvals file with empty approved_packages."""
    os.makedirs(os.path.dirname(APPROVAL_FILE), exist_ok=True)
    with open(APPROVAL_FILE, "w") as f:
        json.dump({"approved_packages": []}, f, indent=4)
    click.echo(f"Predator Drone: Initialized {APPROVAL_FILE}")

def load_approvals():
    """Load approvals from file or return default if not found."""
    if os.path.exists(APPROVAL_FILE):
        with open(APPROVAL_FILE, "r") as f:
            return json.load(f)
    init_approvals() # Create if missing
    return {"approved_packages": []}

def is_approved(name, version, public_key):
    approvals = load_approvals()
    return any(pkg.get("name") == name and pkg.get("version") == version for pkg in approvals.get("approved_packages", []))

def approve_package(name, version, private_key):
    approvals = load_approvals()
    approvals["approved_packages"].append({"name": name, "version": version})
    with open(APPROVAL_FILE, "w") as f:
        json.dump(approvals, f, indent=4)