import os
import json
import click

CONFIG_FILE = ".pdg/pdg_config.json"
DEFAULT_CONFIG = {"key_dir": "./keys", "allowed_licenses": ["MIT", "Apache-2.0"]}

def init_config():
    """Initialize configuration file with default settings."""
    os.makedirs(os.path.dirname(CONFIG_FILE), exist_ok=True)
    with open(CONFIG_FILE, "w") as f:
        json.dump(DEFAULT_CONFIG, f, indent=4)
    click.echo(f"Predator Drone: Initialized {CONFIG_FILE}")

def load_config():
    """Load configuration from file or return default if not found."""
    if os.path.exists(CONFIG_FILE):
        with open(CONFIG_FILE, "r") as f:
            return json.load(f)
    init_config() # Create if missing
    return DEFAULT_CONFIG